
new function()
{
    var load = function(name) {return required(FileSystem.MakePath(name, Origin.Directory()));};
    var base = function(name) {return load("Base/" + name);};

    this.DetectWidi = function(cfg)
    { // check for WiDi installed
        Log("WiDi detection started");

        var ns_ver  = base("version.js");
        var ns_cinf = base("component_info.js");
        var helper = load("helper.js");

        var cpu = load("detect_cpu.js").CpuInfo();
        var osinfo = load("detect_os.js").OsInfo();

        var WiDi_data = {};
        if(cpu.model < 37 || cpu.model == 54 || cpu.model == 38)
            WiDi_data.cpumismatch = true;
        else if(cpu.model < 42 && osinfo.version.ge("6.3"))
            WiDi_data.platformmismatch = true;

        Log("Looking for CPU specific WiDi entry...");
        var percpu_entry;
        helper.filter(cfg.select("/config/widi/row") || [], function(row)
        {
            var model = helper.etext(row, "cpu_model");
            if(model)
            {
                var etext = function(name) {return helper.etext(row, name);};
                Log("Found per-cpu entry: " + model + " : " + etext("os") + " : " + etext("bit_version"));
                if(helper.filter(model.split(/[,;]+/), function(mod) {return parseInt(mod) == cpu.model;}))
                {
                    Log("cpu model matched: " + cpu.model);
                    if(parseInt(etext("bit_version")) == osinfo.bitnes)
                    {
                        if(etext("os") == osinfo.name)
                        {
                            Log("per-cpu entry matched");
                            percpu_entry = row;
                            return true;
                        }
                        else
                            Log("os-version mismatch: " + etext("os") + " <=> " + osinfo.name);
                    }
                    else
                        Log("os-bitnes mismatch. ignore");
                }
                else
                    Log("module mismatch. ignore");
            }
        });

        var zero = function() {return percpu_entry && ns_ver.Version(helper.etext(percpu_entry, "driver_version")).eq("0.0.0.0");};
		var zeroAndMiracast = function() {return zero() };

        // searching for WiDi installed by upgrade code
        var widi_code = GetOpt.GetDefault("widi-code", "{438937D0-2F16-4D4E-B3A0-5A0E6B5046F0}");
        Log("WiDi upgrade code: " + widi_code);
        var widiprod = WI.RelatedProducts(widi_code);
        var version = null;
        if(widiprod && widiprod.length)
        {
            var widip = ns_cinf.InfoWI(widiprod[0]);
            if(widip)
            {
                Log("Found WiDi product: " + widip.Name() + " : " + widip.Version());
                var version = GetOpt.GetDefault("widi-version", widip.Version());
                Log("Found WiDi drivers set: " + version);
                WiDi_data.current_version = version;
                WiDi_data.name = widip.Name();

                if(!percpu_entry && cpu.model >= 58 && osinfo.win81)
                {
                    Log("WiDi software will be removed");
                    WiDi_data.uninstall = widiprod[0];
                }
                else if(percpu_entry && zero())
                {
                    Log("WiDi software will be removed");
                    WiDi_data.uninstall = widiprod[0];
                }
            }
        }
        else
            Log("No WiDi product found");

        if(!percpu_entry && !version && cpu.model >= 58 && osinfo.win81) // no widi detected on new procs & win81
        {
            Log("No WiDi action required (no WiDi on 8.1 & IVB)");
            return null; // nothing to do
        }
		
		if (percpu_entry && zero() && osinfo.version.eq("6.1"))
		{
			Log("WiDi unsupported on a win7 platform " + cpu.model);
			WiDi_data.uninstall = false;
			WiDi_data.new_version = null;
			return WiDi_data;
		}

        if(!WiDi_data.uninstall)
        {
            if(zero())
            {
                Log("No WiDi software available");
                return null; // nothing to do
            }

            Log("Looking for WiDi software to install");
            if(cpu.model >= 42 || osinfo.version.ge("6.2")) // CPU SNB+ or win8+
                var tail = /Wireless Display Software\s*$/;
            else
                var tail = /Wireless Display\s*$/;

            var xpath = "/config/widi/row";
            Log("Pattern to search: " + xpath);
            var rows = cfg.select(xpath);
            if(percpu_entry || (rows && rows.length))
            {
                helper.filter(rows || [percpu_entry], function(row)
                {
                    if(percpu_entry)
                        row = percpu_entry;

                    var widiname = helper.etext(row, "device_name");
                    Log("widi row: " + widiname);
                    if(percpu_entry || (widiname && widiname.match(tail)))
                    {
                        Log("driver name matched");

                        if(helper.etext(row, "os") != osinfo.name ||
                           helper.etext(row, "bit_version") != osinfo.bitnes)
                        {
                            Log("Found record for another os: " + helper.etext(row, "os") +
                                " : " + helper.etext(row, "bit_version"));
                            WiDi_data.another_os = true;
                            return false;
                        }
                        Log("Found matched record");

                        WiDi_data.name = helper.etext(row, "device_name");
                        WiDi_data.new_version = helper.etext(row, "driver_version");
                        WiDi_data.url = helper.etext(row, "driver_download_url");
                        WiDi_data.cmdline = helper.etext(row, "cmdline");
                        if(typeof(WiDi_data.cmdline) == "undefined")
                            WiDi_data.cmdline = "/s /v/qn  /norestart";
                        Log("WiDi:");
                        Log("OS: " + helper.etext(row, "os"));
                        Log("Bitness: " + helper.etext(row, "bit_version"));
                        helper.marknewer(helper.etext(row, "driver_version"), version, WiDi_data);
                        Log("Url: " + helper.etext(row, "driver_download_url"));
                        Log("Name: " + helper.etext(row, "device_name"));
                        Log("WiDi detection status:");
                        helper.log_object(WiDi_data);
                        return true;
                    }
                });
            }
        }
        return WiDi_data;
    }
}


