
new function()
{
    var load = function(name) {return required(FileSystem.MakePath(name, Origin.Directory()));};
    var base = function(name) {return load("Base/" + name);};

    var ns = this;

    var ns_cinf = base("component_info.js");
    var ns_ver  = base("version.js");

    var helper = load("helper.js");

    this.DetectProSet = function(data)
    {
        Log("Wireless ProSet detection started");
        // using Windows Installer (WI) to search all products by upgrade code
        data.proset_name = "[proset_name]";
        var proset_upgrade_code = GetOpt.GetDefault("proset-code", "{FA026B12-71FB-4996-9B82-F64F70B06453}");
        Log("Proset upgrade code: " + proset_upgrade_code);

        var reg = Registry("HKLM", "SOFTWARE\\Microsoft\\Windows\\CurrentVersion\\Uninstall");

        var look_for_proset = function(subname)
        {
            var r = reg.Key(subname);

            if(r.Exists() && r.Value("BundleUpgradeCode"))
                if(r.Value("BundleUpgradeCode").toLowerCase() == proset_upgrade_code.toLowerCase())
                {
                    Log("Found ProSet registry entry: " + subname);
                    var ver = r.Value("DisplayVersion");
                    data.installed_proset_version = GetOpt.GetDefault("proset-version", ver);
                    Log("Wireless ProSet software installed, version: " + data.installed_proset_version);
                    data.proset_version_installed = ns_ver.Version(data.installed_proset_version);
                    return true;
                }
        }

        Log("Looking for Proset Registry: 64 bit");
        if(helper.filter(reg.Subkeys(), look_for_proset))
            return;
        reg.WowRedirect(false);
        Log("Looking for Proset Registry: 32 bit");
        if(helper.filter(reg.Subkeys(), look_for_proset))
            return;

        var pros = WI.RelatedProducts(proset_upgrade_code);
        if(!pros || !pros.length)
        {
            Log("Wireless ProSet software is not installed");
            data.proset_install = true;
            data.proset_update = true;
        }
        else
        {
            var pro = ns_cinf.InfoWI(pros[0]);
            data.installed_proset_version = GetOpt.GetDefault("proset-version", pro.Version());
            Log("Wireless ProSet software installed, version: " + data.installed_proset_version);
            data.proset_version_installed = ns_ver.Version(data.installed_proset_version);
        }
    }

    this.DetectWifi = function(cfg, drivers, devices)
    {
        Log("WiFi detection starting...");

        var callbacks = {};
        callbacks.classfilter = function() {return /4D36E972-E325-11CE-BFC1-08002BE10318/i;}
        callbacks.xpath = function(pci)
        {
            var cond1 = "pci_device_id='[%s]' and pci_subsystem_id='[%s]' ";
            var cond2 = "and pci_subvendor_id='[%s]'";
            var x = StringList.Format(cond1, pci.id.toUpperCase(), pci.sub_id.toUpperCase()) +
                    StringList.Format(cond2, pci.sub_vendor.toUpperCase());
            return "/config/wireless/row[" + x + "]";
        }
        callbacks.fake = function(id, value) {return GetOpt.GetDefault("wifi-" + id, value);}

        var data = helper.ScanHardware(cfg, devices, drivers, callbacks);
        Log("WiFi detection status:");
        helper.log_object(data);

        if(typeof(data.cmdline) == "undefined")
            data.cmdline = "-q -norestart";
            //data.cmdline = "-?";

        if(!data.error)
        { // ok, let's try to detect ProSet software
            ns.DetectProSet(data);
            helper.filter(data.devices, function(d, k)
            {
                if(d.matched)
                {
                    var e = d.entry;
                    var vr = helper.etext(e, "proset_version");
                    var v = ns_ver.Version(vr);
                    Log("Proset matched: " + k + " : " + vr);
                    data.proset_version = vr; // set proset version in any case
                    if(data.proset_version_installed && data.proset_version_installed.lt(v))
                    {
                        Log("Installed Proset version is obsolete.");
                        data.proset_update = true;
                    }
                    else if(!data.proset_version_installed)
                    {
                        Log("Found ProSet version to install: " + vr);
                        Log("No Proset Installed");
                    }
                    else if(data.proset_version_installed && data.proset_version_installed.ge(v))
                    {
                        Log("Installed Proset version is newer or same - disable ProSet update");
                        data.update = false;
                        data.install = false;
                    }
                }
            });
        }
        else
        {
            Log("Failed to locate Intel WiFi device... Try to search Broadcom devices...");
            if(!helper.filter(devices, function(d)
            { // try to locate Broadcom supported device
                var device_id = GetOpt.GetDefault("wifi-id", d.DeviceID);
                if(device_id)
                {
                    var pci_id = helper.parse_pci(device_id);
                    var sd_id = helper.parse_sd(device_id);
                    if((pci_id && pci_id.vendor.match(/14E4/i)) ||
                       (sd_id && sd_id.vendor.match(/02D0/i))) // process only Broadcom devices
                    {
                        Log("Processing: " + device_id);

                        var device = {};
                        var id = pci_id ? pci_id.id : sd_id.id;

                        var cond = "pci_device_id='[%s]'";
                        var x = StringList.Format(cond, id.toUpperCase());
                        var xpath = "/config/broadcom/row[" + x + "]";

                        Log("Pattern to search: " + xpath);
                        if(xpath)
                        {
                            if(helper.filter(cfg.select(xpath), function(e)
                            {
                                data.broadcom = true;
                                data.error = false;
                                Log("Found Broadcom device:");
                                helper.log_object(d);
                                return true;
                            }))
                                return true;
                        }
                    }
                }
                return false;
            }))
            {
                if(data.no_devices)
                    data.error_message = "[not_supported_wifi]";
                else // if(data.another_os)
                    data.error_message = "[wrong_os_wifi]";
            }
        }

        return data;
    }
}

