
new function()
{
    var load = function(name) {return required(FileSystem.MakePath(name, Origin.Directory()));};
    var base = function(name) {return load("Base/" + name);};

    this.schedule = function(obj, name, dumper_online, dumper_offline, error_message, statefunc)
    {
        var ns_dwn  = base("dumper_download.js");
        var helper  = load("helper.js");
        var ns_dmp  = base("dumper.js");
        var ns_dlg  = base("dialogs_base.js");

        var codename = name;

        if(!statefunc)
            Log("Warning: no state function...");

        var wrapretry = function(action)
        {
            if(action)
            {
                var apply = action.Apply;
                action.Apply = function()
                {
                    var failed = function(r) {return res != Action.r_ok && res != 1;}
                    do
                    {
                        var res = apply();
                        if(failed(res))
                        {
                            if(res == Action.r_cancel)
                                return res;
                            else
                            {
                                if(ns_dlg.WiDiFailedRetry())
                                {
                                    ns_dlg.Installation("Billboard");
                                    continue;
                                }
                            }
                        }
                    }while(failed(res));

                    return res;
                }
            }
            return action;
        }

        if(obj && obj.url && (obj.install || obj.update || obj.proset_install || obj.proset_update))
        {
            var name = obj.proset_name ? obj.proset_name : obj.name;
            var failed = function(text)
            {
                GlobalErrors.Clear();
                GlobalErrors.Add(text ? text : StringList.Format(error_message, "http://www.intel.com/support/go/iknow/gh/2591.htm")); //obj.url));
                return Action.r_error;
            }

            var targetdir = FileSystem.AbsPath(FileSystem.exe_dir, "installs");
            var dest = FileSystem.AbsPath(targetdir, FileSystem.FileName(obj.url));
            var dmp = ns_dwn.Download();
            if(!GetOpt.Exists("failed-to-download"))
                dmp.Url(obj.url);
            else
                dmp.Url("http://localhost:8080/failed-to-download"); // try to download fake file

            dmp.File(dest);
            Log("Url: " + obj.url);
            Log("Destination: " + dest);
            Log("Command line arguments: " + obj.cmdline);

            // wrap download dumper Apply action to provide error processing
            var d_apply = dmp.Apply;
            dmp.Apply = function()
            {
                if(!FileSystem.Exists(dest))
                {
                    var res = d_apply();
                    if(res != Action.r_ok && res != 1)
                        failed(StringList.Format("[failed_to_download_driver]", name));
                    return res;
                }
                else
                {
                    Log("Download: Destination exists... Skip downloading: " + dest);
                    return Action.r_ok;
                }
            }

            var progress = Progress();
            progress.total = -1;
            var progressapply = function(){return progress;}

            var state = function(st){return {Apply:function(){if(st && statefunc) statefunc(st); return Action.r_ok;}};}

            //dumper_online.AddAction(state("download"), "set state download for " + name);
            if(!GetOpt.Exists("no-download") && !FileSystem.Exists(dest))
            {
                var d = dumper_online.AddAction(wrapretry(dmp), "download " + name);
                d.Group("Download");
                d.Attribute("countable", true);
            }
            else if(FileSystem.Exists(dest))
                Log("File exists... skip downloading");

            //dumper_online.AddAction(state("wait"), "set state wait for " + name);

            var make_exe_apply = function(dest, cmd)
            {
                return function()
                {
                    progressapply().message = "Check signature: " + FileSystem.FileName(dest);

                    Log("checking signature for: " + dest + " : " + FileSystem.Size(dest));
                    if(!FileSystem.Signed(dest))
                    {
                        Log(StringList.Format("[file_not_signed]", FileSystem.FileName(dest)));
                        return failed();
                    }
                    if(!FileSystem.IntelCertificate(dest))
                    {
                        Log("File signed by non-Intel certificate");
                        return failed();
                    }
                    if(Wizard.Canceled())
                        return Action.r_cancel;

                    var quote = function(str)
                    { // quote string if spaces inside
                        if(str.match(/\s/))
                            return '"' + str + '"';
                        return str;
                    }

                    // hack for proset: fix configuration file to enable wifi software feature (and
                    // disable proset feature
                    var destdir = FileSystem.Directory(dest);
                    var conffile = FileSystem.AbsPath(destdir, "setup.xml");
                    Log("Looking for configuration file to fix: " + conffile);
                    if(FileSystem.Exists(conffile))
                    {
                        Log("Fixing configuration");
                        var fixcfg = FileSystem.AbsPath(Origin.Directory(), "fixconfig.js");
                        var cfgcmd = "wscript.exe //B " + quote(fixcfg) + " " + quote(conffile);
                        Log("Cmd for fix config: " + cfgcmd);
                        CreateProcess(null, cfgcmd, true);
                        Log("Done");
                    }
                    else
                        Log("  No config found. Skip it...");

                    progress.message = name;
                    var procname = quote(dest);
                    if(typeof(cmd) != "undefined")
                        cmdline = procname + " " + obj.cmdline;
                    else
                        cmdline = procname + " /q /s";
                    Log("Command line: " + cmdline);
                    if(!GetOpt.Exists("fake-exec"))
                        var res = CreateProcess(null, cmdline, true);
                    else
                        var res = {failed:false, exitcode:0};
                    Log("Process exited");
                    helper.log_object(res);
                    if(res.failed || (res.exitcode && res.exitcode != 3010 && res.exitcode != 1641)) // reboot required
                    {
                        Log("Failed: " + error_message);
                        return failed();
                    }
                    return Wizard.Canceled() ? Action.r_cancel : Action.r_ok;
                }
            }

            if(dest.match(/\.exe$/i))
            { // executable
                var exedmp = ns_dmp.Dumper("exe processing for " + name);
                var act = {Apply: make_exe_apply(dest, obj.cmdline), ProgressApply:progressapply};
                exedmp.AddAction(act).Attribute("countable", true);
                var act = exedmp;
            }
            else if(dest.match(/\.msi$/i))
            { // msi component
                Log("Building MSI dumper: " + name);
                var msidmp = ns_dmp.Dumper("exe processing for " + name);
                var sinfo = ns_cinf.InfoMSI(dest);
                var msiinfo = {Path: dest, ProductCode: sinfo.Id(), Install: true};
                Log("Component id: " + msiinfo.ProductCode);
                if(typeof(obj.cmdline) != "undefined")
                    msiinfo.Parameters = obj.cmdline;
                var act = DumperAction.MSI(msiinfo);
                // disabling rollback for MSI
                act.Rollback = function() {Log("Rollback disabled"); return Action.r_ok;}
                msidmp.AddAction(act).Attribute("countable", true);
                var act = msidmp;
            }
            else if(dest.match(/\.zip$/i))
            {
                var zip;
                var act_run = {Apply:function(){return Action.r_error;}, ProgressApply:progressapply};
                var act_zip = {Apply:function()
                {
                    if(!zip)
                        return failed();
                    var destdir = FileSystem.AbsPath(targetdir, codename + "_extract");
                    Log("Extract to directory: " + destdir);
                    FileSystem.CreateDirectory(destdir);
                    if(!zip.Extract(destdir))
                        return failed();

                    var ffiles = FileSystem.FindFilesRecursive(destdir, "setup.exe");
                    if(ffiles && ffiles.length)
                    {
                        var exe = FileSystem.AbsPath(destdir, ffiles[0]);
                        Log("Found setup.exe: " + exe);
                        act_run.Apply = make_exe_apply(exe, obj.cmdline);
                    }

                    return Action.r_ok;
                }};

                var act_cfg = {Apply:function()
                {
                    zip = Zip(dest);
                    if(!zip)
                        return failed();
                    act_zip.ProgressApply = function() {return zip.Progress();}
                    return Action.r_ok;
                }};

                var zipdmp = ns_dmp.Dumper("zip processing for " + name);
                zipdmp.AddAction(act_cfg, "Configuring zip: " + dest).Attribute("countable", true);
                zipdmp.AddAction(act_zip, "Extract zip: " + dest);
                zipdmp.AddAction(act_run, "Run executable (path will be detected later)");
                var act = zipdmp;
            }

            //dumper_offline.AddAction(state("download"), "set state install for " + name);
            if(!GetOpt.Exists("no-install") && act)
                var act = dumper_offline.AddAction(act, "installation " + name);
            dumper_offline.AddAction(state("finish"), "set state finish for " + name);
            return true;
        }
        return false;
    }
}

