
new function()
{
    var load = function(name) {return required(FileSystem.MakePath(name, Origin.Directory()));};
    var base = function(name) {return load("Base/" + name);};

    var ns_dlg = base("dialogs_base.js");
    var osinfo = load("detect_os.js").OsInfo();

    var set_finish_text = function(oem)
    {
        if(!oem)
        {
            if (osinfo.version.ge("10.0")) {
                ns_dlg.WiDiComplete.OnClick(function () { Execute.URL("http://supportkb.intel.com/wireless/wireless-display/templates/selfservice/intelwidi/#portal/1026/article/700100000023961/Running-Intel-WiDi-with-Windows-10-Steps-to-Connect-and-Display"); });
                ns_dlg.WiDiComplete.Text("[complete_81]");
                ns_dlg.WiDiComplete.Mark("[learn_more]");
            }
            else if(osinfo.version.ge("6.3"))
            { // set config for win 8.1
                ns_dlg.WiDiComplete.Text("[complete_81]");
                ns_dlg.WiDiComplete.OnClick(function(){Execute.URL("http://www.intel.com/support/go/iknow/gh/2592.htm");});
                ns_dlg.WiDiComplete.Mark("[learn_more]");
            } else {
                ns_dlg.WiDiComplete.Text("[ready_to_use]");
                ns_dlg.WiDiComplete.Mark("[learn_more]");
                //ns_dlg.WiDiComplete.Mark("[launch_widi]");
                ns_dlg.WiDiComplete.OnClick(function() { Execute.URL("http://www.intel.com/support/go/iknow/gh/2590.htm"); });
            }
        }
        else
        {
            ns_dlg.WiDiComplete.Text("[oem_need_to_update]");
            ns_dlg.WiDiComplete.Mark("[learn_more_about_update]");
            ns_dlg.WiDiComplete.OnClick(function(){Execute.URL("http://windows.microsoft.com/en-US/windows/help/windows-update");});
        }
    }

    this.Finish = function(oem)
    {
        var no_text = false;
        if(!oem)
            ns_dlg.DialogHeader("WiDiComplete", "[subtitle_complete]");
        else
            ns_dlg.DialogHeader("WiDiComplete", "[subtitle_complete]", "[complete_subheader_oem]");
        set_finish_text(oem);

        ns_dlg.WiDiComplete(osinfo.version.ge("6.3"));
        return Action.r_ok;
    }

    this.UpToDate = function(oem)
    {
        ns_dlg.DialogHeader("WiDiComplete", "[system_up_to_date_header]"/*, "[system_up_to_date_subheader]"*/);
        set_finish_text(oem);
        ns_dlg.WiDiComplete(osinfo.version.ge("6.3") && !oem);
        return Action.r_ok;
    }

    var quote = function(str)
    { // quote string if spaces inside
        if(str.match(/\s/))
            return '"' + str + '"';
        return str;
    }

    this.RebootRequired = function(on_expand, stater, config_path)
    {
        Log("Reboot required");
        System.ExitCode(0x444e434c); // 'DNCL' - disable removing of temp data

        var reg = Registry("HKLM", "SOFTWARE\\Microsoft\\Windows\\CurrentVersion\\RunOnce");
        if(!reg.Exists())
            reg.Create();

        var image = FileSystem.AbsPath(FileSystem.exe_dir, FileSystem.exe_name);
        if(image.match(" "))
            image = '"' + image + '"';

        var cmdline = image + " --restarted --no-progress --no-splash --config-path=" + quote(config_path);
        Log("Writing value: " + cmdline);
        reg.Value("widi update tool", cmdline);
        var fexp = on_expand("[reboot_message]\\par\\par ", stater.Bullet);
        ns_dlg.WiDiReboot.Text(StringList.Format("[reboot_message]", fexp.ExpandedText()));

        if(ns_dlg.WiDiReboot() == Action.r_ok)
        {
            Log("Scheduling reboot");
            var ns_dmpf = base("dumper_file.js");
            var act = ns_dmpf.Directory();
            act.DelayedReboot();
            act.Apply();
            act.Commit();
        }
        return Action.r_ok;
    }
}

