
// script should be executed by WSH
// usage: fixconfig.js path_to_file

var args = WScript.Arguments;
if(args.Length < 1)
    WScript.Quit();

var filename = args(0);

var xml = new ActiveXObject("Msxml.DOMDocument");
xml.load(filename);

var attr = function(name, value)
{
    var a = xml.createAttribute(name);
    a.text = value;
    return a;
}

var filter = function(c, cb)
{
    for(var i = 0; i < c.length; i++)
    {
        var n = c.nextNode();
        if(cb(n))
            return true;
    }
    return false;
}

filter(xml.selectNodes('//SelectableFeature[@Id="WIFI_Software"]'), function(software)
{
    if(software)
        software.attributes.setNamedItem(attr("Selected", "yes"));
});

filter(xml.selectNodes('//SelectableFeature[@Id="WIFI_PROSet"]'), function(proset)
{
    if(proset)
        proset.attributes.setNamedItem(attr("Selected", "no"));
});

xml.save(filename);

