
new function()
{
    var load = function(name) {return required(FileSystem.MakePath(name, Origin.Directory()));};
    var base = function(name) {return load("Base/" + name);};

    var baseurl = GetOpt.GetDefault("cfg-base-url", "http://downloadmirror.intel.com/23188/eng/");

    this.GetFile = function()
    {
        var ns_dwn = base("dumper_download.js");

        var xmlpath = GetOpt.GetDefault("config-path", FileSystem.AbsPath(Origin.Directory(), "config.xml"));
        Log("Processing xml table: " + xmlpath);
        if(!FileSystem.Exists(xmlpath))
        {
            Log("File doesn't exist. Trying to download it");
            var xmlpath = FileSystem.AbsPath(FileSystem.GetTemp(), "config.xml");
            Log("New xml path: " + xmlpath);

            var try_to_download = function(url, target)
            {
                Log("Trying to download from: " + url);

                var ddown = ns_dwn.Download();
                ddown.Url(url);
                ddown.File(target);
                Wizard.Notify("Progress_Splash", "connect", ddown.ProgressApply().id);
                var res = ddown.Apply();
                if(res == Action.r_ok || res == 1 || res == true && FileSystem.Exists(target))
                {
                    Log("  Done: " + target);
                    return true;
                }
                Log("Failed");
                GlobalErrors.Clear();
                return false;
            }

            Log("Trying zip file first");
            var zipurl = baseurl + "config.xml.zip";
            var zippath = FileSystem.AbsPath(FileSystem.GetTemp(), "config.xml.zip");
            if(try_to_download(zipurl, zippath))
            {
                Log("Ok, extracting archive");

                var zip = Zip(zippath);
                var cfgdir = FileSystem.Parent(xmlpath);
                Wizard.Notify("Progress_Splash", "connect", zip.Progress().id);
                zip.Extract(cfgdir);
                if(FileSystem.Exists(xmlpath))
                    return xmlpath;
            }

            Log("Failed to get archived config... Try to get extracted config...");
            var xmlurl = baseurl + "config.xml";
            if(try_to_download(xmlurl, xmlpath))
                return xmlpath;
            else
                Log("No config available");

            return null;
        }
        else
        {
            Log("File exists. Using local copy");
            return xmlpath;
        }
    }
}


