
new function()
{
    var load = function(name) {return required(FileSystem.MakePath(name, Origin.Directory()));};
    var base = function(name) {return load("Base/" + name);};

    var ns = this;

    var ns_ver  = base("version.js");
    var osinfo = load("detect_os.js").OsInfo();

    this.filter = function(collection, cb)
    {
        for(var i in collection)
        {
            var k = collection[i];
            if(cb(k, i))
                return true;
        }
        return false;
    }

    this.parse_pci = function(id)
    {
        if(id)
        {
            var m = id.match(/pci\\ven_([0-9a-z]{4})&dev_([0-9a-z]{4})&subsys_([0-9a-z]{4})([0-9a-z]{4})/i);
            if(m)
                return {vendor:m[1], id:m[2], sub_id:m[3], sub_vendor:m[4]};

            var m = id.match(/pci\\ven_([0-9a-z]{4})&dev_([0-9a-z]{4})/i);
            if(m)
                return {vendor:m[1], id:m[2]};
        }
        return null;
    }

    this.parse_sd = function(id)
    {
        if(id)
        {
            var m = id.match(/sd\\vid_([0-9a-z]{4})&pid_([0-9a-z]{4})/i);
            if(m)
                return {vendor:m[1], id:m[2]};
        }
        return null;
    }

    this.pci2key = function(pci)
    {
        var key = "";
        if(pci.vendor)
        {
            key = key + pci.vendor.toUpperCase() + "_";
            if(pci.id)
            {
                key = key + pci.id.toUpperCase() + "_";
                if(pci.sub_id)
                {
                    key = key + pci.sub_id.toUpperCase() + "_";
                    if(pci.sub_vendor)
                        key = key + pci.sub_vendor.toUpperCase() + "_";
                }
            }
        }
        return key.replace(/_$/, "");
    }

    this.etext = function(node, subpath)
    {
        if(node)
        {
            var n = node.single(subpath);
            if(n)
                return n.text;
        }
        return undefined;
    }

    this.marknewer = function(media, cached, holder)
    {
        Log("Version: " + media + " -> Installed: " + cached);
        if(holder)
        {
            var v = ns_ver.Version(media);
            if(cached)
            {
                if(v.gt(cached))
                {
                    holder.update = true;
                    holder.install = false;
                }
            }
            else
            {
                holder.install = true;
                holder.update = true;
            }
        }
    }

    this.log_object = function(obj)
    {
        for(var i in obj)
            Log("Object: " + i + " : " + obj[i]);
    }

    this.quote = function(str)
    { // quote string if spaces inside
        if(str.match(/\s/))
            return '"' + str + '"';
        return str;
    }

    this.ScanHardware = function(cfg, devices, drivers, callbacks)
    {
        if(!callbacks.fake)
            callbacks.fake = function(id, value) {return value;}

        var hw = {};
        ns.filter(devices, function(d)
        {
            var device_id = callbacks.fake("id", d.DeviceID);
            if(device_id)
            {
                var pci_id = ns.parse_pci(device_id);
                if(pci_id && pci_id.vendor == '8086') // process only Intel devices
                {
                    Log("Processing: " + device_id);

                    var device = {};

                    var xpath = callbacks.xpath(pci_id);
                    Log("Pattern to search: " + xpath);
                    if(xpath)
                    {
                        var entries = cfg.select(xpath);
                        var version = ns_ver.Version("0.0");
                        var entry_found = false;
                        ns.filter(entries, function(row)
                        {
                            entry_found = true;
                            if(ns.etext(row, "os") != osinfo.name ||
                               ns.etext(row, "bit_version") != osinfo.bitnes)
                            {
                                Log("Found record for another os: " + ns.etext(row, "os") +
                                    " : " + ns.etext(row, "bit_version") +
                                    " : " + ns.etext(row, "driver_version") +
                                    " : " + ns.etext(row, "driver_download_url"));
                                device.another_os = true;
                            }
                            else
                            {
                                Log("Found record: " + ns.etext(row, "os") +
                                    " : " + ns.etext(row, "bit_version") +
                                    " : " + ns.etext(row, "driver_version") +
                                    " : " + ns.etext(row, "driver_download_url"));
                                var driver_version = ns.etext(row, "driver_version");
                                if(!device.matched && !driver_version)
                                    Log(Log.l_warning, "No driver_version entry in table. Using first enumerated entry as reference");
                                if((!device.matched && !driver_version) ||
                                   version.lt(driver_version))
                                {
                                    version = ns_ver.Version(ns.etext(row, "driver_version"));
                                    device.url = ns.etext(row, "driver_download_url");
                                    device.name = ns.etext(row, "device_name");
                                    device.version = driver_version || "0.0";
                                    device.entry = row;
                                }
                                device.matched = true;
                            }
                            return false;
                        });
                        if(!entry_found)
                            Log("No entries found");
                    }
                    if(device.matched || device.another_os)
                        hw[ns.pci2key(pci_id)] = device;
                }
            }

            return false;
        });

        // ok, now look for drivers
        var classfilter = callbacks.classfilter();
        ns.filter(drivers, function(d)
        {
            var device_id = callbacks.fake("id", d.DeviceID);
            if(device_id)
            {
                var pci_id = ns.parse_pci(device_id);
                if(pci_id)
                {
                    if(d.ClassGuid.match(classfilter))
                    {
                        Log("Processing driver:");
                        ns.log_object(d);

                        var manufacturer = callbacks.fake("manufacturer", d.DriverProviderName);

                        if(manufacturer.match(/intel/i))
                        {
                            Log("Manufacturer matched");
                            var device = hw[ns.pci2key(pci_id)];
                            if(device)
                            {
                                Log("Device located in HW list");
                                var ver = device.driver_version;
                                var dv = callbacks.fake("version", d.DriverVersion);
                                Log("Driver version: " + dv);
                                if(!ver)
                                {
                                    Log("Set device driver version");
                                    device.driver_version = dv;
                                    device.inf = d.InfName;
                                }
                                else
                                {
                                    var v = ns_ver.Version(ver);
                                    if(v.lt(dv))
                                    {
                                        Log("Set device driver version");
                                        device.driver_version = dv;
                                        device.inf = d.InfName;
                                    }
                                }
                            }
                            else
                                Log("Driver for non-H/W device");
                        }
                        else
                            Log("Non Intel driver. Ignore.");
                    }
                }
            }
        });

        // now compare installed driver version & version from table
        var data = {devices:hw, no_devices:true};
        ns.filter(hw, function(entry)
        {
            data.no_devices = false;
            if(entry.matched)
            {
                if(!data.url)
                { // set at leat one mathed entry
                    data.url = entry.url;
                    data.name = entry.name;
                    data.version = entry.version;
                    data.cmdline = ns.etext(entry.entry, "cmdline");
                    data.driver_version = entry.driver_version;
                    //if(entry.driver_version)
                    //    data.inf = entry.inf;
                }

                if(entry.driver_version)
                    var v = ns_ver.Version(entry.driver_version);

                if(!entry.driver_version || v.lt(entry.version))
                { // newer driver detected
                    data.update = true;
                    data.url = entry.url;
                    data.name = entry.name;
                    data.version = entry.version;
                    data.cmdline = ns.etext(entry.entry, "cmdline");
                    data.driver_version = entry.driver_version;
                    if(entry.driver_version)
                        data.inf = entry.inf;
                    return true;
                }
                else if(entry.driver_version && v.ge(entry.version))
                    data.older = true; // older elements present
            }
            else if(entry.another_os)
                data.another_os = true;

            return false;
        });

        if(!data.update && !data.older)
            data.error = true;

        return data;
    }
}


