
new function()
{
    var mediaconfig_name = "mediaconfig.js";
    var group_name = "widi update tool";
    var splash_file = "splash/widi.png";
    var init_name = Origin.File();

    var load = function(name) {return required(FileSystem.MakePath(name, Origin.Directory()));};
    var base = function(name) {return required(FileSystem.MakePath(name, Origin.Directory() + "Base"));};
    var path = function(name, dir) {return FileSystem.MakePath(name, dir);}

    var splash = function() {if(!GetOpt.Exists("no-splash")) Action.show_splash_screen({image:path(splash_file, Origin.Directory())});};

    Log("###############################################################");
    Log('### Executing of init file "' + path(Origin.File(), Origin.Directory()) + '" begin');

    base("namespace.js");
    base("extend.js");
    base("log_helper.js");

    if(typeof(Wizard) != "undefined" && !Wizard.OnNotify)
        base("wizard.js")

    if(!Namespace.Defined("Root.installer"))
        base("installer.js");

    //###############################################################
    var mediaconfig = path(mediaconfig_name, Origin.Directory());

    this.Media = function(start, group)
    {
        if(Splash.Canceled())
            return;

        if(start)
            splash();

        if(Splash.Canceled())
            return;

        if(FileSystem.Exists(mediaconfig) && !FileSystem.IsDirectory(mediaconfig))
        {
            var m_config = required(mediaconfig);
            if(m_config && m_config.Media)
            {
                if(start)
                    m_config.Media(true, group_name);
                else
                    m_config.Media(false, group);
            }
        }

        if(Splash.Canceled())
            return;

        if(start)
        {
            if(m_config && m_config.Go)
            {
                return safecall(function(){return m_config.Go();},
                                function(){Log(Log.l_error, "Exception handled calling mediaconfig.Go"); return Action.r_error;});
            }
        }
    }

    this.Cache = function(start, group)
    {
        if(Splash.Canceled())
            return;

        if(start)
            splash();

        if(FileSystem.Exists(mediaconfig) && !FileSystem.IsDirectory(mediaconfig))
        {
            var m_config = required(mediaconfig);
            if(m_config && m_config.Cache)
            {
                if(start)
                    m_config.Cache(true, group_name);
                else
                    m_config.Cache(false, group);
            }
        }

        if(Splash.Canceled())
            return;

        if(start)
        {
            if(m_config && m_config.Go)
            {
                return safecall(function(){return m_config.Go();},
                                function(){Log(Log.l_error, "Exception handled calling mediaconfig.Go"); return Action.r_error;});
            }
        }
    }
}

