
new function()
{
    var min_os = "6.1";
    //var min_os = "6.3";

    if(GetOpt.Exists("dump-sys-info"))
    {
        var dump_data = function(w)
        {
            for(var i in w)
            {
                for(var j in w[i])
                    Log("Property: " + j + " : " + w[i][j]);
                Log("==========================");
            }
        }

        dump_data(WMI.Query("Select * from  Win32_PnPSignedDriver"));
        dump_data(WMI.Query("Select * from  Win32_PnPEntity"));
        dump_data(WMI.Query("Select * from  Win32_DeviceBus"));
        dump_data(WMI.Query("Select * from  Win32_SystemDevices"));
    }

    var load = function(name) {return required(FileSystem.MakePath(name, Origin.Directory()));};
    var base = function(name) {return load("Base/" + name);};

    var group_name = "widi update tool";
    var started = false;

    var prod = null;

    var media = false;

    this.Cache = function(start, group) {} // not used

    this.Media = function(start, group) {} // not used

    this.Go = function()
    {
        Log("Go started");
        // loading helper modules
        var ns_dlg  = base("dialogs_base.js");
        var ns_ver  = base("version.js");
        var ns_scn  = base("scenario.js");
        var ns_rbt  = base("pendingreboot.js");
        var ns_cinf = base("component_info.js");
        var ns_dmp  = base("dumper.js");
        var ns_inst = base("install.js");
        var ns_hlp  = load("helper.js");
        var ns_dmpf = base("dumper_file.js");
        var ns_exp  = load("details_expand.js");

        /*ns_rbt.PendingReboot.FileRenaming();
        ns_rbt.PendingReboot.AutoUpdate();
        ns_rbt.PendingReboot.BaseServicing();
        ns_rbt.PendingReboot.Installer();*/

        var restarted = GetOpt.Exists("restarted");

        var HD_data;
        var Wireless_data;
        var WiDi_data;

        var on_expand = function(prefix, bullet_f) {return ns_exp.Expander(HD_data, Wireless_data, WiDi_data, prefix, bullet_f);}

        var stater = load("statusupdate.js");

        ns_dlg.Load();
        Wizard.Notify("title", "cancel-built-in", true);
        Wizard.Subscribe("title", "canceled", function()
        {
            Log("Canceled...");
            var progress = Progress();
            progress.total = -1;
            Wizard.Notify("Progress1", "connect", progress.id);
            progress.message = "[canceling]";
            Wizard.Cancel.Disable();
        });

        ns_dlg.Title("[title]");
        ns_dlg.Title.BigIcon(FileSystem.MakePath("Icons/micl.ico", Origin.Directory()));
        ns_dlg.Title.SmallIcon(FileSystem.MakePath("Icons/micl.ico", Origin.Directory()));

        var set_failed = function(text)
        {
            GlobalErrors.Clear();
            GlobalErrors.Add("[alert_img] " + text);
            ns_dlg.WiDiFailed();
        }

        var osinfo = load("detect_os.js").OsInfo();

        if (osinfo.version.lt(GetOpt.GetDefault("min-os", min_os))) {
            set_failed("[os_not_supported]");
            return 1;
        }

        var cfgfile = load("getconfig.js").GetFile();
        if(!cfgfile)
        {
            set_failed("[failed_to_get_config]");
            return 1;
        }

        var cfg = XML(FileSystem.AbsPath(cfgfile));
        if(cfg && GetOpt.Exists("check-config"))
        {
            var checker = load("check_config.js");
            if(checker)
                checker.is_valid_config(cfg);
        }

        if(GetOpt.Exists("silent"))
        {
            var silent = GetOpt.Get("silent");
            if(!silent)
                silent = "full";
        }

        var Installation = function()
        {
            if(!silent)
                Wizard.BusyStart();
            Log(" Start installation adjustment");
            ns_dlg.Installer().AnalizeConfiguration();
            Log(" installation adjustment completed");

            var on_start = function(threads)
            {
                if(!silent)
                    Wizard.BusyStop();
                if(!silent || silent == "progress")
                    ns_dlg.Installation(threads);
            }
            ns_dlg.Installer().OnStart(on_start);

            return ns_dlg.Installer().Execute();
        }

        if(System.SecondInstance())
        {
            set_failed("[another_instance]");
            return;
        }

        if(!cfg)
        {
            set_failed("[config_failed]");
            return 1;
        }

        Splash.Status(StringList.Format("[scan_hw]"));

        var devices = WMI.Query("Select * from  Win32_PnPEntity where (DeviceID like '%PCI%' and (DeviceID like '%8086%' or DeviceID like '%14E4%')) or (DeviceID like '%SD%' and DeviceID like '%02D0%')");

        if(GetOpt.Exists("wifi-id") || GetOpt.Exists("hd-id"))
            var drivers = WMI.Query("select * from Win32_PnPSignedDriver where ClassGuid='{4D36E972-E325-11CE-BFC1-08002BE10318}' or ClassGuid='{4D36E968-E325-11CE-BFC1-08002BE10318}'");
        else
            var drivers = WMI.Query("select * from Win32_PnPSignedDriver where HardWareID like '%8086%' and (ClassGuid='{4D36E972-E325-11CE-BFC1-08002BE10318}' or ClassGuid='{4D36E968-E325-11CE-BFC1-08002BE10318}')");

        var HD_data = load("detect_hd.js").DetectHD(cfg, drivers, devices);
        var Wireless_data = load("detect_wifi.js").DetectWifi(cfg, drivers, devices);
        var WiDi_data = load("detect_widi.js").DetectWidi(cfg);

        var failed = false;
        var failed_text = "";

        if(Wireless_data.error)
        {
            failed_text = failed_text + Wireless_data.error_message + "\\par ";
            failed = true;
        }

        if(HD_data.error)
        {
            failed_text = failed_text + HD_data.error_message + "\\par ";
            failed = true;
        }

        if(WiDi_data)
        {
            Log("WiDi data processing");
            if(WiDi_data.cpumismatch)
            {
                failed_text = failed_text + "[cpu_not_supported]\\par ";
                failed = true;
            }
            else if(WiDi_data.platformmismatch)
            {
                failed_text = failed_text + "[platform_not_supported]\\par ";
                failed = true;
            }
            else if(!WiDi_data.new_version && !WiDi_data.uninstall)
            //else if(!WiDi_data.new_version)
            {
                failed_text = failed_text + "[wrong_os_widi]\\par ";
                failed = true;
            }
        }

        if(failed)
        {
            ns_rbt.PendingReboot(); // write pending reboot to logs for later analisys
            set_failed(failed_text)
            return 1;
        }

        if(HD_data.oem)
            StringList.Replace("oem_found", "[oem_driver]");
        if(Wireless_data.broadcom)
            StringList.Replace("broadcom_found", "[broadcom_driver]");

        var is_oem_obsolete = function()
        {
            return false;
        }

        var finish = function()
        {
            //var reboot_required = (ns_rbt.PendingReboot.BaseServicing() || ns_rbt.PendingReboot.AutoUpdate() || ns_rbt.PendingReboot.Installer()) ||
            var reboot_required = (HD_data.update || GetOpt.Exists("force-reboot")) &&
                !GetOpt.Exists("suppress-reboot") && !restarted; // prevent infinite loop for reboot
            if(reboot_required)
                load("finishdialog.js").RebootRequired(on_expand, stater, cfgfile);
            else
                load("finishdialog.js").Finish(is_oem_obsolete());

            return Action.r_ok;
        }

        var hdver = ns_ver.Version(HD_data.version);
        var wifiver = ns_ver.Version(Wireless_data.version);
        if(WiDi_data && WiDi_data.current_version && WiDi_data.new_version)
            var widiver = ns_ver.Version(WiDi_data.new_version);

        var pre_text = "\\fs19 {\\b [title]\\par\\par}";
        if(Wireless_data.update || Wireless_data.proset_update)
        {
            if(!GetOpt.Exists("no-pending-reboot") &&
                    (ns_rbt.PendingReboot.BaseServicing() || ns_rbt.PendingReboot.AutoUpdate() || ns_rbt.PendingReboot.Installer() ||
                     GetOpt.Exists("force-pending-reboot")))
            {
                set_failed("[pending_reboot]");
                return 1;
            }
        }

        Wizard.Notify("welcome", "mark link", "[here]");
        ns_dlg.PreInstall.Skip = function(){return true;}

        StringList.Replace("cancel confirmation title", StringList.Format("[header_template]", "[cancel_header_template]"));
        StringList.Replace("cancel confirmation message", StringList.Format("[widi_text_template]", "[cancel_text]"));

        ns_dlg.WiDiWelcome.Text("[welcome_template]");
        Wizard.Notify("billboard/text", "set rtf text", StringList.Format("[widi_text_template]", "[show_me]"));
        Wizard.Notify("billboard/text", "mark link", "[here]");

        Wizard.Subscribe("welcome", "OnClicked", on_expand("[welcome_template]\\par\\par "));

        var stater_cb = stater.Configure(on_expand("[show_me]\\par\\par ", stater.Bullet));
        Wizard.Notify("billboard/text", "show", true);

        Wizard.Notify("pre_install/info", "set rtf text", pre_text);

        var progress_monitor = load("progress_monitor.js");

        var dumper = ns_dmp.Dumper("Main dumper");
        var dumper_online = ns_dmp.Dumper("Dumper to download");
        var dumper_offline = ns_dmp.Dumper("Dumper to install");
        dumper_online.PreAction().AddAction({Apply:function(){ns_dlg.WiDiFailed.Header("[failed_to_download]"); return Action.r_ok;}}); // freeze estimated time
        dumper_offline.PreAction().AddAction({Apply:function(){progress_monitor.Detach(); return Action.r_ok;}}); // freeze estimated time
        dumper_offline.PreAction().AddAction({Apply:function()
        { // update header
            ns_dlg.DialogHeader("Installation", "[subtitle_install]");
            ns_dlg.DialogHeader("Installation");
            ns_dlg.WiDiFailed.Header("[failed_to_install]");
            return Action.r_ok;
        }}); // freeze estimated time

        if(!GetOpt.Exists("no-action"))
        {
            dumper.AddAction(dumper_online);
            dumper.AddAction(dumper_offline);
        }
        else
            dumper.AddAction({Apply: function() {return Action.r_ok;}}, "Fake action");

        var update_required = false;

        var to_download = load("downloader.js").schedule;

        var steps = 0;
        var step = 0;
        var percent = 0;
        var next = function()
        {
            step++;
            percent = 100 * step / steps;
            StringList.Replace("completed_percent", parseInt(percent));
            StringList.Replace("cancel confirmation message", StringList.Format("[widi_text_template]", "[cancel_text]"));
        }

        if(to_download(Wireless_data, "wireless", dumper_online, dumper_offline, "[failed_to_install_wifi]", stater_cb.wifi))
        {
            steps += 2;
            update_required = true;
            dumper_online.AddAction({Apply: function(){next(); return Action.r_ok;}}, "Step++");
            dumper_offline.AddAction({Apply: function(){next(); return Action.r_ok;}}, "Step++");

            progress_monitor.AddItem(92856320, 75);
        }

        if(to_download(HD_data, "hd", dumper_online, dumper_offline, "[failed_to_install_hd]", stater_cb.hd))
        {
            steps += 2;
            update_required = true;
            dumper_online.AddAction({Apply: function(){next(); return Action.r_ok;}}, "Step++");
            dumper_offline.AddAction({Apply: function(){next(); return Action.r_ok;}}, "Step++");

            progress_monitor.AddItem(154972160, 90);
        }

        if(WiDi_data)
        {
            Log("Scheduling WiDi actions");
            if(WiDi_data.uninstall)
            {
                update_required = true;
                steps++;
                Log("Building MSI dumper to remove WiDi");
                load("terminate_widi.js").Terminate(dumper_offline);
                var msiinfo = {ProductCode: WiDi_data.uninstall, Remove: true};
                var act = dumper_offline.AddAction(DumperAction.MSI(msiinfo), "remove WiDi driver");
                dumper_offline.AddAction({Apply:function(){stater_cb.widi("finish"); return Action.r_ok;}}, "widi uninstall finish state");
                act.Group("Uninstall");
                act.Attribute("countable", true);

                progress_monitor.AddItem(0, 60);
            }
            else if(WiDi_data.update || WiDi_data.install)
            {
                Log("Scheduling install new version of WiDi");
                if(HD_data && HD_data.update) // if HD install required - set fake offline dumper to prevent WiDi install
                    to_download(WiDi_data, "widi", dumper_online, ns_dmp.Dumper(), "[failed_to_install_widi]", stater_cb.widi);
                else
                {
                    load("terminate_widi.js").Terminate(dumper_offline);
                    to_download(WiDi_data, "widi", dumper_online, dumper_offline, "[failed_to_install_widi]", stater_cb.widi);
                }
                steps += 2;
                update_required = true;
                dumper_online.AddAction({Apply: function(){next(); return Action.r_ok;}}, "Step++");
                dumper_offline.AddAction({Apply: function(){next(); return Action.r_ok;}}, "Step++");

                progress_monitor.AddItem(0, 60);
            }
        }

        if(restarted)
        { // after restart tool should remove itself
            Log("Scheduling self-remove");
            var act = ns_dmpf.Directory();
            act.DelayedRemove(FileSystem.exe_dir);
            act.Apply();
            act.Commit();
        }

        var prg = Progress();
        prg.Connect(Wizard.Notify("Progress1", "id"));

        Wizard.Subscribe("title", "about to cancel", function()
        {
            Log("About to cancel: " + prg.position + "/" + prg.total);
            var max = function(a, b) {return a > b ? a : b;};
            if(prg.total > 0)
                var perc = max(parseInt(percent + (prg.position * 100 / prg.total / steps)), 0);
            else
                var perc = max(parseInt(percent), 0);
            
            if(perc > 90)
                perc = 90; // beautify: it is strange to have 100% complete & incomplete :)

            StringList.Replace("completed_percent", perc);
            StringList.Replace("cancel confirmation message", StringList.Format("[widi_text_template]", "[cancel_text]"));
        });

        if(update_required && osinfo.version.ge("6.3"))
        {
            Log("Scheduling VAD driver processing");
            var vad=load("detect_vad.js");
            vad.Schedule(dumper_offline);
        }

        Log("Update required: " + update_required);

        var scenario = ns_scn.Create();

        if((update_required || restarted) && !GetOpt.Exists("up-to-date"))
        {
            if((osinfo.version.le("6.2") && is_oem_obsolete()) || GetOpt.Exists("old-oem"))
            { // check if oem is too old
                set_failed("[oem_driver_too_old]");
                return 1;
            }

            scenario.Add(function() {return ns_dlg.WiDiError(function()
            {
                ns_dlg.WiDiError.Text("[low_battery]");

                var w = WMI.Query("Select * from  Win32_Battery");
                for(var i in w)
                {
                    Log("Battery:");
                    ns_hlp.log_object(w[i]);
                    if(w[i])
                    {
                        var battery_status = parseInt(GetOpt.GetDefault("battery-status", w[i].BatteryStatus));
                        var estimated = parseInt(w[i].EstimatedChargeRemaining);
                        if(battery_status == 4 || battery_status == 5) // low or critical
                            return true;
                        if(battery_status == 1 && estimated && estimated < 25) // discharging && <25%
                            return true;
                    }
                }
                return false;
            })})

            if(!restarted)
            {
                scenario.Add(ns_dlg.WiDiEula);
                scenario.Add(ns_dlg.WiDiWelcome);
            }
            //scenario.Add(function(){scenario.OnCancel(ns_dlg.Cancel); return Action.r_ok;});
            scenario.Add(function(){return ns_dlg.Installation("Billboard");});
            scenario.Add(function(){return ns_inst.Process(dumper);});
            scenario.OnError(ns_dlg.WiDiFailed);
            scenario.OnFinish(finish);
        }
        else
        {
            scenario.Add(function(){return Action.r_ok;}); // add any action to make scenario non-empty
            if(GetOpt.Get("up-to-date") == "oem-obsolete")
                scenario.OnFinish(function(){return load("finishdialog.js").UpToDate(true);});
            else
                scenario.OnFinish(function(){return load("finishdialog.js").UpToDate(is_oem_obsolete());});
        }

        return scenario();
    }
}


