new function()
{
    var load = function(name) {return required(FileSystem.MakePath(name, Origin.Directory()));};
    var base = function(name) {return required(FileSystem.MakePath(name, Origin.Directory() + "Base"));};
    var conf = function(name) {return load("ProductConfig/" + name);}

    var from_config = function(name) {return FileSystem.MakePath(name, Origin.Directory());};

    var interface_version = "0.0.0.0";

    var ns = this;

    var ns_vint = base("verint.js");
    var ns_version = base("version.js");
    var ns_event   = base("event.js");

    ns_vint.Add("product",       interface_version, base("product3.js"));
    ns_vint.Add("feature",       interface_version, base("feature3.js"));
    ns_vint.Add("component",     interface_version, base("component3.js"));
    ns_vint.Add("component_msi", interface_version, base("component_msi3.js"));
    ns_vint.Add("component_exe", interface_version, base("component_exe.js"));
    ns_vint.Add("component_zip", interface_version, base("component_zip.js"));
    ns_vint.Add("feature_info",  interface_version, base("feature_info.js"));
    ns_vint.Add("feature_map",   interface_version, base("feature_map.js"));

    var callbacks = {};

    var add_node_attr_into_info = function(node, info)
    {
        // node attributes also need to be stored
        for(var i in node.attributes)
        {
            if(!info.Property(i))
            {
                //Log("Add attribute " + i + " as property into Info val = " + node.attributes[i]);
                info.Property(i, node.attributes[i]);
            }
            else
                Log("Can't add attribute '" + i + "' as property into Info due to property with the same name already exists");
        }
    }

    // load configuration scripts
    var cb_files = FileSystem.FindFiles(FileSystem.AbsPath(Origin.Directory(), "ProductConfig"), "*.js");
    for(var i in cb_files)
    {
        var f = cb_files[i];
        Log("Product configuration script: " + f);

        var loader = conf(f);
        if(loader)
        {
            var id = Guid();
            if(loader.Id)
                id = loader.Id();
            if(!callbacks[id])
            {
                callbacks[id] = loader;
                Log("Set product loader: " + id);
            }
        }
    }

    var notify = function(attribute, proc)
    {
        for(var i in callbacks)
        {
            if(callbacks[i] && callbacks[i][attribute])
                proc(callbacks[i][attribute]);
        }
    }

    var filter = function(attribute, proc)
    {
        for(var i in callbacks)
        {
            if(callbacks[i] && callbacks[i][attribute])
                if(proc(callbacks[i][attribute]))
                    return true;
        }
        return false;
    }

    var exinit = function(attribute, proc)
    {
        var ev = ns_event.FEvent();
        for(var i in callbacks)
        {
            if(callbacks[i] && callbacks[i][attribute])
            {
                var e = proc(callbacks[i][attribute]);
                if(e)
                    ev.Connect(e);
            }
        }
        return ev.Empty() ? null : ev;
    }

    var load_components = function(dir, prod, node, cache)
    {
        var ns_info = base("component_info.js");
        var ns_src = base("component_source.js");

        var ns_cmp    = ns_vint.Get("component");
        var ns_cmpmsi = ns_vint.Get("component_msi");
        var ns_cmpexe = ns_vint.Get("component_exe");
        var ns_cmpzip = ns_vint.Get("component_zip");
        var ns_feamap = ns_vint.Get("feature_map");


        var base_url = GetOpt.GetDefault("media-url", node.attributes.url);
        if(base_url)
            Log("Component processing: base url: " + base_url);

        Log("Load component info");
        Log("  media dir: " + dir);
        Log("  cache mode: " + (cache ? "true" : "false"));

        if(cache)
        {
            var installs = FileSystem.MakePath("installs", FileSystem.GetTemp());
            // create action to clean installs directory after download
            var duf = base("dumper_file.js");
            if(duf)
            {
                var act = duf.Directory();
                act.DelayedRemove(installs);
                act.Skip = function(){return prod.Action() == prod.action_t.remove;};
                var post = prod.PostAction();
                if(post)
                    post.AddAction(act, "Clean installs in Temp");
            }
        }
        else
            var installs = FileSystem.MakePath("../installs", Origin.Directory());

        // load XML based information
        var xml_files = FileSystem.FindFiles(dir, "*.xml");
        var components = {};
        for(var i in xml_files)
        {
            var root = XML(FileSystem.MakePath(xml_files[i], dir));
            if(root && !filter("FilterInfo", function(cb){return cb(root, node);}))
            {
                var c = root.single("/component[@alias and @type]");
                if(c)
                {
                    var alias = c.attributes.alias;
                    var type = c.attributes.type;
                    var xml_info = ns_info.InfoXMLNode(root);
                    var component = prod.ComponentsFullSet()[xml_info.Id()];
                    if(!component)
                    {
                        var c_info = ns_info.ComponentInfo();
                        c_info.AddInfo(xml_info);

                        var component_data = {Info: c_info};
                        var exin = exinit("ExInit", function(cb) {return cb(root, node);});
                        if(exin)
                            component_data.ExInit = exin;

                        if(type == "msi")
                        { // create MSI based component
                            //var wi_info = ns_info.InfoWI(xml_info.Id());
                            //c_info.AddInfo(wi_info); // disabled due to MSI feature processing
                            component = ns_cmpmsi.Create(component_data);
                            var pro = component.Processor();
                            if(pro && pro.FeatureMap)
                            {
                                var feamap = ns_feamap.FeatureMap(c);
                                if(feamap)
                                    pro.FeatureMap(feamap);
                            }
                        }
                        else if(type == "exe")
                        { // create EXE based component
                            component = ns_cmpexe.Create(component_data);
                        }
                        else if(type == "zip")
                        { // create ZIP based component
                            component = ns_cmpzip.Create(component_data);
                        }
                        else
                        { // create EXE or another based component
                            component = ns_cmp.Create(component_data);
                        }
                    }

                    if(component && !component.SourceNode)
                        component.SourceNode = c;

                    if(component && !component.Source())
                    { // create source object for component
                        var files = c.single("files");
                        if(files)
                        {
                            var local_url = files.attributes.url;
                            var make_url = function(u)
                            {
                                if(local_url)
                                    return StringList.Format(GetOpt.GetDefault("media-url", local_url), u);
                                else
                                    return StringList.Format(base_url, u);
                            }

                            var k = files.single("key");
                            if(k)
                            {
                                Log("Component source: " + alias);
                                var file = FileSystem.MakePath(k.text, installs);
                                Log("  Key file target: " + file);
                                var c_src = null;
                                if(base_url)
                                {
                                    var url = make_url(k.text);
                                    var c_src = ns_src.UrlSource(file, url, parseInt(k.attributes.size));
                                    Log("  Key file url: " + url);
                                    if(c_src)
                                    {
                                        Log("  Web based File source object created");
                                        var s_files = files.select("file");
                                        if(s_files)
                                        {
                                            for(var s in s_files)
                                            {
                                                var url = make_url(s_files[s].text);
                                                var file = FileSystem.MakePath(s_files[s].text, installs);

                                                var src = ns_src.UrlSource(file, url, parseInt(s_files[s].attributes.size));
                                                Log("  Additional file url: " + url);
                                                Log("  Additional file target: " + file);
                                                if(src)
                                                    c_src.AddDependency(src);
                                            }
                                        }
                                    }
                                }
                                else
                                {
                                    if(FileSystem.Exists(file))
                                        var c_src = ns_src.FileSource(file);
                                }
                                if(c_src)
                                    component.Source(c_src);
                            }
                        }
                    }

                    if(component)
                        components[alias] = component;

                    Log("Component added to scope: alias: " + alias);
                    Log("Component added to scope: id: " + component.Id());
                }
            }
        }
        for(var i in components)
            return components; // in case if at least one element exists in components - return it
        return null; // else return null
    }

    var load_product = function(root, prod, components)
    {
        var ns_prd     = ns_vint.Get("product");
        var ns_feature = ns_vint.Get("feature");
        var ns_finfo   = ns_vint.Get("feature_info");

        var import_components = function(feature, node, components)
        {
            var cmps = node.select("component[@alias]");
            if(cmps && components)
            {
                for(var c in cmps)
                {
                    var cm = components[cmps[c].attributes.alias];
                    //if(cm && !cm.Disabled())
                    if(cm)
                    {
                        Log("Component " + cmps[c].attributes.alias + " added to feature " + feature.Name());
                        feature.Components().Add(cm);
                    }
                }
            }
        }

        var import_properties = function(product, node)
        {
            var props = node.select("property[@name]");
            if(props)
            {
                for(var p in props)
                {
                    var nm = props[p].attributes.name;
                    var val = StringList.Format(props[p].text);
                    if(nm)
                    {
                        Log("Property " + nm + " (value = '" + val + "') added to product " + product.Name());
                        product.CustomProperties().Value(nm, val);
                    }
                }
            }
        }


        if(root)
        {
            notify("Component", function(cb) {cb(components, root);}); // call callback function to postprocess components

            import_properties(prod, root);
            import_components(prod, root, components);            

            var signed = root.select("components/component[@alias and @signed='true']");
            for(var i in signed)
            {
                var alias = signed[i].attributes.alias;
                if(components[alias]) // set attribute to evaluate keyfile signature
                {
                    Log("Signed component: " + alias);
                    if(components[alias].Signed)
                        components[alias].Signed(true);
                }
            }

            var features = root.select("feature[@name and @id]");
            if(features)
            {
                var f_list = {};
                // create list of features
                for(var i in features)
                {
                    var f = features[i];
                    var id = f.attributes.id;
                    var name = f.attributes.name;
                    var parent = f.attributes.parent;
                    var prio = f.attributes.priority;
                    var ord = f.attributes.order;
                    var descr = f.attributes.description;

                    var feat = {};
                    var finfo = ns_finfo.InfoPure(id, name, descr);

                    add_node_attr_into_info(f, finfo);

                    feat.feature = ns_feature.Create(finfo);
                    feat.parent = parent;
                    if(prio)
                        feat.feature.Priority(parseInt(prio));
                    if(ord)
                        feat.feature.Order(parseInt(ord));
                    f_list[id] = feat;
                    Log("Created feature: " + name + " (" + id + "). Parent feature: " + feat.parent);

                    import_components(feat.feature, f, components);
                }

                // link features to product & another features
                for(var i in f_list)
                {
                    var f = f_list[i];
                    if(f.parent && f_list[f.parent] && f_list[f.parent].feature)
                    {
                        f_list[f.parent].feature.Features().Add(f.feature);
                        Log("Feature " + f.feature.Name() + " was added to parent feature " + f.parent);
                    }
                    else if(f.feature && !f.parent)
                    {
                        prod.Features().Add(f.feature);
                        Log("Feature " + f.feature.Name() + " was added to product");
                    }
                }
            }

            // call callback function to postprocess features
            var feat = {};
            for(var i in f_list)
                feat[i] = f_list[i].feature;
            notify("Feature", function(cb){cb(feat, root);});

            return prod;
        }
    }
    
    var create_product = function(source, cache)
    {
        Log("Creating product from file: " + source);

        var ns_finfo = ns_vint.Get("feature_info");
        var ns_prd   = ns_vint.Get("product");

        if(FileSystem.Exists(source))
        {
            var src = XML(source);
            if(src)
            {
                var root = src.single("/product[@name and @version and @id]");
                if(root)
                {
                    // get formal product attributes
                    var id = root.attributes.id;
                    var name = StringList.Format(root.attributes.name);
                    var version = root.attributes.version;
                    var descr = StringList.Format(root.attributes.description);

                    // create & base configure product
                    var pinfo = ns_finfo.InfoPure(id, name, descr, version);

                    add_node_attr_into_info(root, pinfo);

                    var prod = ns_prd.Create(pinfo);

                    prod.IS.AddSource(Origin.Directory());
                    prod.IS.AddSource(FileSystem.MakePath("..\\" + Cache.config_name, Origin.Directory()));

                    prod.ARP.DisplayName(name);
                    prod.ARP.DisplayVersion(version);
                    prod.ARP.Properties().Value("DisplayIcon", FileSystem.MakePath("Icons/micl.ico", prod.IS.TargetDir()));

                    prod.MICL.AddSource(FileSystem.exe_dir + FileSystem.exe_name);
                    prod.MICL.AddSource(FileSystem.exe_dir + "micl.js");
                    
                    var eula_rtf = StringList.Format("[eula_rtf]");
                    if(eula_rtf == "")
                        var eula_rtf = FileSystem.MakePath("eula.rtf", FileSystem.exe_dir);
                    else
                        eual_rtf = from_config(eula_rtf);

                    prod.MICL.AddSource(eula_rtf);
                    prod.MICL.AddSource(FileSystem.exe_dir, "*.cat");
                    prod.MICL.AddSource(Cache.Config());
                    prod.MICL.AddSource(Cache.PluginsDir());

                    prod.ContentLoaders().Add(id, function()
                        {
                            load_product(root, prod, load_components(FileSystem.Directory(source), prod, root, cache));
                            prod.Loaders = callbacks;
                            return true;
                        });
                    // call callback function to postprocess product
                    prod.RelationSetters().Add(Guid(), function() {Log("Setters called"); notify("Product", function(cb){cb(prod, root);}); return true;});

                    prod.Description(descr);

                    prod.ProductPostProcess = new ns_event.Event();

                    if(root.attributes.visible == "false")
                        prod.TopVisible(false);

                    return prod;
                }
            }
        }
        return null;
    }

    this.ProductFromMedia = function(cache)
    {
        Log("product_content::ProductFromMedia");
        var media = FileSystem.MakePath("Media", Origin.Directory());
        var config = FileSystem.MakePath("product.xml", media);
        Log("Creating product based on config file: " + config);
        return create_product(config, cache);

        return null;
    }

    this.ProductFromCache = function()
    {
        return ns.ProductFromMedia(true);
    }
}

