
//###############################################################
var required = function()
{
    var func_cache = {};

    var load = function(file)
    {
        if(FileSystem.Exists(file))
        {
            var name = FileSystem.FileName(file).toLowerCase();
            if(name)
            {
                var files = func_cache[name];
                if(files)
                {
                    for(var i in files)
                    {
                        if(FileSystem.Same(files[i].file, file))
                            return files[i].obj;
                    }
                }
            }
        }

        var obj = Execute.JScript(file);
        if(obj && name)
        {
            var f = {file:file, obj:obj};
            if(!func_cache[name])
                func_cache[name] = [];
            func_cache[name].push(f);
        }
        return obj;
    }

    return load;
}();

var execute = function(file)
{
    return Execute.JScript(file);
}

new function()
{
    var product_opt = "product";
    var init_name   = "init.js";
    var config_name = "config";

    var ScriptToStart = null;
    var StartDir = null;

    if(GetOpt.Exists(product_opt) && GetOpt.Get(product_opt))
    {
        StartDir = FileSystem.MakePath( GetOpt.Get(product_opt), Cache.CacheDir() );
        Log("   Start directory: " + StartDir);
        StringList.Load(StartDir);
    }
    else
    {
        StartDir = FileSystem.MakePath(FileSystem.exe_dir + config_name);
        Log("Launch from media. Start directory: " + StartDir);
    }

    ScriptToStart = FileSystem.MakePath(init_name, StartDir);
    Log("Script to start: " + ScriptToStart);

    if( FileSystem.Exists(ScriptToStart) )
    {
        var starter = required(ScriptToStart);
        if(starter)
        {
            if(Cache.Cached())
            {
                Log("Cache processing starting...");
                var ret = safecall(function(){return starter.Cache(true);},
                                   function(){Log(Log.l_error, "Exception handled calling init.Cache"); return Action.r_error;});
            }
            else
            {
                Log("Media processing starting...");
                var ret = safecall(function(){return starter.Media(true);},
                                   function(){Log(Log.l_error, "Exception handled calling init.Media"); return Action.r_error;});
            }

            switch(ret)
            {
            case Action.r_error:
                System.ExitCode(2);
                break;
            case Action.r_cancel:
                System.ExitCode(1);
                break;
            default:
                //System.ExitCode(0);
                break;
            }

        }
    }
    else
    {
        Log(Log.l_critical, "Script file doesn't exist. Abort");
        System.ExitCode(2);
    }
}

