#!/bin/bash
#
###########################################################
#
# (C) Copyright IBM Corporation 2007.
#       Released under GPL v2.
#       Author : Donjuma Lee (donslee@us.ibm.com)
#
# VERSION: 2.02
#
# contributions from Joel Diaz (joeldiaz@us.ibm.com)
#
###########################################################

# driver tool path
DRVTL_PATH="/usr/local/bin"
# ensure a working PATH
export PATH=/bin:/usr/bin:${DRVTL_PATH}:$PATH

# count errors
ERROR_COUNT=0

# locatin of the installer rpm
TOOL_DIR="tools"

# set the application directory
APPS_DIR="apps"

INSTALLER_PATH="$(dirname $0)"
cd $INSTALLER_PATH 2> /dev/null

# find the path and count the installer rpm
INSTALLER_RPM="$(find ${TOOL_DIR}/ -type f -name \*.rpm 2> /dev/null)"
INSTALLER_COUNT="$(find ${TOOL_DIR}/ -type f -name \*.rpm 2> /dev/null | wc -l)"

# installer setup
IBM_DRVTL="ibm-driver-tool.pl"
INSTALL_OPTIONS="--yes $@"

# basic package health checks
if [ ${INSTALLER_COUNT} -gt 1 ] || [ ${INSTALLER_COUNT} -lt 1 ]
then
	echo -e "Unexpected number of installer RPMs found: ${INSTALLER_COUNT}"
	echo -e "${INSTALLER_RPM}"
	ERROR_COUNT=$(( ${ERROR_COUNT} + 1 ))
fi
if [ ${ERROR_COUNT} -gt 0 ]
then
	echo -e "Exiting...."
	exit 1
fi

# install/update the installer
if [ -f ${INSTALLER_RPM} ]
then
	rpm -Uvh ${INSTALLER_PATH}/${INSTALLER_RPM} > /dev/null 2>&1
else
	echo -e "\ninstall.sh: ${TOOL_DIR}/ibm-driver-tools rpm not found"
	exit 1
fi

# run the installer with default and user provided options
if [ $? -gt 0 ] && [ ! -f "${DRVTL_PATH}/${IBM_DRVTL}" ]
then
	echo -e "\ninstall.sh: ibm-driver-tools failed to install."
	echo -e "This installation requires the following:"
	rpm -qp --requires ${INSTALLER_RPM}
	exit 1
else
echo -e "\n\n INSTALL_OPTIONS ${INSTALL_OPTIONS}\n"
	${IBM_DRVTL} ${INSTALL_OPTIONS}
	EXIT_CODE=$?
fi

# if the package was successfully installed
# install any apps
if [ -d ${APPS_DIR} ] && [ ${EXIT_CODE} -eq 0 ]
then
	if [ $(find ${APPS_DIR} -type f -name \*.rpm 2> /dev/null | wc --l) -gt 0 ]
	then
		echo -e "Applications directory \"${APPS_DIR}\" found, installing included RPMs"
		find ${APPS_DIR} -type f -name \*.rpm | xargs --replace=file rpm -Uvh file
	fi
fi

# exit with the installers exit code
exit ${EXIT_CODE}
