/*
 *----------------------------------------------------------------------------
 *	LSI Corporation
 *	1621 Barber Lane
 *	Milpitas, California 95035
 *----------------------------------------------------------------------------
 * Copyright  2004-2006, LSI Corporation All Rights Reserved.
 * 
 * LSI's source code is an unpublished work and the use of copyright
 * notice does not imply otherwise. This source code contains confidential,
 * trade secret material of LSI Corporation. Any attempt or
 * participation in deciphering, decoding, reverse engineering or
 * in any way altering the source code is strictly prohibited, unless the
 * prior written consent of LSI Corporation.
 *---------------------------------------------------------------------------- 
 */

/** 
 *@file osl_char.h
 *
 *@brief
 * Operating System Layer Character driver header.
 *
 * This file contains the character driver related definitions of MegaSWR
 * driver. This is used for sending IOCTL's down to the driver. 
 *
 *@bug
 *	None
 *
 *@warning
 *	None
 *
 *@note
 *	01-11-2004	: Created this file 
 */

#ifndef LSI_MEGA_SWR_OSL_CHAR
#define LSI_MEGA_SWR_OSL_CHAR

#define LSI_RAID_CHAR_DRIVER_NAME		"megaraid_swr_ioctl"
/**@todo manoj is this enough? */
#define LSI_RAID_IOCTL_MAX_DATA_SIZE	0x10000 /* 64 K */

#define  LSI_RAID_IOCTL_TIMEOUT		20 /* 20Sec */

/* ioctl activity status */
#define  LSI_RAID_IOCTL_NOT_ACTIVE	0x00
#define  LSI_RAID_IOCTL_ACTIVE		0x01
#define  LSI_RAID_IOCTL_FINISHED		0x02

#define LSI_GET_CTRLR_ID(ioctl)	((ioctl)->ioctlHeader.other.controllerId)
#define LSI_GET_MFI_IOCTL_VIR(ioctl_data) ((MFI_IOCTL *)(ioctl_data)->dma.vir)
#define LSI_GET_MFI_IOCTL_PHY(ioctl_d) ((unsigned long)((ioctl_d)->dma.dma_addr))
#define LSI_GET_MFI_IOCTL_LEN(ioctl_d) ((ioctl_d)->dma.len)

uint32_t lsraid_load_ioctl_module(pvt_data_t *adp);
void_t lsraid_unload_ioctl_module(pvt_data_t *adp);
uint32_t lsraid_register_char_driver(void_t);
uint32_t lsraid_unregister_char_driver(void_t);
#endif /* LSI_MEGA_SWR_OSL_CHAR */

/* vim: set ts=4 sw=4 tw=78 wrap ai si: */
