######
#
# Makefile Linux 2.6 Kernel Specific Definitions for the Tolapai build system 
#
# @par
# INTEL CONFIDENTIAL
# Copyright 2009 Intel Corporation All Rights Reserved.
# 
# The source code contained or described herein and all documents related to the
# source code ("Material") are owned by Intel Corporation or its suppliers or
# licensors. Title to the Material remains with Intel Corporation or its
# suppliers and licensors. The Material may contain trade secrets and proprietary
# and confidential information of Intel Corporation and its suppliers and
# licensors, and is protected by worldwide copyright and trade secret laws and
# treaty provisions. No part of the Material may be used, copied, reproduced,
# modified, published, uploaded, posted, transmitted, distributed, or disclosed
# in any way without Intels prior express written permission.
# No license under any patent, copyright, trade secret or other intellectual
# property right is granted to or conferred upon you by disclosure or delivery
# of the Materials, either expressly, by implication, inducement, estoppel or
# otherwise. Any license under such intellectual property rights must be
# express and approved by Intel in writing.
# 
# Include any supplier copyright notices as supplier requires Intel to use.
# Include supplier trademarks or logos as supplier requires Intel to use,
# preceded by an asterisk.
# An asterisked footnote can be added as follows: 
#   *Third Party trademarks are the property of their respective owners.
# 
# Unless otherwise agreed by Intel in writing, you may not remove or alter this
# notice or any other notice embedded in Materials by Intel or Intels suppliers
# or licensors in any way.
# 
#  version: ADS.L.1.1.0-160
######

$(info Building for linux_2.6)


INCLUDES+=-I ./#path to production header files and to add another "-I <path to another directory of include files>"


ifeq ($($(PROG_ACY)_OS_LEVEL), user_space)
CFLAGS+=-fPIC $(DEBUGFLAGS) -Wall -Wpointer-arith -O2 $(INCLUDES)
endif


ifeq ($($(PROG_ACY)_OS_LEVEL), kernel_space)
CFLAGS+= 
endif


ifeq ($($(PROG_ACY)_EXTRA_WARNINGS),y)
EXTRA_CFLAGS+= -Wno-div-by-zero -Wfloat-equal -Wtraditional  -Wundef -Wno-endif-labels \
      -Wshadow -Wbad-function-cast -Wcast-qual -Wcast-align -Wwrite-strings -Wconversion -Wsign-compare -Waggregate-return \
      -Wstrict-prototypes  -Wmissing-prototypes -Wmissing-declarations  -Wmissing-noreturn \
      -Wmissing-format-attribute -Wno-multichar -Wno-deprecated-declarations -Wpacked -Wpadded -Wredundant-decls -Wnested-externs -Wunreachable-code \
      -Winline -Wlong-long -Wdisabled-optimization 

## unrecognized options
## -Wextra -Wdeclaration-after-statement -Wlarger-than-len -Wold-style-definition -Wmissing-field-initializers -Winvalid-pch
## -Wvariadic-macros -Wno-pointer-sign
endif


LIB_SHARED_FLAGS=-shared -soname $(LIB_SHARED)
LIB_STATIC_FLAGS=
EXE_FLAGS=


