# @par
# INTEL CONFIDENTIAL
# Copyright 2009 Intel Corporation All Rights Reserved.
# 
# The source code contained or described herein and all documents related to the
# source code ("Material") are owned by Intel Corporation or its suppliers or
# licensors. Title to the Material remains with Intel Corporation or its
# suppliers and licensors. The Material may contain trade secrets and proprietary
# and confidential information of Intel Corporation and its suppliers and
# licensors, and is protected by worldwide copyright and trade secret laws and
# treaty provisions. No part of the Material may be used, copied, reproduced,
# modified, published, uploaded, posted, transmitted, distributed, or disclosed
# in any way without Intels prior express written permission.
# No license under any patent, copyright, trade secret or other intellectual
# property right is granted to or conferred upon you by disclosure or delivery
# of the Materials, either expressly, by implication, inducement, estoppel or
# otherwise. Any license under such intellectual property rights must be
# express and approved by Intel in writing.
# 
# Include any supplier copyright notices as supplier requires Intel to use.
# Include supplier trademarks or logos as supplier requires Intel to use,
# preceded by an asterisk.
# An asterisked footnote can be added as follows: 
#   *Third Party trademarks are the property of their respective owners.
# 
# Unless otherwise agreed by Intel in writing, you may not remove or alter this
# notice or any other notice embedded in Materials by Intel or Intels suppliers
# or licensors in any way.
# 
#  version: ADS.L.1.1.0-160

ifeq ($($(PROG_ACY)_OS_LEVEL), user_space)

# Compile the object files with the CFLAGS
$(OBJECTS): %.o: %.c
	@echo 'Compiling $<' ;\
	echo $(COMPILER) $(CFLAGS) $(EXTRA_CFLAGS) -c  $(PWD)/$< -o $($(PROG_ACY)_FINAL_OUTPUT_DIR)/$@;\
	$(COMPILER) $(CFLAGS) $(EXTRA_CFLAGS) -c $(PWD)/$< -o $($(PROG_ACY)_FINAL_OUTPUT_DIR)/$@;


# Create the shared library
$(LIB_SHARED): obj
	@echo 'Creating shared library ${LIB_SHARED}'; \
	cd $($(PROG_ACY)_FINAL_OUTPUT_DIR);\
	echo $(LINKER) $(LIB_SHARED_FLAGS) -o $@ -lc $(OBJECTS) $(ADDITIONAL_OBJECTS);\
	$(LINKER) $(LIB_SHARED_FLAGS) -o $@ -lc $(OBJECTS) $(ADDITIONAL_OBJECTS);


# Create the static library
$(LIB_STATIC): obj
	@echo 'Creating static library ${LIB_STATIC}'; \
	cd $($(PROG_ACY)_FINAL_OUTPUT_DIR);\
	echo $(ARCHIVER) $(LIB_STATIC_FLAGS) r $@ $(OBJECTS) $(ADDITIONAL_OBJECTS);\
	$(ARCHIVER) $(LIB_STATIC_FLAGS) r $@ $(OBJECTS) $(ADDITIONAL_OBJECTS);


#Create executable output
$(EXECUTABLE):  obj
	@echo 'Creating executable ${OUTPUT_NAME}'; \
	cd $($(PROG_ACY)_FINAL_OUTPUT_DIR);\
	$(COMPILER) $(EXE_FLAGS) -o $@  $(OBJECTS) $(ADDITIONAL_OBJECTS);


$(MODULENAME):
	@echo Error: $@: You cannot build modules in user_space;

endif
