######
#
# Makefile Common Definitions for the Tolapai build system 
#
# @par
# INTEL CONFIDENTIAL
# Copyright 2009 Intel Corporation All Rights Reserved.
# 
# The source code contained or described herein and all documents related to the
# source code ("Material") are owned by Intel Corporation or its suppliers or
# licensors. Title to the Material remains with Intel Corporation or its
# suppliers and licensors. The Material may contain trade secrets and proprietary
# and confidential information of Intel Corporation and its suppliers and
# licensors, and is protected by worldwide copyright and trade secret laws and
# treaty provisions. No part of the Material may be used, copied, reproduced,
# modified, published, uploaded, posted, transmitted, distributed, or disclosed
# in any way without Intels prior express written permission.
# No license under any patent, copyright, trade secret or other intellectual
# property right is granted to or conferred upon you by disclosure or delivery
# of the Materials, either expressly, by implication, inducement, estoppel or
# otherwise. Any license under such intellectual property rights must be
# express and approved by Intel in writing.
# 
# Include any supplier copyright notices as supplier requires Intel to use.
# Include supplier trademarks or logos as supplier requires Intel to use,
# preceded by an asterisk.
# An asterisked footnote can be added as follows: 
#   *Third Party trademarks are the property of their respective owners.
# 
# Unless otherwise agreed by Intel in writing, you may not remove or alter this
# notice or any other notice embedded in Materials by Intel or Intels suppliers
# or licensors in any way.
# 
#  version: ADS.L.1.1.0-160
#####

######Support $(PROG_ACY) and previous vars#################################
PROG_ACY?=ICP
ifdef $(PROG_ACY)_KERNEL_SOURCE_ROOT
KERNEL_SOURCE_ROOT=$($(PROG_ACY)_KERNEL_SOURCE_ROOT)
endif
$(PROG_ACY)_CORE?=ia
$(PROG_ACY)_OS?=linux_2.6
####################################################################

#Check to ensure that the BUILDSYSTEM is defined, it should point to the top of the build dir structure where build_files  are located
ifndef $(PROG_ACY)_BUILDSYSTEM_PATH
$(error $(PROG_ACY)_BUILDSYSTEM_PATH is undefined. Please set the path to the top of the build structure \
	"-> setenv BUILDSYSTEM_PATH <path>")
endif

# Ensure the ENV_DIR environmental var is defined.
ifndef $(PROG_ACY)_ENV_DIR
$(error $(PROG_ACY)_ENV_DIR is undefined. Please set the path to your environment makefile \
        "-> setenv $(PROG_ACY)_ENV_DIR <path>")
endif

#Add your project environment Makefile
include $($(PROG_ACY)_ENV_DIR)/environment.mk

# Compiler, Linker and Archive commands are defined in the core specific makefile
CC=$(COMPILER)
LD=$(LINKER)
AR=$(ARCHIVER)

EXTRA_CFLAGS+=-O2


PWD= $(shell pwd)

##directories
# path where to store all the build outputs
# only this one can be overwritten by users.
# This way, and with the 3 variables, we can prevent any rm -rf `pwd`
# when doing `make clean or distclean'
$(PROG_ACY)_BUILD_OUTPUT_DIR?=$(PWD)
$(PROG_ACY)_MID_OUTPUT_DIR=$($(PROG_ACY)_BUILD_OUTPUT_DIR)/build
$(PROG_ACY)_FINAL_OUTPUT_DIR=$($(PROG_ACY)_MID_OUTPUT_DIR)/$($(PROG_ACY)_OS)/$($(PROG_ACY)_OS_LEVEL)/
FINAL_OUTPUT_DIR=$($(PROG_ACY)_FINAL_OUTPUT_DIR)

# Defines a loop macro for making subdirectories
define LOOP
@for dir in $(SUBDIRS); do \
	(echo ; echo $$dir :; cd $$dir && \
		$(MAKE) $@ || return 1) \
	done
endef

include $($(PROG_ACY)_BUILDSYSTEM_PATH)/build_files/Core/$($(PROG_ACY)_CORE).mk
include $($(PROG_ACY)_BUILDSYSTEM_PATH)/build_files/OS/$($(PROG_ACY)_OS).mk

