####################
#  RULES
# @par
# INTEL CONFIDENTIAL
# Copyright 2009 Intel Corporation All Rights Reserved.
# 
# The source code contained or described herein and all documents related to the
# source code ("Material") are owned by Intel Corporation or its suppliers or
# licensors. Title to the Material remains with Intel Corporation or its
# suppliers and licensors. The Material may contain trade secrets and proprietary
# and confidential information of Intel Corporation and its suppliers and
# licensors, and is protected by worldwide copyright and trade secret laws and
# treaty provisions. No part of the Material may be used, copied, reproduced,
# modified, published, uploaded, posted, transmitted, distributed, or disclosed
# in any way without Intels prior express written permission.
# No license under any patent, copyright, trade secret or other intellectual
# property right is granted to or conferred upon you by disclosure or delivery
# of the Materials, either expressly, by implication, inducement, estoppel or
# otherwise. Any license under such intellectual property rights must be
# express and approved by Intel in writing.
# 
# Include any supplier copyright notices as supplier requires Intel to use.
# Include supplier trademarks or logos as supplier requires Intel to use,
# preceded by an asterisk.
# An asterisked footnote can be added as follows: 
#   *Third Party trademarks are the property of their respective owners.
# 
# Unless otherwise agreed by Intel in writing, you may not remove or alter this
# notice or any other notice embedded in Materials by Intel or Intels suppliers
# or licensors in any way.
# 
#  version: ADS.L.1.1.0-160
####################


######Support $(PROG_ACY)_ and previous vars#################################
PROG_ACY?=ICP
ifdef $(PROG_ACY)_KERNEL_SOURCE_ROOT
KERNEL_SOURCE_ROOT=$($(PROG_ACY)_KERNEL_SOURCE_ROOT)
endif
####################################################################


# Build and Install Everything, this is the default rule.
all: install 

#Top-level var for turning on debug#
ifdef $(PROG_ACY)_DEBUG
EXTRA_CFLAGS+=-DDEBUG=1
endif

# create .o's from the list of source files
# and keep only the name of the files
OBJECTS=$(notdir $(foreach file,$(SOURCES),$(file:.c=.o)))
OBJ=$(foreach file,$(SOURCES),$(file:.c=.o))
OBJ+=$(foreach file,$(MODULE_SOURCES),$(file:.c=.o))

LIB_SHARED=$(OUTPUT_NAME)_s.so
EXECUTABLE=$(OUTPUT_NAME)

LIB_STATIC=$(OUTPUT_NAME).a
MODULENAME=$(OUTPUT_NAME).o

obj: dirs $(OBJECTS)
lib_shared: $(LIB_SHARED)
exe: $(EXECUTABLE)
lib_static: $(LIB_STATIC)
module: $(MODULENAME)

vpath %.o  $($(PROG_ACY)_FINAL_OUTPUT_DIR)
vpath %.c $(dir $(SOURCES))

.PHONY: clean all help

# Cleanup
clean: 
	@echo 'Removing derived objects...'; \
	$(RM) -rf $(OBJECTS) $(LIB_STATIC) $(LIB_SHARED) $(EXECUTABLE) *.o *.cov *.a *.so* *.mod.* *.ko .*.cmd Module.symvers modules.order; \
	$(RM) -rf .tmp_versions; \
	$(RM) -rf $($(PROG_ACY)_FINAL_OUTPUT_DIR);



# rules to create the output directories
dirs:
	@echo 'Creating output directory' ;\
	test -d $($(PROG_ACY)_FINAL_OUTPUT_DIR) || mkdir -p $($(PROG_ACY)_FINAL_OUTPUT_DIR);



#include specific rules according to OS and IX_OS_LEVEL
include $($(PROG_ACY)_BUILDSYSTEM_PATH)/build_files/OS/$($(PROG_ACY)_OS)_$($(PROG_ACY)_OS_LEVEL)_rules.mk
