/******************************************************************************
* @file    adsTelTypes.h
*
* Contents: This file contains the type definitions for the ADS Telephony API.
*
* @par
* INTEL CONFIDENTIAL
* Copyright 2009 Intel Corporation All Rights Reserved.
* 
* The source code contained or described herein and all documents related to the
* source code ("Material") are owned by Intel Corporation or its suppliers or
* licensors. Title to the Material remains with Intel Corporation or its
* suppliers and licensors. The Material may contain trade secrets and proprietary
* and confidential information of Intel Corporation and its suppliers and
* licensors, and is protected by worldwide copyright and trade secret laws and
* treaty provisions. No part of the Material may be used, copied, reproduced,
* modified, published, uploaded, posted, transmitted, distributed, or disclosed
* in any way without Intels prior express written permission.
* No license under any patent, copyright, trade secret or other intellectual
* property right is granted to or conferred upon you by disclosure or delivery
* of the Materials, either expressly, by implication, inducement, estoppel or
* otherwise. Any license under such intellectual property rights must be
* express and approved by Intel in writing.
* 
* Include any supplier copyright notices as supplier requires Intel to use.
* Include supplier trademarks or logos as supplier requires Intel to use,
* preceded by an asterisk.
* An asterisked footnote can be added as follows: 
*   *Third Party trademarks are the property of their respective owners.
* 
* Unless otherwise agreed by Intel in writing, you may not remove or alter this
* notice or any other notice embedded in Materials by Intel or Intels suppliers
* or licensors in any way.
* 
*  version: ADS.L.1.1.0-160
******************************************************************************/

#ifndef ADS_TEL_TYPES_H_
#define ADS_TEL_TYPES_H_


/****************************************************************************/
/******************* DEFINES ************************************************/
/****************************************************************************/

/**
 * @ingroup adsTelEndpoint
 *       Maximum number of tones that can be sent to or detected by a tone
 *       generator component.
 * @description
 *       Used to define the maximum number of tones that can be sent to or
 *       detected by a tone generator component. See @ref adsTelEpTonePlay().
 */
#define ADS_TEL_MAX_TONES 32

/**
 * @ingroup adsTelEndpoint
 *       Maximum tone ID.
 * @description
 *       Maximum tone ID that can be passed to the tone generator/detector
 *       component. See @ref adsTelEpTonePlay().
 */
#define ADS_TEL_MAX_TONE_ID 255

/**
 * @ingroup adsTelEndpoint
 *       Maximum number of FSK bytes that can be sent to or detected by a tone
 *       generator component.
 * @description
 *       Used to define the maximum number of FSK bytes that can be sent to or
 *       detected by a tone generator component. See @ref adsTelEpFskPlay().
 */
#define ADS_TEL_MAX_FSK_BYTES       128


/**
 * @ingroup adsTelEndpoint
 *       Maximum number of parameters that can be set or retrieved for any
 *       component.
 * @description
 *       Used to define the maximum number of parameters that can be set or
 *       retrieved for any component. See @ref adsTelEpCompParamsSet()
 *       and
 */
#define ADS_TEL_MAX_PARAMS          32


/**
 * @ingroup adsTelCallback
 *       Maximum payload length.
 * @description
 *       Used to define the maximum length of payload for @ref AdsTelPacket_t
 *       that can be passed to the framwork via @ref adsTelEpDataCb_t.
 */
#define ADS_TEL_MAX_PAYLOAD_SIZE    1024


/**
 * @ingroup adsTelCallback
 *       Audio packet packet payload type.
 * @description
 *       Used to specify that the payload of a framework packet
 *       is audio.
 */
#define ADS_TEL_RTP_MD_TYPE_AUDIO   0x1


/**
 * @ingroup adsTelCallback
 *       RFC2833 Event packet payload type.
 * @description
 *       Used to specify that the payload of a framework packet
 *       is a RFC2833 Event.
 */
#define ADS_TEL_RTP_MD_TYPE_RFC2833_EVENT   0x2


/**
 * @ingroup adsTelEndpoint
 *       Identifier for the last segment to play.
 * @description
 *       Used to specify that this is the last segment to play.
 *       See @ref AdsTelMediaDesc_t
 */
#define ADS_TEL_MEDIA_SEG_EOP       0x7f


/**
 * @ingroup adsTelEndpoint
 *       Maximum number of segments that can be sent to a player component.
 * @description
 *       Used to define the maximum number of segments that can be sent
 *       to a player.
 */
#define ADS_TEL_PLY_MAX_SEGS        16


/**
 * @ingroup adsTelEndpoint
 *       Tone Generator last segment identifer
 * @description
 *       Used to define the last segment of a tone segment array buffer.
 *       See @ref AdsTelToneSeg_t.
 */
#define ADS_TEL_TG_LASTSEG          0x7F

/**
 * @ingroup adsTelEndpoint
 *       Tone Generator segment output mode type
 * @description
 *       Used to define the output mode of a tone generator as overwrite.
 *       This means that the tone generator will overwrite the output of the
 *       decoder. See @ref AdsTelToneSeg_t.
 */
#define ADS_TEL_TG_MODE_OVERWRITE  1

/**
 * @ingroup adsTelEndpoint
 *       Tone Generator segment output mode type
 * @description
 *       Used to define the output mode of a tone generator as mixer mode.
 *       This means that the output of the tone generator and the decoder
 *       will be mixed. See @ref AdsTelToneSeg_t.
 */
#define ADS_TEL_TG_MODE_MIX        2


/**
 * @ingroup adsTelEndpoint
 *       Tone Generator segment tone type
 * @description
 *       Used to define the tone generator segment tone type as Single Tone.
 *       See @ref AdsTelToneSeg_t.
 */
#define ADS_TEL_TG_SINGLETONE      1

/**
 * @ingroup adsTelEndpoint
 *       Tone Generator segment tone type
 * @description
 *       Used to define the tone generator segment tone type as Dual Tone.
 *       See @ref AdsTelToneSeg_t.
 */
#define ADS_TEL_TG_DUALTONE        2

/**
 * @ingroup adsTelEndpoint
 *       Tone Generator segment tone type
 * @description
 *       Used to define the tone generator segment tone type as Amplitude
 *       Modulated. See @ref AdsTelToneSeg_t.
 */
#define ADS_TEL_TG_AMTONE          3

/**
 * @ingroup adsTelEndpoint
 *       Tone Detector qualification criteria type
 * @description
 *       Used to define the tone detector qualification criteria as loose.
 *       See @ref AdsTelToneInfo_t.
 */
#define ADS_TEL_TD_QUAL_CRITERIA_LOOSE     1

/**
 * @ingroup adsTelEndpoint
 *       Tone Detector qualification criteria type
 * @description
 *       Used to define the tone detector qualification criteria as medium.
 *       See @ref AdsTelToneInfo_t.
 */
#define ADS_TEL_TD_QUAL_CRITERIA_MEDIUM    2

/**
 * @ingroup adsTelEndpoint
 *       Tone Detector qualification criteria type
 * @description
 *       Used to define the tone detector qualification criteria as tight.
 *       See @ref AdsTelToneInfo_t.
 */
#define ADS_TEL_TD_QUAL_CRITERIA_TIGHT     3



/**
 * @ingroup adsTelEndpoint
 *       Tone Detector event report attribute type
 * @description
 *       Used to define the tone detector event reporting attribute as
 *       tone on only. See @ref AdsTelToneInfo_t.
 */
#define ADS_TEL_TD_TONEATTR_EVTON       1

/**
 * @ingroup adsTelEndpoint
 *       Tone Detector event report attribute type
 * @description
 *       Used to define the tone detector event reporting attribute as
 *       tone off only. See @ref AdsTelToneInfo_t.
 */
#define ADS_TEL_TD_TONEATTR_EVTOFF      2

/**
 * @ingroup adsTelEndpoint
 *       Tone Detector event report attribute type
 * @description
 *       Used to define the tone detector event reporting attribute as
 *       tone on and tone off. See @ref AdsTelToneInfo_t.
 */
#define ADS_TEL_TD_TONEATTR_EVTBOTH \
                       (ADS_TEL_TD_TONEATTR_EVTON|ADS_TEL_TD_TONEATTR_EVTOFF)

/**
 * @ingroup adsTelEndpoint
 *       Tone Detector tone type
 * @description
 *       Used to define the tone detector tone type as single tone.
 *       See @ref AdsTelToneInfo_t.
 */
#define  ADS_TEL_TD_SINGLETONE          1

/**
 * @ingroup adsTelEndpoint
 *       Tone Detector tone type
 * @description
 *       Used to define the tone detector tone type as dual tone.
 *       See @ref AdsTelToneInfo_t.
 */
#define  ADS_TEL_TD_DUALTONE            2


/***********************************************************
 * tone id definitions. Consistent to RFC 2833 standard
 **********************************************************/

/**
 * @ingroup adsTelEndpoint
 *       RFC DTMF 0
 * @description
 *       Used to define the RFC DTMF 0 tone.
 */
#define RFC_TID_DTMF_0      0

/**
 * @ingroup adsTelEndpoint
 *       RFC DTMF 1
 * @description
 *       Used to define the RFC DTMF 1 tone.
 */
#define RFC_TID_DTMF_1      1

/**
 * @ingroup adsTelEndpoint
 *       RFC DTMF 2
 * @description
 *       Used to define the RFC DTMF 2 tone.
 */
#define RFC_TID_DTMF_2      2

/**
 * @ingroup adsTelEndpoint
 *       RFC DTMF 3
 * @description
 *       Used to define the RFC DTMF 3 tone.
 */
#define RFC_TID_DTMF_3      3

/**
 * @ingroup adsTelEndpoint
 *       RFC DTMF 4
 * @description
 *       Used to define the RFC DTMF 4 tone.
 */
#define RFC_TID_DTMF_4      4

/**
 * @ingroup adsTelEndpoint
 *       RFC DTMF 5
 * @description
 *       Used to define the RFC DTMF 5 tone.
 */
#define RFC_TID_DTMF_5      5

/**
 * @ingroup adsTelEndpoint
 *       RFC DTMF 6
 * @description
 *       Used to define the RFC DTMF 6 tone.
 */
#define RFC_TID_DTMF_6      6

/**
 * @ingroup adsTelEndpoint
 *       RFC DTMF 7
 * @description
 *       Used to define the RFC DTMF 7 tone.
 */
#define RFC_TID_DTMF_7      7

/**
 * @ingroup adsTelEndpoint
 *       RFC DTMF 8
 * @description
 *       Used to define the RFC DTMF 8 tone.
 */
#define RFC_TID_DTMF_8      8

/**
 * @ingroup adsTelEndpoint
 *       RFC DTMF 9
 * @description
 *       Used to define the RFC DTMF 9 tone.
 */
#define RFC_TID_DTMF_9      9

/**
 * @ingroup adsTelEndpoint
 *       RFC DTMF 10
 * @description
 *       Used to define the RFC DTMF 10 tone.
 */
#define RFC_TID_DTMF_STAR   10

/**
 * @ingroup adsTelEndpoint
 *       RFC DTMF 11
 * @description
 *       Used to define the RFC DTMF 11 tone.
 */
#define RFC_TID_DTMF_POUND  11

/**
 * @ingroup adsTelEndpoint
 *       RFC DTMF 12
 * @description
 *       Used to define the RFC DTMF 12 tone.
 */
#define RFC_TID_DTMF_A      12

/**
 * @ingroup adsTelEndpoint
 *       RFC DTMF 13
 * @description
 *       Used to define the RFC DTMF 13 tone.
 */
#define RFC_TID_DTMF_B      13

/**
 * @ingroup adsTelEndpoint
 *       Tone Detector tone type
 * @description
 *       Used to define the tone detector tone type.
 *       See @ref AdsTelToneInfo_t.
 */
#define RFC_TID_DTMF_C      14

/**
 * @ingroup adsTelEndpoint
 *       RFC DTMF 15
 * @description
 *       Used to define the RFC DTMF 15 tone.
 */
#define RFC_TID_DTMF_D      15


/* Fax tone id for fax bypass */
/**
 * @ingroup adsTelEndpoint
 *       Fax CED Tone.
 * @description
 *       Used to define a Fax CED tone.
 */
#define RFC_TID_FAX_CED     32

/**
 * @ingroup adsTelEndpoint
 *       Fax CNG Tone.
 * @description
 *       Used to define a Fax CNG tone.
 */
#define RFC_TID_FAX_CNG     36

/**
 * @ingroup adsTelEndpoint
 *       Fax V21 Tone.
 * @description
 *       Used to define a Fax V21 tone.
 */
#define RFC_TID_FAX_V21     40

/**
 * @ingroup adsTelEndpoint
 *       Call Progress Tone Base.
 * @description
 *       Used to the call progress tone base.
 */
#define RFC_CPT_START        64

/**
 * @ingroup adsTelEndpoint
 *       RFC CPT - Dial Tone
 * @description
 *       Used to define the RFC CPT - Dial Tone.
 */
#define RFC_TID_DIAL         66

/**
 * @ingroup adsTelEndpoint
 *       RFC CPT - PBX Dial Tone
 * @description
 *       Used to define the RFC CPT - PBX Dial Tone.
 */
#define RFC_TID_PBX_DIAL     67

/**
 * @ingroup adsTelEndpoint
 *       RFC CPT - Special Dial Tone
 * @description
 *       Used to define the RFC CPT - Special Dial Tone.
 */
#define RFC_TID_SP_DIAL      68

/**
 * @ingroup adsTelEndpoint
 *       RFC CPT - 2nd Dial Tone
 * @description
 *       Used to define the RFC CPT - 2nd Dial Tone.
 */
#define RFC_TID_2ND_DIAL     69

/**
 * @ingroup adsTelEndpoint
 *       RFC CPT - Ring Tone
 * @description
 *       Used to define the RFC CPT - Ring Tone.
 */
#define RFC_TID_RING         70

/**
 * @ingroup adsTelEndpoint
 *       RFC CPT - Special Ring Tone
 * @description
 *       Used to define the RFC CPT - Special Ring Tone.
 */
#define RFC_TID_SP_RING      71

/**
 * @ingroup adsTelEndpoint
 *       RFC CPT - Busy Tone
 * @description
 *       Used to define the RFC CPT - Busy Tone.
 */
#define RFC_TID_BUSY         72

/**
 * @ingroup adsTelEndpoint
 *       RFC CPT - Congestion Tone
 * @description
 *       Used to define the RFC CPT - Congestion Tone.
 */
#define RFC_TID_CONGESTION   73

/**
 * @ingroup adsTelEndpoint
 *       RFC CPT - Special Information Tone
 * @description
 *       Used to define the RFC CPT - Special Information Tone.
 */
#define RFC_TID_SP_INFO      74

/**
 * @ingroup adsTelEndpoint
 *       RFC CPT - Comfort Tone
 * @description
 *       Used to define the RFC CPT - Comfort Tone.
 */
#define RFC_TID_COMFORT      75

/**
 * @ingroup adsTelEndpoint
 *       RFC CPT - Hold Tone
 * @description
 *       Used to define the RFC CPT - Hold Tone.
 */
#define RFC_TID_HOLD         76

/**
 * @ingroup adsTelEndpoint
 *       Fax Tone ID.
 * @description
 *       Used to define a Fax tone - record tone.
 *       See @ref AdsTelToneInfo_t.
 */
#define RFC_TID_REC          77

/**
 * @ingroup adsTelEndpoint
 *       RFC CPT - Caller Wait Tone
 * @description
 *       Used to define the RFC CPT - Caller Wait Tone.
 */
#define RFC_TID_CALLER_WT    78

/**
 * @ingroup adsTelEndpoint
 *       RFC CPT - Call Waiting Tone
 * @description
 *       Used to define the RFC CPT - Call Waiting Tone.
 */
#define RFC_TID_CALL_WT      79

/**
 * @ingroup adsTelEndpoint
 *       RFC CPT - Pay Tone
 * @description
 *       Used to define the RFC CPT - Pay Tone.
 */
#define RFC_TID_PAY          80

/**
 * @ingroup adsTelEndpoint
 *       RFC CPT - Positive Indication Tone
 * @description
 *       Used to define the RFC CPT - Positive Indication Tone.
 */
#define RFC_TID_POS_IND      81

/**
 * @ingroup adsTelEndpoint
 *       RFC CPT - Negative Indication Tone
 * @description
 *       Used to define the RFC CPT - Negative Indication Tone.
 */
#define RFC_TID_NEG_IND      82

/**
 * @ingroup adsTelEndpoint
 *       RFC CPT - Warning Tone
 * @description
 *       Used to define the RFC CPT - Warning Tone.
 */
#define RFC_TID_WARNING      83

/**
 * @ingroup adsTelEndpoint
 *       RFC CPT - Intrusion Tone
 * @description
 *       Used to define the RFC CPT - Intrusion Tone.
 */
#define RFC_TID_INSTRUSION   84

/**
 * @ingroup adsTelEndpoint
 *       RFC CPT - Calling Card Service Tone
 * @description
 *       Used to define the RFC CPT - Calling Card Service Tone.
 */
#define RFC_TID_CAL_CARD     85

/**
 * @ingroup adsTelEndpoint
 *       RFC CPT - Payphone Recognition Tone
 * @description
 *       Used to define the RFC CPT - Payphone Recognition Tone.
 */
#define RFC_TID_PAYPHONE     86

/**
 * @ingroup adsTelEndpoint
 *       RFC CPT - CPE Alerting Signal
 * @description
 *       Used to define the RFC CPT - CPE Alerting Signal.
 */
#define RFC_TID_CAS          87

/**
 * @ingroup adsTelEndpoint
 *       RFC CPT - Off Hook Warning Tone
 * @description
 *       Used to define the RFC CPT - Off Hook Warning Tone.
 */
#define RFC_TID_OFFHK_WARN   88

/**
 * @ingroup adsTelEndpoint
 *       RFC CPT - Dial Tone
 * @description
 *       Used to define the RFC CPT - Confirmation Tone.
 */
#define RFC_TID_CONFIRMATION 97

/**
 * @ingroup adsTelEndpoint
 *       RFC CPT - Three Party Remind Tone
 * @description
 *       Used to define the RFC CPT - Three Party Remind Tone.
 */
#define RFC_TID_THR_PARTY    99

/**
 * @ingroup adsTelEndpoint
 *       RFC CPT - Number Unavailable Tone
 * @description
 *       Used to define the RFC CPT - Number Unavailable Tone.
 */
#define RFC_TID_UNAVAILABLE  102

/**
 * @ingroup adsTelEndpoint
 *       RFC CPT - Queue Tone
 * @description
 *       Used to define the RFC CPT - Queue Tone.
 */
#define RFC_TID_QUEUE        106


/***********************************************************
 * Japanese Call Progress Tones
 **********************************************************/
/**
 * @ingroup adsTelEndpoint
 *       Japan country code and pre-defined progress tones.
 * @description
 *       Dial tone.
 */
#define NTT_TID_DT    RFC_TID_DIAL

/**
 * @ingroup adsTelEndpoint
 *       Japan country code and pre-defined progress tones.
 * @description
 *       Ring back tone.
 */
#define NTT_TID_RBT    RFC_TID_RING

 /**
  * @ingroup adsTelEndpoint
  *       Japan country code and pre-defined progress tones.
  * @description
  *       Busy tone.
  */
#define NTT_TID_BT    RFC_TID_BUSY

/**
 * @ingroup adsTelEndpoint
 *       Japan country code and pre-defined progress tones.
 * @description
 *       Private dial tone.
 */
#define NTT_TID_PDT    RFC_TID_PBX_DIAL

/**
 * @ingroup adsTelEndpoint
 *       Japan country code and pre-defined progress tones.
 * @description
 *       Second dial tone.
 */
#define NTT_TID_SDT    RFC_TID_2ND_DIAL

/**
 * @ingroup adsTelEndpoint
 *       Japan country code and pre-defined progress tones.
 * @description
 *       Acceptance tone.
 */
#define NTT_TID_CPT    RFC_TID_POS_IND

/**
 * @ingroup adsTelEndpoint
 *       Japan country code and pre-defined progress tones.
 * @description
 *       Hold service tone.
 */
#define NTT_TID_HST    RFC_TID_HOLD

/**
 * @ingroup adsTelEndpoint
 *       Japan country code and pre-defined progress tones.
 * @description
 *       Incoming id tone.
 */
#define NTT_TID_IIT    RFC_TID_CALL_WT

/**
 * @ingroup adsTelEndpoint
 *       Japan country code and pre-defined progress tones.
 * @description
 *       Special incoming id tone.
 */
#define NTT_TID_SIIT    110

/**
 * @ingroup adsTelEndpoint
 *       Japan country code and pre-defined progress tones.
 * @description
 *       Howler tone.
 */
#define NTT_TID_HOW    RFC_TID_OFFHK_WARN


/***********************************************************
 * US Call Progress Tones
 **********************************************************/
/**
 * @ingroup adsTelEndpoint
 *       United States country code and pre-defined progress tones.
 * @description
 *       Dial tone.
 */
#define US_TID_DIAL    RFC_TID_DIAL

/**
 * @ingroup adsTelEndpoint
 *       United States country code and pre-defined progress tones.
 * @description
 *       Ring back tone.
 */
#define US_TID_RING    RFC_TID_RING

/**
 * @ingroup adsTelEndpoint
 *       United States country code and pre-defined progress tones.
 * @description
 *       Busy tone.
 */
#define US_TID_BUSY    RFC_TID_BUSY

/**
 * @ingroup adsTelEndpoint
 *       United States country code and pre-defined progress tones.
 * @description
 *       Recall dial tone.
 */
#define US_TID_RC_DIAL    RFC_TID_SP_DIAL

/**
 * @ingroup adsTelEndpoint
 *       United States country code and pre-defined progress tones.
 * @description
 *       PBX dial tone.
 */
#define US_TID_PBX_DIAL    RFC_TID_PBX_DIAL

/**
 * @ingroup adsTelEndpoint
 *       United States country code and pre-defined progress tones.
 * @description
 *       Congestion tone.
 */
#define US_TID_CONGESTION    RFC_TID_CONGESTION

/**
 * @ingroup adsTelEndpoint
 *       United States country code and pre-defined progress tones.
 * @description
 *       Call waiting tone.
 */
#define US_TID_CALL_WT    RFC_TID_CALL_WT

/**
 * @ingroup adsTelEndpoint
 *       United States country code and pre-defined progress tones.
 * @description
 *       Operator intervening tone.
 */
#define US_TID_WARN_OPER    110


/***********************************************************
 * Peoples Republic Of China Call Progress Tones
 **********************************************************/
/**
 * @ingroup adsTelEndpoint
 *       China country code and pre-defined progress tones.
 * @description
 *       Dial tone.
 */
#define PRC_TID_DIAL    RFC_TID_DIAL

/**
 * @ingroup adsTelEndpoint
 *       China country code and pre-defined progress tones.
 * @description
 *       Ring back tone.
 */
#define PRC_TID_RING    RFC_TID_RING

/**
 * @ingroup adsTelEndpoint
 *       China country code and pre-defined progress tones.
 * @description
 *       Busy tone.
 */
#define PRC_TID_BUSY    RFC_TID_BUSY

/**
 * @ingroup adsTelEndpoint
 *       China country code and pre-defined progress tones.
 * @description
 *       Special dial tone.
 */
#define PRC_TID_SP_DIAL    RFC_TID_SP_DIAL

/**
 * @ingroup adsTelEndpoint
 *       China country code and pre-defined progress tones.
 * @description
 *       Congestion tone.
 */
#define PRC_TID_CONGESTION    RFC_TID_CONGESTION

/**
 * @ingroup adsTelEndpoint
 *       China country code and pre-defined progress tones.
 * @description
 *       Unavailable tone.
 */
#define PRC_TID_UNAVAILABLE    RFC_TID_UNAVAILABLE

/**
 * @ingroup adsTelEndpoint
 *       China country code and pre-defined progress tones.
 * @description
 *       Long distance tone.
 */
#define PRC_TID_TOLL    RFC_TID_COMFORT

/**
 * @ingroup adsTelEndpoint
 *       China country code and pre-defined progress tones.
 * @description
 *       Queue tone.
 */
#define PRC_TID_QUEUE    RFC_TID_QUEUE

/**
 * @ingroup adsTelEndpoint
 *       China country code and pre-defined progress tones.
 * @description
 *       Call waiting tone.
 */
#define PRC_TID_CALL_WT    RFC_TID_CALL_WT

/**
 * @ingroup adsTelEndpoint
 *       China country code and pre-defined progress tones.
 * @description
 *       3 party remind tone.
 *       See @ref AdsTelToneInfo_t.
 */
#define PRC_TID_THR_PARTY    RFC_TID_THR_PARTY

/**
 * @ingroup adsTelEndpoint
 *       China country code and pre-defined progress tones.
 * @description
 *       Confirmation tone.
 */
#define PRC_TID_CONFIRMATION    RFC_TID_CONFIRMATION

/**
 * @ingroup adsTelEndpoint
 *       China country code and pre-defined progress tones.
 * @description
 *       Howler tone.
 */
#define PRC_TID_OFFHK_WARN    RFC_TID_OFFHK_WARN


/***********************************************************
 * Decdocer autoswitch bitmasks
 **********************************************************/
/**
 * @ingroup adsTelEndpoint
 *       Decoder AutoSwitch Parameters.
 * @description
 *       Mask bits used to specify the coder type - OFF.
 */
#define ADS_TEL_DEC_AUTOSW_OFF 0x0000

/**
 * @ingroup adsTelEndpoint
 *       Decoder AutoSwitch Parameters.
 * @description
 *       Mask bits used to specify the coder type - G711MU.
 */
#define ADS_TEL_DEC_AUTOSW_G711MU 0x0001

/**
 * @ingroup adsTelEndpoint
 *       Decoder AutoSwitch Parameters.
 * @description
 *       Mask bits used to specify the coder type - G711A.
 */
#define ADS_TEL_DEC_AUTOSW_G711A 0x0002

/**
 * @ingroup adsTelEndpoint
 *       Decoder AutoSwitch Parameters.
 * @description
 *       Mask bits used to specify the coder type - G729A.
 */
#define ADS_TEL_DEC_AUTOSW_G729A 0x0004

/**
 * @ingroup adsTelEndpoint
 *       Decoder AutoSwitch Parameters.
 * @description
 *       Mask bits used to specify the coder type - G723.
 */
#define ADS_TEL_DEC_AUTOSW_G723 0x0008

/**
 * @ingroup adsTelEndpoint
 *       Decoder AutoSwitch Parameters.
 * @description
 *       Mask bits used to specify the coder type - G722.
 */
#define ADS_TEL_DEC_AUTOSW_G722_64 0x0010

/**
 * @ingroup adsTelEndpoint
 *       Decoder AutoSwitch Parameters.
 * @description
 *       Mask bits used to specify the coder type - G726_40.
 */
#define ADS_TEL_DEC_AUTOSW_G726_40 0x0020

/**
 * @ingroup adsTelEndpoint
 *       Decoder AutoSwitch Parameters.
 * @description
 *       Mask bits used to specify the coder type - G726_32.
 */
#define ADS_TEL_DEC_AUTOSW_G726_32 0x0040

/**
 * @ingroup adsTelEndpoint
 *       Decoder AutoSwitch Parameters.
 * @description
 *       Mask bits used to specify the coder type - G726_24.
 */
#define ADS_TEL_DEC_AUTOSW_G726_24 0x0080

/**
 * @ingroup adsTelEndpoint
 *       Decoder AutoSwitch Parameters.
 * @description
 *       Mask bits used to specify the coder type - G726_16.
 */
#define ADS_TEL_DEC_AUTOSW_G726_16 0x0100

/**
 * @ingroup adsTelEndpoint
 *       Decoder AutoSwitch Parameters.
 * @description
 *       Mask bits used to specify the coder type - G729_1.
 */
#define ADS_TEL_DEC_AUTOSW_G729_1 0x0200

/**
 * @ingroup adsTelEndpoint
 *       Decoder AutoSwitch Parameters.
 * @description
 *       Mask bits used to specify the coder type - G722_56.
 */
#define ADS_TEL_DEC_AUTOSW_G722_56 0x0400

/**
 * @ingroup adsTelEndpoint
 *       Decoder AutoSwitch Parameters.
 * @description
 *       Mask bits used to specify the coder type - G722_48.
 */
#define ADS_TEL_DEC_AUTOSW_G722_48 0x0800

/**
 * @ingroup adsTelEndpoint
 *       Decoder AutoSwitch Parameters.
 * @description
 *       Mask bits used to specify the coder type - ALL.
 */
#define ADS_TEL_DEC_AUTOSW_ALL 0xffff


/***********************************************************
 * Tone Detection Termination Digits Masks
 **********************************************************/
/**
 * @ingroup adsTelEndpoint
 *       Termination digits.
 * @description
 *       Mask bits used to specify the termination digit for TD.
 *       See @ref adsTelEpToneRecv().
 */
#define ADS_TEL_TD_TIMEOUT_FOREVER         0xffff

/**
 * @ingroup adsTelEndpoint
 *       Termination digits.
 * @description
 *       Mask bits used to specify the termination digit for TD.
 *       See @ref adsTelEpToneRecv().
 */
#define ADS_TEL_TD_TERM_DIGIT_NONE         0x0000

/**
 * @ingroup adsTelEndpoint
 *       Termination digits.
 * @description
 *       Mask bits used to specify the termination digit for TD.
 *       See @ref adsTelEpToneRecv().
 */
#define ADS_TEL_TD_TERM_DIGIT_0            0x0001

/**
 * @ingroup adsTelEndpoint
 *       Termination digits.
 * @description
 *       Mask bits used to specify the termination digit for TD.
 *       See @ref adsTelEpToneRecv().
 */
#define ADS_TEL_TD_TERM_DIGIT_1            0x0002

/**
 * @ingroup adsTelEndpoint
 *       Termination digits.
 * @description
 *       Mask bits used to specify the termination digit for TD.
 *       See @ref adsTelEpToneRecv().
 */
#define ADS_TEL_TD_TERM_DIGIT_2            0x0004

/**
 * @ingroup adsTelEndpoint
 *       Termination digits.
 * @description
 *       Mask bits used to specify the termination digit for TD.
 *       See @ref adsTelEpToneRecv().
 */
#define ADS_TEL_TD_TERM_DIGIT_3            0x0008

/**
 * @ingroup adsTelEndpoint
 *       Termination digits.
 * @description
 *       Mask bits used to specify the termination digit for TD.
 *       See @ref adsTelEpToneRecv().
 */
#define ADS_TEL_TD_TERM_DIGIT_4            0x0010

/**
 * @ingroup adsTelEndpoint
 *       Termination digits.
 * @description
 *       Mask bits used to specify the termination digit for TD.
 *       See @ref adsTelEpToneRecv().
 */
#define ADS_TEL_TD_TERM_DIGIT_5            0x0020

/**
 * @ingroup adsTelEndpoint
 *       Termination digits.
 * @description
 *       Mask bits used to specify the termination digit for TD.
 *       See @ref adsTelEpToneRecv().
 */
#define ADS_TEL_TD_TERM_DIGIT_6            0x0040

/**
 * @ingroup adsTelEndpoint
 *       Termination digits.
 * @description
 *       Mask bits used to specify the termination digit for TD.
 *       See @ref adsTelEpToneRecv().
 */
#define ADS_TEL_TD_TERM_DIGIT_7            0x0080

/**
 * @ingroup adsTelEndpoint
 *       Termination digits.
 * @description
 *       Mask bits used to specify the termination digit for TD.
 *       See @ref adsTelEpToneRecv().
 */
#define ADS_TEL_TD_TERM_DIGIT_8            0x0100

/**
 * @ingroup adsTelEndpoint
 *       Termination digits.
 * @description
 *       Mask bits used to specify the termination digit for TD.
 *       See @ref adsTelEpToneRecv().
 */
#define ADS_TEL_TD_TERM_DIGIT_9            0x0200

/**
 * @ingroup adsTelEndpoint
 *       Termination digits.
 * @description
 *       Mask bits used to specify the termination digit for TD.
 *       See @ref adsTelEpToneRecv().
 */
#define ADS_TEL_TD_TERM_DIGIT_STAR         0x0400

/**
 * @ingroup adsTelEndpoint
 *       Termination digits.
 * @description
 *       Mask bits used to specify the termination digit for TD.
 *       See @ref adsTelEpToneRecv().
 */
#define ADS_TEL_TD_TERM_DIGIT_POUND        0x0800

/**
 * @ingroup adsTelEndpoint
 *       Termination digits.
 * @description
 *       Mask bits used to specify the termination digit for TD.
 *       See @ref adsTelEpToneRecv().
 */
#define ADS_TEL_TD_TERM_DIGIT_A            0x1000

/**
 * @ingroup adsTelEndpoint
 *       Termination digits.
 * @description
 *       Mask bits used to specify the termination digit for TD.
 *       See @ref adsTelEpToneRecv().
 */
#define ADS_TEL_TD_TERM_DIGIT_B            0x2000

/**
 * @ingroup adsTelEndpoint
 *       Termination digits.
 * @description
 *       Mask bits used to specify the termination digit for TD.
 *       See @ref adsTelEpToneRecv().
 */
#define ADS_TEL_TD_TERM_DIGIT_C            0x4000

/**
 * @ingroup adsTelEndpoint
 *       Termination digits.
 * @description
 *       Mask bits used to specify the termination digit for TD.
 *       See @ref adsTelEpToneRecv().
 */
#define ADS_TEL_TD_TERM_DIGIT_D            0x8000

/***********************************************************
 * Stop Reasons
 **********************************************************/
/**
 * @ingroup adsTelEndpoint
 *       Stop Reasons.
 * @description
 *       Stopped by user.
 *       See @ref AdsTelRetTg_t @ref AdsTelRetTd_t. @ref AdsTelRetTdFsk_t
 */
#define ADS_TEL_STOP_REASON_USER       1

/**
 * @ingroup adsTelEndpoint
 *       Stop Reasons.
 * @description
 *       End of Data.
 *       See @ref AdsTelRetTg_t @ref AdsTelRetTd_t. @ref AdsTelRetTdFsk_t
 */
#define ADS_TEL_STOP_REASON_EOD        2

/**
 * @ingroup adsTelEndpoint
 *       Stop Reasons.
 * @description
 *       Stopped by a termination condition.
 *       See @ref AdsTelRetTg_t @ref AdsTelRetTd_t. @ref AdsTelRetTdFsk_t
 */
#define ADS_TEL_STOP_REASON_TERM       3

/**
 * @ingroup adsTelEndpoint
 *       Stop Reasons.
 * @description
 *       Time out.
 *       See @ref AdsTelRetTg_t @ref AdsTelRetTd_t. @ref AdsTelRetTdFsk_t
 */
#define ADS_TEL_STOP_REASON_TIMEOUT    4

/**
 * @ingroup adsTelEndpoint
 *       Stop Reasons.
 * @description
 *       General error.
 *       See @ref AdsTelRetTg_t @ref AdsTelRetTd_t. @ref AdsTelRetTdFsk_t
 */
#define ADS_TEL_STOP_REASON_ERROR      5


/***********************************************************
 * Parameter Values
 **********************************************************/
/**
 * @ingroup adsTelEndpoint
 *       Parameter Value
 * @description
 *       Enable a parameter.
 * @see
 *       @ref adsTelEpCompParamsSet() \n
 *       @ref adsTelEpCompParamsGet().
 */
#define ADS_TEL_PARAM_ON                    1

/**
 * @ingroup adsTelEndpoint
 *       Parameter Value
 * @description
 *       Disable a parameter.
 * @see
 *       @ref adsTelEpCompParamsSet() \n
 *       @ref adsTelEpCompParamsGet().
 */
#define ADS_TEL_PARAM_OFF                   0

/**
 * @ingroup adsTelEndpoint
 *       Parameter Value
 * @description
 *       EC Non Linear Processing On
 * @see
 *       @ref adsTelEpCompParamsSet() \n
 *       @ref adsTelEpCompParamsGet().
 */
#define ADS_TEL_PARAM_EC_NLP_ON             1

/**
 * @ingroup adsTelEndpoint
 *       Parameter Value
 * @description
 *       EC Non Linear Processing Sub band on.
 * @see
 *       @ref adsTelEpCompParamsSet() \n
 *       @ref adsTelEpCompParamsGet().
 */
#define ADS_TEL_PARAM_EC_NLP_SUB_ON         2

/**
 * @ingroup adsTelEndpoint
 *       Parameter Value
 * @description
 *       Tone Detector Report Tone On
 * @see
 *       @ref adsTelEpCompParamsSet() \n
 *       @ref adsTelEpCompParamsGet().
 */
#define ADS_TEL_PARAM_TD_RPT_OFF            0

/**
 * @ingroup adsTelEndpoint
 *       Parameter Value
 * @description
 *       Tone Detector Report Tone On
 * @see
 *       @ref adsTelEpCompParamsSet() \n
 *       @ref adsTelEpCompParamsGet().
 */
#define ADS_TEL_PARAM_TD_RPT_TONE_ON        1

/**
 * @ingroup adsTelEndpoint
 *       Parameter Value
 * @description
 *       Tone Detector Report Tone off
 * @see
 *       @ref adsTelEpCompParamsSet() \n
 *       @ref adsTelEpCompParamsGet().
 */
#define ADS_TEL_PARAM_TD_RPT_TONE_OFF       2

/**
 * @ingroup adsTelEndpoint
 *       Parameter Value
 * @description
 *       Tone Detector Report Tone on/off
 * @see
 *       @ref adsTelEpCompParamsSet() \n
 *       @ref adsTelEpCompParamsGet().
 */
#define ADS_TEL_PARAM_TD_RPT_TONE_ON_OFF    3

/**
 * @ingroup adsTelEndpoint
 *       Parameter Value
 * @description
 *       Tone Detector TC Frame Max
 */
#define ADS_TEL_PARAM_TD_TC_FRAMES_MAX      3

/**
 * @ingroup adsTelEndpoint
 *       Parameter Value
 * @description
 *       Tone Detector non adaptive threshold.
 * @see
 *       @ref adsTelEpCompParamsSet() \n
 *       @ref adsTelEpCompParamsGet().
 */
#define ADS_TEL_PARAM_TD_NON_ADAPT_THRES    0

/**
 * @ingroup adsTelEndpoint
 *       Parameter Value
 * @description
 *       Tone Detector adaptive threshold.
 * @see
 *       @ref adsTelEpCompParamsSet() \n
 *       @ref adsTelEpCompParamsGet().
 */
#define ADS_TEL_PARAM_TD_ADAPT_THRES        1

/**
 * @ingroup adsTelEndpoint
 *       Parameter Value
 * @description
 *       G726 Pack LSB
 * @see
 *       @ref adsTelEpCompParamsSet() \n
 *       @ref adsTelEpCompParamsGet().
 */
#define ADS_TEL_PARAM_G726_PACK_LSB         0

/**
 * @ingroup adsTelEndpoint
 *       Parameter Value
 * @description
 *       G726 Pack MSB
 * @see
 *       @ref adsTelEpCompParamsSet() \n
 *       @ref adsTelEpCompParamsGet().
 */
#define ADS_TEL_PARAM_G726_PACK_MSB         1


/**
 * @ingroup adsTelEndpoint
 *       Parameter Value
 * @description
 *       Tone Generator FSK V23
 * @see
 *       @ref adsTelEpCompParamsSet() \n
 *       @ref adsTelEpCompParamsGet().
 */
#define ADS_TEL_PARAM_TG_FSK_V23         0

/**
 * @ingroup adsTelEndpoint
 *       Parameter Value
 * @description
 *       Tone Generator FSK B202
 * @see
 *       @ref adsTelEpCompParamsSet() \n
 *       @ref adsTelEpCompParamsGet().
 */
#define ADS_TEL_PARAM_TG_FSK_B202        1

/**
 * @ingroup adsTelEndpoint
 *       Parameter Value
 * @description
 *       Tone Generator FSK R1200
 * @see
 *       @ref adsTelEpCompParamsSet() \n
 *       @ref adsTelEpCompParamsGet().
 */
#define ADS_TEL_PARAM_TG_FSK_R1200       8

/**
 * @ingroup adsTelEndpoint
 *       Parameter Value
 * @description
 *       Tone Generator FSK R600
 * @see
 *       @ref adsTelEpCompParamsSet() \n
 *       @ref adsTelEpCompParamsGet().
 */
#define ADS_TEL_PARAM_TG_FSK_R600        16

/**
 * @ingroup adsTelEndpoint
 *       Parameter Value
 * @description
 *       Tone Generator FSK R300
 * @see
 *       @ref adsTelEpCompParamsSet() \n
 *       @ref adsTelEpCompParamsGet().
 */
#define ADS_TEL_PARAM_TG_FSK_R300        32

/**
 * @ingroup adsTelEndpoint
 *       Parameter Value
 * @description
 *       Tone Generator FSK R150
 * @see
 *       @ref adsTelEpCompParamsSet() \n
 *       @ref adsTelEpCompParamsGet().
 */
#define ADS_TEL_PARAM_TG_FSK_R150        64

/**
 * @ingroup adsTelEndpoint
 *       Parameter Value
 * @description
 *       Tone Generator FSK R75
 * @see
 *       @ref adsTelEpCompParamsSet() \n
 *       @ref adsTelEpCompParamsGet().
 */
#define ADS_TEL_PARAM_TG_FSK_R75         128

/**
 * @ingroup adsTelEndpoint
 *       Parameter Value
 * @description
 *       Tone Generator/Player wideband mode
 * @see
 *       @ref adsTelEpCompParamsSet() \n
 *       @ref adsTelEpCompParamsGet().
 */
#define ADS_TEL_PARAM_WB             1

/**
 * @ingroup adsTelEndpoint
 *       Parameter Value
 * @description
 *       Tone Generator/Player narrowband mode
 * @see
 *       @ref adsTelEpCompParamsSet() \n
 *       @ref adsTelEpCompParamsGet().
 */
#define ADS_TEL_PARAM_NB             0


/**
 * @ingroup adsTelEndpoint
 *       Parameter Value
 * @description
 *       Country Specific Tone Generator FSK CS US
 * @see
 *       @ref adsTelEpCompParamsSet() \n
 *       @ref adsTelEpCompParamsGet().
 */
#define ADS_TEL_PARAM_TG_FSK_CS_US       300

/**
 * @ingroup adsTelEndpoint
 *       Parameter Value
 * @description
 *       Country Specific Tone Generator FSK Mark US
 * @see
 *       @ref adsTelEpCompParamsSet() \n
 *       @ref adsTelEpCompParamsGet().
 */
#define ADS_TEL_PARAM_TG_FSK_MARK_US     180

/**
 * @ingroup adsTelEndpoint
 *       Parameter Value
 * @description
 *       Country Specific Tone Generator FSK CS Japan
 * @see
 *       @ref adsTelEpCompParamsSet() \n
 *       @ref adsTelEpCompParamsGet().
 */
#define ADS_TEL_PARAM_TG_FSK_CS_JP       0

/**
 * @ingroup adsTelEndpoint
 *       Parameter Value
 * @description
 *       Country Specific Tone Generator FSK Mark Japan
 * @see
 *       @ref adsTelEpCompParamsSet() \n
 *       @ref adsTelEpCompParamsGet().
 */
#define ADS_TEL_PARAM_TG_FSK_MARK_JP     100

/**
 * @ingroup adsTelEndpoint
 *       Parameter Value
 * @description
 *       Country Specific Tone Generator FSK CS Peoples Republic of China
 * @see
 *       @ref adsTelEpCompParamsSet() \n
 *       @ref adsTelEpCompParamsGet().
 */
#define ADS_TEL_PARAM_TG_FSK_CS_PRC      300

/**
 * @ingroup adsTelEndpoint
 *       Parameter Value
 * @description
 *       Country Specific Tone Generator FSK Mark Peoples Republic of China
 * @see
 *       @ref adsTelEpCompParamsSet() \n
 *       @ref adsTelEpCompParamsGet().
 */
#define ADS_TEL_PARAM_TG_FSK_MARK_PRC    180



/**
 * @ingroup adsTelEndpoint
 *       Parameter Value
 * @description
 *       Country Specific Tone Detector FSK CS US
 * @see
 *       @ref adsTelEpCompParamsSet() \n
 *       @ref adsTelEpCompParamsGet().
 */
#define ADS_TEL_PARAM_TD_FSK_CS_US          200

/**
 * @ingroup adsTelEndpoint
 *       Parameter Value
 * @description
 *       Country Specific Tone Detector FSK Mark US
 * @see
 *       @ref adsTelEpCompParamsSet() \n
 *       @ref adsTelEpCompParamsGet().
 */
#define ADS_TEL_PARAM_TD_FSK_MARK_US        100

/**
 * @ingroup adsTelEndpoint
 *       Parameter Value
 * @description
 *       Country Specific Tone Detector FSK CS JP
 * @see
 *       @ref adsTelEpCompParamsSet() \n
 *       @ref adsTelEpCompParamsGet().
 */
#define ADS_TEL_PARAM_TD_FSK_CS_JP          0

/**
 * @ingroup adsTelEndpoint
 *       Parameter Value
 * @description
 *       Country Specific Tone Detector FSK Mark JP
 * @see
 *       @ref adsTelEpCompParamsSet() \n
 *       @ref adsTelEpCompParamsGet().
 */
#define ADS_TEL_PARAM_TD_FSK_MARK_JP        60

/**
 * @ingroup adsTelEndpoint
 *       Parameter Value
 * @description
 *       Country Specific Tone Detector FSK CS Peoples Republic of China
 * @see
 *       @ref adsTelEpCompParamsSet() \n
 *       @ref adsTelEpCompParamsGet().
 */
#define ADS_TEL_PARAM_TD_FSK_CS_PRC         200

/**
 * @ingroup adsTelEndpoint
 *       Parameter Value
 * @description
 *       Country Specific Tone Detector FSK Mark Peoples Republic of China
 * @see
 *       @ref adsTelEpCompParamsSet() \n
 *       @ref adsTelEpCompParamsGet().
 */
#define ADS_TEL_PARAM_TD_FSK_MARK_PRC       100








/**
 * @ingroup adsTelEndpoint
 *       Parameter Value
 * @description
 *       Codec Type Pass Through
 * @see
 *       @ref adsTelEpCompParamsSet() \n
 *       @ref adsTelEpCompParamsGet().
 */
#define ADS_TEL_PARAM_CODER_TYPE_PASSTHRU       0

/**
 * @ingroup adsTelEndpoint
 *       Parameter Value
 * @description
 *       Codec Type G711 MU Law 10ms
 * @see
 *       @ref adsTelEpCompParamsSet() \n
 *       @ref adsTelEpCompParamsGet().
 */
#define ADS_TEL_PARAM_CODER_TYPE_G711MU_10MS    1

/**
 * @ingroup adsTelEndpoint
 *       Parameter Value
 * @description
 *       Codec Type G711 A Law 10ms
 * @see
 *       @ref adsTelEpCompParamsSet() \n
 *       @ref adsTelEpCompParamsGet().
 */
#define ADS_TEL_PARAM_CODER_TYPE_G711A_10MS     2

/**
 * @ingroup adsTelEndpoint
 *       Parameter Value
 * @description
 *       Codec Type G729ab
 * @see
 *       @ref adsTelEpCompParamsSet() \n
 *       @ref adsTelEpCompParamsGet().
 */
#define ADS_TEL_PARAM_CODER_TYPE_G729A          3

/**
 * @ingroup adsTelEndpoint
 *       Parameter Value
 * @description
 *       Codec Type G723.1
 * @see
 *       @ref adsTelEpCompParamsSet() \n
 *       @ref adsTelEpCompParamsGet().
 */
#define ADS_TEL_PARAM_CODER_TYPE_G723           4

/**
 * @ingroup adsTelEndpoint
 *       Parameter Value
 * @description
 *       Codec Type G722 64Kbps
 * @see
 *       @ref adsTelEpCompParamsSet() \n
 *       @ref adsTelEpCompParamsGet().
 */
#define ADS_TEL_PARAM_CODER_TYPE_G722_64        5

/**
 * @ingroup adsTelEndpoint
 *       Parameter Value
 * @description
 *       Codec Type G722 56Kbps
 * @see
 *       @ref adsTelEpCompParamsSet() \n
 *       @ref adsTelEpCompParamsGet().
 */
#define ADS_TEL_PARAM_CODER_TYPE_G722_56        6

/**
 * @ingroup adsTelEndpoint
 *       Parameter Value
 * @description
 *       Codec Type G722 48kbps
 * @see
 *       @ref adsTelEpCompParamsSet() \n
 *       @ref adsTelEpCompParamsGet().
 */
#define ADS_TEL_PARAM_CODER_TYPE_G722_48        7

/**
 * @ingroup adsTelEndpoint
 *       Parameter Value
 * @description
 *       Codec Type G726 40
 * @see
 *       @ref adsTelEpCompParamsSet() \n
 *       @ref adsTelEpCompParamsGet().
 */
#define ADS_TEL_PARAM_CODER_TYPE_G726_40        8

/**
 * @ingroup adsTelEndpoint
 *       Parameter Value
 * @description
 *       Codec Type G726 32
 * @see
 *       @ref adsTelEpCompParamsSet() \n
 *       @ref adsTelEpCompParamsGet().
 */
#define ADS_TEL_PARAM_CODER_TYPE_G726_32        9

/**
 * @ingroup adsTelEndpoint
 *       Parameter Value
 * @description
 *       Codec Type G726 24
 * @see
 *       @ref adsTelEpCompParamsSet() \n
 *       @ref adsTelEpCompParamsGet().
 */
#define ADS_TEL_PARAM_CODER_TYPE_G726_24        10

/**
 * @ingroup adsTelEndpoint
 *       Parameter Value
 * @description
 *       Codec Type G726 16
 * @see
 *       @ref adsTelEpCompParamsSet() \n
 *       @ref adsTelEpCompParamsGet().
 */
#define ADS_TEL_PARAM_CODER_TYPE_G726_16        11

/**
 * @ingroup adsTelEndpoint
 *       Parameter Value
 * @description
 *       Codec Type G729 1
 * @see
 *       @ref adsTelEpCompParamsSet() \n
 *       @ref adsTelEpCompParamsGet().
 */
#define ADS_TEL_PARAM_CODER_TYPE_G729_1         12

/**
 * @ingroup adsTelEndpoint
 *       Parameter Value
 * @description
 *       Codec Type G722.1
 * @see
 *       @ref adsTelEpCompParamsSet() \n
 *       @ref adsTelEpCompParamsGet().
 */
#define ADS_TEL_PARAM_CODER_TYPE_G722_1         13

/**
 * @ingroup adsTelEndpoint
 *       Parameter Value
 * @description
 *       Codec Type G728
 * @see
 *       @ref adsTelEpCompParamsSet() \n
 *       @ref adsTelEpCompParamsGet().
 */
#define ADS_TEL_PARAM_CODER_TYPE_G728           14

/**
 * @ingroup adsTelEndpoint
 *       Parameter Value
 * @description
 *       Codec Type G729I Integrated Mode
 * @see
 *       @ref adsTelEpCompParamsSet() \n
 *       @ref adsTelEpCompParamsGet().
 */
#define ADS_TEL_PARAM_CODER_TYPE_G729I          15

/**
 * @ingroup adsTelEndpoint
 *       Parameter Value
 * @description
 *       Codec Type GSM AMR
 * @see
 *       @ref adsTelEpCompParamsSet() \n
 *       @ref adsTelEpCompParamsGet().
 */
#define ADS_TEL_PARAM_CODER_TYPE_GSM_AMR        16

/**
 * @ingroup adsTelEndpoint
 *       Parameter Value
 * @description
 *       Codec Type ITU G722.2, 3GPP AMRWB
 * @see
 *       @ref adsTelEpCompParamsSet() \n
 *       @ref adsTelEpCompParamsGet().
 */
#define ADS_TEL_PARAM_CODER_TYPE_AMRWB          17

/**
 * @ingroup adsTelEndpoint
 *       Parameter Value
 * @description
 *       Codec Type AMRWB+, 3GPP AMRWB Enhanced codec
 * @see
 *       @ref adsTelEpCompParamsSet() \n
 *       @ref adsTelEpCompParamsGet().
 */
#define ADS_TEL_PARAM_CODER_TYPE_AMRWB_PLUS     18

/**
 * @ingroup adsTelEndpoint
 *       Parameter Value
 * @description
 *       Codec Type GSM Full Rate
 * @see
 *       @ref adsTelEpCompParamsSet() \n
 *       @ref adsTelEpCompParamsGet().
 */
#define ADS_TEL_PARAM_CODER_TYPE_GSM_FR         19

/**
 * @ingroup adsTelEndpoint
 *       Parameter Value
 * @description
 *       Codec Type GSM Half Rate
 * @see
 *       @ref adsTelEpCompParamsSet() \n
 *       @ref adsTelEpCompParamsGet().
 */
#define ADS_TEL_PARAM_CODER_TYPE_GSM_HR         20

/**
 * @ingroup adsTelEndpoint
 *       Parameter Value
 * @description
 *       Codec Type GSM Enhanced Full Rate Codec
 * @see
 *       @ref adsTelEpCompParamsSet() \n
 *       @ref adsTelEpCompParamsGet().
 */
#define ADS_TEL_PARAM_CODER_TYPE_GSM_EFR        21
    /**
 * @ingroup adsTelEndpoint
 *       Parameter Value
 * @description
 *       Codec Type QCELP8, Qualcomm Codec
 * @see
 *       @ref adsTelEpCompParamsSet() \n
 *       @ref adsTelEpCompParamsGet().
 */
#define ADS_TEL_PARAM_CODER_TYPE_QCELP8         22

/**
 * @ingroup adsTelEndpoint
 *       Parameter Value
 * @description
 *       Codec Type QCELP13, Qualcomm Codec
 * @see
 *       @ref adsTelEpCompParamsSet() \n
 *       @ref adsTelEpCompParamsGet().
 */
#define ADS_TEL_PARAM_CODER_TYPE_QCELP13        23

/**
 * @ingroup adsTelEndpoint
 *       Parameter Value
 * @description
 *       Codec Type Selectable Mode Vocoder
 * @see
 *       @ref adsTelEpCompParamsSet() \n
 *       @ref adsTelEpCompParamsGet().
 */
#define ADS_TEL_PARAM_CODER_TYPE_SMV            24

/**
 * @ingroup adsTelEndpoint
 *       Parameter Value
 * @description
 *       Codec Type Internet Low Bit rate codec
 * @see
 *       @ref adsTelEpCompParamsSet() \n
 *       @ref adsTelEpCompParamsGet().
 */
#define ADS_TEL_PARAM_CODER_TYPE_ILBC           25

/**
 * @ingroup adsTelEndpoint
 *       Parameter Value
 * @description
 *       Codec Type Enhanced variable rate codec
 * @see
 *       @ref adsTelEpCompParamsSet() \n
 *       @ref adsTelEpCompParamsGet().
 */
#define ADS_TEL_PARAM_CODER_TYPE_EVRC           26

/**
 * @ingroup adsTelEndpoint
 *       Parameter Value
 * @description
 *       Codec Type ITU G722.1C
 * @see
 *       @ref adsTelEpCompParamsSet() \n
 *       @ref adsTelEpCompParamsGet().
 */
#define ADS_TEL_PARAM_CODER_TYPE_SIREN14        27

/**
 * @ingroup adsTelEndpoint
 *       Parameter Value
 * @description
 *       Codec Type Undefined
 * @see
 *       @ref adsTelEpCompParamsSet() \n
 *       @ref adsTelEpCompParamsGet().
 */
#define ADS_TEL_PARAM_CODER_TYPE_UNDEF          -1

/**
 * @ingroup adsTelEndpoint
 *       Parameter Value
 * @description
 *       Upsample data from NB to WB
 * @see
 *       @ref adsTelEpCompParamsSet() \n
 *       @ref adsTelEpCompParamsGet().
 */
#define  ADS_TEL_PARAM_SRC_UPSAMPLE             0

/**
 * @ingroup adsTelEndpoint
 *       Parameter Value
 * @description
 *       downsample data from WB to NB
 * @see
 *       @ref adsTelEpCompParamsSet() \n
 *       @ref adsTelEpCompParamsGet().
 */
#define  ADS_TEL_PARAM_SRC_DOWNSAMPLE             1



/***********************************************************
 * Parameter IDs
 **********************************************************/
/**
 * @ingroup adsTelEndpoint
 *       Parameter ID
 * @description
 *       EC Flag\n
 *       @ref ADS_TEL_PARAM_ON - enable\n
 *       @ref ADS_TEL_PARAM_OFF - disable
 * @see
 *       @ref adsTelEpCompParamsSet() \n
 *       @ref adsTelEpCompParamsGet().
 */
#define ADS_TEL_PARAMID_EC_ECENABLE             1

/**
 * @ingroup adsTelEndpoint
 *       Parameter ID
 * @description
 *       EC tail length
 * @see
 *       @ref adsTelEpCompParamsSet() \n
 *       @ref adsTelEpCompParamsGet().
 */
#define ADS_TEL_PARAMID_EC_ECTAIL               2

/**
 * @ingroup adsTelEndpoint
 *       Parameter ID
 * @description
 *       EC NLP flag,\n
 *       @ref ADS_TEL_PARAM_OFF - disable\n
 *       @ref ADS_TEL_PARAM_EC_NLP_ON - NLP on & Suppr Off\n
 *       @ref ADS_TEL_PARAM_EC_NLP_SUB_ON - NLP on & Suppr on
 * @see
 *       @ref adsTelEpCompParamsSet() \n
 *       @ref adsTelEpCompParamsGet().
 */
#define ADS_TEL_PARAMID_EC_ECNLP                3

/**
 * @ingroup adsTelEndpoint
 *       Parameter ID
 * @description
 *       EC freeze flag\n
 *       @ref ADS_TEL_PARAM_ON - freeze\n
 *       @ref ADS_TEL_PARAM_OFF - not freeze
 * @see
 *       @ref adsTelEpCompParamsSet() \n
 *       @ref adsTelEpCompParamsGet().
 */
#define ADS_TEL_PARAMID_EC_ECFREEZE             4

/**
 * @ingroup adsTelEndpoint
 *       Parameter ID
 * @description
 *       EC delay componesation 0 ~ 40
 * @see
 *       @ref adsTelEpCompParamsSet() \n
 *       @ref adsTelEpCompParamsGet().
 */
#define ADS_TEL_PARAMID_EC_DELAYCOMP            5

/**
 * @ingroup adsTelEndpoint
 *       Parameter ID
 * @description
 *       AEC flag\n
 *       @ref ADS_TEL_PARAM_ON - enable\n
 *       @ref ADS_TEL_PARAM_OFF - disable
 * @see
 *       @ref adsTelEpCompParamsSet() \n
 *       @ref adsTelEpCompParamsGet().
 */
#define ADS_TEL_PARAMID_EC_AECENABLE            6

/**
 * @ingroup adsTelEndpoint
 *       Parameter ID
 * @description
 *       AEC ALG flag\n
 *       0 - Full band\n
 *       1 - Sub-band\n
 *       2 - Sub band fast
 * @see
 *       @ref adsTelEpCompParamsSet() \n
 *       @ref adsTelEpCompParamsGet().
 */
#define ADS_TEL_PARAMID_EC_AECALG               7

/**
 * @ingroup adsTelEndpoint
 *       Parameter ID
 * @description
 *       AEC Tail Length 1 to 200 ms
 * @see
 *       @ref adsTelEpCompParamsSet() \n
 *       @ref adsTelEpCompParamsGet().
 */
#define ADS_TEL_PARAMID_EC_AECTAIL              8

/**
 * @ingroup adsTelEndpoint
 *       Parameter ID
 * @description
 *       AEC freeze flag\n
 *       @ref ADS_TEL_PARAM_ON - freeze\n
 *       @ref ADS_TEL_PARAM_OFF - not freeze
 * @see
 *       @ref adsTelEpCompParamsSet() \n
 *       @ref adsTelEpCompParamsGet().
 */
#define ADS_TEL_PARAMID_EC_AECFREEZE            9

/**
 * @ingroup adsTelEndpoint
 *       Parameter ID
 * @description
 *       AEC Use of Zero Coeff\n
 *       @ref ADS_TEL_PARAM_ON - enable\n
 *       @ref ADS_TEL_PARAM_OFF - disable
 * @see
 *       @ref adsTelEpCompParamsSet() \n
 *       @ref adsTelEpCompParamsGet().
 */
#define ADS_TEL_PARAMID_EC_AECZCF               10

/**
 * @ingroup adsTelEndpoint
 *       Parameter ID
 * @description
 *       AEC CNG\n
 *       @ref ADS_TEL_PARAM_ON - enable\n
 *       @ref ADS_TEL_PARAM_OFF - disable
 * @see
 *       @ref adsTelEpCompParamsSet() \n
 *       @ref adsTelEpCompParamsGet().
 */
#define ADS_TEL_PARAMID_EC_AECCNG               11

/**
 * @ingroup adsTelEndpoint
 *       Parameter ID
 * @description
 *       AEC NLP\n
 *       0 - disable\n
 *       1 - enable general\n
 *       2 - enable sbf specific algo\n
 *       3 - enable gen with initial anti-howling supressor, sbf only
 * @see
 *       @ref adsTelEpCompParamsSet() \n
 *       @ref adsTelEpCompParamsGet().
 */
#define ADS_TEL_PARAMID_EC_AECNLP               12

/**
 * @ingroup adsTelEndpoint
 *       Parameter ID
 * @description
 *       AEC TD flg\n
 *       @ref ADS_TEL_PARAM_ON - enable\n
 *       @ref ADS_TEL_PARAM_OFF - disable
 * @see
 *       @ref adsTelEpCompParamsSet() \n
 *       @ref adsTelEpCompParamsGet().
 */
#define ADS_TEL_PARAMID_EC_AECTD                13

/**
 * @ingroup adsTelEndpoint
 *       Parameter ID
 * @description
 *       AEC AntiHowling\n
 *       0 - disable anti-howling\n
 *       1 - spectra-based HD\n
 *       2 - energy-based HD
 * @see
 *       @ref adsTelEpCompParamsSet() \n
 *       @ref adsTelEpCompParamsGet().
 */
#define ADS_TEL_PARAMID_EC_AECHOWL              14

/**
 * @ingroup adsTelEndpoint
 *       Parameter ID
 * @description
 *       affine projection order,1...
 * @see
 *       @ref adsTelEpCompParamsSet() \n
 *       @ref adsTelEpCompParamsGet().
 */
#define ADS_TEL_PARAMID_EC_AECAP                15

/**
 * @ingroup adsTelEndpoint
 *       Parameter ID
 * @description
 *       IPP NR noise mitigation level 0,...,5
 * @see
 *       @ref adsTelEpCompParamsSet() \n
 *       @ref adsTelEpCompParamsGet().
 */
#define ADS_TEL_PARAMID_EC_AECNR                16

/**
 * @ingroup adsTelEndpoint
 *       Parameter ID
 * @description
 *       IPP NR smoothing mode 0,...,2
 * @see
 *       @ref adsTelEpCompParamsSet() \n
 *       @ref adsTelEpCompParamsGet().
 */
#define ADS_TEL_PARAMID_EC_AECNRSMTH            17

/**
 * @ingroup adsTelEndpoint
 *       Parameter ID
 * @description
 *       IPP NR DC compensation flag
 * @see
 *       @ref adsTelEpCompParamsSet() \n
 *       @ref adsTelEpCompParamsGet().
 */
#define ADS_TEL_PARAMID_EC_AECDCFLAG            18




/** High Pass Filter Parameter IDs **/

/**
 * @ingroup adsTelEndpoint
 *       Parameter ID
 * @description
 *       HIgh Pass Filter Flag\n
 *       @ref ADS_TEL_PARAM_ON - enable\n
 *       @ref ADS_TEL_PARAM_OFF - disable
 * @see
 *       @ref adsTelEpCompParamsSet() \n
 *       @ref adsTelEpCompParamsGet().
 */
#define ADS_TEL_PARMID_HPF_ENABLE               1

/** SCL Parameter IDs **/

/**
 * @ingroup adsTelEndpoint
 *       Parameter ID
 * @description
 *       SCL Volume
 * @see
 *       @ref adsTelEpCompParamsSet() \n
 *       @ref adsTelEpCompParamsGet().
 */
#define ADS_TEL_PARMID_SCL_VOL                  1


/** AGC Parameter IDs **/

/**
 * @ingroup adsTelEndpoint
 *       Parameter ID
 * @description
 *       AGC flag\n
 *       @ref ADS_TEL_PARAM_ON - enable\n
 *       @ref ADS_TEL_PARAM_OFF - disable
 * @see
 *       @ref adsTelEpCompParamsSet() \n
 *       @ref adsTelEpCompParamsGet().
 */
#define ADS_TEL_PARMID_AGC_ENABLE               1






/**
 * @ingroup adsTelEndpoint
 *       Parameter ID
 * @description
 *       G711 CNG flag\n
 *       @ref ADS_TEL_PARAM_ON - enable\n
 *       @ref ADS_TEL_PARAM_OFF - disable
 * @see
 *       @ref adsTelEpCompParamsSet() \n
 *       @ref adsTelEpCompParamsGet().
 */
#define ADS_TEL_PARMID_DEC_CNG                  1

/**
 * @ingroup adsTelEndpoint
 *       Parameter ID
 * @description
 *       codec type. See ADS ADS_TEL_PARAM_CODER_TYPE_* defines.
 * @see
 *       @ref adsTelEpCompParamsSet() \n
 *       @ref adsTelEpCompParamsGet().
 */
#define ADS_TEL_PARMID_DEC_CTYPE                2

/**
 * @ingroup adsTelEndpoint
 *       Parameter ID
 * @description
 *       packet-loss report\n
 *       @ref ADS_TEL_PARAM_ON - enable\n
 *       @ref ADS_TEL_PARAM_OFF - disable
 * @see
 *       @ref adsTelEpCompParamsSet() \n
 *       @ref adsTelEpCompParamsGet().
 */
#define ADS_TEL_PARMID_DEC_EVT_PKT              3

/**
 * @ingroup adsTelEndpoint
 *       Parameter ID
 * @description
 *       report payload type change\n
 *       @ref ADS_TEL_PARAM_ON - enable\n
 *       @ref ADS_TEL_PARAM_OFF - disable
 * @see
 *       @ref adsTelEpCompParamsSet() \n
 *       @ref adsTelEpCompParamsGet().
 */
#define ADS_TEL_PARMID_DEC_EVT_PKTCHNG          4

/**
 * @ingroup adsTelEndpoint
 *       Parameter ID
 * @description
 *       Auto coder switch mask, Or'd bits. See ADS_TEL_DEC_AUTOSW_* defines.
 * @see
 *       @ref adsTelEpCompParamsSet() \n
 *       @ref adsTelEpCompParamsGet().
 */
#define ADS_TEL_PARMID_DEC_AUTOSW               5

/**
 * @ingroup adsTelEndpoint
 *       Parameter ID
 * @description
 *       RTP payload type for G.726-40
 * @see
 *       @ref adsTelEpCompParamsSet() \n
 *       @ref adsTelEpCompParamsGet().
 */
#define ADS_TEL_PARMID_DEC_G726_40_RTP_PLD      6

/**
 * @ingroup adsTelEndpoint
 *       Parameter ID
 * @description
 *       RTP payload type for G.726-32
 * @see
 *       @ref adsTelEpCompParamsSet() \n
 *       @ref adsTelEpCompParamsGet().
 */
#define ADS_TEL_PARMID_DEC_G726_32_RTP_PLD      7

/**
 * @ingroup adsTelEndpoint
 *       Parameter ID
 * @description
 *       RTP payload type for G.726-24
 * @see
 *       @ref adsTelEpCompParamsSet() \n
 *       @ref adsTelEpCompParamsGet().
 */
#define ADS_TEL_PARMID_DEC_G726_24_RTP_PLD      8

/**
 * @ingroup adsTelEndpoint
 *       Parameter ID
 * @description
 *       RTP payload type for G.726-16
 * @see
 *       @ref adsTelEpCompParamsSet() \n
 *       @ref adsTelEpCompParamsGet().
 */
#define ADS_TEL_PARMID_DEC_G726_16_RTP_PLD      9

/**
 * @ingroup adsTelEndpoint
 *       Parameter ID
 * @description
 *       G.726 packing format\n
 *       @ref ADS_TEL_PARAM_G726_PACK_LSB
 *       @ref ADS_TEL_PARAM_G726_PACK_MSB
 * @see
 *       @ref adsTelEpCompParamsSet() \n
 *       @ref adsTelEpCompParamsGet().
 */
#define ADS_TEL_PARMID_DEC_G726_PACK            10

/**
 * @ingroup adsTelEndpoint
 *       Parameter ID
 * @description
 *       RTP payload type for G.729.1
 * @see
 *       @ref adsTelEpCompParamsSet() \n
 *       @ref adsTelEpCompParamsGet().
 */
#define ADS_TEL_PARMID_DEC_G729_1_RTP_PLD       11

/**
 * @ingroup adsTelEndpoint
 *       Parameter ID
 * @description
 *       RTP payload type for G.722-64
 * @see
 *       @ref adsTelEpCompParamsSet() \n
 *       @ref adsTelEpCompParamsGet().
 */
#define ADS_TEL_PARMID_DEC_G722_64_RTP_PLD      12

/**
 * @ingroup adsTelEndpoint
 *       Parameter ID
 * @description
 *       RTP payload type for G.722-56
 * @see
 *       @ref adsTelEpCompParamsSet() \n
 *       @ref adsTelEpCompParamsGet().
 */
#define ADS_TEL_PARMID_DEC_G722_56_RTP_PLD      13

/**
 * @ingroup adsTelEndpoint
 *       Parameter ID
 * @description
 *       RTP payload type for G.722-48
 * @see
 *       @ref adsTelEpCompParamsSet() \n
 *       @ref adsTelEpCompParamsGet().
 */
#define ADS_TEL_PARMID_DEC_G722_48_RTP_PLD      14





/** Encoder Parameter ID's **/

/**
 * @ingroup adsTelEndpoint
 *       Parameter ID
 * @description
 *       VAD flag\n
 *       @ref ADS_TEL_PARAM_ON - enable\n
 *       @ref ADS_TEL_PARAM_OFF - disable
 * @see
 *       @ref adsTelEpCompParamsSet() \n
 *       @ref adsTelEpCompParamsGet().
 */
#define ADS_TEL_PARMID_ENC_VAD                  2

/**
 * @ingroup adsTelEndpoint
 *       Parameter ID
 * @description
 *       codec type. See ADS ADS_TEL_PARAM_CODER_TYPE_* defines.
 * @see
 *       @ref adsTelEpCompParamsSet() \n
 *       @ref adsTelEpCompParamsGet().
 */
#define ADS_TEL_PARMID_ENC_CTYPE                3

/**
 * @ingroup adsTelEndpoint
 *       Parameter ID
 * @description
 *       number of frames per packet
 * @see
 *       @ref adsTelEpCompParamsSet() \n
 *       @ref adsTelEpCompParamsGet().
 */
#define ADS_TEL_PARMID_ENC_MFPP                 4

/**
 * @ingroup adsTelEndpoint
 *       Parameter ID
 * @description
 *       packet-loss report\n
 *       @ref ADS_TEL_PARAM_ON - enable\n
 *       @ref ADS_TEL_PARAM_OFF - disable
 * @see
 *       @ref adsTelEpCompParamsSet() \n
 *       @ref adsTelEpCompParamsGet().
 */
#define ADS_TEL_PARMID_ENC_EVT_PKT              5

/**
 * @ingroup adsTelEndpoint
 *       Parameter ID
 * @description
 *       G723 encoding rate either 5.3k or 6.3k
 * @see
 *       @ref adsTelEpCompParamsSet() \n
 *       @ref adsTelEpCompParamsGet().
 */
#define ADS_TEL_PARMID_ENC_G723_RATE            6

/**
 * @ingroup adsTelEndpoint
 *       Parameter ID
 * @description
 *       RTP payload type for G.726-40
 * @see
 *       @ref adsTelEpCompParamsSet() \n
 *       @ref adsTelEpCompParamsGet().
 */
#define ADS_TEL_PARMID_ENC_G726_40_RTP_PLD      7

/**
 * @ingroup adsTelEndpoint
 *       Parameter ID
 * @description
 *       RTP payload type for G.726-32
 * @see
 *       @ref adsTelEpCompParamsSet() \n
 *       @ref adsTelEpCompParamsGet().
 */
#define ADS_TEL_PARMID_ENC_G726_32_RTP_PLD      8

/**
 * @ingroup adsTelEndpoint
 *       Parameter ID
 * @description
 *       RTP payload type for G.726-24
 * @see
 *       @ref adsTelEpCompParamsSet() \n
 *       @ref adsTelEpCompParamsGet().
 */
#define ADS_TEL_PARMID_ENC_G726_24_RTP_PLD      9

/**
 * @ingroup adsTelEndpoint
 *       Parameter ID
 * @description
 *       RTP payload type for G.726-16
 * @see
 *       @ref adsTelEpCompParamsSet() \n
 *       @ref adsTelEpCompParamsGet().
 */
#define ADS_TEL_PARMID_ENC_G726_16_RTP_PLD      10

/**
 * @ingroup adsTelEndpoint
 *       Parameter ID
 * @description
 *       G.726 packing format\n
 *       @ref ADS_TEL_PARAM_G726_PACK_LSB
 *       @ref ADS_TEL_PARAM_G726_PACK_MSB
 * @see
 *       @ref adsTelEpCompParamsSet() \n
 *       @ref adsTelEpCompParamsGet().
 */
#define ADS_TEL_PARMID_ENC_G726_PACK            11

/**
 * @ingroup adsTelEndpoint
 *       Parameter ID
 * @description
 *       RTP payload type for G.729.1
 * @see
 *       @ref adsTelEpCompParamsSet() \n
 *       @ref adsTelEpCompParamsGet().
 */
#define ADS_TEL_PARMID_ENC_G729_1_RTP_PLD       12

/**
 * @ingroup adsTelEndpoint
 *       Parameter ID
 * @description
 *       G729.1 encoding rate
 * @see
 *       @ref adsTelEpCompParamsSet() \n
 *       @ref adsTelEpCompParamsGet().
 */
#define ADS_TEL_PARMID_ENC_G729_1_RATE          13
    /**
 * @ingroup adsTelEndpoint
 *       Parameter ID
 * @description
 *       RTP payload type for G.722-64
 * @see
 *       @ref adsTelEpCompParamsSet() \n
 *       @ref adsTelEpCompParamsGet().
 */
#define ADS_TEL_PARMID_ENC_G722_64_RTP_PLD      14

/**
 * @ingroup adsTelEndpoint
 *       Parameter ID
 * @description
 *       RTP payload type for G.722-56
 * @see
 *       @ref adsTelEpCompParamsSet() \n
 *       @ref adsTelEpCompParamsGet().
 */
#define ADS_TEL_PARMID_ENC_G722_56_RTP_PLD      15

/**
 * @ingroup adsTelEndpoint
 *       Parameter ID
 * @description
 *       RTP payload type for G.722-48
 * @see
 *       @ref adsTelEpCompParamsSet() \n
 *       @ref adsTelEpCompParamsGet().
 */
#define ADS_TEL_PARMID_ENC_G722_48_RTP_PLD      16




/** Tone Generator Parameter IDs **/

/**
 * @ingroup adsTelEndpoint
 *       Parameter ID
 * @description
 *       volume adjustment
 * @see
 *       @ref adsTelEpCompParamsSet() \n
 *       @ref adsTelEpCompParamsGet().
 */
#define ADS_TEL_PARMID_TG_VOL               1


/**
 * @ingroup adsTelEndpoint
 *       Parameter ID
 * @description
 *       FSK Modulation Type\n
 *       @ref ADS_TEL_PARAM_TG_FSK_V23\n
 *       @ref ADS_TEL_PARAM_TG_FSK_B202
 * @see
 *       @ref adsTelEpCompParamsSet() \n
 *       @ref adsTelEpCompParamsGet().
 */
#define ADS_TEL_PARMID_TG_FSK_MOD           2

/**
 * @ingroup adsTelEndpoint
 *       Parameter ID
 * @description
 *       CS bit length
 * @see
 *       @ref adsTelEpCompParamsSet() \n
 *       @ref adsTelEpCompParamsGet().
 */
#define ADS_TEL_PARMID_TG_FSK_CS                3

/**
 * @ingroup adsTelEndpoint
 *       Parameter ID
 * @description
 *       MARK bit length
 * @see
 *       @ref adsTelEpCompParamsSet() \n
 *       @ref adsTelEpCompParamsGet().
 */
#define ADS_TEL_PARMID_TG_FSK_MARK          4

/**
 * @ingroup adsTelEndpoint
 *       Parameter ID
 * @description
 *       Baud rate
 *       @ref ADS_TEL_PARAM_TG_FSK_R1200\n
 *       @ref ADS_TEL_PARAM_TG_FSK_R600\n
 *       @ref ADS_TEL_PARAM_TG_FSK_R300\n
 *       @ref ADS_TEL_PARAM_TG_FSK_R150\n
 *       @ref ADS_TEL_PARAM_TG_FSK_R75
 * @see
 *       @ref adsTelEpCompParamsSet() \n
 *       @ref adsTelEpCompParamsGet().
 */
#define ADS_TEL_PARMID_TG_FSK_RATE          5

/**
 * @ingroup adsTelEndpoint
 *       Parameter ID
 * @description
 *       RFC2833 flag\n
 *       @ref ADS_TEL_PARAM_ON - enable\n
 *       @ref ADS_TEL_PARAM_OFF - disable
 * @see
 *       @ref adsTelEpCompParamsSet() \n
 *       @ref adsTelEpCompParamsGet().
 */
#define ADS_TEL_PARMID_TG_RFC2833           6

/**
 * @ingroup adsTelEndpoint
 *       Parameter ID
 * @description
 *       post mark bit length
 * @see
 *       @ref adsTelEpCompParamsSet() \n
 *       @ref adsTelEpCompParamsGet().
 */
#define ADS_TEL_PARMID_TG_FSK_POSTMK            7

/**
 * @ingroup adsTelEndpoint
 *       Parameter ID
 * @description
 *       WB or NB mode in the PCM line\n
 *       @ref ADS_TEL_PARAM_WB\n
 *       @ref ADS_TEL_PARAM_NB
 * @see
 *       @ref adsTelEpCompParamsSet() \n
 *       @ref adsTelEpCompParamsGet().
 */
#define ADS_TEL_PARMID_TG_PCM_MODE              8





/** Tone Detector Parameters **/


/**
 * @ingroup adsTelEndpoint
 *       Parameter ID
 * @description
 *       Tone clamping flag\n
 *       @ref ADS_TEL_PARAM_ON - enable\n
 *       @ref ADS_TEL_PARAM_OFF - disable
 * @see
 *       @ref adsTelEpCompParamsSet() \n
 *       @ref adsTelEpCompParamsGet().
 */
#define ADS_TEL_PARMID_TD_TC                1

/**
 * @ingroup adsTelEndpoint
 *       Parameter ID
 * @description
 *       Number of frames to buffer in TC buffer
 * @see
 *       @ref adsTelEpCompParamsSet() \n
 *       @ref adsTelEpCompParamsGet().
 */
#define ADS_TEL_PARMID_TD_TC_FRAMES         2

/**
 * @ingroup adsTelEndpoint
 *       Parameter ID
 * @description
 *       report event\n
 *       @ref ADS_TEL_PARAM_TD_RPT_OFF\n
 *       @ref ADS_TEL_PARAM_TD_RPT_TONE_ON\n
 *       @ref ADS_TEL_PARAM_TD_RPT_TONE_OFF\n
 *       @ref ADS_TEL_PARAM_TD_RPT_TONE_ON_OFF
 * @see
 *       @ref adsTelEpCompParamsSet() \n
 *       @ref adsTelEpCompParamsGet().
 */
#define ADS_TEL_PARMID_TD_RPT_EVENTS            3

/**
 * @ingroup adsTelEndpoint
 *       Parameter ID
 * @description
 *       RFC2833E flag\n
 *       @ref ADS_TEL_PARAM_ON - enable\n
 *       @ref ADS_TEL_PARAM_OFF - disable
 * @see
 *       @ref adsTelEpCompParamsSet() \n
 *       @ref adsTelEpCompParamsGet().
 */
#define ADS_TEL_PARMID_TD_RFC2833E_ENABLE       4

/**
 * @ingroup adsTelEndpoint
 *       Parameter ID
 * @description
 *       Update rate of RFC2833 pkts. (in 10-ms units)
 * @see
 *       @ref adsTelEpCompParamsSet() \n
 *       @ref adsTelEpCompParamsGet().
 */
#define ADS_TEL_PARMID_TD_RFC2833E_UPDATERATE       5

/**
 * @ingroup adsTelEndpoint
 *       Parameter ID
 * @description
 *       End of Event Redundancy
 * @see
 *       @ref adsTelEpCompParamsSet() \n
 *       @ref adsTelEpCompParamsGet().
 */
#define ADS_TEL_PARMID_TD_RFC2833E_NUMEOE       6

/**
 * @ingroup adsTelEndpoint
 *       Parameter ID
 * @description
 *       Begin of Event Redundancy
 * @see
 *       @ref adsTelEpCompParamsSet() \n
 *       @ref adsTelEpCompParamsGet().
 */
#define ADS_TEL_PARMID_TD_RFC2833E_NUMBOE       7

/**
 * @ingroup adsTelEndpoint
 *       Parameter ID
 * @description
 *       Suppress encoder when sending RFC2833 RTP packets\n
 *       @ref ADS_TEL_PARAM_ON - enable\n
 *       @ref ADS_TEL_PARAM_OFF - disable
 * @see
 *       @ref adsTelEpCompParamsSet() \n
 *       @ref adsTelEpCompParamsGet().
 * @note
 *       This parameter is not currently supported and audio data
 *       is always transmitted.
 */
#define ADS_TEL_PARMID_TD_RFC2833E_AUDIOSUPRESS     8

/**
 * @ingroup adsTelEndpoint
 *       Parameter ID
 * @description
 *       RFC2833 payload type
 * @see
 *       @ref adsTelEpCompParamsSet() \n
 *       @ref adsTelEpCompParamsGet().
 */
#define ADS_TEL_PARMID_TD_RFC2833E_PAYLOADTYPE      9

/**
 * @ingroup adsTelEndpoint
 *       Parameter ID
 * @description
 *       minimum CS-bit length required by FSK receiver
 * @see
 *       @ref adsTelEpCompParamsSet() \n
 *       @ref adsTelEpCompParamsGet().
 */
#define ADS_TEL_PARMID_TD_FSK_CS            10

/**
 * @ingroup adsTelEndpoint
 *       Parameter ID
 * @description
 *       minimum mark-bit length required by FSK receiver
 * @see
 *       @ref adsTelEpCompParamsSet() \n
 *       @ref adsTelEpCompParamsGet().
 */
#define ADS_TEL_PARMID_TD_FSK_MARK          11

/**
 * @ingroup adsTelEndpoint
 *       Parameter ID
 * @description
 *       extra stop-bit length allowed between the data
 * @see
 *       @ref adsTelEpCompParamsSet() \n
 *       @ref adsTelEpCompParamsGet().
 */
#define ADS_TEL_PARMID_TD_FSK_STOP          12

/**
 * @ingroup adsTelEndpoint
 *       Parameter ID
 * @description
 *       FSK receiver Baud rate
 * @see
 *       @ref adsTelEpCompParamsSet() \n
 *       @ref adsTelEpCompParamsGet().
 */
#define ADS_TEL_PARMID_TD_FSK_RATE          13

/**
 * @ingroup adsTelEndpoint
 *       Parameter ID
 * @description
 *       FSK detector with adaptive or non-adaptive threshold
 *       @ref ADS_TEL_PARAM_TD_NON_ADAPT_THRES\n
 *       @ref ADS_TEL_PARAM_TD_ADAPT_THRES
 * @see
 *       @ref adsTelEpCompParamsSet() \n
 *       @ref adsTelEpCompParamsGet().
 */
#define ADS_TEL_PARMID_TD_FSK_ADAPT_THRESHOLD       14

/**
 * @ingroup adsTelEndpoint
 *       Parameter ID
 * @description
 *       Minimum number of bytes to be received by the FSK detector
 * @see
 *       @ref adsTelEpCompParamsSet() \n
 *       @ref adsTelEpCompParamsGet().
 */
#define ADS_TEL_PARMID_TD_FSK_RX_MIN_BYTES      15

/**
 * @ingroup adsTelEndpoint
 *       Parameter ID
 * @description
 *       Completely enable/disable the Tone Detector\n
 *       @ref ADS_TEL_PARAM_ON - enable\n
 *       @ref ADS_TEL_PARAM_OFF - disable
 * @see
 *       @ref adsTelEpCompParamsSet() \n
 *       @ref adsTelEpCompParamsGet().
 */
#define ADS_TEL_PARMID_TD_ENABLE            16



/**
 * @ingroup adsTelEndpoint
 *       Parameter ID
 * @description
 *       Player Volume control in dB
 * @see
 *       @ref adsTelEpCompParamsSet() \n
 *       @ref adsTelEpCompParamsGet().
 */
#define ADS_TEL_PARMID_PLY_VOL              1

/**
 * @ingroup adsTelEndpoint
 *       Parameter ID
 * @description
 *       Player Mode\n
 *       @ref ADS_TEL_PARAM_WB\n
 *       @ref ADS_TEL_PARAM_NB
 * @see
 *       @ref adsTelEpCompParamsSet() \n
 *       @ref adsTelEpCompParamsGet().
 */
#define ADS_TEL_PARMID_PLY_MODE                 2


/**
 * @ingroup adsTelEndpoint
 *       Parameter ID
 * @description
 *       SRC Enable\n
 *       @ref ADS_TEL_PARAM_ON - enable\n
 *       @ref ADS_TEL_PARAM_OFF - disable
 * @see
 *       @ref adsTelEpCompParamsSet() \n
 *       @ref adsTelEpCompParamsGet().
 */
#define ADS_TEL_PARMID_SRC_ENABLE               1

/**
 * @ingroup adsTelEndpoint
 *       Parameter ID
 * @description
 *       SRC Mode\n
 *       @ref ADS_TEL_PARAM_SRC_UPSAMPLE\n
 *       @ref ADS_TEL_PARAM_SRC_DOWNSAMPLE
 * @see
 *       @ref adsTelEpCompParamsSet() \n
 *       @ref adsTelEpCompParamsGet().
 */
#define ADS_TEL_PARMID_SRC_MODE                 2








/****************************************************************************/
/******************* TYPEDEFS ***********************************************/
/****************************************************************************/
/**
 * @ingroup adsTelEndpoint
 *       Endpoint Handle.
 *
 * @description
 *       The handle used for controlling an endpoint instance.
 *
 * @purpose
 *       Used to determine the endpoint instance being accessed.
 * @see
 *       @ref adsTelEpCreate() \n
 *       @ref adsTelEpDestroy().
 */
typedef unsigned int AdsTelEpHandle_t;


/**
 * @ingroup adsTelRouter
 *       Router Handle.
 *
 * @description
 *       The handle used for controlling an router instance.
 *
 * @purpose
 *       Used to determine the router instance being accessed.
 * @see
 *       @ref adsTelRouterCreate() \n
 *       @ref adsTelRouterDestroy().
 */
typedef unsigned int AdsTelRtrHandle_t;


/**
 * @ingroup adsTelEndpoint
 *       Media Handle.
 *
 * @description
 *       The handle used for playing an audio file.
 *
 * @purpose
 *       Used to identify registered wav file.
 * @see
 *       @ref adsTelRegisterWavFile() \n
 *       @ref adsTelEpPlayAudio().
 */
typedef short AdsTelMediaHandle_t;



/****************************************************************************/
/******************* ENUMERATED TYPES ***************************************/
/****************************************************************************/

/**
 * @ingroup adsTel
 *       AdsTel return type.
 *
 * @description
 *       return types for adsTel API calls and @ref adsTelFwCb_t.
 */
typedef enum
{
    ADS_TEL_STATUS_SUCCESS          = 0,
    /**< successful return status.*/
    ADS_TEL_STATUS_FAIL             = -101,
    /**< failure return status.*/
    ADS_TEL_STATUS_INVALID_PARAM    = -102,
    /**< invalid parameter return status.*/
    ADS_TEL_STATUS_EVENT            = -103,
    /**< event return status. See @ref adsTelFwCb_t.*/
    ADS_TEL_STATUS_GET_PARAMS       = -104,
    /**< @ref adsTelFwCb_t return status for a call to
         @ref adsTelEpCompParamsGet().*/
    ADS_TEL_STATUS_TG_CMPLT         = -105,
    /**< @ref adsTelFwCb_t return status for a call to @ref adsTelEpTonePlay()
         or @ref adsTelEpFskPlay().*/
    ADS_TEL_STATUS_TD_RCV_CMPLT     = -106,
    /**< @ref adsTelFwCb_t return status for a call to
         @ref adsTelEpToneRecv().*/
    ADS_TEL_STATUS_TD_RCV_FSK_CMPLT = -107,
    /**< @ref adsTelFwCb_t return status for a call to
         @ref adsTelEpFskRecv().*/
    ADS_TEL_STATUS_PLY_CMPLT        = -108,
    /**< @ref adsTelFwCb_t return status for a call to
         @ref adsTelEpPlayAudio().*/
    ADS_TEL_STATUS_UNDERFLOW        = -109,
    /**< @ref adsTelEpDataCb_t status to be returned when no RTP packet
              is available.*/
    ADS_TEL_STATUS_TONE             = -110,
    /**< @ref adsTelEpDataCb_t status to be returned when only a RFC2833 tone
         packet is available.*/
    ADS_TEL_STATUS_AUDIO            = -111,
    /**< @ref adsTelEpDataCb_t status to be returned when an audio packet
         is available.*/
    ADS_TEL_STATUS_AUDIO_TONE       = -112,
    /**< @ref adsTelEpDataCb_t status to be returned when both an audio packet
         and a RFC2833 tone packet is available.*/
    ADS_TEL_STATUS_INVALID_FORMAT   = -113,
    /**< invalid wav file format status.*/
    ADS_TEL_STATUS_DELIMITER       = -114,
    /**< delimiter for error checks.*/
} AdsTelStatus_t;

/**
 * @ingroup adsTelEndpoint
 *       Call Progress Tone Geographical Location Settings
 *
 * @description
 *       Selects the geographical specific call progress tones.
 *       See @ref AdsTelInit_t.
 */
typedef enum
{
    ADS_TEL_GEO_PROC = 0,
    /**< Peoples Republic of China call progress tone setting*/
    ADS_TEL_GEO_JAPAN,
    /**< Japanese call progress tone setting*/
    ADS_TEL_GEO_USA,
    /**< United States of America call progress tone setting*/
    ADS_TEL_GEO_DELIMITER,
    /**< delimiter for error checks.*/
} AdsTelGeo_t;


/**
 * @ingroup adsTelCallback
 *       AdsTel event types.
 *
 * @description
 *       event types that can be returned by the framework via
 *       @ref adsTelFwCb_t return type @ref ADS_TEL_STATUS_EVENT.
 */
typedef enum
{
    ADS_TEL_EV_TD_TONE_ON =      0x101,
    /**< tone on event.*/
    ADS_TEL_EV_TD_TONE_OFF =     0x102,
    /**< tone off event.*/
    ADS_TEL_EV_LOST_PACKET =     0x103,
    /**< lost packet event.*/
    ADS_TEL_EV_DEC_PACKET_CHNG = 0x104,
    /**< payload type of packek changed.*/
} AdsTelEvent_t;


/**
 * @ingroup adsTelEndpoint
 *       AdsTel call/endpoint priority.
 *
 * @description
 *       specifies the priority of an endpoint/router. A 911 priority
 *       endpoint/router will always be set up. If needs be a low priority
 *       endpoint/router will be destroyed to accomodate the creation of the
 *       911 priority endpoint/router.
 * @note
 *       Call Priority is not currently supported. All calls must be
 *       configured with ADS_TEL_CALL_PRIOR_NORMAL.
 */
typedef enum
{
    ADS_TEL_CALL_PRIOR_NORMAL = 0,
    /**< normal call priority*/
    ADS_TEL_CALL_PRIOR_911,
    /**< 911 call priority*/
    ADS_TEL_CALL_PRIOR_DELIMITER,
    /**< delimiter for error checks.*/
} AdsTelCallPrior_t;


/**
 * @ingroup adsTelEndpoint
 *       AdsTel endpoint pipeline direction.
 *
 * @description
 *       Select a pipeline within an endpoint.
 */
typedef enum
{
    ADS_TEL_PIPE_DIR_IN = 0,
    /**< inbound pipeline.*/
    ADS_TEL_PIPE_DIR_OUT,
    /**< outbound pipeline.*/
    ADS_TEL_PIPE_DIR_DELIMITER,
    /**< delimiter for error checks.*/
} AdsTelPipeDir_t;


/**
 * @ingroup adsTelEndpoint
 *       AdsTel endpoint connection type.
 *
 * @description
 *       Selects the type of the endpoint being created.
 *       See @ref adsTelEpCreate().
 */
typedef enum
{
    ADS_TEL_PIPE_CONN_TYPE_PCM = 0,
    /**< PCM pipeline.*/
    ADS_TEL_PIPE_CONN_TYPE_IP,
    /**< IP pipeline.*/
    ADS_TEL_PIPE_CONN_TYPE_DELIMITER
    /**< delimiter for error checks.*/
} AdsTelPipeConType_t;


/**
 * @ingroup adsTelEndpoint
 *       PCM data type .
 *
 * @description
 *       Selects the sampling format for the PCM endpoint being created.
 *       See @ref adsTelEpCreate().
 */
typedef enum
{
    ADS_TEL_PCM_S_BE_16B_WB_LINEAR = 0x1221,
    /**< signed, Big Endian, 16 bit, 16 KHz, Linear.*/
    ADS_TEL_PCM_S_BE_16B_NB_LINEAR = 0x1121,
    /**< signed, Big Endian, 8 bit, 8 KHz, Linear.*/
    ADS_TEL_PCM_S_LE_16B_WB_LINEAR = 0x1222,
    /**< signed, Little Endian, 16 bit, 16 KHz, Linear.*/
    ADS_TEL_PCM_S_LE_16B_NB_LINEAR = 0x1122,
    /**< signed, Little Endian, 8 bit, 8 KHz, Linear.*/
} AdsTelPcmData_t;


/**
 * @ingroup adsTelRouter
 *       AdsTel router type.
 *
 * @description
 *       specifies the type of a router.
 *
 * @note
 *       router type is not currently supported and all routers should be
 *       be created with the ADS_TEL_RTR_NORMAL type.
 */
typedef enum
{
    ADS_TEL_RTR_NORMAL = 0,
    /**< standard router.*/
    ADS_TEL_RTR_CONF,
    /**< conference router.*/
    ADS_TEL_RTR_LECTURE,
    /**< lecture router.*/
    ADS_TEL_RTR_DELIMITER,
    /**< delimiter for error checks.*/
} AdsTelRtrType_t;

/**
 * @ingroup adsTelRouter
 *       AdsTel pipeline types.
 *
 * @description
 *       specifies the type of a pipeline. See @ref adsTelEpCreate().
 */
typedef enum
{
    ADS_TEL_PIPE_IP_OUT = 0,
    /**< IP outbound pipeline type.*/
    ADS_TEL_PIPE_IP_IN,
    /**< IP inbound pipeline type.*/
    ADS_TEL_PIPE_PCM_OUT,
    /**< PCM outbound pipeline type.*/
    ADS_TEL_PIPE_PCM_IN,
    /**< PCM inbound pipeline type.*/
    ADS_TEL_PIPE_DELIMITER,
    /**< delimiter for error checks.*/
} AdsTelPipeType_t;



/**
 * @ingroup adsTelEndpoint
 *       AdsTel endpoint connection status.
 *
 * @description
 *       specifies the connection status of endpoint inbound and
 *       outbound piplelines. See @ref adsTelEpConStatusSet().
 */
typedef enum
{
    ADS_TEL_EP_CONN_NONE = 0,
    /**<Endpoint pipelines disconnected.*/
    ADS_TEL_EP_CONN_IN,
    /**< Endpoint inbound pipeline connected only.*/
    ADS_TEL_EP_CONN_OUT,
    /**< Endpoint outbound pipeline connected only.*/
    ADS_TEL_EP_CONN_BOTH,
    /**< Endpoint inbound and outbound pipelines connected*/
    ADS_TEL_EP_CONN_DELIMITER,
    /**< delimiter for error checks.*/
}AdsTelEpConStatus_t;


/**
 * @ingroup adsTelEndpoint
 *       AdsTel Tone Detector tone category.
 *
 * @description
 *       specifies the tone category for the Tone Detector.
 *       See @ref adsTelTdAmplitudeRangeSet().
 */
typedef enum
{
    ADS_TEL_TD_CAT_DTMF = 0,
    /**<Tone Detector DTMF category.*/
    ADS_TEL_TD_CAT_DELIMITER,
    /**< delimiter for error checks.*/
}AdsTelTdCategory_t;


/****************************************************************************/
/******************* CALLBACK DEFINITIONS ***********************************/
/****************************************************************************/

/**
 * @ingroup adsTelCallback
 *        adsTel Framework Data callback.
 * @description
 *        Function prototype called by ADS when it is ready to receive/transmit
 *        data for a pipeline
 *
 * @context
 *
 * @assumptions
 *        None
 * @sideEffects
 *        None
 *
 * @return
 *        void
 * @pre
 *        None
 * @post
 *        None
 * @note
 *        None
 * @see
 *
 */
typedef AdsTelStatus_t (*adsTelEpDataCb_t) (AdsTelEpHandle_t   endPtHandle,
                                            void*              pBuffer1,
                                            void*              pBuffer2);

/**
 * @ingroup adsTelCallback
 *        adsTel Framework API and Event callback.
 * @description
 *        Prototype of the client's function to accept notification of API
 *        completion and event messages. This function is registered through
 *        the adsTel initialization function @ref adsTelInit(). The format of
 *        the data buffer pData is dependent on the the value of status.
 *
 *
 * @context
 *        Framework thread context.
 * @assumptions
 *        None
 * @sideEffects
 *        None
 *
 * @param
 *        transId [OUT] - value that was returned to the client application
 *                        from the original API call. Note this value will
 *                        be 0 when an event is being returned.
 * @param
 *        pData [OUT] - The returned data buffer. The format of the buffer
 *                      is dependent of the returned status.
 * @return
 *        void.
 * @pre
 *        None.
 * @post
 *        None.
 * @note
 *        None.
 * @see
 *        @ref adsTelInit() \n
 *        @ref AdsTelRetAck_t \n
 *        @ref AdsTelRetTg_t \n
 *        @ref AdsTelRetTd_t \n
 *        @ref AdsTelRetTdFsk_t \n
 *        @ref AdsTelRetEv_t \n
 *        @ref AdsTelRetGetParams_t \n
 *        @ref AdsTelRetPlay_t.
 */
typedef void (*adsTelFwCb_t) (unsigned int   transId,
                              void*          pData);



/****************************************************************************/
/******************* STRUCTURE TYPES ****************************************/
/****************************************************************************/

/**
 * @ingroup adsTel
 *       This structure contains the Initialization parameters for ADS.
 * @description
 *       This structure contains the initialization parameters for the ADS
 *       framework @ref adsTelInit().
 * @purpose
 *       Initialization paramters for ADS.
 * @see
 *        None.
 */
typedef struct
{
    unsigned int numEp;
    /**< The number of endpoints that will be supported by the framework.
         The number of routers supported by the framework will be half the
         number of endpoints supported.*/
    unsigned int geo;
    /**< The geographical location that the framework is configured for.
         0 = Peoples Republic Of China
         1 = Japan
         2 = USA*/
    unsigned int numRTTs;
    /**< The number of real-time threads that the system will use.*/
    unsigned int ctrlPrior;
    /**< The priority of the control thread within the framework.
         The allowable range is 1-99 with higher numbers being higher
         priority*/
    unsigned int rttPrior;
    /**< The priority of the real time threads within the framework.
         The allowable range is 1-99 with higher numbers being higher
         priority*/
    adsTelFwCb_t fwCb;
    /**< The framework callback function.*/
} AdsTelInit_t;


/**
 * @ingroup adsTelCallback
 *       API return structure type.
 * @description
 *       Contains the status and associated data that is returned as
 *       part of an API call.
 * @purpose
 *       Provide return data from an API call.
 * @see
 *        None.
 */
typedef struct
{
    AdsTelStatus_t status;
    /**< the return status of the API call.*/
    void *buffer;
    /**<  return data of the API call.*/
 } AdsTelRetBuf_t;


/**
 * @ingroup adsTelCallback
 *       ADS Framework Buffer format.
 *
 * @description
 *       The format of the buffer that is used to pass data between the
 *       ADS framework and the client application for IP data.
 *
 * @purpose
 *       Format of the buffer used when passing data via the data callbacks.
 *
 * @see
 *       @ref adsTelEpDataCb_t().
 */
typedef struct{
    unsigned short  channelID;
    /**< channel ID */
    unsigned short  payloadType;
    /**< bit[0-6] payload type, bit[7] SID mark bit*/
    unsigned int    mediaType:4;
    /**< media type */
    unsigned int    payloadLen:12;
    /**< payload length */
    unsigned int    timeStamp;
    /**< local or remote time stamp */
    unsigned long   privateData1;
    /**< Private data field untouched by the framework */
    unsigned long   privateData2;
    /**< Private data field untouched by the framework */
    char            payload[ADS_TEL_MAX_PAYLOAD_SIZE];
    /**< payload */

#ifdef __GNUC__
} __attribute__ ((packed)) AdsTelPacket_t;
#endif
#ifdef __ghs__
} AdsTelPacket_t;
#pragma pack()
#endif

/**
 * @ingroup adsTelCallback
 *       ADS Framework Buffer format.
 *
 * @description
 *       The format of the buffer that is used to pass data between the
 *       ADS framework and the client application for PCM data.
 *
 * @purpose
 *       Format of the buffer used when passing data via the data callbacks.
 *
 * @see
 *       @ref adsTelEpDataCb_t().
 */

typedef struct
{
    unsigned short channelID;
    /**< channel ID */
    unsigned short payloadType;
    /**< bit[0-6] payload type, bit[7] SID mark bit*/
    unsigned short payloadLength;
    /**< payload length in bytes */
    unsigned int timestamp;
    /**< frame time stamp */
    unsigned short payloadValid;
    /**< data is valid */
    unsigned long   privateData1;
    /**< Private data field untouched by the framework */
    unsigned long   privateData2;
    /**< Private data field untouched by the framework */
    char  payload[ADS_TEL_MAX_PAYLOAD_SIZE];
    /**< payload */
} AdsTelPCMPacket_t;

/**
 * @ingroup adsTelCallback
 *       @ref adsTelFwCb_t return buffer structure type.
 *
 * @description
 *       This structure is the return buffer type of @ref adsTelFwCb_t
 *       when retStatus is any of the following
 *       @ref AdsTelStatus_t members.
 *         @ref ADS_TEL_STATUS_SUCCESS \n
 *         @ref ADS_TEL_STATUS_FAIL \n
 *         @ref ADS_TEL_STATUS_INVALID_PARAM.
 *
 * @purpose
 *       Return buffer structure type for API and event callback
 *       @ref adsTelFwCb_t.
 * @see
 *       @ref adsTelFwCb_t.
 */
typedef struct AdsTelRetAck_s
{
    unsigned int   transId;
    /**< the transaction ID that was returned from the original API call*/
    AdsTelStatus_t retStatus;
    /**< the return status*/
} AdsTelRetAck_t;


/**
 * @ingroup adsTelCallback
 *       @ref adsTelFwCb_t return buffer structure type.
 *
 * @description
 *       This structure is the return buffer type of @ref adsTelFwCb_t when
 *       retStatus is any of the following @ref AdsTelStatus_t members.
 *          @ref ADS_TEL_STATUS_TG_CMPLT.
 *
 * @purpose
 *       Return buffer structure type for API and event callback
 *       @ref adsTelFwCb_t.
 * @see
 *       @ref adsTelFwCb_t \n
 *       @ref adsTelEpTonePlay() \n
 *       @ref adsTelEpFskPlay().
 */
typedef struct AdsTelRetTg_s
{
    unsigned int   transId;
    /**< the transaction ID that was returned from the original API call*/
    AdsTelStatus_t retStatus;
    /**< the returned status*/
    unsigned int   reason;
    /**< the reason for the TG play completion. */
    unsigned int   numTones;
    /**< the number of tones played. 0 if FSK data*/
} AdsTelRetTg_t;


/**
 * @ingroup adsTelCallback
 *       @ref adsTelFwCb_t return buffer structure type.
 *
 * @description
 *       This structure is the return buffer type of @ref adsTelFwCb_t
 *       when retStatus is any of the following @ref AdsTelStatus_t
 *       members.
 *          @ref ADS_TEL_STATUS_TD_RCV_FSK_CMPLT.
 *
 * @purpose
 *       Return buffer structure type for API and event callback
 *       @ref adsTelFwCb_t.
 * @see
 *       @ref adsTelFwCb_t \n
 *       @ref adsTelEpFskRecv().
 */
typedef struct AdsTelRetTdFsk_s
{
    unsigned int   transId;
    /**< the transaction ID that was returned from the original API call*/
    AdsTelStatus_t retStatus;
    /**< the returned status*/
    unsigned int   reason;
    /**< the reason that for the TD FSK detect completion.*/
    unsigned int   numBytes;
    /**< the number of FSK bytes received*/
    char data[ADS_TEL_MAX_FSK_BYTES];
    /**< the FSK data bytes received*/
} AdsTelRetTdFsk_t;


/**
 * @ingroup adsTelCallback
 *       @ref adsTelFwCb_t return buffer structure type.
 *
 * @description
 *       This structure is the return buffer type of @ref adsTelFwCb_t when
 *       retStatus is any of the following @ref AdsTelStatus_t members.
 *          @ref ADS_TEL_STATUS_TD_RCV_CMPLT.
 *
 * @purpose
 *       Return buffer structure type for API and event callback
 *       @ref adsTelFwCb_t.
 * @see
 *       @ref adsTelFwCb_t \n
 *       @ref adsTelEpToneRecv().
 */
typedef struct AdsTelRetTd_s
{
    unsigned int   transId;
    /**< the transaction ID that was returned from the original API call.*/
    AdsTelStatus_t retStatus;
    /**< the returned status.*/
    unsigned int   reason;
    /**< the reason that for the TD  detect completion.*/
    unsigned int   numTones;
    /**< the number of tones detected.*/
    unsigned int   tones[ADS_TEL_MAX_TONES];
    /**< the received tone IDs.*/
} AdsTelRetTd_t;


/**
 * @ingroup adsTelCallback
 *       @ref adsTelFwCb_t return buffer structure type.
 *
 * @description
 *       This structure is the return buffer type of @ref adsTelFwCb_t
 *       when retStatus is any of the following @ref AdsTelStatus_t
 *       members.
 *          @ref ADS_TEL_STATUS_EVENT.
 *
 * @purpose
 *       Return buffer structure type for API and event callback
 *       @ref adsTelFwCb_t.
 * @see
 *       @ref adsTelFwCb_t \n
 *       @ref adsTelEpToneRecv().
 */
typedef struct AdsTelRetEv_s
{
    unsigned int     transId;
    /**< the transaction ID - This will always be set to 0.*/
    AdsTelStatus_t   retStatus;
    /**< the returned status.*/
    AdsTelEpHandle_t epHandle;
    /**< the endpoint on which the event occurred.*/
    AdsTelPipeDir_t  pipeDir;
    /**< the pipeline on which the event occurred.*/
    unsigned int     compId;
    /**< the component location in the pipeline on which the event occured.*/
    unsigned int     code;
    /**< the event code. See @ref AdsTelEvent_t.*/
    unsigned int     data1;
    /**< the event data word 1*/
    unsigned int     data2;
    /**< the event data word 1.*/
} AdsTelRetEv_t;


/**
 * @ingroup adsTelCallback
 *       @ref adsTelFwCb_t return buffer structure type.
 *
 * @description
 *       This structure is the return buffer type of @ref adsTelFwCb_t when
 *       retStatus is any of the following @ref AdsTelStatus_t members.
 *          @ref ADS_TEL_STATUS_GET_PARAMS.
 *
 * @purpose
 *       Return buffer structure type for API and event callback
 *       @ref adsTelFwCb_t.
 * @see
 *       @ref adsTelFwCb_t \n
 *       @ref adsTelEpCompParamsGet().
 */
typedef struct AdsTelRetGetParams_s
{
    unsigned int   transId;
    /**< the transaction ID that was returned from the original API call.*/
    AdsTelStatus_t retStatus;
    /**< the returned status.*/
    unsigned int   numParams;
    /**< the number of parameters being returned.*/
    int   paramVals[ADS_TEL_MAX_PARAMS];
    /**< the paramter values. The index is the param ID*/
} AdsTelRetGetParams_t;


/**
 * @ingroup adsTelCallback
 *       @ref adsTelFwCb_t return buffer structure type.
 *
 * @description
 *       This structure is the return buffer type of @ref adsTelFwCb_t when
 *       retStatus is any of the following @ref AdsTelStatus_t members.
 *          @ref ADS_TEL_STATUS_PLY_CMPLT.
 *
 * @purpose
 *       Return buffer structure type for API and event callback
 *       @ref adsTelFwCb_t.
 * @see
 *       @ref adsTelFwCb_t \n
 *       @ref adsTelEpCompParamsGet().
 */
typedef struct AdsTelRetPlay_s
{
    unsigned int   transId;
    /**< the transaction ID that was returned from the original API call.*/
    AdsTelStatus_t retStatus;
    /**< the returned status*/
    unsigned int   reason;
    /**< the reson for the player completion.*/
} AdsTelRetPlay_t;



/**
 * @ingroup adsTelEndpoint
 *       Audio segment to play
 *
 * @description
 *       This structure is used to define the audio segments to play. It is
 *       passed as a parameter to @ref adsTelEpPlayAudio().
 *
 * @purpose
 *       Parameters of the audio segment to play.
 * @see
 *       @ref AdsTelMediaHandle_t \n
 *       @ref adsTelEpPlayAudio().
 */
typedef struct AdsTelMediaDesc_s
{
    int               offset;
    /**< offset in bytes where player starts. */
    int               length;
    /**< length to play (in 10ms unit), 0 to play until the end. */
    AdsTelMediaHandle_t  handle;
    /**< media handle to play. */
    short             next;
    /**< next segment, 0 to play segment in infinite loop,
     *   @ref ADS_TEL_MEDIA_SEG_EOP for the last segment. */
} AdsTelMediaDesc_t;





/* segment data for tone generation template. */
/**
 * @ingroup adsTelEndpoint
 *       Tone segment structure
 *
 * @description
 *       This structure is used to define the segment data for tone generation
 *       template. It is passed as a parameter to @ref adsTelTgToneBuild().
 *
 * @purpose
 *       Parameters of the tone to build for tone generation.
 * @see
 *       @ref adsTelTgToneBuild.
 */
typedef struct {
    unsigned short  repCount;
    /**< Number of repeating the segment. 0 means to repeate forever */
    unsigned short  segType;
     /**< signal type (single, dual or AM tone ) */
    unsigned int  durationOn;
    /**< tone on duration in milli seconds. */
    unsigned int  durationOff;
    /**< tone off duration in milli seconds. */
    short   freqA;
    /**< frequency A in Hz */
    short   freqB;
    /**< the 2nd frequence in Hz if dual or AM tone,ignored if single tone */
    short   ampA;
    /**< amplitude of A signal in dBm */
    short   ampB;
    /**< amplitude of B signal in dBm if dual tone, modulation rate in
         percentage if AM tone, ignored if single tone */
    unsigned short  mode;
    /**< mode, overwrite or mix over the decoder outupt */
    short   nextSeg;
    /**< the index of next segment relative to the current segement. e.g., 1
       means to go the following segment, 0 means repeat the current segment,
       -2 means go back to previous 2 segments. ADS_TEL_TG_LASTSEG means the
       last segment */
} AdsTelToneSeg_t;




/* segment data for tone generation template. */
/**
 * @ingroup adsTelEndpoint
 *       Tone Information structure
 *
 * @description
 *       This structure is used to define the tone informations for tone
 *       detection template. It is passed as a parameter to
 *       @ref adsTelTdToneBuild().
 *
 * @purpose
 *       Parameters of the tone to build for tone detection.
 * @see
 *       @ref adsTelTdToneBuild.
 */
typedef struct {
    unsigned short  type;
    /**< single or dual frequency tone */
    unsigned short  criteria;
     /**< loose, medium or tight */
    unsigned short  freqLowA;
    /**< low bound of the 1st frequency in Hz */
    unsigned short  freqHighA;
    /**< high bound of the 1st frequency in Hz */
    unsigned short  freqLowB;
    /**< low bound of the 2nd frequency in Hz */
    unsigned short  freqHighB;
    /**< high bound of the 2nd frequency in Hz */
    short  ampLowA;
    /**< low level of the 1st frequency in dBm */
    short  ampHighA;
    /**< high level of the 1st frequency in dBm */
    short  ampLowB;
    /**< low level of the 2nd frequency in dBm */
    short  ampHighB;
    /**< high level of the 2nd frequency in dBm */
    char  attributes;
    /**< attribute (how to report the tone can be) */
} AdsTelToneInfo_t;


#endif /*#ifndef ADS_TEL_TYPES_H_*/
