/******************************************************************************
* @file  adsTelAddTone.c
*
* Contents: This file contains functions to add tones for TD and TG.
*
* @par
* INTEL CONFIDENTIAL
* Copyright 2009 Intel Corporation All Rights Reserved.
* 
* The source code contained or described herein and all documents related to the
* source code ("Material") are owned by Intel Corporation or its suppliers or
* licensors. Title to the Material remains with Intel Corporation or its
* suppliers and licensors. The Material may contain trade secrets and proprietary
* and confidential information of Intel Corporation and its suppliers and
* licensors, and is protected by worldwide copyright and trade secret laws and
* treaty provisions. No part of the Material may be used, copied, reproduced,
* modified, published, uploaded, posted, transmitted, distributed, or disclosed
* in any way without Intels prior express written permission.
* No license under any patent, copyright, trade secret or other intellectual
* property right is granted to or conferred upon you by disclosure or delivery
* of the Materials, either expressly, by implication, inducement, estoppel or
* otherwise. Any license under such intellectual property rights must be
* express and approved by Intel in writing.
* 
* Include any supplier copyright notices as supplier requires Intel to use.
* Include supplier trademarks or logos as supplier requires Intel to use,
* preceded by an asterisk.
* An asterisked footnote can be added as follows: 
*   *Third Party trademarks are the property of their respective owners.
* 
* Unless otherwise agreed by Intel in writing, you may not remove or alter this
* notice or any other notice embedded in Materials by Intel or Intels suppliers
* or licensors in any way.
* 
*  version: ADS.L.1.1.0-160
*
******************************************************************************/

#include "adsTel.h"
#include "adsTelAddTone.h"
#include "adsTelCommon.h"


/*************************************
 * Add user tones to the Tone Generator
 *************************************/
void adsTelAddToneTG(void)
{
    AdsTelToneSeg_t toneSegs[MAX_TONE_SEG];


    toneSegs[TG_TONE_SEG_0].repCount    = TG_TONE_ID_255_SEG0_REP_CNT;
    toneSegs[TG_TONE_SEG_0].segType     = ADS_TEL_TG_SINGLETONE;
    toneSegs[TG_TONE_SEG_0].durationOn  = TG_TONE_ID_255_SEG0_ONTIME;
    toneSegs[TG_TONE_SEG_0].durationOff = TG_TONE_ID_255_SEG0_OFFTIME;
    toneSegs[TG_TONE_SEG_0].freqA       = TG_TONE_ID_255_SEG0_FREQ_A;
    toneSegs[TG_TONE_SEG_0].freqB       = TG_TONE_ID_255_SEG0_FREQ_B;
    toneSegs[TG_TONE_SEG_0].ampA        = TG_TONE_ID_255_SEG0_AMP_A;
    toneSegs[TG_TONE_SEG_0].ampB        = TG_TONE_ID_255_SEG0_AMP_B;
    toneSegs[TG_TONE_SEG_0].mode        = ADS_TEL_TG_MODE_OVERWRITE;
    toneSegs[TG_TONE_SEG_0].nextSeg     = ADS_TEL_TG_LASTSEG;
    if (ADS_TEL_STATUS_SUCCESS != adsTelTgToneBuild(TG_TONE_ID_255,
                                                   (TG_TONE_SEG_0+1),
                                                    toneSegs))
    {
        printf("\nERROR:%s: Failed to build the tone id 255 ****\n",
               __FUNCTION__);
    }

    toneSegs[TG_TONE_SEG_0].repCount    = TG_TONE_ID_254_SEG0_REP_CNT;
    toneSegs[TG_TONE_SEG_0].segType     = ADS_TEL_TG_DUALTONE;
    toneSegs[TG_TONE_SEG_0].durationOn  = TG_TONE_ID_254_SEG0_ONTIME;
    toneSegs[TG_TONE_SEG_0].durationOff = TG_TONE_ID_254_SEG0_OFFTIME;
    toneSegs[TG_TONE_SEG_0].freqA       = TG_TONE_ID_254_SEG0_FREQ_A;
    toneSegs[TG_TONE_SEG_0].freqB       = TG_TONE_ID_254_SEG0_FREQ_B;
    toneSegs[TG_TONE_SEG_0].ampA        = TG_TONE_ID_254_SEG0_AMP_A;
    toneSegs[TG_TONE_SEG_0].ampB        = TG_TONE_ID_254_SEG0_AMP_B;
    toneSegs[TG_TONE_SEG_0].mode        = ADS_TEL_TG_MODE_OVERWRITE;
    toneSegs[TG_TONE_SEG_0].nextSeg     = ADS_TEL_TG_LASTSEG;
    if (ADS_TEL_STATUS_SUCCESS != adsTelTgToneBuild(TG_TONE_ID_254,
                                                   (TG_TONE_SEG_0+1),
                                                    toneSegs))
    {
        printf("\nERROR:%s: Failed to build the tone id 254 ****\n",
               __FUNCTION__);
    }

    toneSegs[TG_TONE_SEG_0].repCount    = TG_TONE_ID_253_SEG0_REP_CNT;
    toneSegs[TG_TONE_SEG_0].segType     = ADS_TEL_TG_AMTONE;
    toneSegs[TG_TONE_SEG_0].durationOn  = TG_TONE_ID_253_SEG0_ONTIME;
    toneSegs[TG_TONE_SEG_0].durationOff = TG_TONE_ID_253_SEG0_OFFTIME;
    toneSegs[TG_TONE_SEG_0].freqA       = TG_TONE_ID_253_SEG0_FREQ_A;
    toneSegs[TG_TONE_SEG_0].freqB       = TG_TONE_ID_253_SEG0_FREQ_B;
    toneSegs[TG_TONE_SEG_0].ampA        = TG_TONE_ID_253_SEG0_AMP_A;
    toneSegs[TG_TONE_SEG_0].ampB        = TG_TONE_ID_253_SEG0_AMP_B;
    toneSegs[TG_TONE_SEG_0].mode        = ADS_TEL_TG_MODE_OVERWRITE;
    toneSegs[TG_TONE_SEG_0].nextSeg     = ADS_TEL_TG_LASTSEG;
    if (ADS_TEL_STATUS_SUCCESS != adsTelTgToneBuild(TG_TONE_ID_253,
                                                   (TG_TONE_SEG_0+1),
                                                    toneSegs))
    {
        printf("\nERROR:%s: Failed to build the tone id 253 ****\n",
               __FUNCTION__);
    }

    /* Two Segment Tone. Continuous. */
    toneSegs[TG_TONE_SEG_0].repCount    = TG_TONE_ID_252_SEG0_REP_CNT;
    toneSegs[TG_TONE_SEG_0].segType     = ADS_TEL_TG_SINGLETONE;
    toneSegs[TG_TONE_SEG_0].durationOn  = TG_TONE_ID_252_SEG0_ONTIME;
    toneSegs[TG_TONE_SEG_0].durationOff = TG_TONE_ID_252_SEG0_OFFTIME;
    toneSegs[TG_TONE_SEG_0].freqA       = TG_TONE_ID_252_SEG0_FREQ_A;
    toneSegs[TG_TONE_SEG_0].freqB       = TG_TONE_ID_252_SEG0_FREQ_B;
    toneSegs[TG_TONE_SEG_0].ampA        = TG_TONE_ID_252_SEG0_AMP_A;
    toneSegs[TG_TONE_SEG_0].ampB        = TG_TONE_ID_252_SEG0_AMP_B;
    toneSegs[TG_TONE_SEG_0].mode        = ADS_TEL_TG_MODE_OVERWRITE;
    toneSegs[TG_TONE_SEG_0].nextSeg     = TG_TONE_ID_252_SEG0_NXT_SEG;

    toneSegs[TG_TONE_SEG_1].repCount    = TG_TONE_ID_252_SEG1_REP_CNT;
    toneSegs[TG_TONE_SEG_1].segType     = ADS_TEL_TG_SINGLETONE;
    toneSegs[TG_TONE_SEG_1].durationOn  = TG_TONE_ID_252_SEG1_ONTIME;
    toneSegs[TG_TONE_SEG_1].durationOff = TG_TONE_ID_252_SEG1_OFFTIME;
    toneSegs[TG_TONE_SEG_1].freqA       = TG_TONE_ID_252_SEG1_FREQ_A;
    toneSegs[TG_TONE_SEG_1].freqB       = TG_TONE_ID_252_SEG1_FREQ_B;
    toneSegs[TG_TONE_SEG_1].ampA        = TG_TONE_ID_252_SEG1_AMP_A;
    toneSegs[TG_TONE_SEG_1].ampB        = TG_TONE_ID_252_SEG1_AMP_B;
    toneSegs[TG_TONE_SEG_1].mode        = ADS_TEL_TG_MODE_OVERWRITE;
    toneSegs[TG_TONE_SEG_1].nextSeg     = TG_TONE_ID_252_SEG1_NXT_SEG;
    if (ADS_TEL_STATUS_SUCCESS != adsTelTgToneBuild(TG_TONE_ID_252,
                                                   (TG_TONE_SEG_1+1),
                                                    toneSegs))
    {
        printf("\nERROR:%s: Failed to build the tone id 252 ****\n",
               __FUNCTION__);
    }

    /* Off-hook warning, Five Segment Tone. Continuous. */
    toneSegs[TG_TONE_SEG_0].repCount    = TG_TONE_ID_251_SEG0_REP_CNT;
    toneSegs[TG_TONE_SEG_0].segType     = ADS_TEL_TG_SINGLETONE;
    toneSegs[TG_TONE_SEG_0].durationOn  = TG_TONE_ID_251_SEG0_ONTIME;
    toneSegs[TG_TONE_SEG_0].durationOff = TG_TONE_ID_251_SEG0_OFFTIME;
    toneSegs[TG_TONE_SEG_0].freqA       = TG_TONE_ID_251_SEG0_FREQ_A;
    toneSegs[TG_TONE_SEG_0].freqB       = TG_TONE_ID_251_SEG0_FREQ_B;
    toneSegs[TG_TONE_SEG_0].ampA        = TG_TONE_ID_251_SEG0_AMP_A;
    toneSegs[TG_TONE_SEG_0].ampB        = TG_TONE_ID_251_SEG0_AMP_B;
    toneSegs[TG_TONE_SEG_0].mode        = ADS_TEL_TG_MODE_OVERWRITE;
    toneSegs[TG_TONE_SEG_0].nextSeg     = TG_TONE_ID_251_SEG0_NXT_SEG;

    toneSegs[TG_TONE_SEG_1].repCount    = TG_TONE_ID_251_SEG1_REP_CNT;
    toneSegs[TG_TONE_SEG_1].segType     = ADS_TEL_TG_SINGLETONE;
    toneSegs[TG_TONE_SEG_1].durationOn  = TG_TONE_ID_251_SEG1_ONTIME;
    toneSegs[TG_TONE_SEG_1].durationOff = TG_TONE_ID_251_SEG1_OFFTIME;
    toneSegs[TG_TONE_SEG_1].freqA       = TG_TONE_ID_251_SEG1_FREQ_A;
    toneSegs[TG_TONE_SEG_1].freqB       = TG_TONE_ID_251_SEG1_FREQ_B;
    toneSegs[TG_TONE_SEG_1].ampA        = TG_TONE_ID_251_SEG1_AMP_A;
    toneSegs[TG_TONE_SEG_1].ampB        = TG_TONE_ID_251_SEG1_AMP_B;
    toneSegs[TG_TONE_SEG_1].mode        = ADS_TEL_TG_MODE_OVERWRITE;
    toneSegs[TG_TONE_SEG_1].nextSeg     = TG_TONE_ID_251_SEG1_NXT_SEG;

    toneSegs[TG_TONE_SEG_2].repCount    = TG_TONE_ID_251_SEG2_REP_CNT;
    toneSegs[TG_TONE_SEG_2].segType     = ADS_TEL_TG_SINGLETONE;
    toneSegs[TG_TONE_SEG_2].durationOn  = TG_TONE_ID_251_SEG2_ONTIME;
    toneSegs[TG_TONE_SEG_2].durationOff = TG_TONE_ID_251_SEG2_OFFTIME;
    toneSegs[TG_TONE_SEG_2].freqA       = TG_TONE_ID_251_SEG2_FREQ_A;
    toneSegs[TG_TONE_SEG_2].freqB       = TG_TONE_ID_251_SEG2_FREQ_B;
    toneSegs[TG_TONE_SEG_2].ampA        = TG_TONE_ID_251_SEG2_AMP_A;
    toneSegs[TG_TONE_SEG_2].ampB        = TG_TONE_ID_251_SEG2_AMP_B;
    toneSegs[TG_TONE_SEG_2].mode        = ADS_TEL_TG_MODE_OVERWRITE;
    toneSegs[TG_TONE_SEG_2].nextSeg     = TG_TONE_ID_251_SEG2_NXT_SEG;

    toneSegs[TG_TONE_SEG_3].repCount    = TG_TONE_ID_251_SEG3_REP_CNT;
    toneSegs[TG_TONE_SEG_3].segType     = ADS_TEL_TG_SINGLETONE;
    toneSegs[TG_TONE_SEG_3].durationOn  = TG_TONE_ID_251_SEG3_ONTIME;
    toneSegs[TG_TONE_SEG_3].durationOff = TG_TONE_ID_251_SEG3_OFFTIME;
    toneSegs[TG_TONE_SEG_3].freqA       = TG_TONE_ID_251_SEG3_FREQ_A;
    toneSegs[TG_TONE_SEG_3].freqB       = TG_TONE_ID_251_SEG3_FREQ_B;
    toneSegs[TG_TONE_SEG_3].ampA        = TG_TONE_ID_251_SEG3_AMP_A;
    toneSegs[TG_TONE_SEG_3].ampB        = TG_TONE_ID_251_SEG3_AMP_B;
    toneSegs[TG_TONE_SEG_3].mode        = ADS_TEL_TG_MODE_OVERWRITE;
    toneSegs[TG_TONE_SEG_3].nextSeg     = TG_TONE_ID_251_SEG3_NXT_SEG;

    toneSegs[TG_TONE_SEG_4].repCount    = TG_TONE_ID_251_SEG4_REP_CNT;
    toneSegs[TG_TONE_SEG_4].segType     = ADS_TEL_TG_SINGLETONE;
    toneSegs[TG_TONE_SEG_4].durationOn  = TG_TONE_ID_251_SEG4_ONTIME;
    toneSegs[TG_TONE_SEG_4].durationOff = TG_TONE_ID_251_SEG4_OFFTIME;
    toneSegs[TG_TONE_SEG_4].freqA       = TG_TONE_ID_251_SEG4_FREQ_A;
    toneSegs[TG_TONE_SEG_4].freqB       = TG_TONE_ID_251_SEG4_FREQ_B;
    toneSegs[TG_TONE_SEG_4].ampA        = TG_TONE_ID_251_SEG4_AMP_A;
    toneSegs[TG_TONE_SEG_4].ampB        = TG_TONE_ID_251_SEG4_AMP_B;
    toneSegs[TG_TONE_SEG_4].mode        = ADS_TEL_TG_MODE_OVERWRITE;
    toneSegs[TG_TONE_SEG_4].nextSeg     = TG_TONE_ID_251_SEG4_NXT_SEG;
    if (ADS_TEL_STATUS_SUCCESS != adsTelTgToneBuild(TG_TONE_ID_251,
                                                   (TG_TONE_SEG_4+1),
                                                    toneSegs))
    {
        printf("\nERROR:%s: Failed to build the tone id 251 ****\n",
               __FUNCTION__);
    }


    /* Information startup tone (CAT), Two SegmentTone. */
    toneSegs[TG_TONE_SEG_0].repCount    = TG_TONE_ID_250_SEG0_REP_CNT;
    toneSegs[TG_TONE_SEG_0].segType     = ADS_TEL_TG_DUALTONE;
    toneSegs[TG_TONE_SEG_0].durationOn  = TG_TONE_ID_250_SEG0_ONTIME;
    toneSegs[TG_TONE_SEG_0].durationOff = TG_TONE_ID_250_SEG0_OFFTIME;
    toneSegs[TG_TONE_SEG_0].freqA       = TG_TONE_ID_250_SEG0_FREQ_A;
    toneSegs[TG_TONE_SEG_0].freqB       = TG_TONE_ID_250_SEG0_FREQ_B;
    toneSegs[TG_TONE_SEG_0].ampA        = TG_TONE_ID_250_SEG0_AMP_A;
    toneSegs[TG_TONE_SEG_0].ampB        = TG_TONE_ID_250_SEG0_AMP_B;
    toneSegs[TG_TONE_SEG_0].mode        = ADS_TEL_TG_MODE_OVERWRITE;
    toneSegs[TG_TONE_SEG_0].nextSeg     = TG_TONE_ID_250_SEG0_NXT_SEG;

    toneSegs[TG_TONE_SEG_1].repCount    = TG_TONE_ID_250_SEG1_REP_CNT;
    toneSegs[TG_TONE_SEG_1].segType     = ADS_TEL_TG_DUALTONE;
    toneSegs[TG_TONE_SEG_1].durationOn  = TG_TONE_ID_250_SEG1_ONTIME;
    toneSegs[TG_TONE_SEG_1].durationOff = TG_TONE_ID_250_SEG1_OFFTIME;
    toneSegs[TG_TONE_SEG_1].freqA       = TG_TONE_ID_250_SEG1_FREQ_A;
    toneSegs[TG_TONE_SEG_1].freqB       = TG_TONE_ID_250_SEG1_FREQ_B;
    toneSegs[TG_TONE_SEG_1].ampA        = TG_TONE_ID_250_SEG1_AMP_A;
    toneSegs[TG_TONE_SEG_1].ampB        = TG_TONE_ID_250_SEG1_AMP_B;
    toneSegs[TG_TONE_SEG_1].mode        = ADS_TEL_TG_MODE_OVERWRITE;
    toneSegs[TG_TONE_SEG_1].nextSeg     = ADS_TEL_TG_LASTSEG;

    if (ADS_TEL_STATUS_SUCCESS != adsTelTgToneBuild(TG_TONE_ID_250,
                                                   (TG_TONE_SEG_1+1),
                                                    toneSegs))
    {
        printf("\nERROR:%s: Failed to build the tone id 250 ****\n",
               __FUNCTION__);
    }

    return;
}

/*************************************
 * Add user tones to the Tone Detector
 *************************************/
void adsTelAddToneTD(void)
{

    AdsTelToneInfo_t toneInfo;

    /*
     * 500Hz +- 20 Single Tone.
     */
    toneInfo.type          = ADS_TEL_TD_SINGLETONE;
    toneInfo.criteria      = ADS_TEL_TD_QUAL_CRITERIA_LOOSE;
    toneInfo.freqLowA      = TD_TONE_ID_255_FREQ_LOW_A;
    toneInfo.freqHighA     = TD_TONE_ID_255_FREQ_HIGH_A;
    toneInfo.freqLowB      = TD_TONE_ID_255_FREQ_LOW_B;
    toneInfo.freqHighB     = TD_TONE_ID_255_FREQ_HIGH_B;
    toneInfo.ampLowA       = TD_TONE_ID_255_AMP_LOW_A;
    toneInfo.ampHighA      = TD_TONE_ID_255_AMP_HIGH_A;
    toneInfo.ampLowB       = TD_TONE_ID_255_AMP_LOW_B;
    toneInfo.ampHighB      = TD_TONE_ID_255_AMP_HIGH_B;
    toneInfo.attributes    = ADS_TEL_TD_TONEATTR_EVTBOTH;
    if (ADS_TEL_STATUS_SUCCESS != adsTelTdToneBuild(TD_TONE_ID_255,
                                                    &toneInfo))
    {
        printf("\nERROR:%s: Failed to build TD tone id 255\n",
               __FUNCTION__);
    }

    /*
     * 700Hz +- 10 Single Tone. Amplitude -5 to -30
     */
    toneInfo.type         = ADS_TEL_TD_SINGLETONE;
    toneInfo. criteria    = ADS_TEL_TD_QUAL_CRITERIA_LOOSE;
    toneInfo.freqLowA     = TD_TONE_ID_249_FREQ_LOW_A;
    toneInfo.freqHighA    = TD_TONE_ID_249_FREQ_HIGH_A;
    toneInfo.freqLowB     = TD_TONE_ID_249_FREQ_LOW_B;
    toneInfo.freqHighB    = TD_TONE_ID_249_FREQ_HIGH_B;
    toneInfo.ampLowA      = TD_TONE_ID_249_AMP_LOW_A;
    toneInfo.ampHighA     = TD_TONE_ID_249_AMP_HIGH_A;
    toneInfo.ampLowB      = TD_TONE_ID_249_AMP_LOW_B;
    toneInfo.ampHighB     = TD_TONE_ID_249_AMP_HIGH_B;
    toneInfo.attributes   = ADS_TEL_TD_TONEATTR_EVTBOTH;
    if (ADS_TEL_STATUS_SUCCESS != adsTelTdToneBuild(TD_TONE_ID_249,
                                                    &toneInfo))
    {
        printf("\nERROR:%s: Failed to build TD tone id 249\n",
               __FUNCTION__);
    }


    /*
     * DTMF0 DualTone.
     */
    toneInfo.type         = ADS_TEL_TD_DUALTONE;
    toneInfo.criteria     = ADS_TEL_TD_QUAL_CRITERIA_LOOSE;
    toneInfo.freqLowA     = TD_TONE_ID_248_FREQ_LOW_A;
    toneInfo.freqHighA    = TD_TONE_ID_248_FREQ_HIGH_A;
    toneInfo.freqLowB     = TD_TONE_ID_248_FREQ_LOW_B;
    toneInfo.freqHighB    = TD_TONE_ID_248_FREQ_HIGH_B;
    toneInfo.ampLowA      = TD_TONE_ID_248_AMP_LOW_A;
    toneInfo.ampHighA     = TD_TONE_ID_248_AMP_HIGH_A;
    toneInfo.ampLowB      = TD_TONE_ID_248_AMP_LOW_B;
    toneInfo.ampHighB     = TD_TONE_ID_248_AMP_HIGH_B;
    toneInfo.attributes   = ADS_TEL_TD_TONEATTR_EVTBOTH;
    if (ADS_TEL_STATUS_SUCCESS != adsTelTdToneBuild(TD_TONE_ID_248,
                                                    &toneInfo))
    {
        printf("\nERROR:%s: Failed to build TD tone id 248\n",
               __FUNCTION__);
    }

    return;
}

