/******************************************************************************
* @file    adsTelUtils.c
*
* Contents: This file contain common functions for both RefApps.
*
* @par
* INTEL CONFIDENTIAL
* Copyright 2009 Intel Corporation All Rights Reserved.
* 
* The source code contained or described herein and all documents related to the
* source code ("Material") are owned by Intel Corporation or its suppliers or
* licensors. Title to the Material remains with Intel Corporation or its
* suppliers and licensors. The Material may contain trade secrets and proprietary
* and confidential information of Intel Corporation and its suppliers and
* licensors, and is protected by worldwide copyright and trade secret laws and
* treaty provisions. No part of the Material may be used, copied, reproduced,
* modified, published, uploaded, posted, transmitted, distributed, or disclosed
* in any way without Intels prior express written permission.
* No license under any patent, copyright, trade secret or other intellectual
* property right is granted to or conferred upon you by disclosure or delivery
* of the Materials, either expressly, by implication, inducement, estoppel or
* otherwise. Any license under such intellectual property rights must be
* express and approved by Intel in writing.
* 
* Include any supplier copyright notices as supplier requires Intel to use.
* Include supplier trademarks or logos as supplier requires Intel to use,
* preceded by an asterisk.
* An asterisked footnote can be added as follows: 
*   *Third Party trademarks are the property of their respective owners.
* 
* Unless otherwise agreed by Intel in writing, you may not remove or alter this
* notice or any other notice embedded in Materials by Intel or Intels suppliers
* or licensors in any way.
* 
*  version: ADS.L.1.1.0-160
******************************************************************************/

/****************************************************************************/
/******************* INCLUDES ***********************************************/
/****************************************************************************/

#include <setjmp.h>
#include "adsTel.h"
#include "adsTelCommon.h"
#include "adsTelRTP.h"


/****************************************************************************/
/******************* GLOBALS ************************************************/
/****************************************************************************/

/*Menu jump location*/
extern jmp_buf atPrtMenu;

extern AdsTelDesc_t  epList[MAX_IP_LINES_SUPPORTED];


/****************************************************************************/
/******************* FUNCTION DECLARATIONS **********************************/
/****************************************************************************/

/*utility functions*/
int adsRefAppGetNum(char *str, unsigned int * pUNumericValue,
                    int * pSNumericValue);
int adsRefAppGetStr(char *str, char *pInStr);

void configureCallIPtoPCM(unsigned int lineNum,
                             unsigned int pcmNum);

AdsTelStatus_t epHandleToEpIdConvert(unsigned int  epHandle,
                                     unsigned int* pEndpointId);

unsigned int convertEpToRtp(AdsTelEpHandle_t epHandle,
                            unsigned int*    pSamplesPerPacket,
                            unsigned int* decoder);


/****************************************************************************/
/******************* FUNCTION DEFINITIONS ***********************************/
/****************************************************************************/

/****************************************************
 * Convert an endpoint ID to an RTP Port number
 * this function is called by FW callback handling
 * function
 ****************************************************/
AdsTelStatus_t epHandleToEpIdConvert(unsigned int  epHandle,
                                     unsigned int* pEndpointId)
{
    unsigned int i = 0;

    for (i=0; i<MAX_IP_LINES_SUPPORTED; i++)
    {
        if (epList[i].epHandle == epHandle)
        {
            *pEndpointId = i;
            return ADS_TEL_STATUS_SUCCESS;
        }
    }

    return ADS_TEL_STATUS_FAIL;
}



/****************************************************
 * Convert an endpoint ID to an RTP Port number or
 * update the decoder codec type. This function is
 * called by ads_ip_cb_xxbound() and
 * frameworkPayChange().
 ****************************************************/
unsigned int convertEpToRtp(AdsTelEpHandle_t epHandle,
                            unsigned int*    pSamplesPerPacket,
                            unsigned int* decoder)
{
    unsigned int i = 0;
    unsigned int numSamples = 0;

    while ( i < MAX_IP_LINES_SUPPORTED)
    {
        if (epList[i].epHandle == epHandle)
        {

            if (decoder != NULL)
            {
                epList[i].de_codec= *decoder;
                configureCallIPtoPCM(i, 0);
            }
            if (pSamplesPerPacket != NULL)
            {
                /*calc the frame size*/
                if ((epList[i].de_codec >= ADS_TEL_PARAM_CODER_TYPE_G722_64) &&
                    (epList[i].de_codec <= ADS_TEL_PARAM_CODER_TYPE_G722_48))
                {
                    /*set the frame size to WB*/
                    numSamples = NUM_SAMPLES_WB;
                }
                else
                {
                    /*set the frame size to WB*/
                    numSamples = NUM_SAMPLES_NB;
                }

                /*update for mfpp setting*/
                *pSamplesPerPacket = numSamples*epList[i].mfppVal;
            }

            return i*RTP_PORT_MULTIPLIER;
        }

        i++;
    }

    return MAX_RTP_CONNECTIONS;
}

/*********************************************
 * get an integer or usigned integer for stdin
 *********************************************/
int adsRefAppGetNum(char *str, unsigned int * pUNumericValue,
                    int * pSNumericValue)
{
    int c;
    int i = 0;
    char input[ADS_TEL_CODELET_STRLEN];
    unsigned int neg_sign = 0;
    int bInvalidCharFound = 0;

    if(pUNumericValue != NULL)
    {
        if(str && *str)
        {
          printf("%s", str);
        }
        do
        {
            c = getc(stdin);

            if (c == 0x08)
            {
                if(i)
                {
                  i--;
                }
                continue;
            }
            if(c >= '0' && c <= '9')
            {
                input[i++] = c;
                continue;
            }

            /* exception if x entered, jump to main menu */
            if(c == 'x')
            {
                /*flush char after an x*/
                while((c != '\r') && (c != '\n'))
                {
                  c = getc(stdin);
                }
                longjmp(atPrtMenu, 1);
            }
            if((c != '\r') && (c != '\n'))
            {
                bInvalidCharFound = 1;
                continue;
            }

        } while(i<(ADS_TEL_CODELET_STRLEN-1) && c!='\r' && c!='\n');

        if(i<=0 || bInvalidCharFound)
        {
            return ADS_TEL_STATUS_FAIL;  /*if non numeric return error*/
        }

        input[i] = '\0';

        *pUNumericValue = atoi(input);
        return ADS_TEL_STATUS_SUCCESS;
    }
    else
    {
        if (pSNumericValue != NULL)
        {
            if(str && *str)
            {
              printf("%s", str);
            }
            do
            {
                c = getc(stdin);

                if (c == 0x08)
                {
                    if(i)
                    {
                      i--;
                    }
                    continue;
                }
                if (i==0)
                {
                    if(c == '-')
                    {

                        input[i++] = c;
                        neg_sign=1;
                        continue;
                    }

                }

                if(c >= ASCII_0 && c <= ASCII_9)
                {
                    input[i++] = c;
                    continue;
                }

                /* exception if x entered, jump to main menu */
                if(c == 'x')
                {
                    /*flush char after an x*/
                    while((c != '\r') && (c != '\n'))
                    {
                      c = getc(stdin);
                    }
                    longjmp(atPrtMenu, 1);
                }
                if((c != '\r') && (c != '\n'))
                {
                    bInvalidCharFound = 1;
                    continue;
                }

            } while(i<(ADS_TEL_CODELET_STRLEN-1) && c!='\r' && c!='\n');

            if(i<=0 || bInvalidCharFound)
            {
                return ADS_TEL_STATUS_FAIL;  /*if non numeric return error*/
            }

            input[i] = '\0';

            *pSNumericValue = atoi(input);
            return ADS_TEL_STATUS_SUCCESS;
        }
        else
        {
            return ADS_TEL_STATUS_FAIL;
        }
    }




}


/**************************
 * get an string from stdin
 **************************/
int adsRefAppGetStr(char *str, char *pInStr)
{
    int c;
    int i=0;

    if(str && *str)
    {
      printf("%s", str);
    }
    do
    {
        c = getc(stdin);
        if (c == 0x08)
        {
            if(i)
            {
              i--;
            }
        }
        else
        {
            pInStr[i++] = c;
        }

    } while(i<ADS_TEL_CODELET_STRLEN && c!='\r' && c!='\n');

    pInStr[i-1] = '\0';

    return i-1;
}
