/******************************************************************************
* @file    adsTelCommon.h
*
* Contents: Common includes between both reference applications
*
* @par
* INTEL CONFIDENTIAL
* Copyright 2009 Intel Corporation All Rights Reserved.
* 
* The source code contained or described herein and all documents related to the
* source code ("Material") are owned by Intel Corporation or its suppliers or
* licensors. Title to the Material remains with Intel Corporation or its
* suppliers and licensors. The Material may contain trade secrets and proprietary
* and confidential information of Intel Corporation and its suppliers and
* licensors, and is protected by worldwide copyright and trade secret laws and
* treaty provisions. No part of the Material may be used, copied, reproduced,
* modified, published, uploaded, posted, transmitted, distributed, or disclosed
* in any way without Intels prior express written permission.
* No license under any patent, copyright, trade secret or other intellectual
* property right is granted to or conferred upon you by disclosure or delivery
* of the Materials, either expressly, by implication, inducement, estoppel or
* otherwise. Any license under such intellectual property rights must be
* express and approved by Intel in writing.
* 
* Include any supplier copyright notices as supplier requires Intel to use.
* Include supplier trademarks or logos as supplier requires Intel to use,
* preceded by an asterisk.
* An asterisked footnote can be added as follows: 
*   *Third Party trademarks are the property of their respective owners.
* 
* Unless otherwise agreed by Intel in writing, you may not remove or alter this
* notice or any other notice embedded in Materials by Intel or Intels suppliers
* or licensors in any way.
* 
*  version: ADS.L.1.1.0-160
******************************************************************************/
#ifndef ADS_TEL_COMMON_H_
#define ADS_TEL_COMMON_H_

#include <stdio.h>
#include <stdlib.h>
#include <string.h>


/****************************************************************************/
/******************* Refapp Configuration ***********************************/
/****************************************************************************/

/*****************************************************************
 * Endpoint Reference Application Configuration
 * Note: The number of endpoints and PCM lines supported cannot
 *       be changed
 *****************************************************************/
/*define here due to the common function convertEpToRtp*/
#ifndef ADS_REF_APP_PBX
#define MAX_IP_LINES_SUPPORTED  2
#define MAX_PCM_LINES_SUPPORTED 1
#define ADS_TEL_EP_NUM_EPS     (MAX_IP_LINES_SUPPORTED+MAX_PCM_LINES_SUPPORTED)
typedef enum{
    ADS_LINE_STATE_DIAL = 0,
    ADS_LINE_STATE_CONNECTED,
    ADS_LINE_STATE_ON_HOLD,
    ADS_LINE_STATE_3WAY,
    ADS_LINE_STATE_ON_HOOK,
} AdsEpLineState_t;

typedef struct
{
    AdsTelEpHandle_t    epHandle;
    AdsEpLineState_t    state;
    AdsTelMediaHandle_t onHoldHandle;
    unsigned int        codec;    /*encoder codec value*/
    unsigned int        de_codec; /*decoder codec value*/
    unsigned int        mfppVal;  /*multiple frames per packet value*/
} AdsTelDesc_t;

/*****************************************************************
 * IP PBX Reference Application Configuration
 * Note: The number of PCM lines supported cannot be changed
 *****************************************************************/
#else
/* maximum numer of IP endpoints that can be supported*/
#define MAX_IP_LINES_SUPPORTED  20

/* maximum numer of PCM endpoints that can be supported*/
#define MAX_EP_SUPPORTED        MAX_IP_LINES_SUPPORTED
typedef struct
{
    unsigned int     callId;
    AdsTelEpHandle_t epHandle;
    unsigned int     codec;    /*encoder codec value*/
    unsigned int     de_codec; /*decoder codec value*/
    unsigned int     mfppVal;  /*multiple frames per packet value*/
} AdsTelDesc_t;
#endif


/****************************************************************************/
/******************* DEFINES ************************************************/
/****************************************************************************/

#define YES                     1
#define NO                      0

/*the number of samples in a WB frame*/
#define NUM_SAMPLES_WB          160

/*the number of samples in a NB frame*/
#define NUM_SAMPLES_NB          80

/*number of connections on a two way call*/
#define TWO_PARTY_CALL          2

/*number of connections on a three way call*/
#define THREE_PARTY_CALL        3

/*Switching call options*/
#define SWITCH_NO_TERMINATE     NO
#define SWITCH_TERMINATE        YES

/*maximum number of connections on a PBX call*/
#define ADS_MAX_EP_CONS         THREE_PARTY_CALL

/**********************************
 *PCM outbound pipeline components*
 **********************************/
#define PCM_OUT_TG              0
#define PCM_OUT_PLY             1
#define PCM_OUT_SRC             2

/**********************************
 *PCM inbound pipeline components *
 **********************************/
#define PCM_IN_SRC              0
#define PCM_IN_HPF              1
#define PCM_IN_EC               2
#define PCM_IN_AGC              3
#define PCM_IN_TG               4
#define PCM_IN_SCL              5

/**********************************
 *IP outbound pipeline components *
 **********************************/
#define IP_OUT_TD               0
#define IP_OUT_SCL              1
#define IP_OUT_PLY              2
#define IP_OUT_ENC              3

/**********************************
 *IP inbound pipeline components*
 **********************************/
#define IP_IN_DEC               0
#define IP_IN_TG                1
#define IP_IN_ALC               2
#define IP_IN_SCL               3


/*The maximum number of components per pipeline that ADS supports*/
#define ADS_MAX_COMPS_PER_PIPE  10

/*Ascii table 0 value*/
#define ASCII_0                 48

/*Ascii table 9 value*/
#define ASCII_9                 57


/*Number of parameters being set*/
#define NUM_PARAMS_1            1
#define NUM_PARAMS_2            2


/*MFPP Limits*/
#define ADS_TEL_MIN_MFPP        1
#define ADS_TEL_MAX_MFPP        10


/*Player segment*/
#define MEDIA_SEG               4

/*Arg number used to pass audio files*/
#define ADS_TEL_MAX_ARG         3
#define ADS_TEL_ARG_1           1
#define ADS_TEL_ARG_2           2

#define ADS_TEL_CODELET_STRLEN  80


/****************************************************************************/
/******************* Function Declarations **********************************/
/****************************************************************************/

/*menu printing function*/
int adsRefAppDemoMenu(void);

/*utility functions*/
int adsRefAppGetNum(char *str, unsigned int * pUNumericValue,
                    int * pSNumericValue);
int adsRefAppGetStr(char *str, char *pInStr);

/*
 * Convert an endpoint ID to an RTP Port number
 * this function is called by ads_ip_cb_xxbound () */
unsigned int convertEpToRtp(AdsTelEpHandle_t epHandle,
                            unsigned int*    pSamplesPerPacket,
                            unsigned int* decoder);

/* Convert an endpoint ID to an RTP Port number
 * this function is called by FW callback handling
 * function */
AdsTelStatus_t epHandleToEpIdConvert(unsigned int  epHandle,
                                     unsigned int* pEndpointId);


/*callback function that is called by the framework*/
void frameworkCb(unsigned int transId, void* pData);


/*start the framework timing thread*/
AdsTelStatus_t
adsTriggerTaskStart(void *triggerFunc, unsigned int rttPriority);


/*stop the framework timing thread*/
void adsTriggerTaskStop(void);

/* 10msec trigger function using rt-signals */
void unblockEvery10ms(void);

#endif /*#ifndef ADS_TEL_COMMON_H_*/
