/******************************************************************************
* @file    adsTelEp.h
*
* Contents: This file contains Endpoint Application configuration
            parameters.
*
* @par
* INTEL CONFIDENTIAL
* Copyright 2009 Intel Corporation All Rights Reserved.
* 
* The source code contained or described herein and all documents related to the
* source code ("Material") are owned by Intel Corporation or its suppliers or
* licensors. Title to the Material remains with Intel Corporation or its
* suppliers and licensors. The Material may contain trade secrets and proprietary
* and confidential information of Intel Corporation and its suppliers and
* licensors, and is protected by worldwide copyright and trade secret laws and
* treaty provisions. No part of the Material may be used, copied, reproduced,
* modified, published, uploaded, posted, transmitted, distributed, or disclosed
* in any way without Intels prior express written permission.
* No license under any patent, copyright, trade secret or other intellectual
* property right is granted to or conferred upon you by disclosure or delivery
* of the Materials, either expressly, by implication, inducement, estoppel or
* otherwise. Any license under such intellectual property rights must be
* express and approved by Intel in writing.
* 
* Include any supplier copyright notices as supplier requires Intel to use.
* Include supplier trademarks or logos as supplier requires Intel to use,
* preceded by an asterisk.
* An asterisked footnote can be added as follows: 
*   *Third Party trademarks are the property of their respective owners.
* 
* Unless otherwise agreed by Intel in writing, you may not remove or alter this
* notice or any other notice embedded in Materials by Intel or Intels suppliers
* or licensors in any way.
* 
*  version: ADS.L.1.1.0-160
******************************************************************************/
#ifndef ADS_TEL_EP_H_
#define ADS_TEL_EP_H_

#include "adsTelEpALSA.h"
#include "adsTelTypes.h"



/****************************************************************************/
/******************* Refapp Configuration ***********************************/
/****************************************************************************/

/*PCM line number*/
#define PCM_MAIN_LINE                   0


/****************************************************************************/
/******************* Framework Configuration ********************************/
/****************************************************************************/

/*the geo code for the framework*/
#define ADS_TEL_EP_GEO                  ADS_TEL_GEO_PROC

/*The number of real time threads within the framework*/
#define ADS_TEL_EP_NUM_RTTS             1

/*Framework threading priorities*/
#define ADS_TEL_EP_CTRL_PRIOR           10
#define ADS_TEL_EP_RTT_PRIOR            90


/****************************************************************************/
/******************* ALSA SETTINGS ******************************************/
/****************************************************************************/

/* The amount of PCM data that will be buffered in ALSA in ms
 * e.g. a setting of 25 leads to a one way end to end delay of 50ms*/
#define PCM_BUFFER_LEN                  25


#define PCM_STREAM_RATE_8K              8000 /* pcm stream rate in hz */
#define PCM_STREAM_RATE_16K             16000 /* pcm stream rate in hz */


/*ALSA Format for each channel*/
#define ALSA_PCM_FORMAT                 SND_PCM_FORMAT_S16_BE



/*The PCM rate that is used for each channel*/
#define ALSA_PCM_STREAM_RATE            PCM_STREAM_RATE_16K

/*PCM Data type for endpoint creation*/
#define ALSA_PCM_DATA_TYPE              ADS_TEL_PCM_S_BE_16B_WB_LINEAR

/****************************************************************************/
/******************* FUNCTION DECLARATIONS **********************************/
/****************************************************************************/

/* Configure a PCM Inbound and IP Outbound pipelines for a call based on the
 * codec (encoder) and MFPP settings*/
void configureCallPCMtoIP(unsigned int lineNum,
                             unsigned int pcmNum,
                             unsigned int mfppVal);

/* Configure a PCM Outbound and IP Inbound pipelines for a call based on the
 * codec (decoder) */
void configureCallIPtoPCM(unsigned int lineNum,
                             unsigned int pcmNum);


/*initialise the tracking arrays*/
void initEpTrackingArrays(void);


#endif /*ADS_TEL_EP_H_*/

