/******************************************************************************
* @file    adsTelEpALSA.h
*
* Contents: This file contains the ALSA function declarations.
*
* @par
* INTEL CONFIDENTIAL
* Copyright 2009 Intel Corporation All Rights Reserved.
* 
* The source code contained or described herein and all documents related to the
* source code ("Material") are owned by Intel Corporation or its suppliers or
* licensors. Title to the Material remains with Intel Corporation or its
* suppliers and licensors. The Material may contain trade secrets and proprietary
* and confidential information of Intel Corporation and its suppliers and
* licensors, and is protected by worldwide copyright and trade secret laws and
* treaty provisions. No part of the Material may be used, copied, reproduced,
* modified, published, uploaded, posted, transmitted, distributed, or disclosed
* in any way without Intels prior express written permission.
* No license under any patent, copyright, trade secret or other intellectual
* property right is granted to or conferred upon you by disclosure or delivery
* of the Materials, either expressly, by implication, inducement, estoppel or
* otherwise. Any license under such intellectual property rights must be
* express and approved by Intel in writing.
* 
* Include any supplier copyright notices as supplier requires Intel to use.
* Include supplier trademarks or logos as supplier requires Intel to use,
* preceded by an asterisk.
* An asterisked footnote can be added as follows: 
*   *Third Party trademarks are the property of their respective owners.
* 
* Unless otherwise agreed by Intel in writing, you may not remove or alter this
* notice or any other notice embedded in Materials by Intel or Intels suppliers
* or licensors in any way.
* 
*  version: ADS.L.1.1.0-160
******************************************************************************/
#ifndef ADS_TEL_EP_ALSA_H_
#define ADS_TEL_EP_ALSA_H_

#include <alsa/asoundlib.h>
#include "adsTel.h"

/****************************************************************************/
/******************* DEFINES ************************************************/
/****************************************************************************/

/* used for snd_pcm_open to specify open in blocking mode */
#define BLOCKING                0

/* used by set_rate_near specifying that we are trying to
 * exactly specify the rate */
#define TRY_EXACT               0

/*number of hw channels setup for each stream*/
#define ALSA_NUM_HW_CHANS       1

/*use ALSA R/W mode*/
#define ALSA_ACCESS_MODE SND_PCM_ACCESS_RW_INTERLEAVED

/*PCM Rate setting*/
#define PCM_RATE_1K             1000

/*ALSA packet interval in ms*/
#define ALSA_PKT_INTERVAL       10

/*Memory partitioning offsets*/
#define SECOND                  1
#define THIRD                   2
#define FOURTH                  3

/* maximum number of bytes for pcm payload in ads */
#define MAX_PCM_PAYLOAD_BYTES   320

/* number of ping or pong buffers used in endpoint struct */
#define NUMBER_PINGPONG_BUFFERS 4

#define CONFIGURED              1
#define UNCONFIGURED            0

/*number of active ALSA channels*/
#define ONE_ACTIVE_CHAN         1


/****************************************************************************/
/******************* TYPE DEFINITIONS ***************************************/
/****************************************************************************/
/* ping-pong buffer */
typedef struct
{
    char Data[MAX_PCM_PAYLOAD_BYTES];
    long int expectedFrames;
    long int actualFrames;
    unsigned long data1;
    unsigned long data2;
} AdsTelPipoBuff_t;

/* channel ping-pong buffer structure */
typedef struct
{
    AdsTelPipoBuff_t *pReadPing;              /* alsa read ping buffer */
    AdsTelPipoBuff_t *pReadPong;              /* alsa read pong buffer */
    AdsTelPipoBuff_t *pWritePing;             /* alsa write ping buffer */
    AdsTelPipoBuff_t *pWritePong;             /* alsa write pong buffer */
    unsigned int freq;            /* frequency of alsa device */
    unsigned int interval;        /* alsa interval in msecs */
    unsigned int bConfigured;     /* pcm endpoint is configured */
} AdsTelPcmChan_t;



/****************************************************************************/
/******************* FUNCTION DECLARATIONS **********************************/
/****************************************************************************/

/*initialize codelet ALSA structures*/
int adsTelAlsaInit(void);

/*
 * Open an ALSA hardware device interface
 */
int adsTelAlsaOpenChan(unsigned int chan, char *pDevice,
                        snd_pcm_format_t format, unsigned int rate);


/*
 * Close an ALSA hardware device interface
 */
int adsTelALSACloseChan(unsigned int chan);

/*
 * ALSA trigger function
 */
void alsaTrigger(void);

/*
 * Stop ALSA trigger
 */

void adsTelALSAStopTrigger(void);

/*
 * Start ALSA trigger
 */
void adsTelALSAStartTrigger(void);


/*
 * Framework PCM inbound callback handler
 */
AdsTelStatus_t ads_inbound_cb(AdsTelEpHandle_t epHandle, void *pBuffer1);

/*
 * Framework PCM outbound callback handler
 */
AdsTelStatus_t ads_outbound_cb(AdsTelEpHandle_t epHandle, void *pBuffer1);


#endif /*ADS_TEL_EP_ALSA_H_*/
