/******************************************************************************
* @file    adsTelRTP.h
*
* Contents: This file contains RTP function declarations.
*
* @par
* INTEL CONFIDENTIAL
* Copyright 2009 Intel Corporation All Rights Reserved.
* 
* The source code contained or described herein and all documents related to the
* source code ("Material") are owned by Intel Corporation or its suppliers or
* licensors. Title to the Material remains with Intel Corporation or its
* suppliers and licensors. The Material may contain trade secrets and proprietary
* and confidential information of Intel Corporation and its suppliers and
* licensors, and is protected by worldwide copyright and trade secret laws and
* treaty provisions. No part of the Material may be used, copied, reproduced,
* modified, published, uploaded, posted, transmitted, distributed, or disclosed
* in any way without Intels prior express written permission.
* No license under any patent, copyright, trade secret or other intellectual
* property right is granted to or conferred upon you by disclosure or delivery
* of the Materials, either expressly, by implication, inducement, estoppel or
* otherwise. Any license under such intellectual property rights must be
* express and approved by Intel in writing.
* 
* Include any supplier copyright notices as supplier requires Intel to use.
* Include supplier trademarks or logos as supplier requires Intel to use,
* preceded by an asterisk.
* An asterisked footnote can be added as follows: 
*   *Third Party trademarks are the property of their respective owners.
* 
* Unless otherwise agreed by Intel in writing, you may not remove or alter this
* notice or any other notice embedded in Materials by Intel or Intels suppliers
* or licensors in any way.
* 
*  version: ADS.L.1.1.0-160
******************************************************************************/
#ifndef ADS_TEL_RTP_H_
#define ADS_TEL_RTP_H_


/****************************************************************************/
/******************* INCLUDES ***********************************************/
/****************************************************************************/

#include "adsTel.h"


/****************************************************************************/
/******************* DEFINES ************************************************/
/****************************************************************************/

/*maximum number of RTP connections that can be supported*/
#define MAX_RTP_CONNECTIONS     1000

/*rtp port are offset by 2 as RTP port number + 1 is used for RTCP*/
#define RTP_PORT_MULTIPLIER     2


/****************************************************************************/
/******************* FUNCTION DECLARATIONS **********************************/
/****************************************************************************/

/*Initialize management structures and ORTP*/
void adsTelRtpInit(void);

/*Uninitialize ORTP*/
void adsTelRtpUninit(void);

/*Create a RTP session*/
int adsTelRtpSessionCreate(int localChan, char *remoteIp, int remoteChan);

/*Destroy a RTP session*/
int adsTelRtpSessionDestroy(int channel);

/*ADS IP side Inbound Callback*/
AdsTelStatus_t ads_ip_inbound_cb(AdsTelEpHandle_t epHandle,
                                 void             *pBuffer1,
                                 void             *pBuffer2);

/*ADS IP side Outbound Callback*/
AdsTelStatus_t ads_ip_outbound_cb(AdsTelEpHandle_t epHandle,
                                  void             *pBuffer1,
                                  void             *pBuffer2);

/*
 * N.B. Function is declared here but must be defined by the calling
 * application. See ads_ip_cb_inbound() and ads_ip_cb_outbound() in adsTelRTP.c
 * for usage details and adsTelFwCb.c for the function definition.
 */
unsigned int convertEpToRtp(AdsTelEpHandle_t epHandle,
                            unsigned int*    pSamplesPerPacket,
                            unsigned int*    decoder);


#endif /*ADS_TEL_RTP_H_*/
