/******************************************************************************
* @file    adsTelPbxMain.c
*
* Contents: This file contains initialization and shutdown code for the
            IP PBX codelet.
*
* @par
* INTEL CONFIDENTIAL
* Copyright 2009 Intel Corporation All Rights Reserved.
* 
* The source code contained or described herein and all documents related to the
* source code ("Material") are owned by Intel Corporation or its suppliers or
* licensors. Title to the Material remains with Intel Corporation or its
* suppliers and licensors. The Material may contain trade secrets and proprietary
* and confidential information of Intel Corporation and its suppliers and
* licensors, and is protected by worldwide copyright and trade secret laws and
* treaty provisions. No part of the Material may be used, copied, reproduced,
* modified, published, uploaded, posted, transmitted, distributed, or disclosed
* in any way without Intels prior express written permission.
* No license under any patent, copyright, trade secret or other intellectual
* property right is granted to or conferred upon you by disclosure or delivery
* of the Materials, either expressly, by implication, inducement, estoppel or
* otherwise. Any license under such intellectual property rights must be
* express and approved by Intel in writing.
* 
* Include any supplier copyright notices as supplier requires Intel to use.
* Include supplier trademarks or logos as supplier requires Intel to use,
* preceded by an asterisk.
* An asterisked footnote can be added as follows: 
*   *Third Party trademarks are the property of their respective owners.
* 
* Unless otherwise agreed by Intel in writing, you may not remove or alter this
* notice or any other notice embedded in Materials by Intel or Intels suppliers
* or licensors in any way.
* 
*  version: ADS.L.1.1.0-160
******************************************************************************/

#include "adsTelRTP.h"
#include "adsTelPbx.h"
#include "adsTelCommon.h"

#include <pthread.h>
#include <signal.h>

int main(void)
{
    int status = 0;
    AdsTelInit_t adsInitParams;

    /*Init tracking arrays*/
    initPbxTrackingArrays();

    /*start the framework timing thread*/
    status = adsTriggerTaskStart(unblockEvery10ms, ADS_TEL_PBX_RTT_PRIOR);
    if (status != ADS_TEL_STATUS_SUCCESS)
    {
        printf("\nERROR:%s: adsTriggerTaskStart failed with status code %i\n",
        __FUNCTION__, status);
        return ADS_TEL_STATUS_FAIL;
    }

    /*initialize RTP */
    adsTelRtpInit();

    /*set the number of endpoints to be supported*/
    adsInitParams.numEp = MAX_EP_SUPPORTED;

    /*set the geo code*/
    adsInitParams.geo = ADS_TEL_PBX_GEO;

    /* Set number of RTTs */
    adsInitParams.numRTTs = ADS_TEL_PBX_NUM_RTTS;

    /*set the thread priorities*/
    adsInitParams.ctrlPrior = ADS_TEL_PBX_CTRL_PRIOR;
    adsInitParams.rttPrior = ADS_TEL_PBX_RTT_PRIOR;

    /*set the framework callback function*/
    adsInitParams.fwCb = frameworkCb;

    /*configure the ADS framework*/
    status = (int) adsTelInit(adsInitParams);
    if (status != ADS_TEL_STATUS_SUCCESS)
    {
        printf("\nERROR:%s: adsTelInit failed with status code %u\n",
                __FUNCTION__, status);

        /*uninitialize RTP*/
        adsTelRtpUninit();

        /*stop the timing thread*/
        adsTriggerTaskStop();

        return ADS_TEL_STATUS_FAIL;
    }

    /*print the menu*/
    if (adsRefAppDemoMenu() != 0)
    {
        printf("\nERROR:%s: Application setup failed.\n", __FUNCTION__);
    }

    /*uninitialize RTP*/
    adsTelRtpUninit();

    /*unconfigure the ADS framework*/
    adsTelUnInit();

    /*stop the timing thread*/
    adsTriggerTaskStop();

    return ADS_TEL_STATUS_SUCCESS;
}


