/******************************************************************************
* @file    adsTelEpMain.c
*
* Contents: This file contains initialization and shutdown code for the
            endpoint codelet.
*
* @par
* INTEL CONFIDENTIAL
* Copyright 2009 Intel Corporation All Rights Reserved.
* 
* The source code contained or described herein and all documents related to the
* source code ("Material") are owned by Intel Corporation or its suppliers or
* licensors. Title to the Material remains with Intel Corporation or its
* suppliers and licensors. The Material may contain trade secrets and proprietary
* and confidential information of Intel Corporation and its suppliers and
* licensors, and is protected by worldwide copyright and trade secret laws and
* treaty provisions. No part of the Material may be used, copied, reproduced,
* modified, published, uploaded, posted, transmitted, distributed, or disclosed
* in any way without Intels prior express written permission.
* No license under any patent, copyright, trade secret or other intellectual
* property right is granted to or conferred upon you by disclosure or delivery
* of the Materials, either expressly, by implication, inducement, estoppel or
* otherwise. Any license under such intellectual property rights must be
* express and approved by Intel in writing.
* 
* Include any supplier copyright notices as supplier requires Intel to use.
* Include supplier trademarks or logos as supplier requires Intel to use,
* preceded by an asterisk.
* An asterisked footnote can be added as follows: 
*   *Third Party trademarks are the property of their respective owners.
* 
* Unless otherwise agreed by Intel in writing, you may not remove or alter this
* notice or any other notice embedded in Materials by Intel or Intels suppliers
* or licensors in any way.
* 
*  version: ADS.L.1.1.0-160
******************************************************************************/

#include "ortp/ortp.h"
#include "adsTelEpALSA.h"
#include "adsTelEp.h"
#include "adsTelRTP.h"
#include "adsTelCommon.h"
#include "adsTelAddTone.h"


/****************************************************************************/
/******************* GLOBAL VARIABLES ***************************************/
/****************************************************************************/

/*hold music handles*/
extern AdsTelMediaHandle_t nbHoldHandle;
extern AdsTelMediaHandle_t wbHoldHandle;


/****************************************************************************/
/******************* FUNCTION DECLARATIONS **********************************/
/****************************************************************************/

/*shutdown the application*/
void adsTelAppShutdown(unsigned int level);


/****************************************************************************/
/******************* FUNCTION DEFINITIONS ***********************************/
/****************************************************************************/
int main(int argc, char *argv[])
{
    AdsTelStatus_t status = ADS_TEL_STATUS_SUCCESS;
    AdsTelInit_t adsInitParams;

    /*verify that two input files are provided*/
    if (argc < ADS_TEL_MAX_ARG)
    {
        printf("\nERROR:%s: invalid command parameters\n", __FUNCTION__);
        printf("command format \"adsAppExec onhold_nb.wav onhold_wb.wav"
               " <logging options>\"\n");
        return ADS_TEL_STATUS_FAIL;
    }



    /*initialise the tracking arrays*/
    initEpTrackingArrays();

    /*configure the ALSA settings*/
    status = adsTelAlsaInit();
    if (status != ADS_TEL_STATUS_SUCCESS)
    {
        printf("\nERROR:%s: Failed to initialise ALSA with error %i\n",
                __FUNCTION__,
               status);
        return ADS_TEL_STATUS_FAIL;
    }

    /*Add user tones for the Tone Detector*/
    adsTelAddToneTD();

    /*initialize RTP */
    adsTelRtpInit();

    /*set the number of endpoints to be supported*/
    adsInitParams.numEp = ADS_TEL_EP_NUM_EPS;
    /*set the geo code*/
    adsInitParams.geo = ADS_TEL_EP_GEO;
    /* Set number of RTTs - for endpoint app - set to 1 */
    adsInitParams.numRTTs = ADS_TEL_EP_NUM_RTTS;
    /*set the thread priorities*/
    adsInitParams.ctrlPrior = ADS_TEL_EP_CTRL_PRIOR;
    adsInitParams.rttPrior = ADS_TEL_EP_RTT_PRIOR;
    /*set the framework callback function*/
    adsInitParams.fwCb = frameworkCb;

    /*configure the ADS framework*/
    status = (int) adsTelInit(adsInitParams);
    if (status != ADS_TEL_STATUS_SUCCESS)
    {
        printf("\nERROR:%s: adsTelInit failed with status code %i\n",
                __FUNCTION__, status);

        /*shutdown the application*/
        adsTelAppShutdown(0);

        return ADS_TEL_STATUS_FAIL;
    }

    /*Add user tones for the Tone Generator*/
    adsTelAddToneTG();


    /*register the NB on hold music with the framework*/
    status = adsTelRegisterWavFile(argv[ADS_TEL_ARG_1], &nbHoldHandle);
    if (status != ADS_TEL_STATUS_SUCCESS)
    {
        printf("\nERROR:%s: Call to adsTelRegisterWavFile failed with error"
                   " code %i for file: %s\n", __FUNCTION__, status,
                    argv[ADS_TEL_ARG_1]);

       /*shutdown the application*/
        adsTelAppShutdown(1);

        return ADS_TEL_STATUS_FAIL;
    }

    /*register the WB on hold music with the framework*/
    status = adsTelRegisterWavFile(argv[ADS_TEL_ARG_2], &wbHoldHandle);
    if (status != ADS_TEL_STATUS_SUCCESS)
    {
        printf("\nERROR:%s: Call to adsTelRegisterWavFile failed with error"
                   " code %i for file: %s\n", __FUNCTION__, status,
                    argv[ADS_TEL_ARG_2]);

        /*shutdown the application*/
        adsTelAppShutdown(1);

        return ADS_TEL_STATUS_FAIL;
    }

    /*start the framework timing thread*/
    status = adsTriggerTaskStart(alsaTrigger, ADS_TEL_EP_RTT_PRIOR);
    if (status != ADS_TEL_STATUS_SUCCESS)
    {
        printf("\nERROR:%s: adsTriggerTaskStart failed with status code %i\n",
                __FUNCTION__,
               status);
        return ADS_TEL_STATUS_FAIL;
    }


    /*print the menu*/
    status = adsRefAppDemoMenu();
    if (status != ADS_TEL_STATUS_SUCCESS)
    {
        printf("\nERROR:%s: Application setup failed.\n", __FUNCTION__);
    }

    /*shutdown the application*/
    adsTelAppShutdown(1);

    return status;
}


/*shutdown the application*/
void adsTelAppShutdown(unsigned int level)
{
    if (level == 1)
    {
        /*unconfigure the ADS framework*/
        adsTelUnInit();
    }

    /*uninitialize RTP*/
    adsTelRtpUninit();

    /*stop the timing thread*/
    adsTriggerTaskStop();

    return;
}
