/*
 * Decompiled with CFR 0.152.
 */
package selviewerui;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Label;
import java.awt.Panel;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.InputStreamReader;
import java.io.Serializable;
import java.io.Writer;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.GroupLayout;
import javax.swing.JCheckBox;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JDialog;
import javax.swing.JEditorPane;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.JTextPane;
import javax.swing.KeyStroke;
import javax.swing.LayoutStyle;
import javax.swing.Timer;
import javax.swing.event.CaretEvent;
import javax.swing.event.CaretListener;
import javax.swing.filechooser.FileFilter;
import javax.swing.table.DefaultTableModel;
import org.jdesktop.application.Action;
import org.jdesktop.application.Application;
import org.jdesktop.application.ApplicationActionMap;
import org.jdesktop.application.FrameView;
import org.jdesktop.application.ResourceMap;
import org.jdesktop.application.SingleFrameApplication;
import org.jdesktop.beansbinding.AutoBinding;
import org.jdesktop.beansbinding.BeanProperty;
import org.jdesktop.beansbinding.Binding;
import org.jdesktop.beansbinding.BindingGroup;
import org.jdesktop.beansbinding.Bindings;
import org.jdesktop.beansbinding.ELProperty;
import org.jdesktop.beansbinding.Property;
import selviewerui.SELCLIWrapper;
import selviewerui.SELCellRenderer;
import selviewerui.SELEntryProps;
import selviewerui.SELFileFilter;
import selviewerui.SELTableModel;
import selviewerui.SELTableRowSorter;
import selviewerui.SELViewer;
import selviewerui.SELViewerAbout;
import selviewerui.SELViewerHelp;
import selviewerui.SortTable;

public class SELViewerUI
extends FrameView {
    private String th1 = null;
    private String th2 = null;
    private String th3 = null;
    private String th4 = null;
    private String th5 = null;
    private String hexHeader1 = null;
    private String hexHeader2 = null;
    public ButtonGroup sortByGrp = null;
    private Panel InfoPanel;
    private JLabel OtherEventVals;
    private JMenuItem SELCLearMenuItem;
    private JMenuItem SELGoToMenuItem;
    private JMenu SELMenu;
    private JMenuItem SELPropsMenuItem;
    private JMenuItem SELReloadMenuItem;
    private JMenu SELSortByMenuItem;
    private JMenuItem SELSortEventTypeMenuItem;
    private JMenuItem SELSortGenIdMenuItem;
    private JMenuItem SELSortSensorTypeMenuItem;
    private JMenuItem SELSortSerialMenuItem;
    private JMenuItem SELSortTSMenuItem;
    private JCheckBoxMenuItem ViewInfoPane;
    private JCheckBox colorCodingCheckBox;
    private JLabel criticalEventVals;
    private JMenuItem dispInHex;
    private JMenuItem dispInText;
    private JMenuItem fileOpenMenuItem;
    private JMenuItem fileSaveAsMenuItem;
    private JLabel infoEventVal;
    private JLabel infoEvents;
    private JEditorPane jEditorPane1;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private JLabel jLabel4;
    private JLabel jLabel5;
    private JLabel jLabel7;
    private JLabel jLabel8;
    private JLabel jLabel9;
    private JMenuItem jMenuItem9;
    private JPanel jPanel1;
    private JScrollPane jScrollPane1;
    private JScrollPane jScrollPane3;
    private JSeparator jSeparator1;
    private JTable jTable1;
    private JTextField jTextField2;
    private JTextField jTextField3;
    private JTextField jTextField4;
    private JTextField jTextField6;
    private JTextPane jTextPane1;
    private Label label1;
    private JPanel mainPanel;
    private JMenuBar menuBar;
    private JProgressBar progressBar;
    private JLabel statusAnimationLabel;
    private JLabel statusMessageLabel;
    private JPanel statusPanel;
    private JPanel summaryPanel;
    private JMenu viewMenu;
    private JLabel warnEventVals;
    private BindingGroup bindingGroup;
    private final Timer messageTimer;
    private JDialog aboutBox;
    private static int numProps = 5;
    private Map selPropsMap = new HashMap();
    private final int statusWarnMsg = 1;
    private final int statusInfoMsg = 0;
    private final int CLEARSEL = -1;
    private final int TEXT = 0;
    private final int HEX = 1;
    private boolean isSELBinRunning = false;
    private int displayType;
    private String SELBinPath = "";
    private String SELOpenSavePath = "";
    private String SELBinPath_win = "";
    private String SELSavePath = "";
    public static String infoMsgCol;
    public static String warnMsgCol;
    public static String criticalMsgCol;
    public static String otherMsgCol;
    private String SELTextHdr = "";
    public static boolean showColorCoding;
    private int[] tableColWidth = new int[]{120, 150, 180, -1, 180};

    public SELViewerUI(SingleFrameApplication singleFrameApplication) {
        super((Application)singleFrameApplication);
        this.sortByGrp = new ButtonGroup();
        this.initComponents();
        ResourceMap resourceMap = this.getResourceMap();
        int n = resourceMap.getInteger("StatusBar.messageTimeout");
        this.messageTimer = new Timer(n, new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                SELViewerUI.this.statusMessageLabel.setText("");
            }
        });
        this.messageTimer.setRepeats(false);
        int n2 = resourceMap.getInteger("StatusBar.busyAnimationRate");
        this.progressBar.setVisible(false);
        this.th1 = resourceMap.getString("selviewer.selTextTableHeader1", new Object[0]);
        this.th2 = resourceMap.getString("selviewer.selTextTableHeader2", new Object[0]);
        this.th3 = resourceMap.getString("selviewer.selTextTableHeader3", new Object[0]);
        this.th4 = resourceMap.getString("selviewer.selTextTableHeader4", new Object[0]);
        this.th5 = resourceMap.getString("selviewer.selTextTableHeader5", new Object[0]);
        this.hexHeader1 = resourceMap.getString("selviewer.selHexTableHeader1", new Object[0]);
        this.hexHeader2 = resourceMap.getString("selviewer.selHexTableHeader2", new Object[0]);
        this.SELBinPath = resourceMap.getString("selviewer.SELBinPath", new Object[0]);
        this.SELBinPath_win = resourceMap.getString("selviewer.SELBinPath1", new Object[0]);
        this.SELSavePath = resourceMap.getString("selviewer.SELSavePath", new Object[0]);
        this.SELOpenSavePath = resourceMap.getString("selviewer.SELOpenSaveExePath", new Object[0]);
        this.displayType = 0;
        infoMsgCol = resourceMap.getString("selviewer.infoMsgColor", new Object[0]);
        warnMsgCol = resourceMap.getString("selviewer.warnMsgColor", new Object[0]);
        criticalMsgCol = resourceMap.getString("selviewer.criticalMsgColor", new Object[0]);
        otherMsgCol = resourceMap.getString("selviewer.otherMsgColor", new Object[0]);
        this.jTable1.setModel(new SELTableModel());
        this.jTable1.setDefaultRenderer(Integer.class, new SELCellRenderer());
        SELTableModel sELTableModel = (SELTableModel)this.jTable1.getModel();
        this.jTable1.setRowSorter(new SELTableRowSorter(sELTableModel));
        this.runSELCommand(0);
    }

    private void setColsWidth() {
        if (((SELTableModel)this.jTable1.getModel()).getColumnCount() == 2) {
            this.jTable1.getColumnModel().getColumn(0).setWidth(this.tableColWidth[0]);
            this.jTable1.getColumnModel().getColumn(0).setMaxWidth(this.tableColWidth[0]);
            this.jScrollPane1.setHorizontalScrollBarPolicy(30);
            return;
        }
        ((SELTableModel)this.jTable1.getModel()).fireTableStructureChanged();
    }

    @Action
    public void showAboutBox() {
        if (this.aboutBox == null) {
            JFrame jFrame = SELViewer.getApplication().getMainFrame();
            this.aboutBox = new SELViewerAbout(jFrame);
            this.aboutBox.setLocationRelativeTo(jFrame);
        }
        SELViewer.getApplication().show(this.aboutBox);
    }

    private void initComponents() {
        this.bindingGroup = new BindingGroup();
        this.mainPanel = new JPanel();
        this.jScrollPane1 = new JScrollPane();
        this.jTable1 = new JTable();
        this.InfoPanel = new Panel();
        this.summaryPanel = new JPanel();
        this.infoEvents = new JLabel();
        this.jLabel7 = new JLabel();
        this.jLabel8 = new JLabel();
        this.jLabel9 = new JLabel();
        this.infoEventVal = new JLabel();
        this.warnEventVals = new JLabel();
        this.criticalEventVals = new JLabel();
        this.OtherEventVals = new JLabel();
        this.colorCodingCheckBox = new JCheckBox();
        this.jScrollPane3 = new JScrollPane();
        this.jTextPane1 = new JTextPane();
        this.jPanel1 = new JPanel();
        this.jLabel1 = new JLabel();
        this.jLabel3 = new JLabel();
        this.jTextField3 = new JTextField();
        this.jLabel2 = new JLabel();
        this.jTextField2 = new JTextField();
        this.jLabel4 = new JLabel();
        this.jLabel5 = new JLabel();
        this.jTextField4 = new JTextField();
        this.jTextField6 = new JTextField();
        this.label1 = new Label();
        this.jEditorPane1 = new JEditorPane();
        this.menuBar = new JMenuBar();
        JMenu jMenu = new JMenu();
        this.fileOpenMenuItem = new JMenuItem();
        this.fileSaveAsMenuItem = new JMenuItem();
        JMenuItem jMenuItem = new JMenuItem();
        this.SELMenu = new JMenu();
        this.SELReloadMenuItem = new JMenuItem();
        this.SELPropsMenuItem = new JMenuItem();
        this.SELCLearMenuItem = new JMenuItem();
        this.SELGoToMenuItem = new JMenuItem();
        this.SELSortByMenuItem = new JMenu();
        this.SELSortSerialMenuItem = new JMenuItem();
        this.SELSortTSMenuItem = new JMenuItem();
        this.SELSortSensorTypeMenuItem = new JMenuItem();
        this.SELSortEventTypeMenuItem = new JMenuItem();
        this.SELSortGenIdMenuItem = new JMenuItem();
        this.viewMenu = new JMenu();
        this.ViewInfoPane = new JCheckBoxMenuItem();
        this.jSeparator1 = new JSeparator();
        this.dispInHex = new JMenuItem();
        this.dispInText = new JMenuItem();
        JMenu jMenu2 = new JMenu();
        this.jMenuItem9 = new JMenuItem();
        JMenuItem jMenuItem2 = new JMenuItem();
        this.statusPanel = new JPanel();
        JSeparator jSeparator = new JSeparator();
        this.statusMessageLabel = new JLabel();
        this.statusAnimationLabel = new JLabel();
        this.progressBar = new JProgressBar();
        this.mainPanel.setName("mainPanel");
        this.jScrollPane1.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        this.jScrollPane1.setAutoscrolls(true);
        this.jScrollPane1.setName("jScrollPane1");
        this.jTable1.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        this.jTable1.setModel(new DefaultTableModel((Object[][])null, new String[]{"SNo", "Time stamp", "Sensor Type & Number", "Event Description", "Generator ID"}));
        this.jTable1.setIntercellSpacing(new Dimension(5, 6));
        this.jTable1.setMaximumSize(this.mainPanel.getMaximumSize());
        this.jTable1.setName("jTable1");
        this.jTable1.setRowHeight(24);
        ResourceMap resourceMap = ((SELViewer)Application.getInstance(SELViewer.class)).getContext().getResourceMap(SELViewerUI.class);
        this.jTable1.setSelectionBackground(resourceMap.getColor("jTable1.selectionBackground"));
        this.jTable1.setSelectionForeground(resourceMap.getColor("jTable1.selectionForeground"));
        this.jTable1.setSelectionMode(0);
        this.jScrollPane1.setViewportView(this.jTable1);
        this.InfoPanel.setName("InfoPanel");
        this.summaryPanel.setBorder(BorderFactory.createTitledBorder(resourceMap.getString("summaryPanel.border.title", new Object[0])));
        this.summaryPanel.setName("summaryPanel");
        this.infoEvents.setFont(resourceMap.getFont("infoEvents.font"));
        this.infoEvents.setText(resourceMap.getString("infoEvents.text", new Object[0]));
        this.infoEvents.setName("infoEvents");
        this.jLabel7.setFont(resourceMap.getFont("jLabel7.font"));
        this.jLabel7.setText(resourceMap.getString("jLabel7.text", new Object[0]));
        this.jLabel7.setName("jLabel7");
        this.jLabel8.setFont(resourceMap.getFont("jLabel8.font"));
        this.jLabel8.setText(resourceMap.getString("jLabel8.text", new Object[0]));
        this.jLabel8.setName("jLabel8");
        this.jLabel9.setFont(resourceMap.getFont("jLabel9.font"));
        this.jLabel9.setText(resourceMap.getString("jLabel9.text", new Object[0]));
        this.jLabel9.setName("jLabel9");
        this.infoEventVal.setFont(resourceMap.getFont("infoEventVal.font"));
        this.infoEventVal.setText(resourceMap.getString("infoEventVal.text", new Object[0]));
        this.infoEventVal.setName("infoEventVal");
        this.infoEventVal.setOpaque(true);
        this.warnEventVals.setFont(resourceMap.getFont("warnEventVals.font"));
        this.warnEventVals.setText(resourceMap.getString("warnEventVals.text", new Object[0]));
        this.warnEventVals.setName("warnEventVals");
        this.warnEventVals.setOpaque(true);
        this.criticalEventVals.setFont(resourceMap.getFont("jLabel11.font"));
        this.criticalEventVals.setText(resourceMap.getString("criticalEventVals.text", new Object[0]));
        this.criticalEventVals.setName("criticalEventVals");
        this.criticalEventVals.setOpaque(true);
        this.OtherEventVals.setFont(resourceMap.getFont("jLabel11.font"));
        this.OtherEventVals.setText(resourceMap.getString("OtherEventVals.text", new Object[0]));
        this.OtherEventVals.setName("OtherEventVals");
        this.OtherEventVals.setOpaque(true);
        this.colorCodingCheckBox.setSelected(true);
        this.colorCodingCheckBox.setLabel(resourceMap.getString("colorCodingCheckBox.label", new Object[0]));
        this.colorCodingCheckBox.setName("colorCodingCheckBox");
        this.colorCodingCheckBox.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                SELViewerUI.this.colorCodingCheckBoxActionPerformed(actionEvent);
            }
        });
        this.jScrollPane3.setName("jScrollPane3");
        this.jTextPane1.setBorder(null);
        this.jTextPane1.setEditable(false);
        this.jTextPane1.setFont(resourceMap.getFont("jTextPane1.font"));
        this.jTextPane1.setText(resourceMap.getString("jTextPane1.text", new Object[0]));
        this.jTextPane1.setName("jTextPane1");
        this.jScrollPane3.setViewportView(this.jTextPane1);
        GroupLayout groupLayout = new GroupLayout(this.summaryPanel);
        this.summaryPanel.setLayout(groupLayout);
        groupLayout.setHorizontalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addContainerGap().addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, groupLayout.createSequentialGroup().addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.infoEventVal).addComponent(this.warnEventVals).addComponent(this.criticalEventVals).addComponent(this.OtherEventVals)).addGap(18, 18, 18).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabel9).addComponent(this.jLabel8).addComponent(this.jLabel7).addComponent(this.infoEvents, -2, 132, -2))).addGroup(groupLayout.createSequentialGroup().addComponent(this.colorCodingCheckBox).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jScrollPane3, -2, 124, -2))).addContainerGap(-1, Short.MAX_VALUE)));
        groupLayout.setVerticalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addContainerGap().addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addComponent(this.infoEventVal).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.warnEventVals).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.criticalEventVals).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.OtherEventVals)).addGroup(groupLayout.createSequentialGroup().addComponent(this.infoEvents).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jLabel7).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jLabel8).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jLabel9))).addGap(8, 8, 8).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.colorCodingCheckBox).addGroup(groupLayout.createSequentialGroup().addGap(2, 2, 2).addComponent(this.jScrollPane3, -2, -1, -2))).addContainerGap(104, Short.MAX_VALUE)));
        this.jPanel1.setBorder(BorderFactory.createTitledBorder(resourceMap.getString("jPanel1.border.title", new Object[0])));
        this.jPanel1.setName("jPanel1");
        this.jLabel1.setText(resourceMap.getString("jLabel1.text", new Object[0]));
        this.jLabel1.setName("jLabel1");
        this.jLabel3.setText(resourceMap.getString("jLabel3.text", new Object[0]));
        this.jLabel3.setName("jLabel3");
        this.jTextField3.setBackground(resourceMap.getColor("jTextField3.background"));
        this.jTextField3.setEditable(false);
        this.jTextField3.setName("jTextField3");
        AutoBinding autoBinding = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ_WRITE, (Object)this.jTable1, (Property)ELProperty.create((String)"${selectedElement.column1}"), (Object)this.jTextField3, (Property)BeanProperty.create((String)"text_ON_ACTION_OR_FOCUS_LOST"));
        autoBinding.setSourceNullValue(null);
        autoBinding.setSourceUnreadableValue(null);
        this.bindingGroup.addBinding((Binding)autoBinding);
        this.jLabel2.setText(resourceMap.getString("jLabel2.text", new Object[0]));
        this.jLabel2.setName("jLabel2");
        this.jTextField2.setBackground(resourceMap.getColor("jTextField2.background"));
        this.jTextField2.setEditable(false);
        this.jTextField2.setName("jTextField2");
        autoBinding = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ_WRITE, (Object)this.jTable1, (Property)ELProperty.create((String)"${selectedElement.column2}"), (Object)this.jTextField2, (Property)BeanProperty.create((String)"text_ON_ACTION_OR_FOCUS_LOST"));
        autoBinding.setSourceNullValue(null);
        autoBinding.setSourceUnreadableValue(null);
        this.bindingGroup.addBinding((Binding)autoBinding);
        this.jLabel4.setText(resourceMap.getString("jLabel4.text", new Object[0]));
        this.jLabel4.setName("jLabel4");
        this.jLabel5.setText(resourceMap.getString("jLabel5.text", new Object[0]));
        this.jLabel5.setName("jLabel5");
        this.jTextField4.setBackground(resourceMap.getColor("jTextField4.background"));
        this.jTextField4.setEditable(false);
        this.jTextField4.setName("jTextField4");
        autoBinding = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ_WRITE, (Object)this.jTable1, (Property)ELProperty.create((String)"${selectedElement.column3}"), (Object)this.jTextField4, (Property)BeanProperty.create((String)"text_ON_ACTION_OR_FOCUS_LOST"));
        autoBinding.setSourceNullValue(null);
        autoBinding.setSourceUnreadableValue(null);
        this.bindingGroup.addBinding((Binding)autoBinding);
        this.jTextField6.setBackground(resourceMap.getColor("jTextField6.background"));
        this.jTextField6.setEditable(false);
        this.jTextField6.setName("jTextField6");
        autoBinding = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ_WRITE, (Object)this.jTable1, (Property)ELProperty.create((String)"${selectedElement.column4}"), (Object)this.jTextField6, (Property)BeanProperty.create((String)"text_ON_ACTION_OR_FOCUS_LOST"));
        autoBinding.setSourceNullValue(null);
        autoBinding.setSourceUnreadableValue(null);
        this.bindingGroup.addBinding((Binding)autoBinding);
        this.jEditorPane1.setBackground(resourceMap.getColor("jEditorPane1.background"));
        this.jEditorPane1.setBorder(BorderFactory.createEmptyBorder(1, 1, 1, 1));
        this.jEditorPane1.setContentType(resourceMap.getString("jEditorPane1.contentType", new Object[0]));
        this.jEditorPane1.setEditable(false);
        this.jEditorPane1.setAutoscrolls(false);
        this.jEditorPane1.setName("jEditorPane1");
        autoBinding = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ_WRITE, (Object)this.jTable1, (Property)ELProperty.create((String)"${selectedElement.column0}"), (Object)this.jEditorPane1, (Property)BeanProperty.create((String)"text"));
        autoBinding.setSourceNullValue((Object)"<html></html>");
        autoBinding.setSourceUnreadableValue((Object)"<html></htm>");
        this.bindingGroup.addBinding((Binding)autoBinding);
        this.jEditorPane1.addCaretListener(new CaretListener(){

            public void caretUpdate(CaretEvent caretEvent) {
                SELViewerUI.this.jEditorPane1CaretUpdate(caretEvent);
            }
        });
        this.jEditorPane1.addPropertyChangeListener(new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                SELViewerUI.this.jEditorPane1PropertyChange(propertyChangeEvent);
            }
        });
        GroupLayout groupLayout2 = new GroupLayout(this.jPanel1);
        this.jPanel1.setLayout(groupLayout2);
        groupLayout2.setHorizontalGroup(groupLayout2.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout2.createSequentialGroup().addContainerGap().addGroup(groupLayout2.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabel2).addComponent(this.jLabel4).addComponent(this.jLabel5).addComponent(this.jLabel3).addComponent(this.jLabel1)).addGap(16, 16, 16).addGroup(groupLayout2.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jEditorPane1, -1, 637, Short.MAX_VALUE).addComponent(this.jTextField3, -1, 637, Short.MAX_VALUE).addComponent(this.jTextField2, -1, 637, Short.MAX_VALUE).addComponent(this.jTextField4, -1, 637, Short.MAX_VALUE).addComponent(this.jTextField6, -1, 637, Short.MAX_VALUE)).addContainerGap()));
        groupLayout2.setVerticalGroup(groupLayout2.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout2.createSequentialGroup().addGap(61, 61, 61).addGroup(groupLayout2.createParallelGroup(GroupLayout.Alignment.TRAILING, false).addComponent(this.jLabel1, -1, -1, Short.MAX_VALUE).addComponent(this.jEditorPane1)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(groupLayout2.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jTextField3, -2, -1, -2).addComponent(this.jLabel3)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(groupLayout2.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel2).addComponent(this.jTextField2, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(groupLayout2.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.jTextField4, -2, -1, -2).addComponent(this.jLabel4)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(groupLayout2.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.jLabel5).addComponent(this.jTextField6, -2, -1, -2)).addGap(46, 46, 46)));
        GroupLayout groupLayout3 = new GroupLayout(this.InfoPanel);
        this.InfoPanel.setLayout(groupLayout3);
        groupLayout3.setHorizontalGroup(groupLayout3.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, groupLayout3.createSequentialGroup().addContainerGap().addComponent(this.jPanel1, -1, -1, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.summaryPanel, -2, -1, -2).addContainerGap()));
        groupLayout3.setVerticalGroup(groupLayout3.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout3.createSequentialGroup().addContainerGap().addGroup(groupLayout3.createParallelGroup(GroupLayout.Alignment.TRAILING, false).addComponent(this.jPanel1, GroupLayout.Alignment.LEADING, -1, 259, Short.MAX_VALUE).addComponent(this.summaryPanel, GroupLayout.Alignment.LEADING, -1, -1, Short.MAX_VALUE)).addContainerGap(14, Short.MAX_VALUE)));
        GroupLayout groupLayout4 = new GroupLayout(this.mainPanel);
        this.mainPanel.setLayout(groupLayout4);
        groupLayout4.setHorizontalGroup(groupLayout4.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, groupLayout4.createSequentialGroup().addContainerGap().addGroup(groupLayout4.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.jScrollPane1, GroupLayout.Alignment.LEADING, -1, 1067, Short.MAX_VALUE).addComponent(this.InfoPanel, GroupLayout.Alignment.LEADING, -1, -1, Short.MAX_VALUE)).addContainerGap()));
        groupLayout4.setVerticalGroup(groupLayout4.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, groupLayout4.createSequentialGroup().addContainerGap().addComponent(this.jScrollPane1, -1, 225, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.InfoPanel, -2, -1, -2).addGap(14, 14, 14)));
        this.menuBar.setName("menuBar");
        jMenu.setMnemonic('F');
        jMenu.setText(resourceMap.getString("fileMenu.text", new Object[0]));
        jMenu.setName("fileMenu");
        this.fileOpenMenuItem.setAccelerator(KeyStroke.getKeyStroke(79, 2));
        this.fileOpenMenuItem.setMnemonic('o');
        this.fileOpenMenuItem.setText(resourceMap.getString("fileOpenMenuItem.text", new Object[0]));
        this.fileOpenMenuItem.setName("fileOpenMenuItem");
        this.fileOpenMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                SELViewerUI.this.fileOpenMenuItemActionPerformed(actionEvent);
            }
        });
        jMenu.add(this.fileOpenMenuItem);
        this.fileSaveAsMenuItem.setAccelerator(KeyStroke.getKeyStroke(83, 2));
        this.fileSaveAsMenuItem.setMnemonic('A');
        this.fileSaveAsMenuItem.setText(resourceMap.getString("fileSaveAsMenuItem.text", new Object[0]));
        this.fileSaveAsMenuItem.setName("fileSaveAsMenuItem");
        this.fileSaveAsMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                SELViewerUI.this.fileSaveAsMenuItemActionPerformed(actionEvent);
            }
        });
        jMenu.add(this.fileSaveAsMenuItem);
        ApplicationActionMap applicationActionMap = ((SELViewer)Application.getInstance(SELViewer.class)).getContext().getActionMap(SELViewerUI.class, (Object)this);
        jMenuItem.setAction(applicationActionMap.get("quit"));
        jMenuItem.setName("exitMenuItem");
        jMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                SELViewerUI.this.exitMenuItemActionPerformed(actionEvent);
            }
        });
        jMenu.add(jMenuItem);
        this.menuBar.add(jMenu);
        this.SELMenu.setMnemonic('S');
        this.SELMenu.setText(resourceMap.getString("SELMenu.text", new Object[0]));
        this.SELMenu.setName("SELMenu");
        this.SELMenu.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                SELViewerUI.this.SELMenuActionPerformed(actionEvent);
            }
        });
        this.SELReloadMenuItem.setAccelerator(KeyStroke.getKeyStroke(82, 2));
        this.SELReloadMenuItem.setMnemonic('r');
        this.SELReloadMenuItem.setText(resourceMap.getString("SELReloadMenuItem.text", new Object[0]));
        this.SELReloadMenuItem.setName("SELReloadMenuItem");
        this.SELReloadMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                SELViewerUI.this.SELReloadMenuItemActionPerformed(actionEvent);
            }
        });
        this.SELMenu.add(this.SELReloadMenuItem);
        this.SELPropsMenuItem.setAccelerator(KeyStroke.getKeyStroke(80, 2));
        this.SELPropsMenuItem.setMnemonic('p');
        this.SELPropsMenuItem.setText(resourceMap.getString("SELPropsMenuItem.text", new Object[0]));
        this.SELPropsMenuItem.setName("SELPropsMenuItem");
        this.SELPropsMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                SELViewerUI.this.SELPropsMenuItemActionPerformed(actionEvent);
            }
        });
        this.SELMenu.add(this.SELPropsMenuItem);
        this.SELCLearMenuItem.setAccelerator(KeyStroke.getKeyStroke(75, 2));
        this.SELCLearMenuItem.setMnemonic('c');
        this.SELCLearMenuItem.setText(resourceMap.getString("SELCLearMenuItem.text", new Object[0]));
        this.SELCLearMenuItem.setName("SELCLearMenuItem");
        this.SELCLearMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                SELViewerUI.this.SELCLearMenuItemActionPerformed(actionEvent);
            }
        });
        this.SELMenu.add(this.SELCLearMenuItem);
        this.SELGoToMenuItem.setAccelerator(KeyStroke.getKeyStroke(71, 2));
        this.SELGoToMenuItem.setMnemonic('g');
        this.SELGoToMenuItem.setText(resourceMap.getString("SELGoToMenuItem.text", new Object[0]));
        this.SELGoToMenuItem.setName("SELGoToMenuItem");
        this.SELGoToMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                SELViewerUI.this.SELGoToMenuItemActionPerformed(actionEvent);
            }
        });
        this.SELMenu.add(this.SELGoToMenuItem);
        this.SELSortByMenuItem.setMnemonic('s');
        this.SELSortByMenuItem.setText(resourceMap.getString("SELSortByMenuItem.text", new Object[0]));
        this.SELSortByMenuItem.setInheritsPopupMenu(true);
        this.SELSortByMenuItem.setName("SELSortByMenuItem");
        this.SELSortSerialMenuItem.setMnemonic('n');
        this.SELSortSerialMenuItem.setText(resourceMap.getString("SELSortSerialMenuItem.text", new Object[0]));
        this.SELSortSerialMenuItem.setName("SELSortSerialMenuItem");
        this.SELSortSerialMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                SELViewerUI.this.SELSortSerialMenuItemActionPerformed(actionEvent);
            }
        });
        this.SELSortByMenuItem.add(this.SELSortSerialMenuItem);
        this.SELSortTSMenuItem.setMnemonic('t');
        this.SELSortTSMenuItem.setText(resourceMap.getString("SELSortTSMenuItem.text", new Object[0]));
        this.SELSortTSMenuItem.setName("SELSortTSMenuItem");
        this.SELSortTSMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                SELViewerUI.this.SELSortTSMenuItemActionPerformed(actionEvent);
            }
        });
        this.SELSortByMenuItem.add(this.SELSortTSMenuItem);
        this.SELSortSensorTypeMenuItem.setMnemonic('s');
        this.SELSortSensorTypeMenuItem.setText(resourceMap.getString("SELSortSensorTypeMenuItem.text", new Object[0]));
        this.SELSortSensorTypeMenuItem.setName("SELSortSensorTypeMenuItem");
        this.SELSortSensorTypeMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                SELViewerUI.this.SELSortSensorTypeMenuItemActionPerformed(actionEvent);
            }
        });
        this.SELSortByMenuItem.add(this.SELSortSensorTypeMenuItem);
        this.SELSortEventTypeMenuItem.setMnemonic('e');
        this.SELSortEventTypeMenuItem.setText(resourceMap.getString("SELSortEventTypeMenuItem.text", new Object[0]));
        this.SELSortEventTypeMenuItem.setName("SELSortEventTypeMenuItem");
        this.SELSortEventTypeMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                SELViewerUI.this.SELSortEventTypeMenuItemActionPerformed(actionEvent);
            }
        });
        this.SELSortByMenuItem.add(this.SELSortEventTypeMenuItem);
        this.SELSortGenIdMenuItem.setMnemonic('g');
        this.SELSortGenIdMenuItem.setText(resourceMap.getString("SELSortGenIdMenuItem.text", new Object[0]));
        this.SELSortGenIdMenuItem.setName("SELSortGenIdMenuItem");
        this.SELSortGenIdMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                SELViewerUI.this.SELSortGenIdMenuItemActionPerformed(actionEvent);
            }
        });
        this.SELSortByMenuItem.add(this.SELSortGenIdMenuItem);
        this.SELMenu.add(this.SELSortByMenuItem);
        this.menuBar.add(this.SELMenu);
        this.viewMenu.setMnemonic('V');
        this.viewMenu.setText(resourceMap.getString("viewMenu.text", new Object[0]));
        this.viewMenu.setName("viewMenu");
        this.viewMenu.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                SELViewerUI.this.viewMenuActionPerformed(actionEvent);
            }
        });
        this.ViewInfoPane.setAccelerator(KeyStroke.getKeyStroke(73, 2));
        this.ViewInfoPane.setMnemonic('I');
        this.ViewInfoPane.setSelected(true);
        this.ViewInfoPane.setText(resourceMap.getString("ViewInfoPane.text", new Object[0]));
        this.ViewInfoPane.setName("ViewInfoPane");
        this.ViewInfoPane.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                SELViewerUI.this.ViewInfoPaneActionPerformed(actionEvent);
            }
        });
        this.viewMenu.add(this.ViewInfoPane);
        this.jSeparator1.setName("jSeparator1");
        this.viewMenu.add(this.jSeparator1);
        this.dispInHex.setAccelerator(KeyStroke.getKeyStroke(68, 0));
        this.dispInHex.setMnemonic('h');
        this.dispInHex.setText(resourceMap.getString("dispInHex.text", new Object[0]));
        this.dispInHex.setName("dispInHex");
        this.dispInHex.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                SELViewerUI.this.dispInHexActionPerformed(actionEvent);
            }
        });
        this.viewMenu.add(this.dispInHex);
        this.dispInText.setAccelerator(KeyStroke.getKeyStroke(84, 0));
        this.dispInText.setMnemonic('t');
        this.dispInText.setText(resourceMap.getString("dispInText.text", new Object[0]));
        this.dispInText.setName("dispInText");
        this.dispInText.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                SELViewerUI.this.dispInTextActionPerformed(actionEvent);
            }
        });
        this.viewMenu.add(this.dispInText);
        this.menuBar.add(this.viewMenu);
        jMenu2.setMnemonic('H');
        jMenu2.setText(resourceMap.getString("helpMenu.text", new Object[0]));
        jMenu2.setName("helpMenu");
        this.jMenuItem9.setAccelerator(KeyStroke.getKeyStroke(112, 0));
        this.jMenuItem9.setMnemonic('h');
        this.jMenuItem9.setText(resourceMap.getString("jMenuItem9.text", new Object[0]));
        this.jMenuItem9.setName("jMenuItem9");
        this.jMenuItem9.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                SELViewerUI.this.jMenuItem9ActionPerformed(actionEvent);
            }
        });
        jMenu2.add(this.jMenuItem9);
        jMenuItem2.setAction(applicationActionMap.get("showAboutBox"));
        jMenuItem2.setName("aboutMenuItem");
        jMenuItem2.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                SELViewerUI.this.aboutMenuItemActionPerformed(actionEvent);
            }
        });
        jMenu2.add(jMenuItem2);
        this.menuBar.add(jMenu2);
        this.statusPanel.setName("statusPanel");
        jSeparator.setName("statusPanelSeparator");
        this.statusMessageLabel.setFont(resourceMap.getFont("statusMessageLabel.font"));
        this.statusMessageLabel.setName("statusMessageLabel");
        this.statusAnimationLabel.setHorizontalAlignment(2);
        this.statusAnimationLabel.setName("statusAnimationLabel");
        this.progressBar.setName("progressBar");
        GroupLayout groupLayout5 = new GroupLayout(this.statusPanel);
        this.statusPanel.setLayout(groupLayout5);
        groupLayout5.setHorizontalGroup(groupLayout5.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(jSeparator, -1, 1087, Short.MAX_VALUE).addGroup(groupLayout5.createSequentialGroup().addContainerGap().addComponent(this.statusMessageLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, 952, Short.MAX_VALUE).addComponent(this.progressBar, -2, 111, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.statusAnimationLabel).addContainerGap()));
        groupLayout5.setVerticalGroup(groupLayout5.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout5.createSequentialGroup().addComponent(jSeparator, -2, 2, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE).addGroup(groupLayout5.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.statusMessageLabel).addComponent(this.statusAnimationLabel).addComponent(this.progressBar, -2, -1, -2)).addGap(3, 3, 3)));
        this.setComponent(this.mainPanel);
        this.setMenuBar(this.menuBar);
        this.setStatusBar(this.statusPanel);
        this.bindingGroup.bind();
    }

    private void SELReloadMenuItemActionPerformed(ActionEvent actionEvent) {
        this.runSELCommand(this.displayType);
    }

    private void SELMenuActionPerformed(ActionEvent actionEvent) {
    }

    public void renderSELEntries() {
        this.isSELBinRunning = false;
        this.progressBar.setIndeterminate(false);
        this.progressBar.setValue(50);
        this.readAndDisplay(null, -1);
        this.progressBar.setValue(100);
        this.setStatusMessageLabel("Done", 0);
        this.progressBar.setVisible(false);
    }

    private void SELCLearMenuItemActionPerformed(ActionEvent actionEvent) {
        if (((SELTableModel)this.jTable1.getModel()).getRowCount() == 0) {
            JOptionPane.showMessageDialog(this.mainPanel, "No SEL Entries to clear!", "Clear SEL Entries", -1);
            return;
        }
        int n = JOptionPane.showConfirmDialog(this.mainPanel, "Are you sure you want to clear the SEL Entries?", "Clear SEL Entries?", 0, -1);
        if (n == 0) {
            this.setStatusMessageLabel("Clearing SEL Entries from BMC.", 0);
            this.runSELCommand(-1);
            this.selPropsMap.clear();
            this.infoEventVal.setText(" 0 ");
            this.warnEventVals.setText(" 0 ");
            this.criticalEventVals.setText(" 0 ");
            this.OtherEventVals.setText(" 0 ");
            this.SELPropsMenuItem.setEnabled(false);
        }
    }

    public void clearSELUI() {
        this.isSELBinRunning = false;
        ((SELTableModel)this.jTable1.getModel()).setRowCount(0);
        this.setStatusMessageLabel("Done.", 0);
        this.progressBar.setValue(100);
        this.progressBar.setVisible(false);
    }

    public void runSELCommand(int n) {
        if (this.isSELBinRunning) {
            this.setStatusMessageLabel("Already a BMC command is running.", 0);
            return;
        }
        if (n != -1) {
            this.setStatusMessageLabel("Getting SEL Entries from the BMC", 0);
        } else {
            this.setStatusMessageLabel("Clearing SEL Entries from the BMC", 0);
        }
        this.progressBar.setIndeterminate(true);
        this.progressBar.setVisible(true);
        try {
            Object object;
            String string = System.getProperty("os.name");
            String string2 = "Linux";
            String string3 = string.contentEquals(string2) ? (((File)(object = new File(this.SELBinPath))).exists() ? "./" + this.SELBinPath : this.SELBinPath) : this.SELBinPath_win;
            if (n == -1) {
                string3 = string3 + " /clear";
            } else {
                object = " /save ";
                if (n == 1) {
                    object = (String)object + "/hex ";
                }
                string3 = string3 + (String)object + this.SELSavePath;
                this.SELPropsMenuItem.setEnabled(true);
            }
            string3 = string3 + " /ni ";
            object = Runtime.getRuntime().exec(string3);
            this.isSELBinRunning = true;
            SELCLIWrapper sELCLIWrapper = new SELCLIWrapper(this, (Process)object, n);
            sELCLIWrapper.start();
            this.SELPropsMenuItem.setEnabled(true);
            this.ViewInfoPane.setState(true);
            this.SELCLearMenuItem.setEnabled(true);
            this.dispInHex.setEnabled(true);
            this.dispInText.setEnabled(true);
        }
        catch (Exception exception) {
            this.setStatusMessageLabel("Unable to get SEL entries.", 1);
            this.progressBar.setVisible(false);
            exception.printStackTrace();
            return;
        }
    }

    private void updateMenuItems() {
        if (this.displayType == 1) {
            this.SELSortByMenuItem.setEnabled(false);
            this.ViewInfoPane.setEnabled(false);
        } else {
            this.SELSortByMenuItem.setEnabled(true);
            this.ViewInfoPane.setEnabled(true);
            this.ViewInfoPane.setState(true);
        }
    }

    private void readAndDisplay(File file, int n) {
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        int n5 = 0;
        this.selPropsMap.clear();
        if (file == null) {
            file = new File(this.SELSavePath);
        }
        this.setStatusMessageLabel("Updating the SEL Entries on the SEL Viewer Table.", 0);
        try {
            Object object;
            int n6 = 0;
            BufferedReader bufferedReader = new BufferedReader(new FileReader(file));
            String string = null;
            StringTokenizer stringTokenizer = null;
            String string2 = "\t";
            int n7 = 0;
            ((SELTableModel)this.jTable1.getModel()).setRowCount(0);
            Object[][] objectArray = null;
            String[] stringArray = null;
            if (n == 1) {
                objectArray = new Object[5000][2];
                stringArray = new String[]{this.hexHeader1, this.hexHeader2};
                this.InfoPanel.setVisible(false);
                this.mainPanel.updateUI();
            } else if (n == 0) {
                objectArray = new Object[5000][5];
                stringArray = new String[]{this.th1, this.th2, this.th3, this.th4, this.th5};
                this.InfoPanel.setVisible(true);
                this.mainPanel.updateUI();
            }
            while ((string = bufferedReader.readLine()) != null) {
                Object object2;
                if (n6 < numProps) {
                    object = "\\t";
                    object2 = string.split((String)object);
                    this.selPropsMap.put(object2[0], object2[((String[])object2).length - 1]);
                    ++n6;
                    continue;
                }
                if (n == -1) {
                    if (n6 == numProps) {
                        ++n6;
                        continue;
                    }
                    ++n6;
                    if (string.startsWith("RID:")) {
                        n = 1;
                        this.displayType = 1;
                        objectArray = new Object[5000][2];
                        stringArray = new String[]{this.hexHeader1, this.hexHeader2};
                        this.InfoPanel.setVisible(false);
                        this.mainPanel.updateUI();
                    } else {
                        if (string.startsWith("Num")) {
                            this.SELTextHdr = string;
                            n = 0;
                            this.displayType = 0;
                            objectArray = new Object[5000][5];
                            stringArray = new String[]{this.th1, this.th2, this.th3, this.th4, this.th5};
                            this.InfoPanel.setVisible(true);
                            this.mainPanel.updateUI();
                            continue;
                        }
                        this.setStatusMessageLabel("Cannot open the selected file. File not in a valid SEL File format.", 1);
                        bufferedReader.close();
                        return;
                    }
                }
                if (n == 0) {
                    if (n6 < numProps + 2) {
                        ++n6;
                        continue;
                    }
                    stringTokenizer = new StringTokenizer(string, string2);
                    int n8 = 0;
                    if (stringTokenizer.countTokens() != 5) continue;
                    while (n8 < 5) {
                        if (n8 == 0) {
                            int n9;
                            object2 = stringTokenizer.nextToken();
                            for (int i = n9 = ((String)object2).length(); i < 4; ++i) {
                                object2 = 0 + (String)object2;
                            }
                            objectArray[n7][n8++] = object2;
                            continue;
                        }
                        if (n8 == 3) {
                            object2 = stringTokenizer.nextToken().toString().trim();
                            if (((String)object2).startsWith("Informational event")) {
                                ++n2;
                            } else if (((String)object2).startsWith("CRITICAL event")) {
                                ++n3;
                            } else if (((String)object2).startsWith("Warning event")) {
                                ++n4;
                            } else {
                                ++n5;
                            }
                            objectArray[n7][n8++] = object2;
                            continue;
                        }
                        objectArray[n7][n8++] = stringTokenizer.nextToken().toString().trim();
                    }
                    ++n7;
                    continue;
                }
                if (n != 1) continue;
                if (n6 < numProps + 1) {
                    ++n6;
                    continue;
                }
                objectArray[n7][1] = string;
                objectArray[n7][0] = ++n7;
            }
            ((SELTableModel)this.jTable1.getModel()).setDataVector(objectArray, stringArray);
            ((SELTableModel)this.jTable1.getModel()).setRowCount(n7);
            this.infoEventVal.setText(" " + Integer.toString(n2) + " ");
            this.warnEventVals.setText(" " + Integer.toString(n4) + " ");
            this.criticalEventVals.setText(" " + Integer.toString(n3) + " ");
            this.OtherEventVals.setText(" " + Integer.toString(n5) + " ");
            if (this.colorCodingCheckBox.isSelected()) {
                showColorCoding = true;
                object = Color.decode(infoMsgCol);
                this.infoEventVal.setBackground((Color)object);
                object = Color.decode(warnMsgCol);
                this.warnEventVals.setBackground((Color)object);
                object = Color.decode(criticalMsgCol);
                this.criticalEventVals.setBackground((Color)object);
                object = Color.decode(otherMsgCol);
                this.OtherEventVals.setBackground((Color)object);
            } else {
                showColorCoding = false;
                object = this.jPanel1.getBackground();
                this.infoEventVal.setBackground((Color)object);
                this.warnEventVals.setBackground((Color)object);
                this.criticalEventVals.setBackground((Color)object);
                this.OtherEventVals.setBackground((Color)object);
            }
            this.setColsWidth();
            this.jTable1.setRowSelectionInterval(0, 0);
            this.jTable1.updateUI();
            this.jTable1.scrollRectToVisible(new Rectangle(0, this.jTable1.getRowHeight() * 0, 0, this.jTable1.getRowHeight()));
            this.updateMenuItems();
            this.setStatusMessageLabel("Done!", 0);
            bufferedReader.close();
        }
        catch (Exception exception) {
            this.setStatusMessageLabel("Cannot open the selected file. File not in a valid SEL File format.", 1);
            this.InfoPanel.setVisible(false);
            return;
        }
        this.deleteSELFile();
    }

    private void deleteSELFile() {
        File file = new File(this.SELSavePath);
        file.delete();
    }

    private void fileOpenMenuItemActionPerformed(ActionEvent actionEvent) {
        Serializable serializable;
        String string;
        block7: {
            string = "";
            try {
                serializable = new JFileChooser();
                serializable.setFileFilter(new SELFileFilter());
                int n = serializable.showOpenDialog(this.mainPanel);
                if (n != 1) {
                    string = serializable.getSelectedFile().getAbsoluteFile().getAbsolutePath();
                    if (serializable.getFileFilter().getDescription().startsWith("SEL") && !string.endsWith(".sel")) {
                        string = string + ".sel";
                    }
                    break block7;
                }
                return;
            }
            catch (Exception exception) {
                try {
                    Runtime runtime = Runtime.getRuntime();
                    Process process = runtime.exec(this.SELOpenSavePath + " Open SEL File");
                    BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(process.getInputStream()));
                    string = "";
                    string = bufferedReader.readLine();
                    if (string.equals("") || string == null) {
                        return;
                    }
                }
                catch (Exception exception2) {
                    this.setStatusMessageLabel("A few of the package files are missing. Cannot Open saved files.", 1);
                    return;
                }
            }
        }
        serializable = new File(string);
        this.readAndDisplay((File)serializable, -1);
        this.deleteSELFile();
        this.SELPropsMenuItem.setEnabled(false);
        this.ViewInfoPane.setState(true);
        this.dispInHex.setEnabled(false);
        this.dispInText.setEnabled(false);
        this.SELCLearMenuItem.setEnabled(false);
    }

    private void exitMenuItemActionPerformed(ActionEvent actionEvent) {
        System.exit(0);
    }

    private void fileSaveAsMenuItemActionPerformed(ActionEvent actionEvent) {
        int n;
        Object[] objectArray;
        Object object;
        Object object2;
        String string;
        File file;
        int n2;
        Vector<Vector> vector;
        block19: {
            vector = ((SELTableModel)this.jTable1.getModel()).getDataVector();
            n2 = vector.size();
            if (n2 == 0) {
                JOptionPane.showMessageDialog(this.mainPanel, "No SEL Entries to save!", "Save SEL Entries", -1);
                return;
            }
            file = null;
            string = null;
            try {
                object2 = new JFileChooser();
                ((JFileChooser)object2).setDialogTitle("Save As");
                object = new SELFileFilter();
                ((JFileChooser)object2).addChoosableFileFilter((FileFilter)object);
                ((JFileChooser)object2).setFileFilter((FileFilter)object);
                int n3 = ((JFileChooser)object2).showSaveDialog(this.mainPanel);
                string = null;
                file = null;
                if (n3 != 1) {
                    string = ((JFileChooser)object2).getSelectedFile().getAbsoluteFile().getAbsolutePath();
                    if (((JFileChooser)object2).getFileFilter().getDescription().startsWith("SEL") && !string.endsWith(".sel")) {
                        string = string + ".sel";
                    }
                    break block19;
                }
                return;
            }
            catch (Exception exception) {
                try {
                    object = Runtime.getRuntime();
                    Process process = ((Runtime)object).exec(this.SELOpenSavePath + " Save As");
                    objectArray = new BufferedReader(new InputStreamReader(process.getInputStream()));
                    string = objectArray.readLine();
                    if (string.equals("") || string == null) {
                        return;
                    }
                }
                catch (Exception exception2) {
                    this.setStatusMessageLabel("A few of the package files are missing. Cannot save the SEL to a file.", 1);
                    return;
                }
            }
        }
        file = new File(string);
        if (file.exists() && (n = JOptionPane.showConfirmDialog(this.mainPanel, "File already exists. Do you want to overwrite the file?", "Overwrite?", 0, -1)) == 1) {
            return;
        }
        try {
            object2 = new FileWriter(file);
            object = new BufferedWriter((Writer)object2);
            Object[] objectArray2 = this.selPropsMap.keySet().toArray();
            objectArray = this.selPropsMap.values().toArray();
            for (int i = 0; i < objectArray2.length; ++i) {
                ((Writer)object).write((String)objectArray2[i] + "    " + (String)objectArray[i] + "\n");
            }
            if (this.displayType == 0) {
                ((Writer)object).write("\n" + this.SELTextHdr + "\n");
            } else {
                ((Writer)object).write("\n");
            }
            Vector vector2 = null;
            for (int i = 0; i < n2; ++i) {
                vector2 = vector.elementAt(i);
                if (this.displayType == 0) {
                    for (int j = 0; j < vector2.size(); ++j) {
                        ((Writer)object).write((String)vector2.elementAt(j) + "\t");
                    }
                } else if (this.displayType == 1) {
                    ((Writer)object).write((String)vector2.elementAt(1));
                }
                ((Writer)object).write("\n");
            }
            ((BufferedWriter)object).close();
        }
        catch (Exception exception) {
            JOptionPane.showMessageDialog(this.mainPanel, "Exception Occured: " + exception.toString());
            this.setStatusMessageLabel("Unable to save SEL Entries to a file.", 1);
            exception.printStackTrace();
        }
    }

    private void setStatusMessageLabel(String string, int n) {
        this.statusMessageLabel.setText(string);
        if (n == 0) {
            this.statusMessageLabel.setForeground(Color.BLACK);
        } else {
            this.statusMessageLabel.setForeground(Color.RED);
        }
    }

    private void SELPropsMenuItemActionPerformed(ActionEvent actionEvent) {
        JFrame jFrame = SELViewer.getApplication().getMainFrame();
        SELEntryProps sELEntryProps = new SELEntryProps((Frame)jFrame, true, this.selPropsMap);
        sELEntryProps.setLocationRelativeTo(jFrame);
        SELViewer.getApplication().show(sELEntryProps);
    }

    private void viewMenuActionPerformed(ActionEvent actionEvent) {
    }

    private void dispInHexActionPerformed(ActionEvent actionEvent) {
        if (this.displayType == 1) {
            return;
        }
        this.runSELCommand(1);
        this.displayType = 1;
    }

    private void dispInTextActionPerformed(ActionEvent actionEvent) {
        if (this.displayType == 0) {
            return;
        }
        this.runSELCommand(0);
        this.displayType = 0;
    }

    private void jMenuItem9ActionPerformed(ActionEvent actionEvent) {
        SELViewerHelp sELViewerHelp = new SELViewerHelp();
    }

    private void aboutMenuItemActionPerformed(ActionEvent actionEvent) {
    }

    private void SELSortSerialMenuItemActionPerformed(ActionEvent actionEvent) {
        Vector<Vector> vector = ((SELTableModel)this.jTable1.getModel()).getDataVector();
        Collections.sort(vector, new SortTable(0, true));
        ((SELTableModel)this.jTable1.getModel()).fireTableStructureChanged();
    }

    private void SELSortTSMenuItemActionPerformed(ActionEvent actionEvent) {
        Vector<Vector> vector = ((SELTableModel)this.jTable1.getModel()).getDataVector();
        Collections.sort(vector, new SortTable(1, true));
        ((SELTableModel)this.jTable1.getModel()).fireTableStructureChanged();
    }

    private void SELSortSensorTypeMenuItemActionPerformed(ActionEvent actionEvent) {
        Vector<Vector> vector = ((SELTableModel)this.jTable1.getModel()).getDataVector();
        Collections.sort(vector, new SortTable(2, true));
        ((SELTableModel)this.jTable1.getModel()).fireTableStructureChanged();
    }

    private void SELSortEventTypeMenuItemActionPerformed(ActionEvent actionEvent) {
        Vector<Vector> vector = ((SELTableModel)this.jTable1.getModel()).getDataVector();
        Collections.sort(vector, new SortTable(3, true));
        ((SELTableModel)this.jTable1.getModel()).fireTableStructureChanged();
    }

    private void SELSortGenIdMenuItemActionPerformed(ActionEvent actionEvent) {
        Vector<Vector> vector = ((SELTableModel)this.jTable1.getModel()).getDataVector();
        Collections.sort(vector, new SortTable(4, true));
        ((SELTableModel)this.jTable1.getModel()).fireTableStructureChanged();
    }

    private void SELGoToMenuItemActionPerformed(ActionEvent actionEvent) {
        String string = null;
        try {
            string = JOptionPane.showInputDialog(this.mainPanel, "Which SEL Entry?", "Go To", -1, null, null, null).toString();
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (string == null || string.equals("")) {
            this.setStatusMessageLabel("Invalid SEL Entry to seek to.", 1);
            return;
        }
        Integer n = 0;
        try {
            n = Integer.valueOf(string);
        }
        catch (NumberFormatException numberFormatException) {
            this.setStatusMessageLabel("Invalid SEL Entry to seek to.", 1);
            return;
        }
        if (n <= 0 || n > this.jTable1.getRowCount() || n == null) {
            this.setStatusMessageLabel("Invalid SEL Entry to seek to.", 1);
            return;
        }
        this.jTable1.setRowSelectionInterval(n - 1, n - 1);
        this.jTable1.updateUI();
        Integer n2 = n > 0 ? n - 1 : 0;
        this.jTable1.scrollRectToVisible(new Rectangle(0, this.jTable1.getRowHeight() * n2, 0, this.jTable1.getRowHeight()));
        this.setStatusMessageLabel("Done", 0);
    }

    private void colorCodingCheckBoxActionPerformed(ActionEvent actionEvent) {
        try {
            int n = this.jTable1.getSelectedRow();
            if (this.colorCodingCheckBox.isSelected()) {
                showColorCoding = true;
                Color color = Color.decode(infoMsgCol);
                this.infoEventVal.setBackground(color);
                color = Color.decode(warnMsgCol);
                this.warnEventVals.setBackground(color);
                color = Color.decode(criticalMsgCol);
                this.criticalEventVals.setBackground(color);
                color = Color.decode(otherMsgCol);
                this.OtherEventVals.setBackground(color);
            } else {
                showColorCoding = false;
                Color color = this.jPanel1.getBackground();
                this.infoEventVal.setBackground(color);
                this.warnEventVals.setBackground(color);
                this.criticalEventVals.setBackground(color);
                this.OtherEventVals.setBackground(color);
            }
            ((SELTableModel)this.jTable1.getModel()).fireTableDataChanged();
            this.jTable1.setRowSelectionInterval(n, n);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void ViewInfoPaneActionPerformed(ActionEvent actionEvent) {
        this.InfoPanel.setVisible(this.ViewInfoPane.getState());
        this.mainPanel.updateUI();
    }

    private void jEditorPane1PropertyChange(PropertyChangeEvent propertyChangeEvent) {
    }

    private void jEditorPane1CaretUpdate(CaretEvent caretEvent) {
    }

    private void fileMenuActionPerformed(ActionEvent actionEvent) {
    }

    static {
        showColorCoding = true;
    }
}

