::batch file for win platform
@echo off
set BASE_DIR=%~dp0
set USB_VID=8087
set USB_PID=b6b6
set /a TIMEOUT=60
set DO_DFU_FLASH=1

::Ifwi configuration part
set DO_RECOVERY=0
set EDISON_XML_FILE=%BASE_DIR%pft-config-edison.xml
set MCG_XML_FILE=%BASE_DIR%pft-config-mcg_sku.xml
::Default to Edison
set PFT_XML_FILE=%EDISON_XML_FILE%

:: Handle Ifwi file for DFU update
set IFWI_DFU_EDISON_FILE=%BASE_DIR%edison_ifwi-dbg-dfu.bin
set IFWI_DFU_MCG_FILE=%BASE_DIR%ifwi_saltbay_pr2-dfu.bin
:: Default to Edison SKU
set IFWI_DFU_FILE=%IFWI_DFU_EDISON_FILE%

set DO_LIST_VARIANTS=0
set VAR_DIR=%BASE_DIR%u-boot-envs\
set VARIANT_NAME_DEFAULT=edison-default
set VARIANT_NAME_BLANK=edison-blank
set VARIANT_NAME=%VARIANT_NAME_BLANK%

:: ********************************************************************
:: parse arg
set show_help=0
set argcount=0
set appname=%0
:parse_arg_start
if -%1-==-- goto parse_arg_end
if -%1- == --i- set /a DO_RECOVERY=1
if -%1- == --d- set /a DO_DFU_FLASH=1
if -%1- == ---recovery- (
	set /a DO_RECOVERY=1
	set /a DO_DFU_FLASH=0
)
if -%1- == ---keep-data- (
	set /a DO_RECOVERY=0
	set VARIANT_NAME=%VARIANT_NAME_DEFAULT%
)
if -%1- == --b- (
	set /a DO_RECOVERY=1
	set /a DO_DFU_FLASH=1
	set VARIANT_NAME=%VARIANT_NAME_BLANK%
)
if -%1- == --m- (
	set PFT_XML_FILE=%MCG_XML_FILE%
	set IFWI_DFU_FILE=%IFWI_DFU_MCG_FILE%
)
if -%1- == --l- set /a DO_LIST_VARIANTS=1
if -%1- == --t- (
	set VARIANT_NAME=%2
	shift
)
if -%1- == -/?- set /a show_help=1
if -%1- == --h- set /a show_help=1
if -%1- == ---help- set /a show_help=1
set /a argcount+= 1
shift
goto :parse_arg_start
:parse_arg_end

:: handle help on cmd arg
if %show_help% == 1 (
	call:print-usage %appname%
	exit /b
)

:: U-boot target listing part
if %DO_LIST_VARIANTS% == 0 goto :skip_list_variants
echo Availables U-boot targets:
:: list all .env file in var_dir
for /R %VAR_DIR% %%i in ( *.bin ) do (
	:: echo the file-name only without extension
	echo %%~ni
)
exit /b 5
:skip_list_variants

:: ********************************************************************
:: Ifwi flashing part
if %DO_RECOVERY% == 0 goto :skip_flash_ifwi
echo Starting Recovery mode
echo Please plug and reboot the board
if not exist %PFT_XML_FILE% (
	echo %PFT_XML_FILE% does not exist
	exit /b 3
)
echo Flashing IFWI
call:flash-ifwi
if %errorlevel% neq 0 ( exit /b %errorlevel%)
echo Recovery Success...
echo You can now try a regular flash
:skip_flash_ifwi

:: ********************************************************************
:: Kernel & rootfs flashing part
if %DO_DFU_FLASH% == 0 goto :skip_flash_kernel
echo Using U-boot target: %VARIANT_NAME%
set VARIANT_FILE=%VAR_DIR%%VARIANT_NAME%.bin
	if not exist %VARIANT_FILE% (
		echo U-boot target %VARIANT_NAME%: %VARIANT_FILE% not found aborting
		exit /b 5
)

echo Now waiting for dfu device %USB_VID%:%USB_PID%
echo Please plug and reboot the board
call:dfu-wait
if %errorlevel% neq 0 ( exit /b %errorlevel%)

echo Flashing IFWI
call:flash-command --alt 0 -D %IFWI_DFU_FILE%
if %errorlevel% neq 0 ( exit /b %errorlevel%)
call:flash-command --alt 1 -D %IFWI_DFU_FILE%
if %errorlevel% neq 0 ( exit /b %errorlevel%)

echo Flashing U-Boot
call:flash-command --alt 2 -D %BASE_DIR%u-boot-edison.bin
if %errorlevel% neq 0 ( exit /b %errorlevel%)

echo Flashing U-Boot Environment
call:flash-command --alt 3 -D %VARIANT_FILE%
if %errorlevel% neq 0 ( exit /b %errorlevel%)

echo Flashing U-Boot Environment Backup
call:flash-command --alt 5 -D %VARIANT_FILE%
if %errorlevel% neq 0 ( exit /b %errorlevel%)

echo Flashing boot partition ^(kernel^)
call:flash-command --alt 6 -D %BASE_DIR%edison-image-edison.hddimg
if %errorlevel% neq 0 ( exit /b %errorlevel%)

echo "Flashing rootfs and rebooting"
call:flash-command --alt 7 -D %BASE_DIR%edison-image-edison.ext4 -R
if %errorlevel% neq 0 ( exit /b %errorlevel% )

echo U-boot ^& Kernel System Flash Success...
if %VARIANT_NAME% == %VARIANT_NAME_BLANK% (
	echo Your board needs to reboot twice to complete the flashing procedure, please do not unplug it for 2 minutes.
)
:skip_flash_kernel

:: ********************************************************************
:: The End
if %DO_RECOVERY% == 0 (
if %DO_DFU_FLASH% == 0 (
	echo Nothing to do
	call:print-usage %appname%
))

exit /b 0


:print-usage
	echo Usage: %1 [-hl] [--help] [--recovery] [--keep-data] [-m][-ipdb] [-t uboot-env]
	echo Update all software and restore board to its initial state.
	echo  -h,--help     display this help and exit.
	echo  --recovery    recover the board to DFU mode using a dedicated tool,
	echo                available only on linux and window hosts.
	echo  --keep-data   preserve user data when flashing.
	echo.
	echo.
	echo deprecated commands:
	echo  -m            select MCG SKU soc when flashing IFWI
	echo  -i            flash IFWI
	echo  -d            flash U-boot, U-boot Environment, Linux Kernel, Rootfs
	echo  -b            blanck the device (eq -i -d -t %VARIANT_NAME_BLANK%)
	echo  -l            list availables U-boot target environments and exit
	echo  -t uboot-env  specify U-boot target environments to flash (default is %VARIANT_NAME%)
	exit /b 5

:flash-command
	dfu-util -v -d %USB_VID%:%USB_PID% %*
	set /a err_num=%errorlevel%
	if %err_num% neq 0 echo Flash failed on %*
	exit /b %err_num%

:flash-debug
	echo DEBUG: dfu-util -l
	dfu-util -l
	exit /b

:flash-ifwi
	cflasher -f %PFT_XML_FILE%
	set /a err_num=%errorlevel%
	if %err_num% neq 0 echo Ifwi Flash failed
	exit /b %err_num%

:dfu-wait
	setlocal
	set /a currtime=%TIMEOUT%
:start_wait
	dfu-util -l | findstr "Found" | findstr "%USB_VID%" > NUL
	if %errorlevel% == 0 (
		echo Dfu device found
		exit /b 0
	) else (
		set /a currtime-= 1
		timeout /t 1 /nobreak > nul
		if %currtime% gtr 0 goto:start_wait
	)
	echo Dfu device not found Timeout
	echo Did you plug and reboot your board?
	echo If yes, please try a recovery by calling this script with the --recovery option
	exit /b 3

