#!/bin/sh
# Absolute path to this script, e.g. /home/user/bin/foo.sh
SCRIPT=$(readlink -f "$0")
# Absolute path this script is in, thus /home/user/bin
DIR=$(dirname "$SCRIPT")
PRODUCT_NAME="Intel XDK Daemon"
SERVICE_NAME="xdk-daemon"
INSTALL_LOCATION="/opt"
INSTALL_FOLDER="/xdk-daemon"
APPSLOT="/node_app_slot"

# if not root, try to use sudo
if [[ `whoami` == "root" ]];
then
  SUDO=""
else
  SUDO="sudo"
fi

# installing packages globally
#$SUDO npm install -g
echo "==================================================================="
echo " Installing ${PRODUCT_NAME}"
echo "==================================================================="
echo ""
echo ""
echo " Installing modules for daemon version manager"
echo "--------------------------------------------------------------------"
$SUDO cd $DIR
$SUDO export CPLUS_INCLUDE_PATH=/usr/include/avahi-compat-libdns_sd
$SUDO npm install
echo " DONE!"

echo ""
echo " Installing modules for application daemon component"
echo "--------------------------------------------------------------------"
$SUDO cd $DIR/current
$SUDO npm install
echo " DONE!"

echo ""
echo " Installing modules for debugger agent component"
echo "--------------------------------------------------------------------"
$SUDO cd $DIR/current/node-inspector-server
$SUDO npm install
echo " DONE!"

$SUDO cd $DIR


if [[ "$1" != "build" ]]
then
#=============================================================================
# INSTALLATION STEPS
#=============================================================================

#make all needed directories
echo "Copying main daemon to $INSTALL_LOCATION$INSTALL_FOLDER"
$SUDO mkdir -p $INSTALL_LOCATION$INSTALL_FOLDER
$SUDO cp -ar $DIR/* $INSTALL_LOCATION$INSTALL_FOLDER/
$SUDO chmod 755 $INSTALL_LOCATION$INSTALL_FOLDER/xdk-daemon
echo "DONE!"
echo ""

#Fill previous slot
echo "Archiving current daemon as previous/recovery daemon"
$SUDO mkdir -p $INSTALL_LOCATION$INSTALL_FOLDER/previous
$SUDO cp -ar $DIR/current/* $INSTALL_LOCATION$INSTALL_FOLDER/previous/
echo "DONE!"
echo ""

#Fill default slot
echo "Archiving current daemon as default"
$SUDO mkdir -p $INSTALL_LOCATION$INSTALL_FOLDER/default
$SUDO cp -ar $DIR/current/* $INSTALL_LOCATION$INSTALL_FOLDER/default/
echo "DONE!"
echo ""

#create app slot
echo "Creating Application Slot"
$SUDO mkdir -p $APPSLOT
echo "DONE!"
echo ""

# try add a startup script to our init system
echo ""
echo " Copying starup script"
echo "--------------------------------------------------------------------"
if [[ -d /etc/systemd/system ]]
then
  ${SUDO} cp -f ./${SERVICE_NAME}.service /etc/systemd/system/
  ${SUDO} chmod 755 /etc/systemd/system/${SERVICE_NAME}.service
  ${SUDO} systemctl enable ${SERVICE_NAME}
#elif [[ -d /etc/rc5.d/ ]]
#then
# $SUDO cp -f ./S85xdk-daemon.sh /etc/rc5.d/
#else
# echo "no /etc/rc5.d directory - startup script not copied"
fi


read -p "Start $PRODUCT_NAME now? (y/n)? " -n 1 -r
echo    # (optional) move to a new line
#if [[ ! $REPLY =~ ^[Yy]$ ]]
echo #blank line
if  [ "$REPLY" = "y" ]
then
    echo "Starting $SERVICE_NAME now!"
    $SUDO systemctl start $SERVICE_NAME 
else
    echo "$SERVICE_NAME not started"
    echo "Type: 'systemctl start $SERVICE_NAME' to start the $SERVICE_NAME"
fi
#=============================================================================
echo #blank line
echo "Setup complete!"
fi
echo ""

