/*
 * This file was generated automatically by ExtUtils::ParseXS version 2.2210 from the
 * contents of Bzip2.xs. Do not edit this file, edit Bzip2.xs instead.
 *
 *	ANY CHANGES MADE HERE WILL BE LOST! 
 *
 */

#line 1 "Bzip2.xs"
/* Filename: Bzip2.xs
 * Author  : Paul Marquess, <pmqs@cpan.org>
 * Created : 5th October 2005
 * Version : 2.000
 *
 *   Copyright (c) 2005-2010 Paul Marquess. All rights reserved.
 *   This program is free software; you can redistribute it and/or
 *   modify it under the same terms as Perl itself.
 *
 */


#include "EXTERN.h"
#include "perl.h"
#include "XSUB.h"

#include "bzlib.h" 

#ifdef USE_PPPORT_H
#  define NEED_sv_2pv_nolen
#  include "ppport.h" 
#endif

#if PERL_REVISION == 5 && (PERL_VERSION < 8 || (PERL_VERSION == 8 && PERL_SUBVERSION < 4 ))

#    ifdef SvPVbyte_force
#        undef SvPVbyte_force
#    endif

#    define SvPVbyte_force(sv,lp) SvPV_force(sv,lp)

#endif

#ifndef SvPVbyte_nolen
#    define SvPVbyte_nolen SvPV_nolen
#endif


#if PERL_REVISION == 5 && (PERL_VERSION >= 8 || (PERL_VERSION == 8 && PERL_SUBVERSION < 4 ))
#    define UTF8_AVAILABLE
#endif

typedef int                     DualType ;
typedef int                     int_undef ;

typedef unsigned long           uLong;
typedef unsigned int            uInt;

typedef struct di_stream {
    int      flags ;
#define FLAG_APPEND_OUTPUT      1
#define FLAG_CONSUME_INPUT      8
#define FLAG_LIMIT_OUTPUT       16
    bz_stream stream;
    uInt     bufsize; 
    int      last_error ;
    uLong    bytesInflated ;
    uLong    compressedBytes ;
    uLong    uncompressedBytes ;
    
} di_stream;

typedef di_stream * deflateStream ;
typedef di_stream * Compress__Raw__Bzip2 ;

typedef di_stream * inflateStream ;
typedef di_stream * Compress__Raw__Bunzip2 ;

#define COMPRESS_CLASS    "Compress::Raw::Bzip2"
#define UNCOMPRESS_CLASS  "Compress::Raw::Bunzip2"

#define ZMALLOC(to, typ) ((to = (typ *)safemalloc(sizeof(typ))), \
                                Zero(to,1,typ))


/* static const char * const my_z_errmsg[] = { */
static const char my_z_errmsg[][32] = {
    "End of Stream",        /* BZ_STREAM_END        4       */
    "Finish OK",            /* BZ_FINISH_OK         3       */
    "Flush OK",             /* BZ_FLUSH_OK          2       */
    "Run OK",               /* BZ_RUN_OK            1       */
    "",                     /* BZ_OK                0       */
    "Sequence Error",       /* BZ_SEQUENCE_ERROR    (-1)    */
    "Param Error",          /* BZ_PARAM_ERROR       (-2)    */
    "Memory Error",         /* BZ_MEM_ERROR         (-3)    */
    "Data Error",           /* BZ_DATA_ERROR        (-4)    */
    "Magic Error",          /* BZ_DATA_ERROR_MAGIC  (-5)    */
    "IO Error",             /* BZ_IO_ERROR          (-6)    */
    "Unexpected EOF",       /* BZ_UNEXPECTED_EOF    (-7)    */
    "Output Buffer Full",   /* BZ_OUTBUFF_FULL      (-8)    */
    "Config Error",         /* BZ_CONFIG_ERROR      (-9)    */
    ""};

#define setDUALstatus(var, err)                                         \
                sv_setnv(var, (double)err) ;                            \
                sv_setpv(var, ((err) ? GetErrorString(err) : "")) ;     \
                SvNOK_on(var);

   
#if defined(__SYMBIAN32__)
# define NO_WRITEABLE_DATA
#endif

#define TRACE_DEFAULT 0

#ifdef NO_WRITEABLE_DATA
#  define trace TRACE_DEFAULT
#else
  static int trace = TRACE_DEFAULT ;
#endif

/* Dodge PerlIO hiding of these functions. */
#undef printf

#if 1
#define getInnerObject(x) (*av_fetch((AV*)SvRV(x), 0, FALSE))
#else
#define getInnerObject(x) ((SV*)SvRV(sv))
#endif

#ifdef BZ_NO_STDIO
void bz_internal_error(int errorcode)
{
    croak("bz_internal_error %d\n", errorcode);
}
#endif

static char *
#ifdef CAN_PROTOTYPE
GetErrorString(int error_no)
#else
GetErrorString(error_no)
int error_no ;
#endif
{
    dTHX;
    char * errstr ;
  
#if 0
    if (error_no == BZ_ERRNO) {
        errstr = Strerror(errno) ;
    }
    else
#endif
        errstr = (char*) my_z_errmsg[4 - error_no]; 

    return errstr ;
}

static void
#ifdef CAN_PROTOTYPE
DispHex(void * ptr, int length)
#else
DispHex(ptr, length)
    void * ptr;
    int length;
#endif
{
    char * p = (char*)ptr;
    int i;
    for (i = 0; i < length; ++i) {
        printf(" %02x", 0xFF & *(p+i));
    }
}


static void
#ifdef CAN_PROTOTYPE
DispStream(di_stream * s, char * message)
#else
DispStream(s, message)
    di_stream * s;
    char * message;
#endif
{

#if 0
    if (! trace)
        return ;
#endif

#define EnDis(f) (s->flags & f ? "Enabled" : "Disabled")

    printf("DispStream 0x%p", s) ;
    if (message)
        printf(" - %s \n", message) ;
    printf("\n") ;

    if (!s)  {
        printf("    stream pointer is NULL\n");
    }
    else     {
        printf("    stream           0x%p\n", &(s->stream));
        printf("           opaque    0x%p\n", s->stream.opaque);
        printf("           state     0x%p\n", s->stream.state );
        printf("           next_in   0x%p", s->stream.next_in);
        if (s->stream.next_in){
            printf(" =>");
            DispHex(s->stream.next_in, 4);
        }
        printf("\n");

        printf("           next_out  0x%p", s->stream.next_out);
        if (s->stream.next_out){
            printf(" =>");
            DispHex(s->stream.next_out, 4);
        }
        printf("\n");

        printf("           avail_in  %lu\n",  (unsigned long)s->stream.avail_in);
        printf("           avail_out %lu\n",  (unsigned long)s->stream.avail_out);
        printf("    bufsize          %lu\n",  (unsigned long)s->bufsize);
        printf("      total_in_lo32  %u\n",  s->stream.total_in_lo32);
        printf("      total_in_hi32  %u\n",  s->stream.total_in_hi32);
        printf("      total_out_lo32 %u\n",  s->stream.total_out_lo32);
        printf("      total_out_hi32 %u\n",  s->stream.total_out_hi32);
        printf("    flags            0x%x\n", s->flags);
        printf("           APPEND    %s\n",   EnDis(FLAG_APPEND_OUTPUT));
        printf("           CONSUME   %s\n",   EnDis(FLAG_CONSUME_INPUT));
        printf("           LIMIT     %s\n",   EnDis(FLAG_LIMIT_OUTPUT));

        printf("\n");

    }
}

static di_stream *
#ifdef CAN_PROTOTYPE
InitStream(void)
#else
InitStream()
#endif
{
    di_stream *s ;

    ZMALLOC(s, di_stream) ;

    return s ;
    
}

static void
#ifdef CAN_PROTOTYPE
PostInitStream(di_stream * s, int flags)
#else
PostInitStream(s, flags)
    di_stream *s ;
    int flags ;
#endif
{
    s->bufsize  = 1024 * 16 ;
    s->last_error = 0 ;
    s->flags    = flags ;
}


static SV* 
#ifdef CAN_PROTOTYPE
deRef(SV * sv, const char * string)
#else
deRef(sv, string)
SV * sv ;
char * string;
#endif
{
    dTHX;
    SvGETMAGIC(sv);

    if (SvROK(sv)) {
        sv = SvRV(sv) ;
        SvGETMAGIC(sv);
        switch(SvTYPE(sv)) {
            case SVt_PVAV:
            case SVt_PVHV:
            case SVt_PVCV:
                croak("%s: buffer parameter is not a SCALAR reference", string);
            default:
                break;
        }
        if (SvROK(sv))
            croak("%s: buffer parameter is a reference to a reference", string) ;
    }

    if (!SvOK(sv)) { 
        sv = newSVpv("", 0);
    }

    return sv ;
}

static SV*
#ifdef CAN_PROTOTYPE
deRef_l(SV * sv, const char * string)
#else
deRef_l(sv, string)
SV * sv ;
char * string ;
#endif
{
    dTHX;
    bool wipe = 0 ;
    
    SvGETMAGIC(sv);
    wipe = ! SvOK(sv) ;

    if (SvROK(sv)) {
        sv = SvRV(sv) ;
        SvGETMAGIC(sv);
        wipe = ! SvOK(sv) ;

        switch(SvTYPE(sv)) {
            case SVt_PVAV:
            case SVt_PVHV:
            case SVt_PVCV:
                croak("%s: buffer parameter is not a SCALAR reference", string);
            default:
                break;
        }
        if (SvROK(sv))
            croak("%s: buffer parameter is a reference to a reference", string) ;
    }

    if (SvREADONLY(sv) && PL_curcop != &PL_compiling)
        croak("%s: buffer parameter is read-only", string);

    SvUPGRADE(sv, SVt_PV);

    if (wipe)
        SvCUR_set(sv, 0);
    
    SvOOK_off(sv);
    SvPOK_only(sv);

    return sv ;
}


#include "constants.h"

#line 350 "Bzip2.c"
#ifndef PERL_UNUSED_VAR
#  define PERL_UNUSED_VAR(var) if (0) var = var
#endif

#ifndef PERL_ARGS_ASSERT_CROAK_XS_USAGE
#define PERL_ARGS_ASSERT_CROAK_XS_USAGE assert(cv); assert(params)

/* prototype to pass -Wmissing-prototypes */
STATIC void
S_croak_xs_usage(pTHX_ const CV *const cv, const char *const params);

STATIC void
S_croak_xs_usage(pTHX_ const CV *const cv, const char *const params)
{
    const GV *const gv = CvGV(cv);

    PERL_ARGS_ASSERT_CROAK_XS_USAGE;

    if (gv) {
        const char *const gvname = GvNAME(gv);
        const HV *const stash = GvSTASH(gv);
        const char *const hvname = stash ? HvNAME(stash) : NULL;

        if (hvname)
            Perl_croak(aTHX_ "Usage: %s::%s(%s)", hvname, gvname, params);
        else
            Perl_croak(aTHX_ "Usage: %s(%s)", gvname, params);
    } else {
        /* Pants. I don't think that it should be possible to get here. */
        Perl_croak(aTHX_ "Usage: CODE(0x%"UVxf")(%s)", PTR2UV(cv), params);
    }
}
#undef  PERL_ARGS_ASSERT_CROAK_XS_USAGE

#ifdef PERL_IMPLICIT_CONTEXT
#define croak_xs_usage(a,b)	S_croak_xs_usage(aTHX_ a,b)
#else
#define croak_xs_usage		S_croak_xs_usage
#endif

#endif

/* NOTE: the prototype of newXSproto() is different in versions of perls,
 * so we define a portable version of newXSproto()
 */
#ifdef newXS_flags
#define newXSproto_portable(name, c_impl, file, proto) newXS_flags(name, c_impl, file, proto, 0)
#else
#define newXSproto_portable(name, c_impl, file, proto) (PL_Sv=(SV*)newXS(name, c_impl, file), sv_setpv(PL_Sv, proto), (CV*)PL_Sv)
#endif /* !defined(newXS_flags) */

#line 402 "Bzip2.c"

/* INCLUDE:  Including 'constants.xs' from 'Bzip2.xs' */


XS(XS_Compress__Raw__Bzip2_constant); /* prototype to pass -Wmissing-prototypes */
XS(XS_Compress__Raw__Bzip2_constant)
{
#ifdef dVAR
    dVAR; dXSARGS;
#else
    dXSARGS;
#endif
    if (items != 1)
       croak_xs_usage(cv,  "sv");
    PERL_UNUSED_VAR(ax); /* -Wall */
    SP -= items;
    {
#line 4 "./constants.xs"
#ifdef dXSTARG
	dXSTARG; /* Faster if we have it.  */
#else
	dTARGET;
#endif
	STRLEN		len;
        int		type;
	IV		iv;
	/* NV		nv;	Uncomment this if you need to return NVs */
	/* const char	*pv;	Uncomment this if you need to return PVs */
#line 431 "Bzip2.c"
	SV *	sv = ST(0);
	const char *	s = SvPV(sv, len);
#line 18 "./constants.xs"
        /* Change this to constant(aTHX_ s, len, &iv, &nv);
           if you need to return both NVs and IVs */
	type = constant(aTHX_ s, len, &iv);
      /* Return 1 or 2 items. First is error message, or undef if no error.
           Second, if present, is found value */
        switch (type) {
        case PERL_constant_NOTFOUND:
          sv =
	    sv_2mortal(newSVpvf("%s is not a valid Bzip2 macro", s));
          PUSHs(sv);
          break;
        case PERL_constant_NOTDEF:
          sv = sv_2mortal(newSVpvf(
	    "Your vendor has not defined Bzip2 macro %s, used",
				   s));
          PUSHs(sv);
          break;
        case PERL_constant_ISIV:
          EXTEND(SP, 1);
          PUSHs(&PL_sv_undef);
          PUSHi(iv);
          break;
	/* Uncomment this if you need to return NOs
        case PERL_constant_ISNO:
          EXTEND(SP, 1);
          PUSHs(&PL_sv_undef);
          PUSHs(&PL_sv_no);
          break; */
	/* Uncomment this if you need to return NVs
        case PERL_constant_ISNV:
          EXTEND(SP, 1);
          PUSHs(&PL_sv_undef);
          PUSHn(nv);
          break; */
	/* Uncomment this if you need to return PVs
        case PERL_constant_ISPV:
          EXTEND(SP, 1);
          PUSHs(&PL_sv_undef);
          PUSHp(pv, strlen(pv));
          break; */
	/* Uncomment this if you need to return PVNs
        case PERL_constant_ISPVN:
          EXTEND(SP, 1);
          PUSHs(&PL_sv_undef);
          PUSHp(pv, iv);
          break; */
	/* Uncomment this if you need to return SVs
        case PERL_constant_ISSV:
          EXTEND(SP, 1);
          PUSHs(&PL_sv_undef);
          PUSHs(sv);
          break; */
	/* Uncomment this if you need to return UNDEFs
        case PERL_constant_ISUNDEF:
          break; */
	/* Uncomment this if you need to return UVs
        case PERL_constant_ISUV:
          EXTEND(SP, 1);
          PUSHs(&PL_sv_undef);
          PUSHu((UV)iv);
          break; */
	/* Uncomment this if you need to return YESs
        case PERL_constant_ISYES:
          EXTEND(SP, 1);
          PUSHs(&PL_sv_undef);
          PUSHs(&PL_sv_yes);
          break; */
        default:
          sv = sv_2mortal(newSVpvf(
	    "Unexpected return type %d while processing Bzip2 macro %s, used",
               type, s));
          PUSHs(sv);
        }
#line 508 "Bzip2.c"
	PUTBACK;
	return;
    }
}


/* INCLUDE: Returning to 'Bzip2.xs' from 'constants.xs' */

#define bzlibversion() BZ2_bzlibVersion()

XS(XS_Compress__Raw__Bzip2_bzlibversion); /* prototype to pass -Wmissing-prototypes */
XS(XS_Compress__Raw__Bzip2_bzlibversion)
{
#ifdef dVAR
    dVAR; dXSARGS;
#else
    dXSARGS;
#endif
    if (items != 0)
       croak_xs_usage(cv,  "");
    {
	const char *	RETVAL;
	dXSTARG;

	RETVAL = bzlibversion();
	sv_setpv(TARG, RETVAL); XSprePUSH; PUSHTARG;
    }
    XSRETURN(1);
}


XS(XS_Compress__Raw__Bzip2_new); /* prototype to pass -Wmissing-prototypes */
XS(XS_Compress__Raw__Bzip2_new)
{
#ifdef dVAR
    dVAR; dXSARGS;
#else
    dXSARGS;
#endif
    if (items < 1 || items > 5)
       croak_xs_usage(cv,  "className, appendOut=1, blockSize100k=1, workfactor=0, verbosity=0");
    PERL_UNUSED_VAR(ax); /* -Wall */
    SP -= items;
    {
	const char *	className;
	int	appendOut;
	int	blockSize100k;
	int	workfactor;
	int	verbosity;

	if (SvOK(ST(0)))
            className = (const char *)SvPVbyte_nolen(ST(0));
	else
            className = NULL ;

	if (items < 2)
	    appendOut = 1;
	else {
	    appendOut = (int)SvIV(ST(1));
	}

	if (items < 3)
	    blockSize100k = 1;
	else {
	    blockSize100k = (int)SvIV(ST(2));
	}

	if (items < 4)
	    workfactor = 0;
	else {
	    workfactor = (int)SvIV(ST(3));
	}

	if (items < 5)
	    verbosity = 0;
	else {
	    verbosity = (int)SvIV(ST(4));
	}
#line 370 "Bzip2.xs"
  {
    int err ;
    deflateStream s ;
#if 0
    /* if (trace) */
        warn("in Compress::Raw::Bzip2::_new(items=%d,appendOut=%d, blockSize100k=%d, workfactor=%d, verbosity=%d\n",
	items, appendOut, blockSize100k, workfactor, verbosity);
#endif
    if ((s = InitStream() )) {

        err = BZ2_bzCompressInit ( &(s->stream), 
                                     blockSize100k, 
                                     verbosity,
                                     workfactor );

        if (err != BZ_OK) {
            Safefree(s) ;
            s = NULL ;
	}
	else {
            int flags = 0 ;
            if (appendOut)
                flags |= FLAG_APPEND_OUTPUT;
            PostInitStream(s, appendOut ? FLAG_APPEND_OUTPUT :0) ;
        }
    }
    else
        err = BZ_MEM_ERROR ;

    {
        SV* obj = sv_setref_pv(sv_newmortal(), className, (void*)s);
        XPUSHs(obj);
    }
    if(0)
    {
        SV* obj = sv_2mortal(newSViv(PTR2IV(s))) ;
        XPUSHs(obj);
    }
    if (GIMME == G_ARRAY) {
        SV * sv = sv_2mortal(newSViv(err)) ;
	setDUALstatus(sv, err);
        XPUSHs(sv) ;
    }
  }
#line 632 "Bzip2.c"
	PUTBACK;
	return;
    }
}


XS(XS_Compress__Raw__Bunzip2_new); /* prototype to pass -Wmissing-prototypes */
XS(XS_Compress__Raw__Bunzip2_new)
{
#ifdef dVAR
    dVAR; dXSARGS;
#else
    dXSARGS;
#endif
    if (items < 1 || items > 6)
       croak_xs_usage(cv,  "className, appendOut=1, consume=1, small=0, verbosity=0, limitOutput=0");
    PERL_UNUSED_VAR(ax); /* -Wall */
    SP -= items;
    {
	const char*	className;
	int	appendOut;
	int	consume;
	int	small;
	int	verbosity;
	int	limitOutput;

	if (SvOK(ST(0)))
            className = (const char *)SvPVbyte_nolen(ST(0));
	else
            className = NULL ;

	if (items < 2)
	    appendOut = 1;
	else {
	    appendOut = (int)SvIV(ST(1));
	}

	if (items < 3)
	    consume = 1;
	else {
	    consume = (int)SvIV(ST(2));
	}

	if (items < 4)
	    small = 0;
	else {
	    small = (int)SvIV(ST(3));
	}

	if (items < 5)
	    verbosity = 0;
	else {
	    verbosity = (int)SvIV(ST(4));
	}

	if (items < 6)
	    limitOutput = 0;
	else {
	    limitOutput = (int)SvIV(ST(5));
	}
#line 426 "Bzip2.xs"
  {
    int err = BZ_OK ;
    inflateStream s ;
#if 0
    if (trace)
        warn("in _inflateInit(windowBits=%d, bufsize=%lu, dictionary=%lu\n",
                windowBits, bufsize, (unsigned long)SvCUR(dictionary)) ;
#endif
    if ((s = InitStream() )) {

        err = BZ2_bzDecompressInit (&(s->stream), verbosity, small);
        if (err != BZ_OK) {
            Safefree(s) ;
            s = NULL ;
	}
	if (s) {
            int flags = 0;
            if (appendOut)
                flags |= FLAG_APPEND_OUTPUT;
            if (consume)
                flags |= FLAG_CONSUME_INPUT;
            if (limitOutput)
                flags |= (FLAG_LIMIT_OUTPUT|FLAG_CONSUME_INPUT);
	    PostInitStream(s, flags) ;
        }
    }
    else
	err = BZ_MEM_ERROR ;

    {
        SV* obj = sv_setref_pv(sv_newmortal(), className, (void*)s);
        XPUSHs(obj);
    }
       if (0)
    {
        SV* obj = sv_2mortal(newSViv(PTR2IV(s))) ;
        XPUSHs(obj);
    }
    if (GIMME == G_ARRAY) {
        SV * sv = sv_2mortal(newSViv(err)) ;
	setDUALstatus(sv, err);
        XPUSHs(sv) ;
    }
  }
#line 738 "Bzip2.c"
	PUTBACK;
	return;
    }
}


XS(XS_Compress__Raw__Bzip2_DispStream); /* prototype to pass -Wmissing-prototypes */
XS(XS_Compress__Raw__Bzip2_DispStream)
{
#ifdef dVAR
    dVAR; dXSARGS;
#else
    dXSARGS;
#endif
    if (items < 1 || items > 2)
       croak_xs_usage(cv,  "s, message=NULL");
    {
	Compress__Raw__Bzip2	s;
	char *	message;

	if (SvROK(ST(0)) && sv_derived_from(ST(0), "Compress::Raw::Bzip2")) {
	    IV tmp = SvIV((SV*)SvRV(ST(0)));
	    s = INT2PTR(Compress__Raw__Bzip2,tmp);
	}
	else
	    Perl_croak(aTHX_ "%s: %s is not of type %s",
			"Compress::Raw::Bzip2::DispStream",
			"s", "Compress::Raw::Bzip2");

	if (items < 2)
	    message = NULL;
	else {
	    if (SvOK(ST(1)))
	    message = (char *)SvPVbyte_nolen(ST(1));
	    else
	    message = NULL ;
	}

	DispStream(s, message);
    }
    XSRETURN_EMPTY;
}


XS(XS_Compress__Raw__Bzip2_bzdeflate); /* prototype to pass -Wmissing-prototypes */
XS(XS_Compress__Raw__Bzip2_bzdeflate)
{
#ifdef dVAR
    dVAR; dXSARGS;
#else
    dXSARGS;
#endif
    if (items != 3)
       croak_xs_usage(cv,  "s, buf, output");
    {
	Compress__Raw__Bzip2	s;
	SV *	buf = ST(1);
	SV *	output = ST(2);
	uInt	cur_length;
	uInt	increment;
	int	RETVAL = 0;
	uInt	bufinc;

	if (SvROK(ST(0)) && sv_derived_from(ST(0), "Compress::Raw::Bzip2")) {
	    IV tmp = SvIV((SV*)SvRV(ST(0)));
	    s = INT2PTR(Compress__Raw__Bzip2,tmp);
	}
	else
	    Perl_croak(aTHX_ "%s: %s is not of type %s",
			"Compress::Raw::Bzip2::bzdeflate",
			"s", "Compress::Raw::Bzip2");
#line 490 "Bzip2.xs"
    bufinc = s->bufsize;

    /* If the input buffer is a reference, dereference it */
    buf = deRef(buf, "deflate") ;

    /* initialise the input buffer */
#ifdef UTF8_AVAILABLE    
    if (DO_UTF8(buf) && !sv_utf8_downgrade(buf, 1))
         croak("Wide character in " COMPRESS_CLASS "::bzdeflate input parameter");
#endif         
    s->stream.next_in = (char*)SvPVbyte_nolen(buf) ;
    s->stream.avail_in = SvCUR(buf) ;

    /* and retrieve the output buffer */
    output = deRef_l(output, "deflate") ;
#ifdef UTF8_AVAILABLE    
    if (DO_UTF8(output) && !sv_utf8_downgrade(output, 1))
         croak("Wide character in " COMPRESS_CLASS "::bzdeflate output parameter");
#endif         

    if((s->flags & FLAG_APPEND_OUTPUT) != FLAG_APPEND_OUTPUT) {
        SvCUR_set(output, 0);
        /* sv_setpvn(output, "", 0); */
    }
    cur_length =  SvCUR(output) ;
    s->stream.next_out = (char*) SvPVbyte_nolen(output) + cur_length;
    increment =  SvLEN(output) -  cur_length;
    s->stream.avail_out =  increment;
    while (s->stream.avail_in != 0) {

        if (s->stream.avail_out == 0) {
	    /* out of space in the output buffer so make it bigger */
            Sv_Grow(output, SvLEN(output) + bufinc) ;
            cur_length += increment ;
            s->stream.next_out = (char*) SvPVbyte_nolen(output) + cur_length ;
            increment = bufinc ;
            s->stream.avail_out = increment;
            bufinc *= 2 ;
        }

        RETVAL = BZ2_bzCompress(&(s->stream), BZ_RUN);
        if (RETVAL != BZ_RUN_OK) 
            break;
    }

    s->compressedBytes    += cur_length + increment - s->stream.avail_out ;
    s->uncompressedBytes  += SvCUR(buf) - s->stream.avail_in  ;

    s->last_error = RETVAL ;
    if (RETVAL == BZ_RUN_OK) {
        SvPOK_only(output);
        SvCUR_set(output, cur_length + increment - s->stream.avail_out) ;
        SvSETMAGIC(output);
    }
#line 865 "Bzip2.c"
	ST(0) = sv_newmortal();
        setDUALstatus(ST(0), RETVAL) ;


    }
    XSRETURN(1);
}


XS(XS_Compress__Raw__Bzip2_DESTROY); /* prototype to pass -Wmissing-prototypes */
XS(XS_Compress__Raw__Bzip2_DESTROY)
{
#ifdef dVAR
    dVAR; dXSARGS;
#else
    dXSARGS;
#endif
    if (items != 1)
       croak_xs_usage(cv,  "s");
    {
	Compress__Raw__Bzip2	s;

	if (SvROK(ST(0))) {
	    IV tmp = SvIV((SV*)SvRV(ST(0)));
	    s = INT2PTR(Compress__Raw__Bzip2,tmp);
	}
	else
	    Perl_croak(aTHX_ "%s: %s is not a reference",
			"Compress::Raw::Bzip2::DESTROY",
			"s");
#line 552 "Bzip2.xs"
    BZ2_bzCompressEnd(&s->stream) ;
    Safefree(s) ;
#line 899 "Bzip2.c"
    }
    XSRETURN_EMPTY;
}


XS(XS_Compress__Raw__Bzip2_bzclose); /* prototype to pass -Wmissing-prototypes */
XS(XS_Compress__Raw__Bzip2_bzclose)
{
#ifdef dVAR
    dVAR; dXSARGS;
#else
    dXSARGS;
#endif
    if (items != 2)
       croak_xs_usage(cv,  "s, output");
    {
	Compress__Raw__Bzip2	s;
	SV *	output = ST(1);
	uInt	cur_length;
	uInt	increment;
	uInt	bufinc;
	DualType	RETVAL;

	if (SvROK(ST(0)) && sv_derived_from(ST(0), "Compress::Raw::Bzip2")) {
	    IV tmp = SvIV((SV*)SvRV(ST(0)));
	    s = INT2PTR(Compress__Raw__Bzip2,tmp);
	}
	else
	    Perl_croak(aTHX_ "%s: %s is not of type %s",
			"Compress::Raw::Bzip2::bzclose",
			"s", "Compress::Raw::Bzip2");
#line 564 "Bzip2.xs"
    bufinc = s->bufsize;

    s->stream.avail_in = 0; /* should be zero already anyway */

    /* retrieve the output buffer */
    output = deRef_l(output, "close") ;
#ifdef UTF8_AVAILABLE    
    if (DO_UTF8(output) && !sv_utf8_downgrade(output, 1))
         croak("Wide character in " COMPRESS_CLASS "::bzclose input parameter");
#endif         
    if(! s->flags & FLAG_APPEND_OUTPUT) {
        SvCUR_set(output, 0);
        /* sv_setpvn(output, "", 0); */
    }
    cur_length =  SvCUR(output) ;
    s->stream.next_out = (char*) SvPVbyte_nolen(output) + cur_length;
    increment =  SvLEN(output) -  cur_length;
    s->stream.avail_out =  increment;

    for (;;) {
        if (s->stream.avail_out == 0) {
	    /* consumed all the available output, so extend it */
            Sv_Grow(output, SvLEN(output) + bufinc) ;
            cur_length += increment ;
            s->stream.next_out = (char*) SvPVbyte_nolen(output) + cur_length ;
            increment = bufinc ;
            s->stream.avail_out = increment;
            bufinc *= 2 ;
        }
        RETVAL = BZ2_bzCompress(&(s->stream), BZ_FINISH);

        /* deflate has finished flushing only when it hasn't used up
         * all the available space in the output buffer: 
         */
        /* if (s->stream.avail_out != 0 || RETVAL < 0 ) */
        if (RETVAL == BZ_STREAM_END || RETVAL < 0 )
            break;
    }

    /* RETVAL =  (RETVAL == BZ_STREAM_END ? BZ_OK : RETVAL) ; */
    s->last_error = RETVAL ;

    s->compressedBytes    += cur_length + increment - s->stream.avail_out ;

    if (RETVAL == BZ_STREAM_END) {
        SvPOK_only(output);
        SvCUR_set(output, cur_length + increment - s->stream.avail_out) ;
        SvSETMAGIC(output);
    }
#line 981 "Bzip2.c"
	ST(0) = sv_newmortal();
        setDUALstatus(ST(0), RETVAL) ;


    }
    XSRETURN(1);
}


XS(XS_Compress__Raw__Bzip2_bzflush); /* prototype to pass -Wmissing-prototypes */
XS(XS_Compress__Raw__Bzip2_bzflush)
{
#ifdef dVAR
    dVAR; dXSARGS;
#else
    dXSARGS;
#endif
    if (items != 2)
       croak_xs_usage(cv,  "s, output");
    {
	Compress__Raw__Bzip2	s;
	SV *	output = ST(1);
	uInt	cur_length;
	uInt	increment;
	uInt	bufinc;
	DualType	RETVAL;

	if (SvROK(ST(0)) && sv_derived_from(ST(0), "Compress::Raw::Bzip2")) {
	    IV tmp = SvIV((SV*)SvRV(ST(0)));
	    s = INT2PTR(Compress__Raw__Bzip2,tmp);
	}
	else
	    Perl_croak(aTHX_ "%s: %s is not of type %s",
			"Compress::Raw::Bzip2::bzflush",
			"s", "Compress::Raw::Bzip2");
#line 625 "Bzip2.xs"
    bufinc = s->bufsize;

    s->stream.avail_in = 0; /* should be zero already anyway */

    /* retrieve the output buffer */
    output = deRef_l(output, "close") ;
#ifdef UTF8_AVAILABLE    
    if (DO_UTF8(output) && !sv_utf8_downgrade(output, 1))
         croak("Wide character in " COMPRESS_CLASS "::bzflush input parameter");
#endif         
    if(! s->flags & FLAG_APPEND_OUTPUT) {
        SvCUR_set(output, 0);
        /* sv_setpvn(output, "", 0); */
    }
    cur_length =  SvCUR(output) ;
    s->stream.next_out = (char*) SvPVbyte_nolen(output) + cur_length;
    increment =  SvLEN(output) -  cur_length;
    s->stream.avail_out =  increment;

    for (;;) {
        if (s->stream.avail_out == 0) {
	    /* consumed all the available output, so extend it */
            Sv_Grow(output, SvLEN(output) + bufinc) ;
            cur_length += increment ;
            s->stream.next_out = (char*) SvPVbyte_nolen(output) + cur_length ;
            increment = bufinc ;
            s->stream.avail_out = increment;
            bufinc *= 2 ;
        }
        RETVAL = BZ2_bzCompress(&(s->stream), BZ_FLUSH);

        if (RETVAL == BZ_RUN_OK || RETVAL < 0)
                break;

        /* deflate has finished flushing only when it hasn't used up
         * all the available space in the output buffer: 
         */
        /* RETVAL == if (s->stream.avail_out != 0 || RETVAL < 0 )
            break; */
    }

    /* RETVAL =  (RETVAL == BZ_STREAM_END ? BZ_OK : RETVAL) ; */
    s->last_error = RETVAL ;

    s->compressedBytes    += cur_length + increment - s->stream.avail_out ;

    if (RETVAL == BZ_RUN_OK) {
        SvPOK_only(output);
        SvCUR_set(output, cur_length + increment - s->stream.avail_out) ;
        SvSETMAGIC(output);
    }
#line 1069 "Bzip2.c"
	ST(0) = sv_newmortal();
        setDUALstatus(ST(0), RETVAL) ;


    }
    XSRETURN(1);
}


XS(XS_Compress__Raw__Bzip2_total_in_lo32); /* prototype to pass -Wmissing-prototypes */
XS(XS_Compress__Raw__Bzip2_total_in_lo32)
{
#ifdef dVAR
    dVAR; dXSARGS;
#else
    dXSARGS;
#endif
    if (items != 1)
       croak_xs_usage(cv,  "s");
    {
	Compress__Raw__Bzip2	s;
	uLong	RETVAL;
	dXSTARG;

	if (SvROK(ST(0)) && sv_derived_from(ST(0), "Compress::Raw::Bzip2")) {
	    IV tmp = SvIV((SV*)SvRV(ST(0)));
	    s = INT2PTR(Compress__Raw__Bzip2,tmp);
	}
	else
	    Perl_croak(aTHX_ "%s: %s is not of type %s",
			"Compress::Raw::Bzip2::total_in_lo32",
			"s", "Compress::Raw::Bzip2");
#line 683 "Bzip2.xs"
        RETVAL = s->stream.total_in_lo32 ;
#line 1104 "Bzip2.c"
	XSprePUSH; PUSHu((IV)RETVAL);
    }
    XSRETURN(1);
}


XS(XS_Compress__Raw__Bzip2_total_out_lo32); /* prototype to pass -Wmissing-prototypes */
XS(XS_Compress__Raw__Bzip2_total_out_lo32)
{
#ifdef dVAR
    dVAR; dXSARGS;
#else
    dXSARGS;
#endif
    if (items != 1)
       croak_xs_usage(cv,  "s");
    {
	Compress__Raw__Bzip2	s;
	uLong	RETVAL;
	dXSTARG;

	if (SvROK(ST(0)) && sv_derived_from(ST(0), "Compress::Raw::Bzip2")) {
	    IV tmp = SvIV((SV*)SvRV(ST(0)));
	    s = INT2PTR(Compress__Raw__Bzip2,tmp);
	}
	else
	    Perl_croak(aTHX_ "%s: %s is not of type %s",
			"Compress::Raw::Bzip2::total_out_lo32",
			"s", "Compress::Raw::Bzip2");
#line 691 "Bzip2.xs"
        RETVAL = s->stream.total_out_lo32 ;
#line 1136 "Bzip2.c"
	XSprePUSH; PUSHu((IV)RETVAL);
    }
    XSRETURN(1);
}


XS(XS_Compress__Raw__Bzip2_compressedBytes); /* prototype to pass -Wmissing-prototypes */
XS(XS_Compress__Raw__Bzip2_compressedBytes)
{
#ifdef dVAR
    dVAR; dXSARGS;
#else
    dXSARGS;
#endif
    if (items != 1)
       croak_xs_usage(cv,  "s");
    {
	Compress__Raw__Bzip2	s;
	uLong	RETVAL;
	dXSTARG;

	if (SvROK(ST(0)) && sv_derived_from(ST(0), "Compress::Raw::Bzip2")) {
	    IV tmp = SvIV((SV*)SvRV(ST(0)));
	    s = INT2PTR(Compress__Raw__Bzip2,tmp);
	}
	else
	    Perl_croak(aTHX_ "%s: %s is not of type %s",
			"Compress::Raw::Bzip2::compressedBytes",
			"s", "Compress::Raw::Bzip2");
#line 699 "Bzip2.xs"
        RETVAL = s->compressedBytes;
#line 1168 "Bzip2.c"
	XSprePUSH; PUSHu((IV)RETVAL);
    }
    XSRETURN(1);
}


XS(XS_Compress__Raw__Bzip2_uncompressedBytes); /* prototype to pass -Wmissing-prototypes */
XS(XS_Compress__Raw__Bzip2_uncompressedBytes)
{
#ifdef dVAR
    dVAR; dXSARGS;
#else
    dXSARGS;
#endif
    if (items != 1)
       croak_xs_usage(cv,  "s");
    {
	Compress__Raw__Bzip2	s;
	uLong	RETVAL;
	dXSTARG;

	if (SvROK(ST(0)) && sv_derived_from(ST(0), "Compress::Raw::Bzip2")) {
	    IV tmp = SvIV((SV*)SvRV(ST(0)));
	    s = INT2PTR(Compress__Raw__Bzip2,tmp);
	}
	else
	    Perl_croak(aTHX_ "%s: %s is not of type %s",
			"Compress::Raw::Bzip2::uncompressedBytes",
			"s", "Compress::Raw::Bzip2");
#line 707 "Bzip2.xs"
        RETVAL = s->uncompressedBytes;
#line 1200 "Bzip2.c"
	XSprePUSH; PUSHu((IV)RETVAL);
    }
    XSRETURN(1);
}


XS(XS_Compress__Raw__Bunzip2_DispStream); /* prototype to pass -Wmissing-prototypes */
XS(XS_Compress__Raw__Bunzip2_DispStream)
{
#ifdef dVAR
    dVAR; dXSARGS;
#else
    dXSARGS;
#endif
    if (items < 1 || items > 2)
       croak_xs_usage(cv,  "s, message=NULL");
    {
	Compress__Raw__Bunzip2	s;
	char *	message;

	if (SvROK(ST(0)) && sv_derived_from(ST(0), "Compress::Raw::Bunzip2")) {
	    IV tmp = SvIV((SV*)SvRV(ST(0)));
	    s = INT2PTR(Compress__Raw__Bunzip2,tmp);
	}
	else
	    Perl_croak(aTHX_ "%s: %s is not of type %s",
			"Compress::Raw::Bunzip2::DispStream",
			"s", "Compress::Raw::Bunzip2");

	if (items < 2)
	    message = NULL;
	else {
	    if (SvOK(ST(1)))
	    message = (char *)SvPVbyte_nolen(ST(1));
	    else
	    message = NULL ;
	}

	DispStream(s, message);
    }
    XSRETURN_EMPTY;
}


XS(XS_Compress__Raw__Bunzip2_bzinflate); /* prototype to pass -Wmissing-prototypes */
XS(XS_Compress__Raw__Bunzip2_bzinflate)
{
#ifdef dVAR
    dVAR; dXSARGS;
#else
    dXSARGS;
#endif
    if (items != 3)
       croak_xs_usage(cv,  "s, buf, output");
    {
	Compress__Raw__Bunzip2	s;
	SV *	buf = ST(1);
	SV *	output = ST(2);
	uInt	cur_length = 0;
	uInt	prefix_length = 0;
	uInt	increment = 0;
	STRLEN	stmp;
	uInt	bufinc;
#line 730 "Bzip2.xs"
#ifdef UTF8_AVAILABLE    
    bool	out_utf8  = FALSE;
#endif    
#line 1268 "Bzip2.c"
	DualType	RETVAL;

	if (SvROK(ST(0)) && sv_derived_from(ST(0), "Compress::Raw::Bunzip2")) {
	    IV tmp = SvIV((SV*)SvRV(ST(0)));
	    s = INT2PTR(Compress__Raw__Bunzip2,tmp);
	}
	else
	    Perl_croak(aTHX_ "%s: %s is not of type %s",
			"Compress::Raw::Bunzip2::bzinflate",
			"s", "Compress::Raw::Bunzip2");
#line 734 "Bzip2.xs"
    bufinc = s->bufsize;
    /* If the buffer is a reference, dereference it */
    buf = deRef(buf, "bzinflate") ;

    if (s->flags & FLAG_CONSUME_INPUT && SvREADONLY(buf))
        croak(UNCOMPRESS_CLASS "::bzinflate input parameter cannot be read-only when ConsumeInput is specified");
#ifdef UTF8_AVAILABLE    
    if (DO_UTF8(buf) && !sv_utf8_downgrade(buf, 1))
         croak("Wide character in " UNCOMPRESS_CLASS "::bzinflate input parameter");
#endif         

    /* initialise the input buffer */
    s->stream.next_in = (char*)SvPVbyte_force(buf, stmp) ;
    s->stream.avail_in = SvCUR(buf);

    /* and retrieve the output buffer */
    output = deRef_l(output, "bzinflate") ;
#ifdef UTF8_AVAILABLE    
    if (DO_UTF8(output))
         out_utf8 = TRUE ;
    if (DO_UTF8(output) && !sv_utf8_downgrade(output, 1))
         croak("Wide character in " UNCOMPRESS_CLASS "::bzinflate output parameter");
#endif         
    if((s->flags & FLAG_APPEND_OUTPUT) != FLAG_APPEND_OUTPUT) {
        SvCUR_set(output, 0);
    }

    /* Assume no output buffer - the code below will update if there is any available */
    s->stream.avail_out = 0;

    if (SvLEN(output)) {
        prefix_length = cur_length =  SvCUR(output) ;

        if (s->flags & FLAG_LIMIT_OUTPUT && SvLEN(output) - cur_length - 1 < bufinc)
        {
            Sv_Grow(output, bufinc + cur_length + 1) ;
        }

        /* Only setup the stream output pointers if there is spare 
           capacity in the outout SV
        */
        if (SvLEN(output) > cur_length + 1)
        {
            s->stream.next_out = (char*) SvPVbyte_nolen(output) + cur_length;
            increment = SvLEN(output) -  cur_length - 1;
            s->stream.avail_out = increment;
        }
    }

    s->bytesInflated = 0;

    RETVAL = BZ_OK;

    while (1) {

        if (s->stream.avail_out == 0) {
	    /* out of space in the output buffer so make it bigger */
            Sv_Grow(output, SvLEN(output) + bufinc + 1) ;
            cur_length += increment ;
            s->stream.next_out = (char*) SvPVbyte_nolen(output) + cur_length ;
            increment = bufinc ;
            s->stream.avail_out = increment;
            bufinc *= 2 ;
        }

        /* DispStream(s, "pre"); */
        RETVAL = BZ2_bzDecompress (&(s->stream));

        /* DispStream(s, "apres"); */
        if (RETVAL != BZ_OK || s->flags & FLAG_LIMIT_OUTPUT) 
            break ;

        if (s->stream.avail_out == 0)
            continue ;

        if (s->stream.avail_in == 0) {
            RETVAL = BZ_OK ;
            break ;
        }

    }

    s->last_error = RETVAL ;
    if (RETVAL == BZ_OK || RETVAL == BZ_STREAM_END) {
	unsigned in ;

        s->bytesInflated = cur_length + increment - s->stream.avail_out - prefix_length;
        s->uncompressedBytes += s->bytesInflated ;
        s->compressedBytes   += SvCUR(buf) - s->stream.avail_in  ;

        SvPOK_only(output);
        SvCUR_set(output, prefix_length + s->bytesInflated) ;
	*SvEND(output) = '\0';
#ifdef UTF8_AVAILABLE    
        if (out_utf8)
            sv_utf8_upgrade(output);
#endif        
        SvSETMAGIC(output);

	/* fix the input buffer */
	if (s->flags & FLAG_CONSUME_INPUT) {
	    in = s->stream.avail_in ;
	    SvCUR_set(buf, in) ;
	    if (in)
	        Move(s->stream.next_in, SvPVbyte_nolen(buf), in, char) ;	
            *SvEND(buf) = '\0';
            SvSETMAGIC(buf);
	}
    }
#line 1389 "Bzip2.c"
	ST(0) = sv_newmortal();
        setDUALstatus(ST(0), RETVAL) ;


    }
    XSRETURN(1);
}


XS(XS_Compress__Raw__Bunzip2_inflateCount); /* prototype to pass -Wmissing-prototypes */
XS(XS_Compress__Raw__Bunzip2_inflateCount)
{
#ifdef dVAR
    dVAR; dXSARGS;
#else
    dXSARGS;
#endif
    if (items != 1)
       croak_xs_usage(cv,  "s");
    {
	Compress__Raw__Bunzip2	s;
	uLong	RETVAL;
	dXSTARG;

	if (SvROK(ST(0)) && sv_derived_from(ST(0), "Compress::Raw::Bunzip2")) {
	    IV tmp = SvIV((SV*)SvRV(ST(0)));
	    s = INT2PTR(Compress__Raw__Bunzip2,tmp);
	}
	else
	    Perl_croak(aTHX_ "%s: %s is not of type %s",
			"Compress::Raw::Bunzip2::inflateCount",
			"s", "Compress::Raw::Bunzip2");
#line 850 "Bzip2.xs"
        RETVAL = s->bytesInflated;
#line 1424 "Bzip2.c"
	XSprePUSH; PUSHu((IV)RETVAL);
    }
    XSRETURN(1);
}


XS(XS_Compress__Raw__Bunzip2_DESTROY); /* prototype to pass -Wmissing-prototypes */
XS(XS_Compress__Raw__Bunzip2_DESTROY)
{
#ifdef dVAR
    dVAR; dXSARGS;
#else
    dXSARGS;
#endif
    if (items != 1)
       croak_xs_usage(cv,  "s");
    {
	Compress__Raw__Bunzip2	s;

	if (SvROK(ST(0))) {
	    IV tmp = SvIV((SV*)SvRV(ST(0)));
	    s = INT2PTR(Compress__Raw__Bunzip2,tmp);
	}
	else
	    Perl_croak(aTHX_ "%s: %s is not a reference",
			"Compress::Raw::Bunzip2::DESTROY",
			"s");
#line 859 "Bzip2.xs"
    BZ2_bzDecompressEnd(&s->stream) ;
    Safefree(s) ;
#line 1455 "Bzip2.c"
    }
    XSRETURN_EMPTY;
}


XS(XS_Compress__Raw__Bunzip2_status); /* prototype to pass -Wmissing-prototypes */
XS(XS_Compress__Raw__Bunzip2_status)
{
#ifdef dVAR
    dVAR; dXSARGS;
#else
    dXSARGS;
#endif
    if (items != 1)
       croak_xs_usage(cv,  "s");
    {
	Compress__Raw__Bunzip2	s;
	uLong	RETVAL;
	dXSTARG;

	if (SvROK(ST(0)) && sv_derived_from(ST(0), "Compress::Raw::Bunzip2")) {
	    IV tmp = SvIV((SV*)SvRV(ST(0)));
	    s = INT2PTR(Compress__Raw__Bunzip2,tmp);
	}
	else
	    Perl_croak(aTHX_ "%s: %s is not of type %s",
			"Compress::Raw::Bunzip2::status",
			"s", "Compress::Raw::Bunzip2");
#line 867 "Bzip2.xs"
	RETVAL = s->last_error ;
#line 1486 "Bzip2.c"
	XSprePUSH; PUSHu((IV)RETVAL);
    }
    XSRETURN(1);
}


XS(XS_Compress__Raw__Bunzip2_total_in_lo32); /* prototype to pass -Wmissing-prototypes */
XS(XS_Compress__Raw__Bunzip2_total_in_lo32)
{
#ifdef dVAR
    dVAR; dXSARGS;
#else
    dXSARGS;
#endif
    if (items != 1)
       croak_xs_usage(cv,  "s");
    {
	Compress__Raw__Bunzip2	s;
	uLong	RETVAL;
	dXSTARG;

	if (SvROK(ST(0)) && sv_derived_from(ST(0), "Compress::Raw::Bunzip2")) {
	    IV tmp = SvIV((SV*)SvRV(ST(0)));
	    s = INT2PTR(Compress__Raw__Bunzip2,tmp);
	}
	else
	    Perl_croak(aTHX_ "%s: %s is not of type %s",
			"Compress::Raw::Bunzip2::total_in_lo32",
			"s", "Compress::Raw::Bunzip2");
#line 875 "Bzip2.xs"
        RETVAL = s->stream.total_in_lo32 ;
#line 1518 "Bzip2.c"
	XSprePUSH; PUSHu((IV)RETVAL);
    }
    XSRETURN(1);
}


XS(XS_Compress__Raw__Bunzip2_total_out_lo32); /* prototype to pass -Wmissing-prototypes */
XS(XS_Compress__Raw__Bunzip2_total_out_lo32)
{
#ifdef dVAR
    dVAR; dXSARGS;
#else
    dXSARGS;
#endif
    if (items != 1)
       croak_xs_usage(cv,  "s");
    {
	Compress__Raw__Bunzip2	s;
	uLong	RETVAL;
	dXSTARG;

	if (SvROK(ST(0)) && sv_derived_from(ST(0), "Compress::Raw::Bunzip2")) {
	    IV tmp = SvIV((SV*)SvRV(ST(0)));
	    s = INT2PTR(Compress__Raw__Bunzip2,tmp);
	}
	else
	    Perl_croak(aTHX_ "%s: %s is not of type %s",
			"Compress::Raw::Bunzip2::total_out_lo32",
			"s", "Compress::Raw::Bunzip2");
#line 883 "Bzip2.xs"
        RETVAL = s->stream.total_out_lo32 ;
#line 1550 "Bzip2.c"
	XSprePUSH; PUSHu((IV)RETVAL);
    }
    XSRETURN(1);
}


XS(XS_Compress__Raw__Bunzip2_compressedBytes); /* prototype to pass -Wmissing-prototypes */
XS(XS_Compress__Raw__Bunzip2_compressedBytes)
{
#ifdef dVAR
    dVAR; dXSARGS;
#else
    dXSARGS;
#endif
    if (items != 1)
       croak_xs_usage(cv,  "s");
    {
	Compress__Raw__Bunzip2	s;
	uLong	RETVAL;
	dXSTARG;

	if (SvROK(ST(0)) && sv_derived_from(ST(0), "Compress::Raw::Bunzip2")) {
	    IV tmp = SvIV((SV*)SvRV(ST(0)));
	    s = INT2PTR(Compress__Raw__Bunzip2,tmp);
	}
	else
	    Perl_croak(aTHX_ "%s: %s is not of type %s",
			"Compress::Raw::Bunzip2::compressedBytes",
			"s", "Compress::Raw::Bunzip2");
#line 891 "Bzip2.xs"
        RETVAL = s->compressedBytes;
#line 1582 "Bzip2.c"
	XSprePUSH; PUSHu((IV)RETVAL);
    }
    XSRETURN(1);
}


XS(XS_Compress__Raw__Bunzip2_uncompressedBytes); /* prototype to pass -Wmissing-prototypes */
XS(XS_Compress__Raw__Bunzip2_uncompressedBytes)
{
#ifdef dVAR
    dVAR; dXSARGS;
#else
    dXSARGS;
#endif
    if (items != 1)
       croak_xs_usage(cv,  "s");
    {
	Compress__Raw__Bunzip2	s;
	uLong	RETVAL;
	dXSTARG;

	if (SvROK(ST(0)) && sv_derived_from(ST(0), "Compress::Raw::Bunzip2")) {
	    IV tmp = SvIV((SV*)SvRV(ST(0)));
	    s = INT2PTR(Compress__Raw__Bunzip2,tmp);
	}
	else
	    Perl_croak(aTHX_ "%s: %s is not of type %s",
			"Compress::Raw::Bunzip2::uncompressedBytes",
			"s", "Compress::Raw::Bunzip2");
#line 899 "Bzip2.xs"
        RETVAL = s->uncompressedBytes;
#line 1614 "Bzip2.c"
	XSprePUSH; PUSHu((IV)RETVAL);
    }
    XSRETURN(1);
}

#ifdef __cplusplus
extern "C"
#endif
XS(boot_Compress__Raw__Bzip2); /* prototype to pass -Wmissing-prototypes */
XS(boot_Compress__Raw__Bzip2)
{
#ifdef dVAR
    dVAR; dXSARGS;
#else
    dXSARGS;
#endif
#if (PERL_REVISION == 5 && PERL_VERSION < 9)
    char* file = __FILE__;
#else
    const char* file = __FILE__;
#endif

    PERL_UNUSED_VAR(cv); /* -W */
    PERL_UNUSED_VAR(items); /* -W */
#ifdef XS_APIVERSION_BOOTCHECK
    XS_APIVERSION_BOOTCHECK;
#endif
    XS_VERSION_BOOTCHECK ;

        newXS("Compress::Raw::Bzip2::constant", XS_Compress__Raw__Bzip2_constant, file);
        newXS("Compress::Raw::Bzip2::bzlibversion", XS_Compress__Raw__Bzip2_bzlibversion, file);
        newXS("Compress::Raw::Bzip2::new", XS_Compress__Raw__Bzip2_new, file);
        newXS("Compress::Raw::Bunzip2::new", XS_Compress__Raw__Bunzip2_new, file);
        newXS("Compress::Raw::Bzip2::DispStream", XS_Compress__Raw__Bzip2_DispStream, file);
        newXS("Compress::Raw::Bzip2::bzdeflate", XS_Compress__Raw__Bzip2_bzdeflate, file);
        newXS("Compress::Raw::Bzip2::DESTROY", XS_Compress__Raw__Bzip2_DESTROY, file);
        newXS("Compress::Raw::Bzip2::bzclose", XS_Compress__Raw__Bzip2_bzclose, file);
        newXS("Compress::Raw::Bzip2::bzflush", XS_Compress__Raw__Bzip2_bzflush, file);
        newXS("Compress::Raw::Bzip2::total_in_lo32", XS_Compress__Raw__Bzip2_total_in_lo32, file);
        newXS("Compress::Raw::Bzip2::total_out_lo32", XS_Compress__Raw__Bzip2_total_out_lo32, file);
        newXS("Compress::Raw::Bzip2::compressedBytes", XS_Compress__Raw__Bzip2_compressedBytes, file);
        newXS("Compress::Raw::Bzip2::uncompressedBytes", XS_Compress__Raw__Bzip2_uncompressedBytes, file);
        newXS("Compress::Raw::Bunzip2::DispStream", XS_Compress__Raw__Bunzip2_DispStream, file);
        newXS("Compress::Raw::Bunzip2::bzinflate", XS_Compress__Raw__Bunzip2_bzinflate, file);
        newXS("Compress::Raw::Bunzip2::inflateCount", XS_Compress__Raw__Bunzip2_inflateCount, file);
        newXS("Compress::Raw::Bunzip2::DESTROY", XS_Compress__Raw__Bunzip2_DESTROY, file);
        newXS("Compress::Raw::Bunzip2::status", XS_Compress__Raw__Bunzip2_status, file);
        newXS("Compress::Raw::Bunzip2::total_in_lo32", XS_Compress__Raw__Bunzip2_total_in_lo32, file);
        newXS("Compress::Raw::Bunzip2::total_out_lo32", XS_Compress__Raw__Bunzip2_total_out_lo32, file);
        newXS("Compress::Raw::Bunzip2::compressedBytes", XS_Compress__Raw__Bunzip2_compressedBytes, file);
        newXS("Compress::Raw::Bunzip2::uncompressedBytes", XS_Compress__Raw__Bunzip2_uncompressedBytes, file);

    /* Initialisation Section */

#line 348 "Bzip2.xs"
#ifndef NO_WRITEABLE_DATA
  trace = TRACE_DEFAULT ;
#endif
    /* Check this version of bzip2 is == 1 */
    if (BZ2_bzlibVersion()[0] != '1')
	croak(COMPRESS_CLASS " needs bzip2 version 1.x, you have %s\n", BZ2_bzlibVersion()) ;

#line 1677 "Bzip2.c"

    /* End of Initialisation Section */

#if (PERL_REVISION == 5 && PERL_VERSION >= 9)
  if (PL_unitcheckav)
       call_list(PL_scopestack_ix, PL_unitcheckav);
#endif
    XSRETURN_YES;
}

