/*
 * This file was generated automatically by ExtUtils::ParseXS version 2.2210 from the
 * contents of POSIX.xs. Do not edit this file, edit POSIX.xs instead.
 *
 *	ANY CHANGES MADE HERE WILL BE LOST! 
 *
 */

#line 1 "POSIX.xs"
#define PERL_EXT_POSIX

#ifdef NETWARE
	#define _POSIX_
	/*
	 * Ideally this should be somewhere down in the includes
	 * but putting it in other places is giving compiler errors.
	 * Also here I am unable to check for HAS_UNAME since it wouldn't have
	 * yet come into the file at this stage - sgp 18th Oct 2000
	 */
	#include <sys/utsname.h>
#endif	/* NETWARE */

#define PERL_NO_GET_CONTEXT

#include "EXTERN.h"
#define PERLIO_NOT_STDIO 1
#include "perl.h"
#include "XSUB.h"
#if defined(PERL_IMPLICIT_SYS)
#  undef signal
#  undef open
#  undef setmode
#  define open PerlLIO_open3
#endif
#include <ctype.h>
#ifdef I_DIRENT    /* XXX maybe better to just rely on perl.h? */
#include <dirent.h>
#endif
#include <errno.h>
#ifdef I_FLOAT
#include <float.h>
#endif
#ifdef I_LIMITS
#include <limits.h>
#endif
#include <locale.h>
#include <math.h>
#ifdef I_PWD
#include <pwd.h>
#endif
#include <setjmp.h>
#include <signal.h>
#include <stdarg.h>

#ifdef I_STDDEF
#include <stddef.h>
#endif

#ifdef I_UNISTD
#include <unistd.h>
#endif

/* XXX This comment is just to make I_TERMIO and I_SGTTY visible to
   metaconfig for future extension writers.  We don't use them in POSIX.
   (This is really sneaky :-)  --AD
*/
#if defined(I_TERMIOS)
#include <termios.h>
#endif
#ifdef I_STDLIB
#include <stdlib.h>
#endif
#ifndef __ultrix__
#include <string.h>
#endif
#include <sys/stat.h>
#include <sys/types.h>
#include <time.h>
#ifdef I_UNISTD
#include <unistd.h>
#endif
#include <fcntl.h>

#ifdef HAS_TZNAME
#  if !defined(WIN32) && !defined(__CYGWIN__) && !defined(NETWARE) && !defined(__UWIN__)
extern char *tzname[];
#  endif
#else
#if !defined(WIN32) && !defined(__UWIN__) || (defined(__MINGW32__) && !defined(tzname))
char *tzname[] = { "" , "" };
#endif
#endif

#ifndef PERL_UNUSED_DECL
#  ifdef HASATTRIBUTE
#    if (defined(__GNUC__) && defined(__cplusplus)) || defined(__INTEL_COMPILER)
#      define PERL_UNUSED_DECL
#    else
#      define PERL_UNUSED_DECL __attribute__((unused))
#    endif
#  else
#    define PERL_UNUSED_DECL
#  endif
#endif

#ifndef dNOOP
#define dNOOP extern int Perl___notused PERL_UNUSED_DECL
#endif

#ifndef dVAR
#define dVAR dNOOP
#endif

#if defined(__VMS) && !defined(__POSIX_SOURCE)
#  include <libdef.h>       /* LIB$_INVARG constant */
#  include <lib$routines.h> /* prototype for lib$ediv() */
#  include <starlet.h>      /* prototype for sys$gettim() */
#  if DECC_VERSION < 50000000
#    define pid_t int       /* old versions of DECC miss this in types.h */
#  endif

#  undef mkfifo
#  define mkfifo(a,b) (not_here("mkfifo"),-1)
#  define tzset() not_here("tzset")

#if ((__VMS_VER >= 70000000) && (__DECC_VER >= 50200000)) || (__CRTL_VER >= 70000000)
#    define HAS_TZNAME  /* shows up in VMS 7.0 or Dec C 5.6 */
#    include <utsname.h>
#  endif /* __VMS_VER >= 70000000 or Dec C 5.6 */

   /* The POSIX notion of ttyname() is better served by getname() under VMS */
   static char ttnambuf[64];
#  define ttyname(fd) (isatty(fd) > 0 ? getname(fd,ttnambuf,0) : NULL)

   /* The non-POSIX CRTL times() has void return type, so we just get the
      current time directly */
   clock_t vms_times(struct tms *bufptr) {
	dTHX;
	clock_t retval;
	/* Get wall time and convert to 10 ms intervals to
	 * produce the return value that the POSIX standard expects */
#  if defined(__DECC) && defined (__ALPHA)
#    include <ints.h>
	uint64 vmstime;
	_ckvmssts(sys$gettim(&vmstime));
	vmstime /= 100000;
	retval = vmstime & 0x7fffffff;
#  else
	/* (Older hw or ccs don't have an atomic 64-bit type, so we
	 * juggle 32-bit ints (and a float) to produce a time_t result
	 * with minimal loss of information.) */
	long int vmstime[2],remainder,divisor = 100000;
	_ckvmssts(sys$gettim((unsigned long int *)vmstime));
	vmstime[1] &= 0x7fff;  /* prevent overflow in EDIV */
	_ckvmssts(lib$ediv(&divisor,vmstime,(long int *)&retval,&remainder));
#  endif
	/* Fill in the struct tms using the CRTL routine . . .*/
	times((tbuffer_t *)bufptr);
	return (clock_t) retval;
   }
#  define times(t) vms_times(t)
#else
#if defined (__CYGWIN__)
#    define tzname _tzname
#endif
#if defined (WIN32) || defined (NETWARE)
#  undef mkfifo
#  define mkfifo(a,b) not_here("mkfifo")
#  define ttyname(a) (char*)not_here("ttyname")
#  define sigset_t long
#  define pid_t long
#  ifdef __BORLANDC__
#    define tzname _tzname
#  endif
#  ifdef _MSC_VER
#    define mode_t short
#  endif
#  ifdef __MINGW32__
#    define mode_t short
#    ifndef tzset
#      define tzset()		not_here("tzset")
#    endif
#    ifndef _POSIX_OPEN_MAX
#      define _POSIX_OPEN_MAX	FOPEN_MAX	/* XXX bogus ? */
#    endif
#  endif
#  define sigaction(a,b,c)	not_here("sigaction")
#  define sigpending(a)		not_here("sigpending")
#  define sigprocmask(a,b,c)	not_here("sigprocmask")
#  define sigsuspend(a)		not_here("sigsuspend")
#  define sigemptyset(a)	not_here("sigemptyset")
#  define sigaddset(a,b)	not_here("sigaddset")
#  define sigdelset(a,b)	not_here("sigdelset")
#  define sigfillset(a)		not_here("sigfillset")
#  define sigismember(a,b)	not_here("sigismember")
#ifndef NETWARE
#  undef setuid
#  undef setgid
#  define setuid(a)		not_here("setuid")
#  define setgid(a)		not_here("setgid")
#endif	/* NETWARE */
#else

#  ifndef HAS_MKFIFO
#    if defined(OS2)
#      define mkfifo(a,b) not_here("mkfifo")
#    else	/* !( defined OS2 ) */
#      ifndef mkfifo
#        define mkfifo(path, mode) (mknod((path), (mode) | S_IFIFO, 0))
#      endif
#    endif
#  endif /* !HAS_MKFIFO */

#  ifdef I_GRP
#    include <grp.h>
#  endif
#  include <sys/times.h>
#  ifdef HAS_UNAME
#    include <sys/utsname.h>
#  endif
#  include <sys/wait.h>
#  ifdef I_UTIME
#    include <utime.h>
#  endif
#endif /* WIN32 || NETWARE */
#endif /* __VMS */

#ifdef WIN32
   /* Perl on Windows assigns WSAGetLastError() return values to errno
    * (in win32/win32sck.c).  Therefore we need to map these values
    * back to standard symbolic names, but only for those names having
    * no existing value or an existing value >= 100. (VC++ 2010 defines
    * a group of names with values >= 100 in its errno.h which we *do*
    * need to redefine.) The Errno.pm module does a similar mapping.
    */
#  ifdef EWOULDBLOCK
#    undef EWOULDBLOCK
#  endif
#  define EWOULDBLOCK WSAEWOULDBLOCK
#  ifdef EINPROGRESS
#    undef EINPROGRESS
#  endif
#  define EINPROGRESS WSAEINPROGRESS
#  ifdef EALREADY
#    undef EALREADY
#  endif
#  define EALREADY WSAEALREADY
#  ifdef ENOTSOCK
#    undef ENOTSOCK
#  endif
#  define ENOTSOCK WSAENOTSOCK
#  ifdef EDESTADDRREQ
#    undef EDESTADDRREQ
#  endif
#  define EDESTADDRREQ WSAEDESTADDRREQ
#  ifdef EMSGSIZE
#    undef EMSGSIZE
#  endif
#  define EMSGSIZE WSAEMSGSIZE
#  ifdef EPROTOTYPE
#    undef EPROTOTYPE
#  endif
#  define EPROTOTYPE WSAEPROTOTYPE
#  ifdef ENOPROTOOPT
#    undef ENOPROTOOPT
#  endif
#  define ENOPROTOOPT WSAENOPROTOOPT
#  ifdef EPROTONOSUPPORT
#    undef EPROTONOSUPPORT
#  endif
#  define EPROTONOSUPPORT WSAEPROTONOSUPPORT
#  ifdef ESOCKTNOSUPPORT
#    undef ESOCKTNOSUPPORT
#  endif
#  define ESOCKTNOSUPPORT WSAESOCKTNOSUPPORT
#  ifdef EOPNOTSUPP
#    undef EOPNOTSUPP
#  endif
#  define EOPNOTSUPP WSAEOPNOTSUPP
#  ifdef EPFNOSUPPORT
#    undef EPFNOSUPPORT
#  endif
#  define EPFNOSUPPORT WSAEPFNOSUPPORT
#  ifdef EAFNOSUPPORT
#    undef EAFNOSUPPORT
#  endif
#  define EAFNOSUPPORT WSAEAFNOSUPPORT
#  ifdef EADDRINUSE
#    undef EADDRINUSE
#  endif
#  define EADDRINUSE WSAEADDRINUSE
#  ifdef EADDRNOTAVAIL
#    undef EADDRNOTAVAIL
#  endif
#  define EADDRNOTAVAIL WSAEADDRNOTAVAIL
#  ifdef ENETDOWN
#    undef ENETDOWN
#  endif
#  define ENETDOWN WSAENETDOWN
#  ifdef ENETUNREACH
#    undef ENETUNREACH
#  endif
#  define ENETUNREACH WSAENETUNREACH
#  ifdef ENETRESET
#    undef ENETRESET
#  endif
#  define ENETRESET WSAENETRESET
#  ifdef ECONNABORTED
#    undef ECONNABORTED
#  endif
#  define ECONNABORTED WSAECONNABORTED
#  ifdef ECONNRESET
#    undef ECONNRESET
#  endif
#  define ECONNRESET WSAECONNRESET
#  ifdef ENOBUFS
#    undef ENOBUFS
#  endif
#  define ENOBUFS WSAENOBUFS
#  ifdef EISCONN
#    undef EISCONN
#  endif
#  define EISCONN WSAEISCONN
#  ifdef ENOTCONN
#    undef ENOTCONN
#  endif
#  define ENOTCONN WSAENOTCONN
#  ifdef ESHUTDOWN
#    undef ESHUTDOWN
#  endif
#  define ESHUTDOWN WSAESHUTDOWN
#  ifdef ETOOMANYREFS
#    undef ETOOMANYREFS
#  endif
#  define ETOOMANYREFS WSAETOOMANYREFS
#  ifdef ETIMEDOUT
#    undef ETIMEDOUT
#  endif
#  define ETIMEDOUT WSAETIMEDOUT
#  ifdef ECONNREFUSED
#    undef ECONNREFUSED
#  endif
#  define ECONNREFUSED WSAECONNREFUSED
#  ifdef ELOOP
#    undef ELOOP
#  endif
#  define ELOOP WSAELOOP
#  ifdef EHOSTDOWN
#    undef EHOSTDOWN
#  endif
#  define EHOSTDOWN WSAEHOSTDOWN
#  ifdef EHOSTUNREACH
#    undef EHOSTUNREACH
#  endif
#  define EHOSTUNREACH WSAEHOSTUNREACH
#  ifdef EPROCLIM
#    undef EPROCLIM
#  endif
#  define EPROCLIM WSAEPROCLIM
#  ifdef EUSERS
#    undef EUSERS
#  endif
#  define EUSERS WSAEUSERS
#  ifdef EDQUOT
#    undef EDQUOT
#  endif
#  define EDQUOT WSAEDQUOT
#  ifdef ESTALE
#    undef ESTALE
#  endif
#  define ESTALE WSAESTALE
#  ifdef EREMOTE
#    undef EREMOTE
#  endif
#  define EREMOTE WSAEREMOTE
#  ifdef EDISCON
#    undef EDISCON
#  endif
#  define EDISCON WSAEDISCON
#endif

typedef int SysRet;
typedef long SysRetLong;
typedef sigset_t* POSIX__SigSet;
typedef HV* POSIX__SigAction;
#ifdef I_TERMIOS
typedef struct termios* POSIX__Termios;
#else /* Define termios types to int, and call not_here for the functions.*/
#define POSIX__Termios int
#define speed_t int
#define tcflag_t int
#define cc_t int
#define cfgetispeed(x) not_here("cfgetispeed")
#define cfgetospeed(x) not_here("cfgetospeed")
#define tcdrain(x) not_here("tcdrain")
#define tcflush(x,y) not_here("tcflush")
#define tcsendbreak(x,y) not_here("tcsendbreak")
#define cfsetispeed(x,y) not_here("cfsetispeed")
#define cfsetospeed(x,y) not_here("cfsetospeed")
#define ctermid(x) (char *) not_here("ctermid")
#define tcflow(x,y) not_here("tcflow")
#define tcgetattr(x,y) not_here("tcgetattr")
#define tcsetattr(x,y,z) not_here("tcsetattr")
#endif

/* Possibly needed prototypes */
#ifndef WIN32
double strtod (const char *, char **);
long strtol (const char *, char **, int);
unsigned long strtoul (const char *, char **, int);
#endif

#ifndef HAS_DIFFTIME
#ifndef difftime
#define difftime(a,b) not_here("difftime")
#endif
#endif
#ifndef HAS_FPATHCONF
#define fpathconf(f,n)	(SysRetLong) not_here("fpathconf")
#endif
#ifndef HAS_MKTIME
#define mktime(a) not_here("mktime")
#endif
#ifndef HAS_NICE
#define nice(a) not_here("nice")
#endif
#ifndef HAS_PATHCONF
#define pathconf(f,n)	(SysRetLong) not_here("pathconf")
#endif
#ifndef HAS_SYSCONF
#define sysconf(n)	(SysRetLong) not_here("sysconf")
#endif
#ifndef HAS_READLINK
#define readlink(a,b,c) not_here("readlink")
#endif
#ifndef HAS_SETPGID
#define setpgid(a,b) not_here("setpgid")
#endif
#ifndef HAS_SETSID
#define setsid() not_here("setsid")
#endif
#ifndef HAS_STRCOLL
#define strcoll(s1,s2) not_here("strcoll")
#endif
#ifndef HAS_STRTOD
#define strtod(s1,s2) not_here("strtod")
#endif
#ifndef HAS_STRTOL
#define strtol(s1,s2,b) not_here("strtol")
#endif
#ifndef HAS_STRTOUL
#define strtoul(s1,s2,b) not_here("strtoul")
#endif
#ifndef HAS_STRXFRM
#define strxfrm(s1,s2,n) not_here("strxfrm")
#endif
#ifndef HAS_TCGETPGRP
#define tcgetpgrp(a) not_here("tcgetpgrp")
#endif
#ifndef HAS_TCSETPGRP
#define tcsetpgrp(a,b) not_here("tcsetpgrp")
#endif
#ifndef HAS_TIMES
#ifndef NETWARE
#define times(a) not_here("times")
#endif	/* NETWARE */
#endif
#ifndef HAS_UNAME
#define uname(a) not_here("uname")
#endif
#ifndef HAS_WAITPID
#define waitpid(a,b,c) not_here("waitpid")
#endif

#ifndef HAS_MBLEN
#ifndef mblen
#define mblen(a,b) not_here("mblen")
#endif
#endif
#ifndef HAS_MBSTOWCS
#define mbstowcs(s, pwcs, n) not_here("mbstowcs")
#endif
#ifndef HAS_MBTOWC
#define mbtowc(pwc, s, n) not_here("mbtowc")
#endif
#ifndef HAS_WCSTOMBS
#define wcstombs(s, pwcs, n) not_here("wcstombs")
#endif
#ifndef HAS_WCTOMB
#define wctomb(s, wchar) not_here("wcstombs")
#endif
#if !defined(HAS_MBLEN) && !defined(HAS_MBSTOWCS) && !defined(HAS_MBTOWC) && !defined(HAS_WCSTOMBS) && !defined(HAS_WCTOMB)
/* If we don't have these functions, then we wouldn't have gotten a typedef
   for wchar_t, the wide character type.  Defining wchar_t allows the
   functions referencing it to compile.  Its actual type is then meaningless,
   since without the above functions, all sections using it end up calling
   not_here() and croak.  --Kaveh Ghazi (ghazi@noc.rutgers.edu) 9/18/94. */
#ifndef wchar_t
#define wchar_t char
#endif
#endif

#ifndef HAS_LOCALECONV
#define localeconv() not_here("localeconv")
#endif

#ifdef HAS_LONG_DOUBLE
#  if LONG_DOUBLESIZE > NVSIZE
#    undef HAS_LONG_DOUBLE  /* XXX until we figure out how to use them */
#  endif
#endif

#ifndef HAS_LONG_DOUBLE
#ifdef LDBL_MAX
#undef LDBL_MAX
#endif
#ifdef LDBL_MIN
#undef LDBL_MIN
#endif
#ifdef LDBL_EPSILON
#undef LDBL_EPSILON
#endif
#endif

/* Background: in most systems the low byte of the wait status
 * is the signal (the lowest 7 bits) and the coredump flag is
 * the eight bit, and the second lowest byte is the exit status.
 * BeOS bucks the trend and has the bytes in different order.
 * See beos/beos.c for how the reality is bent even in BeOS
 * to follow the traditional.  However, to make the POSIX
 * wait W*() macros to work in BeOS, we need to unbend the
 * reality back in place. --jhi */
/* In actual fact the code below is to blame here. Perl has an internal
 * representation of the exit status ($?), which it re-composes from the
 * OS's representation using the W*() POSIX macros. The code below
 * incorrectly uses the W*() macros on the internal representation,
 * which fails for OSs that have a different representation (namely BeOS
 * and Haiku). WMUNGE() is a hack that converts the internal
 * representation into the OS specific one, so that the W*() macros work
 * as expected. The better solution would be not to use the W*() macros
 * in the first place, though. -- Ingo Weinhold
 */
#if defined(__BEOS__) || defined(__HAIKU__)
#    define WMUNGE(x) (((x) & 0xFF00) >> 8 | ((x) & 0x00FF) << 8)
#else
#    define WMUNGE(x) (x)
#endif

static int
not_here(const char *s)
{
    croak("POSIX::%s not implemented on this architecture", s);
    return -1;
}

#include "const-c.inc"

static void
restore_sigmask(pTHX_ SV *osset_sv)
{
     /* Fortunately, restoring the signal mask can't fail, because
      * there's nothing we can do about it if it does -- we're not
      * supposed to return -1 from sigaction unless the disposition
      * was unaffected.
      */
     sigset_t *ossetp = (sigset_t *) SvPV_nolen( osset_sv );
     (void)sigprocmask(SIG_SETMASK, ossetp, (sigset_t *)0);
}

#ifdef WIN32

/*
 * (1) The CRT maintains its own copy of the environment, separate from
 * the Win32API copy.
 *
 * (2) CRT getenv() retrieves from this copy. CRT putenv() updates this
 * copy, and then calls SetEnvironmentVariableA() to update the Win32API
 * copy.
 *
 * (3) win32_getenv() and win32_putenv() call GetEnvironmentVariableA() and
 * SetEnvironmentVariableA() directly, bypassing the CRT copy of the
 * environment.
 *
 * (4) The CRT strftime() "%Z" implementation calls __tzset(). That
 * calls CRT tzset(), but only the first time it is called, and in turn
 * that uses CRT getenv("TZ") to retrieve the timezone info from the CRT
 * local copy of the environment and hence gets the original setting as
 * perl never updates the CRT copy when assigning to $ENV{TZ}.
 *
 * Therefore, we need to retrieve the value of $ENV{TZ} and call CRT
 * putenv() to update the CRT copy of the environment (if it is different)
 * whenever we're about to call tzset().
 *
 * In addition to all that, when perl is built with PERL_IMPLICIT_SYS
 * defined:
 *
 * (a) Each interpreter has its own copy of the environment inside the
 * perlhost structure. That allows applications that host multiple
 * independent Perl interpreters to isolate environment changes from
 * each other. (This is similar to how the perlhost mechanism keeps a
 * separate working directory for each Perl interpreter, so that calling
 * chdir() will not affect other interpreters.)
 *
 * (b) Only the first Perl interpreter instantiated within a process will
 * "write through" environment changes to the process environment.
 *
 * (c) Even the primary Perl interpreter won't update the CRT copy of the
 * the environment, only the Win32API copy (it calls win32_putenv()).
 *
 * As with CPerlHost::Getenv() and CPerlHost::Putenv() themselves, it makes
 * sense to only update the process environment when inside the main
 * interpreter, but we don't have access to CPerlHost's m_bTopLevel member
 * from here so we'll just have to check PL_curinterp instead.
 *
 * Therefore, we can simply #undef getenv() and putenv() so that those names
 * always refer to the CRT functions, and explicitly call win32_getenv() to
 * access perl's %ENV.
 *
 * We also #undef malloc() and free() to be sure we are using the CRT
 * functions otherwise under PERL_IMPLICIT_SYS they are redefined to calls
 * into VMem::Malloc() and VMem::Free() and all allocations will be freed
 * when the Perl interpreter is being destroyed so we'd end up with a pointer
 * into deallocated memory in environ[] if a program embedding a Perl
 * interpreter continues to operate even after the main Perl interpreter has
 * been destroyed.
 *
 * Note that we don't free() the malloc()ed memory unless and until we call
 * malloc() again ourselves because the CRT putenv() function simply puts its
 * pointer argument into the environ[] array (it doesn't make a copy of it)
 * so this memory must otherwise be leaked.
 */

#undef getenv
#undef putenv
#undef malloc
#undef free

static void
fix_win32_tzenv(void)
{
    static char* oldenv = NULL;
    char* newenv;
    const char* perl_tz_env = win32_getenv("TZ");
    const char* crt_tz_env = getenv("TZ");
    if (perl_tz_env == NULL)
        perl_tz_env = "";
    if (crt_tz_env == NULL)
        crt_tz_env = "";
    if (strcmp(perl_tz_env, crt_tz_env) != 0) {
        newenv = (char*)malloc((strlen(perl_tz_env) + 4) * sizeof(char));
        if (newenv != NULL) {
            sprintf(newenv, "TZ=%s", perl_tz_env);
            putenv(newenv);
            if (oldenv != NULL)
                free(oldenv);
            oldenv = newenv;
        }
    }
}

#endif

/*
 * my_tzset - wrapper to tzset() with a fix to make it work (better) on Win32.
 * This code is duplicated in the Time-Piece module, so any changes made here
 * should be made there too.
 */
static void
my_tzset(pTHX)
{
#ifdef WIN32
#if defined(USE_ITHREADS) && defined(PERL_IMPLICIT_SYS)
    if (PL_curinterp == aTHX)
#endif
        fix_win32_tzenv();
#endif
    tzset();
}

#line 681 "POSIX.c"
#ifndef PERL_UNUSED_VAR
#  define PERL_UNUSED_VAR(var) if (0) var = var
#endif

#ifndef PERL_ARGS_ASSERT_CROAK_XS_USAGE
#define PERL_ARGS_ASSERT_CROAK_XS_USAGE assert(cv); assert(params)

/* prototype to pass -Wmissing-prototypes */
STATIC void
S_croak_xs_usage(pTHX_ const CV *const cv, const char *const params);

STATIC void
S_croak_xs_usage(pTHX_ const CV *const cv, const char *const params)
{
    const GV *const gv = CvGV(cv);

    PERL_ARGS_ASSERT_CROAK_XS_USAGE;

    if (gv) {
        const char *const gvname = GvNAME(gv);
        const HV *const stash = GvSTASH(gv);
        const char *const hvname = stash ? HvNAME(stash) : NULL;

        if (hvname)
            Perl_croak(aTHX_ "Usage: %s::%s(%s)", hvname, gvname, params);
        else
            Perl_croak(aTHX_ "Usage: %s(%s)", gvname, params);
    } else {
        /* Pants. I don't think that it should be possible to get here. */
        Perl_croak(aTHX_ "Usage: CODE(0x%"UVxf")(%s)", PTR2UV(cv), params);
    }
}
#undef  PERL_ARGS_ASSERT_CROAK_XS_USAGE

#ifdef PERL_IMPLICIT_CONTEXT
#define croak_xs_usage(a,b)	S_croak_xs_usage(aTHX_ a,b)
#else
#define croak_xs_usage		S_croak_xs_usage
#endif

#endif

/* NOTE: the prototype of newXSproto() is different in versions of perls,
 * so we define a portable version of newXSproto()
 */
#ifdef newXS_flags
#define newXSproto_portable(name, c_impl, file, proto) newXS_flags(name, c_impl, file, proto, 0)
#else
#define newXSproto_portable(name, c_impl, file, proto) (PL_Sv=(SV*)newXS(name, c_impl, file), sv_setpv(PL_Sv, proto), (CV*)PL_Sv)
#endif /* !defined(newXS_flags) */

#line 733 "POSIX.c"

XS(XS_POSIX__SigSet_new); /* prototype to pass -Wmissing-prototypes */
XS(XS_POSIX__SigSet_new)
{
#ifdef dVAR
    dVAR; dXSARGS;
#else
    dXSARGS;
#endif
    PERL_UNUSED_VAR(cv); /* -W */
    {
	const char *	packname;
	POSIX__SigSet	RETVAL;

	if (items < 1)
	    packname = "POSIX::SigSet";
	else {
	    packname = (const char *)SvPV_nolen(ST(0));
	}
#line 677 "POSIX.xs"
	{
	    int i;
	    Newx(RETVAL, 1, sigset_t);
	    sigemptyset(RETVAL);
	    for (i = 1; i < items; i++)
		sigaddset(RETVAL, SvIV(ST(i)));
	}
#line 761 "POSIX.c"
	ST(0) = sv_newmortal();
	sv_setref_pv(ST(0), "POSIX::SigSet", (void*)RETVAL);
    }
    XSRETURN(1);
}


XS(XS_POSIX__SigSet_DESTROY); /* prototype to pass -Wmissing-prototypes */
XS(XS_POSIX__SigSet_DESTROY)
{
#ifdef dVAR
    dVAR; dXSARGS;
#else
    dXSARGS;
#endif
    if (items != 1)
       croak_xs_usage(cv,  "sigset");
    {
	POSIX__SigSet	sigset;

	if (SvROK(ST(0))) {
	    IV tmp = SvIV((SV*)SvRV(ST(0)));
	    sigset = INT2PTR(POSIX__SigSet,tmp);
	}
	else
	    Perl_croak(aTHX_ "%s: %s is not a reference",
			"POSIX::SigSet::DESTROY",
			"sigset");
#line 691 "POSIX.xs"
	Safefree(sigset);
#line 792 "POSIX.c"
    }
    XSRETURN_EMPTY;
}


XS(XS_POSIX__SigSet_addset); /* prototype to pass -Wmissing-prototypes */
XS(XS_POSIX__SigSet_addset)
{
#ifdef dVAR
    dVAR; dXSARGS;
#else
    dXSARGS;
#endif
    if (items != 2)
       croak_xs_usage(cv,  "sigset, sig");
    {
	POSIX__SigSet	sigset;
	int	sig = (int)SvIV(ST(1));
	SysRet	RETVAL;

	if (SvROK(ST(0)) && sv_derived_from(ST(0), "POSIX::SigSet")) {
	    IV tmp = SvIV((SV*)SvRV(ST(0)));
	    sigset = INT2PTR(POSIX__SigSet,tmp);
	}
	else
	    Perl_croak(aTHX_ "%s: %s is not of type %s",
			"POSIX::SigSet::addset",
			"sigset", "POSIX::SigSet");

	RETVAL = sigaddset(sigset, sig);
	ST(0) = sv_newmortal();
	if (RETVAL != -1) {
	    if (RETVAL == 0)
		sv_setpvn(ST(0), "0 but true", 10);
	    else
		sv_setiv(ST(0), (IV)RETVAL);
	}
    }
    XSRETURN(1);
}


XS(XS_POSIX__SigSet_delset); /* prototype to pass -Wmissing-prototypes */
XS(XS_POSIX__SigSet_delset)
{
#ifdef dVAR
    dVAR; dXSARGS;
#else
    dXSARGS;
#endif
    if (items != 2)
       croak_xs_usage(cv,  "sigset, sig");
    {
	POSIX__SigSet	sigset;
	int	sig = (int)SvIV(ST(1));
	SysRet	RETVAL;

	if (SvROK(ST(0)) && sv_derived_from(ST(0), "POSIX::SigSet")) {
	    IV tmp = SvIV((SV*)SvRV(ST(0)));
	    sigset = INT2PTR(POSIX__SigSet,tmp);
	}
	else
	    Perl_croak(aTHX_ "%s: %s is not of type %s",
			"POSIX::SigSet::delset",
			"sigset", "POSIX::SigSet");

	RETVAL = sigdelset(sigset, sig);
	ST(0) = sv_newmortal();
	if (RETVAL != -1) {
	    if (RETVAL == 0)
		sv_setpvn(ST(0), "0 but true", 10);
	    else
		sv_setiv(ST(0), (IV)RETVAL);
	}
    }
    XSRETURN(1);
}


XS(XS_POSIX__SigSet_emptyset); /* prototype to pass -Wmissing-prototypes */
XS(XS_POSIX__SigSet_emptyset)
{
#ifdef dVAR
    dVAR; dXSARGS;
#else
    dXSARGS;
#endif
    if (items != 1)
       croak_xs_usage(cv,  "sigset");
    {
	POSIX__SigSet	sigset;
	SysRet	RETVAL;

	if (SvROK(ST(0)) && sv_derived_from(ST(0), "POSIX::SigSet")) {
	    IV tmp = SvIV((SV*)SvRV(ST(0)));
	    sigset = INT2PTR(POSIX__SigSet,tmp);
	}
	else
	    Perl_croak(aTHX_ "%s: %s is not of type %s",
			"POSIX::SigSet::emptyset",
			"sigset", "POSIX::SigSet");

	RETVAL = sigemptyset(sigset);
	ST(0) = sv_newmortal();
	if (RETVAL != -1) {
	    if (RETVAL == 0)
		sv_setpvn(ST(0), "0 but true", 10);
	    else
		sv_setiv(ST(0), (IV)RETVAL);
	}
    }
    XSRETURN(1);
}


XS(XS_POSIX__SigSet_fillset); /* prototype to pass -Wmissing-prototypes */
XS(XS_POSIX__SigSet_fillset)
{
#ifdef dVAR
    dVAR; dXSARGS;
#else
    dXSARGS;
#endif
    if (items != 1)
       croak_xs_usage(cv,  "sigset");
    {
	POSIX__SigSet	sigset;
	SysRet	RETVAL;

	if (SvROK(ST(0)) && sv_derived_from(ST(0), "POSIX::SigSet")) {
	    IV tmp = SvIV((SV*)SvRV(ST(0)));
	    sigset = INT2PTR(POSIX__SigSet,tmp);
	}
	else
	    Perl_croak(aTHX_ "%s: %s is not of type %s",
			"POSIX::SigSet::fillset",
			"sigset", "POSIX::SigSet");

	RETVAL = sigfillset(sigset);
	ST(0) = sv_newmortal();
	if (RETVAL != -1) {
	    if (RETVAL == 0)
		sv_setpvn(ST(0), "0 but true", 10);
	    else
		sv_setiv(ST(0), (IV)RETVAL);
	}
    }
    XSRETURN(1);
}


XS(XS_POSIX__SigSet_ismember); /* prototype to pass -Wmissing-prototypes */
XS(XS_POSIX__SigSet_ismember)
{
#ifdef dVAR
    dVAR; dXSARGS;
#else
    dXSARGS;
#endif
    if (items != 2)
       croak_xs_usage(cv,  "sigset, sig");
    {
	POSIX__SigSet	sigset;
	int	sig = (int)SvIV(ST(1));
	int	RETVAL;
	dXSTARG;

	if (SvROK(ST(0)) && sv_derived_from(ST(0), "POSIX::SigSet")) {
	    IV tmp = SvIV((SV*)SvRV(ST(0)));
	    sigset = INT2PTR(POSIX__SigSet,tmp);
	}
	else
	    Perl_croak(aTHX_ "%s: %s is not of type %s",
			"POSIX::SigSet::ismember",
			"sigset", "POSIX::SigSet");

	RETVAL = sigismember(sigset, sig);
	XSprePUSH; PUSHi((IV)RETVAL);
    }
    XSRETURN(1);
}


XS(XS_POSIX__Termios_new); /* prototype to pass -Wmissing-prototypes */
XS(XS_POSIX__Termios_new)
{
#ifdef dVAR
    dVAR; dXSARGS;
#else
    dXSARGS;
#endif
    PERL_UNUSED_VAR(cv); /* -W */
    {
	const char *	packname;
	POSIX__Termios	RETVAL;

	if (items < 1)
	    packname = "POSIX::Termios";
	else {
	    packname = (const char *)SvPV_nolen(ST(0));
	}
#line 722 "POSIX.xs"
	{
#ifdef I_TERMIOS
	    Newx(RETVAL, 1, struct termios);
#else
	    not_here("termios");
        RETVAL = 0;
#endif
	}
#line 1003 "POSIX.c"
	ST(0) = sv_newmortal();
	sv_setref_pv(ST(0), "POSIX::Termios", (void*)RETVAL);
    }
    XSRETURN(1);
}


XS(XS_POSIX__Termios_DESTROY); /* prototype to pass -Wmissing-prototypes */
XS(XS_POSIX__Termios_DESTROY)
{
#ifdef dVAR
    dVAR; dXSARGS;
#else
    dXSARGS;
#endif
    if (items != 1)
       croak_xs_usage(cv,  "termios_ref");
    {
	POSIX__Termios	termios_ref;

	if (SvROK(ST(0))) {
	    IV tmp = SvIV((SV*)SvRV(ST(0)));
	    termios_ref = INT2PTR(POSIX__Termios,tmp);
	}
	else
	    Perl_croak(aTHX_ "%s: %s is not a reference",
			"POSIX::Termios::DESTROY",
			"termios_ref");
#line 737 "POSIX.xs"
#ifdef I_TERMIOS
	Safefree(termios_ref);
#else
	    not_here("termios");
#endif
#line 1038 "POSIX.c"
    }
    XSRETURN_EMPTY;
}


XS(XS_POSIX__Termios_getattr); /* prototype to pass -Wmissing-prototypes */
XS(XS_POSIX__Termios_getattr)
{
#ifdef dVAR
    dVAR; dXSARGS;
#else
    dXSARGS;
#endif
    if (items < 1 || items > 2)
       croak_xs_usage(cv,  "termios_ref, fd = 0");
    {
	POSIX__Termios	termios_ref;
	int	fd;
	SysRet	RETVAL;

	if (SvROK(ST(0)) && sv_derived_from(ST(0), "POSIX::Termios")) {
	    IV tmp = SvIV((SV*)SvRV(ST(0)));
	    termios_ref = INT2PTR(POSIX__Termios,tmp);
	}
	else
	    Perl_croak(aTHX_ "%s: %s is not of type %s",
			"POSIX::Termios::getattr",
			"termios_ref", "POSIX::Termios");

	if (items < 2)
	    fd = 0;
	else {
	    fd = (int)SvIV(ST(1));
	}
#line 748 "POSIX.xs"
	RETVAL = tcgetattr(fd, termios_ref);
#line 1075 "POSIX.c"
	ST(0) = sv_newmortal();
	if (RETVAL != -1) {
	    if (RETVAL == 0)
		sv_setpvn(ST(0), "0 but true", 10);
	    else
		sv_setiv(ST(0), (IV)RETVAL);
	}
    }
    XSRETURN(1);
}


XS(XS_POSIX__Termios_setattr); /* prototype to pass -Wmissing-prototypes */
XS(XS_POSIX__Termios_setattr)
{
#ifdef dVAR
    dVAR; dXSARGS;
#else
    dXSARGS;
#endif
    if (items < 1 || items > 3)
       croak_xs_usage(cv,  "termios_ref, fd = 0, optional_actions = 0");
    {
	POSIX__Termios	termios_ref;
	int	fd;
	int	optional_actions;
	SysRet	RETVAL;

	if (SvROK(ST(0)) && sv_derived_from(ST(0), "POSIX::Termios")) {
	    IV tmp = SvIV((SV*)SvRV(ST(0)));
	    termios_ref = INT2PTR(POSIX__Termios,tmp);
	}
	else
	    Perl_croak(aTHX_ "%s: %s is not of type %s",
			"POSIX::Termios::setattr",
			"termios_ref", "POSIX::Termios");

	if (items < 2)
	    fd = 0;
	else {
	    fd = (int)SvIV(ST(1));
	}

	if (items < 3)
	    optional_actions = 0;
	else {
	    optional_actions = (int)SvIV(ST(2));
	}
#line 758 "POSIX.xs"
	RETVAL = tcsetattr(fd, optional_actions, termios_ref);
#line 1126 "POSIX.c"
	ST(0) = sv_newmortal();
	if (RETVAL != -1) {
	    if (RETVAL == 0)
		sv_setpvn(ST(0), "0 but true", 10);
	    else
		sv_setiv(ST(0), (IV)RETVAL);
	}
    }
    XSRETURN(1);
}


XS(XS_POSIX__Termios_getispeed); /* prototype to pass -Wmissing-prototypes */
XS(XS_POSIX__Termios_getispeed)
{
#ifdef dVAR
    dVAR; dXSARGS;
#else
    dXSARGS;
#endif
    if (items != 1)
       croak_xs_usage(cv,  "termios_ref");
    {
	POSIX__Termios	termios_ref;
	speed_t	RETVAL;
	dXSTARG;

	if (SvROK(ST(0)) && sv_derived_from(ST(0), "POSIX::Termios")) {
	    IV tmp = SvIV((SV*)SvRV(ST(0)));
	    termios_ref = INT2PTR(POSIX__Termios,tmp);
	}
	else
	    Perl_croak(aTHX_ "%s: %s is not of type %s",
			"POSIX::Termios::getispeed",
			"termios_ref", "POSIX::Termios");

	RETVAL = cfgetispeed(termios_ref);
	XSprePUSH; PUSHi((IV)RETVAL);
    }
    XSRETURN(1);
}


XS(XS_POSIX__Termios_getospeed); /* prototype to pass -Wmissing-prototypes */
XS(XS_POSIX__Termios_getospeed)
{
#ifdef dVAR
    dVAR; dXSARGS;
#else
    dXSARGS;
#endif
    if (items != 1)
       croak_xs_usage(cv,  "termios_ref");
    {
	POSIX__Termios	termios_ref;
	speed_t	RETVAL;
	dXSTARG;

	if (SvROK(ST(0)) && sv_derived_from(ST(0), "POSIX::Termios")) {
	    IV tmp = SvIV((SV*)SvRV(ST(0)));
	    termios_ref = INT2PTR(POSIX__Termios,tmp);
	}
	else
	    Perl_croak(aTHX_ "%s: %s is not of type %s",
			"POSIX::Termios::getospeed",
			"termios_ref", "POSIX::Termios");

	RETVAL = cfgetospeed(termios_ref);
	XSprePUSH; PUSHi((IV)RETVAL);
    }
    XSRETURN(1);
}


XS(XS_POSIX__Termios_getiflag); /* prototype to pass -Wmissing-prototypes */
XS(XS_POSIX__Termios_getiflag)
{
#ifdef dVAR
    dVAR; dXSARGS;
#else
    dXSARGS;
#endif
    if (items != 1)
       croak_xs_usage(cv,  "termios_ref");
    {
	POSIX__Termios	termios_ref;
	tcflag_t	RETVAL;
	dXSTARG;

	if (SvROK(ST(0)) && sv_derived_from(ST(0), "POSIX::Termios")) {
	    IV tmp = SvIV((SV*)SvRV(ST(0)));
	    termios_ref = INT2PTR(POSIX__Termios,tmp);
	}
	else
	    Perl_croak(aTHX_ "%s: %s is not of type %s",
			"POSIX::Termios::getiflag",
			"termios_ref", "POSIX::Termios");
#line 774 "POSIX.xs"
#ifdef I_TERMIOS /* References a termios structure member so ifdef it out. */
	RETVAL = termios_ref->c_iflag;
#else
     not_here("getiflag");
     RETVAL = 0;
#endif
#line 1231 "POSIX.c"
	XSprePUSH; PUSHi((IV)RETVAL);
    }
    XSRETURN(1);
}


XS(XS_POSIX__Termios_getoflag); /* prototype to pass -Wmissing-prototypes */
XS(XS_POSIX__Termios_getoflag)
{
#ifdef dVAR
    dVAR; dXSARGS;
#else
    dXSARGS;
#endif
    if (items != 1)
       croak_xs_usage(cv,  "termios_ref");
    {
	POSIX__Termios	termios_ref;
	tcflag_t	RETVAL;
	dXSTARG;

	if (SvROK(ST(0)) && sv_derived_from(ST(0), "POSIX::Termios")) {
	    IV tmp = SvIV((SV*)SvRV(ST(0)));
	    termios_ref = INT2PTR(POSIX__Termios,tmp);
	}
	else
	    Perl_croak(aTHX_ "%s: %s is not of type %s",
			"POSIX::Termios::getoflag",
			"termios_ref", "POSIX::Termios");
#line 787 "POSIX.xs"
#ifdef I_TERMIOS /* References a termios structure member so ifdef it out. */
	RETVAL = termios_ref->c_oflag;
#else
     not_here("getoflag");
     RETVAL = 0;
#endif
#line 1268 "POSIX.c"
	XSprePUSH; PUSHi((IV)RETVAL);
    }
    XSRETURN(1);
}


XS(XS_POSIX__Termios_getcflag); /* prototype to pass -Wmissing-prototypes */
XS(XS_POSIX__Termios_getcflag)
{
#ifdef dVAR
    dVAR; dXSARGS;
#else
    dXSARGS;
#endif
    if (items != 1)
       croak_xs_usage(cv,  "termios_ref");
    {
	POSIX__Termios	termios_ref;
	tcflag_t	RETVAL;
	dXSTARG;

	if (SvROK(ST(0)) && sv_derived_from(ST(0), "POSIX::Termios")) {
	    IV tmp = SvIV((SV*)SvRV(ST(0)));
	    termios_ref = INT2PTR(POSIX__Termios,tmp);
	}
	else
	    Perl_croak(aTHX_ "%s: %s is not of type %s",
			"POSIX::Termios::getcflag",
			"termios_ref", "POSIX::Termios");
#line 800 "POSIX.xs"
#ifdef I_TERMIOS /* References a termios structure member so ifdef it out. */
	RETVAL = termios_ref->c_cflag;
#else
     not_here("getcflag");
     RETVAL = 0;
#endif
#line 1305 "POSIX.c"
	XSprePUSH; PUSHi((IV)RETVAL);
    }
    XSRETURN(1);
}


XS(XS_POSIX__Termios_getlflag); /* prototype to pass -Wmissing-prototypes */
XS(XS_POSIX__Termios_getlflag)
{
#ifdef dVAR
    dVAR; dXSARGS;
#else
    dXSARGS;
#endif
    if (items != 1)
       croak_xs_usage(cv,  "termios_ref");
    {
	POSIX__Termios	termios_ref;
	tcflag_t	RETVAL;
	dXSTARG;

	if (SvROK(ST(0)) && sv_derived_from(ST(0), "POSIX::Termios")) {
	    IV tmp = SvIV((SV*)SvRV(ST(0)));
	    termios_ref = INT2PTR(POSIX__Termios,tmp);
	}
	else
	    Perl_croak(aTHX_ "%s: %s is not of type %s",
			"POSIX::Termios::getlflag",
			"termios_ref", "POSIX::Termios");
#line 813 "POSIX.xs"
#ifdef I_TERMIOS /* References a termios structure member so ifdef it out. */
	RETVAL = termios_ref->c_lflag;
#else
     not_here("getlflag");
     RETVAL = 0;
#endif
#line 1342 "POSIX.c"
	XSprePUSH; PUSHi((IV)RETVAL);
    }
    XSRETURN(1);
}


XS(XS_POSIX__Termios_getcc); /* prototype to pass -Wmissing-prototypes */
XS(XS_POSIX__Termios_getcc)
{
#ifdef dVAR
    dVAR; dXSARGS;
#else
    dXSARGS;
#endif
    if (items != 2)
       croak_xs_usage(cv,  "termios_ref, ccix");
    {
	POSIX__Termios	termios_ref;
	unsigned int	ccix = (unsigned int)SvUV(ST(1));
	cc_t	RETVAL;
	dXSTARG;

	if (SvROK(ST(0)) && sv_derived_from(ST(0), "POSIX::Termios")) {
	    IV tmp = SvIV((SV*)SvRV(ST(0)));
	    termios_ref = INT2PTR(POSIX__Termios,tmp);
	}
	else
	    Perl_croak(aTHX_ "%s: %s is not of type %s",
			"POSIX::Termios::getcc",
			"termios_ref", "POSIX::Termios");
#line 827 "POSIX.xs"
#ifdef I_TERMIOS /* References a termios structure member so ifdef it out. */
	if (ccix >= NCCS)
	    croak("Bad getcc subscript");
	RETVAL = termios_ref->c_cc[ccix];
#else
     not_here("getcc");
     RETVAL = 0;
#endif
#line 1382 "POSIX.c"
	XSprePUSH; PUSHi((IV)RETVAL);
    }
    XSRETURN(1);
}


XS(XS_POSIX__Termios_setispeed); /* prototype to pass -Wmissing-prototypes */
XS(XS_POSIX__Termios_setispeed)
{
#ifdef dVAR
    dVAR; dXSARGS;
#else
    dXSARGS;
#endif
    if (items != 2)
       croak_xs_usage(cv,  "termios_ref, speed");
    {
	POSIX__Termios	termios_ref;
	speed_t	speed = (speed_t)SvIV(ST(1));
	SysRet	RETVAL;

	if (SvROK(ST(0)) && sv_derived_from(ST(0), "POSIX::Termios")) {
	    IV tmp = SvIV((SV*)SvRV(ST(0)));
	    termios_ref = INT2PTR(POSIX__Termios,tmp);
	}
	else
	    Perl_croak(aTHX_ "%s: %s is not of type %s",
			"POSIX::Termios::setispeed",
			"termios_ref", "POSIX::Termios");

	RETVAL = cfsetispeed(termios_ref, speed);
	ST(0) = sv_newmortal();
	if (RETVAL != -1) {
	    if (RETVAL == 0)
		sv_setpvn(ST(0), "0 but true", 10);
	    else
		sv_setiv(ST(0), (IV)RETVAL);
	}
    }
    XSRETURN(1);
}


XS(XS_POSIX__Termios_setospeed); /* prototype to pass -Wmissing-prototypes */
XS(XS_POSIX__Termios_setospeed)
{
#ifdef dVAR
    dVAR; dXSARGS;
#else
    dXSARGS;
#endif
    if (items != 2)
       croak_xs_usage(cv,  "termios_ref, speed");
    {
	POSIX__Termios	termios_ref;
	speed_t	speed = (speed_t)SvIV(ST(1));
	SysRet	RETVAL;

	if (SvROK(ST(0)) && sv_derived_from(ST(0), "POSIX::Termios")) {
	    IV tmp = SvIV((SV*)SvRV(ST(0)));
	    termios_ref = INT2PTR(POSIX__Termios,tmp);
	}
	else
	    Perl_croak(aTHX_ "%s: %s is not of type %s",
			"POSIX::Termios::setospeed",
			"termios_ref", "POSIX::Termios");

	RETVAL = cfsetospeed(termios_ref, speed);
	ST(0) = sv_newmortal();
	if (RETVAL != -1) {
	    if (RETVAL == 0)
		sv_setpvn(ST(0), "0 but true", 10);
	    else
		sv_setiv(ST(0), (IV)RETVAL);
	}
    }
    XSRETURN(1);
}


XS(XS_POSIX__Termios_setiflag); /* prototype to pass -Wmissing-prototypes */
XS(XS_POSIX__Termios_setiflag)
{
#ifdef dVAR
    dVAR; dXSARGS;
#else
    dXSARGS;
#endif
    if (items != 2)
       croak_xs_usage(cv,  "termios_ref, iflag");
    {
	POSIX__Termios	termios_ref;
	tcflag_t	iflag = (tcflag_t)SvIV(ST(1));

	if (SvROK(ST(0)) && sv_derived_from(ST(0), "POSIX::Termios")) {
	    IV tmp = SvIV((SV*)SvRV(ST(0)));
	    termios_ref = INT2PTR(POSIX__Termios,tmp);
	}
	else
	    Perl_croak(aTHX_ "%s: %s is not of type %s",
			"POSIX::Termios::setiflag",
			"termios_ref", "POSIX::Termios");
#line 853 "POSIX.xs"
#ifdef I_TERMIOS /* References a termios structure member so ifdef it out. */
	termios_ref->c_iflag = iflag;
#else
	    not_here("setiflag");
#endif
#line 1491 "POSIX.c"
    }
    XSRETURN_EMPTY;
}


XS(XS_POSIX__Termios_setoflag); /* prototype to pass -Wmissing-prototypes */
XS(XS_POSIX__Termios_setoflag)
{
#ifdef dVAR
    dVAR; dXSARGS;
#else
    dXSARGS;
#endif
    if (items != 2)
       croak_xs_usage(cv,  "termios_ref, oflag");
    {
	POSIX__Termios	termios_ref;
	tcflag_t	oflag = (tcflag_t)SvIV(ST(1));

	if (SvROK(ST(0)) && sv_derived_from(ST(0), "POSIX::Termios")) {
	    IV tmp = SvIV((SV*)SvRV(ST(0)));
	    termios_ref = INT2PTR(POSIX__Termios,tmp);
	}
	else
	    Perl_croak(aTHX_ "%s: %s is not of type %s",
			"POSIX::Termios::setoflag",
			"termios_ref", "POSIX::Termios");
#line 864 "POSIX.xs"
#ifdef I_TERMIOS /* References a termios structure member so ifdef it out. */
	termios_ref->c_oflag = oflag;
#else
	    not_here("setoflag");
#endif
#line 1525 "POSIX.c"
    }
    XSRETURN_EMPTY;
}


XS(XS_POSIX__Termios_setcflag); /* prototype to pass -Wmissing-prototypes */
XS(XS_POSIX__Termios_setcflag)
{
#ifdef dVAR
    dVAR; dXSARGS;
#else
    dXSARGS;
#endif
    if (items != 2)
       croak_xs_usage(cv,  "termios_ref, cflag");
    {
	POSIX__Termios	termios_ref;
	tcflag_t	cflag = (tcflag_t)SvIV(ST(1));

	if (SvROK(ST(0)) && sv_derived_from(ST(0), "POSIX::Termios")) {
	    IV tmp = SvIV((SV*)SvRV(ST(0)));
	    termios_ref = INT2PTR(POSIX__Termios,tmp);
	}
	else
	    Perl_croak(aTHX_ "%s: %s is not of type %s",
			"POSIX::Termios::setcflag",
			"termios_ref", "POSIX::Termios");
#line 875 "POSIX.xs"
#ifdef I_TERMIOS /* References a termios structure member so ifdef it out. */
	termios_ref->c_cflag = cflag;
#else
	    not_here("setcflag");
#endif
#line 1559 "POSIX.c"
    }
    XSRETURN_EMPTY;
}


XS(XS_POSIX__Termios_setlflag); /* prototype to pass -Wmissing-prototypes */
XS(XS_POSIX__Termios_setlflag)
{
#ifdef dVAR
    dVAR; dXSARGS;
#else
    dXSARGS;
#endif
    if (items != 2)
       croak_xs_usage(cv,  "termios_ref, lflag");
    {
	POSIX__Termios	termios_ref;
	tcflag_t	lflag = (tcflag_t)SvIV(ST(1));

	if (SvROK(ST(0)) && sv_derived_from(ST(0), "POSIX::Termios")) {
	    IV tmp = SvIV((SV*)SvRV(ST(0)));
	    termios_ref = INT2PTR(POSIX__Termios,tmp);
	}
	else
	    Perl_croak(aTHX_ "%s: %s is not of type %s",
			"POSIX::Termios::setlflag",
			"termios_ref", "POSIX::Termios");
#line 886 "POSIX.xs"
#ifdef I_TERMIOS /* References a termios structure member so ifdef it out. */
	termios_ref->c_lflag = lflag;
#else
	    not_here("setlflag");
#endif
#line 1593 "POSIX.c"
    }
    XSRETURN_EMPTY;
}


XS(XS_POSIX__Termios_setcc); /* prototype to pass -Wmissing-prototypes */
XS(XS_POSIX__Termios_setcc)
{
#ifdef dVAR
    dVAR; dXSARGS;
#else
    dXSARGS;
#endif
    if (items != 3)
       croak_xs_usage(cv,  "termios_ref, ccix, cc");
    {
	POSIX__Termios	termios_ref;
	unsigned int	ccix = (unsigned int)SvUV(ST(1));
	cc_t	cc = (cc_t)SvIV(ST(2));

	if (SvROK(ST(0)) && sv_derived_from(ST(0), "POSIX::Termios")) {
	    IV tmp = SvIV((SV*)SvRV(ST(0)));
	    termios_ref = INT2PTR(POSIX__Termios,tmp);
	}
	else
	    Perl_croak(aTHX_ "%s: %s is not of type %s",
			"POSIX::Termios::setcc",
			"termios_ref", "POSIX::Termios");
#line 898 "POSIX.xs"
#ifdef I_TERMIOS /* References a termios structure member so ifdef it out. */
	if (ccix >= NCCS)
	    croak("Bad setcc subscript");
	termios_ref->c_cc[ccix] = cc;
#else
	    not_here("setcc");
#endif
#line 1630 "POSIX.c"
    }
    XSRETURN_EMPTY;
}


/* INCLUDE:  Including 'const-xs.inc' from 'POSIX.xs' */


XS(XS_POSIX_constant); /* prototype to pass -Wmissing-prototypes */
XS(XS_POSIX_constant)
{
#ifdef dVAR
    dVAR; dXSARGS;
#else
    dXSARGS;
#endif
    if (items != 1)
       croak_xs_usage(cv,  "sv");
    PERL_UNUSED_VAR(ax); /* -Wall */
    SP -= items;
    {
	SV *	sv = ST(0);
#line 1293 "./const-xs.inc"
	const PERL_CONTEXT *cx = caller_cx(0, NULL);
	/* cx is NULL if we've been called from the top level. PL_curcop isn't
	   ideal, but it's much cheaper than other ways of not going SEGV.  */
	const COP *cop = cx ? cx->blk_oldcop : PL_curcop;
#line 1658 "POSIX.c"
#line 1298 "./const-xs.inc"
#ifndef SYMBIAN
	/* It's not obvious how to calculate this at C pre-processor time.
	   However, any compiler optimiser worth its salt should be able to
	   remove the dead code, and hopefully the now-obviously-unused static
	   function too.  */
	HV *constant_missing = (C_ARRAY_LENGTH(values_for_notfound) > 1)
	    ? get_missing_hash(aTHX) : NULL;
	if ((C_ARRAY_LENGTH(values_for_notfound) > 1)
	    ? hv_exists_ent(constant_missing, sv, 0) : 0) {
	    sv = newSVpvf("Your vendor has not defined POSIX macro %" SVf
			  ", used at %" COP_FILE_F " line %d\n", sv,
			  COP_FILE(cop), CopLINE(cop));
	} else
#endif
	{
	    sv = newSVpvf("%"SVf" is not a valid POSIX macro at %"
			  COP_FILE_F " line %d\n", sv, COP_FILE(cop), CopLINE(cop));
	}
	croak_sv(sv_2mortal(sv));
#line 1679 "POSIX.c"
	PUTBACK;
	return;
    }
}


/* INCLUDE: Returning to 'POSIX.xs' from 'const-xs.inc' */


XS(XS_POSIX_WEXITSTATUS); /* prototype to pass -Wmissing-prototypes */
XS(XS_POSIX_WEXITSTATUS)
{
#ifdef dVAR
    dVAR; dXSARGS;
#else
    dXSARGS;
#endif
    dXSI32;
    if (items != 1)
       croak_xs_usage(cv,  "status");
    {
	int	status = (int)SvIV(ST(0));
	int	RETVAL;
	dXSTARG;
#line 921 "POSIX.xs"
#if !defined(WEXITSTATUS) || !defined(WIFEXITED) || !defined(WIFSIGNALED) \
      || !defined(WIFSTOPPED) || !defined(WSTOPSIG) || !defined(WTERMSIG)
        RETVAL = 0; /* Silence compilers that notice this, but don't realise
		       that not_here() can't return.  */
#endif
	switch(ix) {
	case 0:
#ifdef WEXITSTATUS
	    RETVAL = WEXITSTATUS(WMUNGE(status));
#else
	    not_here("WEXITSTATUS");
#endif
	    break;
	case 1:
#ifdef WIFEXITED
	    RETVAL = WIFEXITED(WMUNGE(status));
#else
	    not_here("WIFEXITED");
#endif
	    break;
	case 2:
#ifdef WIFSIGNALED
	    RETVAL = WIFSIGNALED(WMUNGE(status));
#else
	    not_here("WIFSIGNALED");
#endif
	    break;
	case 3:
#ifdef WIFSTOPPED
	    RETVAL = WIFSTOPPED(WMUNGE(status));
#else
	    not_here("WIFSTOPPED");
#endif
	    break;
	case 4:
#ifdef WSTOPSIG
	    RETVAL = WSTOPSIG(WMUNGE(status));
#else
	    not_here("WSTOPSIG");
#endif
	    break;
	case 5:
#ifdef WTERMSIG
	    RETVAL = WTERMSIG(WMUNGE(status));
#else
	    not_here("WTERMSIG");
#endif
	    break;
	default:
	    Perl_croak(aTHX_ "Illegal alias %d for POSIX::W*", (int)ix);
	}
#line 1756 "POSIX.c"
	XSprePUSH; PUSHi((IV)RETVAL);
    }
    XSRETURN(1);
}


XS(XS_POSIX_isalnum); /* prototype to pass -Wmissing-prototypes */
XS(XS_POSIX_isalnum)
{
#ifdef dVAR
    dVAR; dXSARGS;
#else
    dXSARGS;
#endif
    if (items != 1)
       croak_xs_usage(cv,  "charstring");
    {
	SV *	charstring = ST(0);
#line 979 "POSIX.xs"
	STRLEN	len;
#line 1777 "POSIX.c"
	int	RETVAL;
	dXSTARG;
#line 981 "POSIX.xs"
	unsigned char *s = (unsigned char *) SvPV(charstring, len);
	unsigned char *e = s + len;
	for (RETVAL = 1; RETVAL && s < e; s++)
	    if (!isalnum(*s))
		RETVAL = 0;
#line 1786 "POSIX.c"
	XSprePUSH; PUSHi((IV)RETVAL);
    }
    XSRETURN(1);
}


XS(XS_POSIX_isalpha); /* prototype to pass -Wmissing-prototypes */
XS(XS_POSIX_isalpha)
{
#ifdef dVAR
    dVAR; dXSARGS;
#else
    dXSARGS;
#endif
    if (items != 1)
       croak_xs_usage(cv,  "charstring");
    {
	SV *	charstring = ST(0);
#line 993 "POSIX.xs"
	STRLEN	len;
#line 1807 "POSIX.c"
	int	RETVAL;
	dXSTARG;
#line 995 "POSIX.xs"
	unsigned char *s = (unsigned char *) SvPV(charstring, len);
	unsigned char *e = s + len;
	for (RETVAL = 1; RETVAL && s < e; s++)
	    if (!isalpha(*s))
		RETVAL = 0;
#line 1816 "POSIX.c"
	XSprePUSH; PUSHi((IV)RETVAL);
    }
    XSRETURN(1);
}


XS(XS_POSIX_iscntrl); /* prototype to pass -Wmissing-prototypes */
XS(XS_POSIX_iscntrl)
{
#ifdef dVAR
    dVAR; dXSARGS;
#else
    dXSARGS;
#endif
    if (items != 1)
       croak_xs_usage(cv,  "charstring");
    {
	SV *	charstring = ST(0);
#line 1007 "POSIX.xs"
	STRLEN	len;
#line 1837 "POSIX.c"
	int	RETVAL;
	dXSTARG;
#line 1009 "POSIX.xs"
	unsigned char *s = (unsigned char *) SvPV(charstring, len);
	unsigned char *e = s + len;
	for (RETVAL = 1; RETVAL && s < e; s++)
	    if (!iscntrl(*s))
		RETVAL = 0;
#line 1846 "POSIX.c"
	XSprePUSH; PUSHi((IV)RETVAL);
    }
    XSRETURN(1);
}


XS(XS_POSIX_isdigit); /* prototype to pass -Wmissing-prototypes */
XS(XS_POSIX_isdigit)
{
#ifdef dVAR
    dVAR; dXSARGS;
#else
    dXSARGS;
#endif
    if (items != 1)
       croak_xs_usage(cv,  "charstring");
    {
	SV *	charstring = ST(0);
#line 1021 "POSIX.xs"
	STRLEN	len;
#line 1867 "POSIX.c"
	int	RETVAL;
	dXSTARG;
#line 1023 "POSIX.xs"
	unsigned char *s = (unsigned char *) SvPV(charstring, len);
	unsigned char *e = s + len;
	for (RETVAL = 1; RETVAL && s < e; s++)
	    if (!isdigit(*s))
		RETVAL = 0;
#line 1876 "POSIX.c"
	XSprePUSH; PUSHi((IV)RETVAL);
    }
    XSRETURN(1);
}


XS(XS_POSIX_isgraph); /* prototype to pass -Wmissing-prototypes */
XS(XS_POSIX_isgraph)
{
#ifdef dVAR
    dVAR; dXSARGS;
#else
    dXSARGS;
#endif
    if (items != 1)
       croak_xs_usage(cv,  "charstring");
    {
	SV *	charstring = ST(0);
#line 1035 "POSIX.xs"
	STRLEN	len;
#line 1897 "POSIX.c"
	int	RETVAL;
	dXSTARG;
#line 1037 "POSIX.xs"
	unsigned char *s = (unsigned char *) SvPV(charstring, len);
	unsigned char *e = s + len;
	for (RETVAL = 1; RETVAL && s < e; s++)
	    if (!isgraph(*s))
		RETVAL = 0;
#line 1906 "POSIX.c"
	XSprePUSH; PUSHi((IV)RETVAL);
    }
    XSRETURN(1);
}


XS(XS_POSIX_islower); /* prototype to pass -Wmissing-prototypes */
XS(XS_POSIX_islower)
{
#ifdef dVAR
    dVAR; dXSARGS;
#else
    dXSARGS;
#endif
    if (items != 1)
       croak_xs_usage(cv,  "charstring");
    {
	SV *	charstring = ST(0);
#line 1049 "POSIX.xs"
	STRLEN	len;
#line 1927 "POSIX.c"
	int	RETVAL;
	dXSTARG;
#line 1051 "POSIX.xs"
	unsigned char *s = (unsigned char *) SvPV(charstring, len);
	unsigned char *e = s + len;
	for (RETVAL = 1; RETVAL && s < e; s++)
	    if (!islower(*s))
		RETVAL = 0;
#line 1936 "POSIX.c"
	XSprePUSH; PUSHi((IV)RETVAL);
    }
    XSRETURN(1);
}


XS(XS_POSIX_isprint); /* prototype to pass -Wmissing-prototypes */
XS(XS_POSIX_isprint)
{
#ifdef dVAR
    dVAR; dXSARGS;
#else
    dXSARGS;
#endif
    if (items != 1)
       croak_xs_usage(cv,  "charstring");
    {
	SV *	charstring = ST(0);
#line 1063 "POSIX.xs"
	STRLEN	len;
#line 1957 "POSIX.c"
	int	RETVAL;
	dXSTARG;
#line 1065 "POSIX.xs"
	unsigned char *s = (unsigned char *) SvPV(charstring, len);
	unsigned char *e = s + len;
	for (RETVAL = 1; RETVAL && s < e; s++)
	    if (!isprint(*s))
		RETVAL = 0;
#line 1966 "POSIX.c"
	XSprePUSH; PUSHi((IV)RETVAL);
    }
    XSRETURN(1);
}


XS(XS_POSIX_ispunct); /* prototype to pass -Wmissing-prototypes */
XS(XS_POSIX_ispunct)
{
#ifdef dVAR
    dVAR; dXSARGS;
#else
    dXSARGS;
#endif
    if (items != 1)
       croak_xs_usage(cv,  "charstring");
    {
	SV *	charstring = ST(0);
#line 1077 "POSIX.xs"
	STRLEN	len;
#line 1987 "POSIX.c"
	int	RETVAL;
	dXSTARG;
#line 1079 "POSIX.xs"
	unsigned char *s = (unsigned char *) SvPV(charstring, len);
	unsigned char *e = s + len;
	for (RETVAL = 1; RETVAL && s < e; s++)
	    if (!ispunct(*s))
		RETVAL = 0;
#line 1996 "POSIX.c"
	XSprePUSH; PUSHi((IV)RETVAL);
    }
    XSRETURN(1);
}


XS(XS_POSIX_isspace); /* prototype to pass -Wmissing-prototypes */
XS(XS_POSIX_isspace)
{
#ifdef dVAR
    dVAR; dXSARGS;
#else
    dXSARGS;
#endif
    if (items != 1)
       croak_xs_usage(cv,  "charstring");
    {
	SV *	charstring = ST(0);
#line 1091 "POSIX.xs"
	STRLEN	len;
#line 2017 "POSIX.c"
	int	RETVAL;
	dXSTARG;
#line 1093 "POSIX.xs"
	unsigned char *s = (unsigned char *) SvPV(charstring, len);
	unsigned char *e = s + len;
	for (RETVAL = 1; RETVAL && s < e; s++)
	    if (!isspace(*s))
		RETVAL = 0;
#line 2026 "POSIX.c"
	XSprePUSH; PUSHi((IV)RETVAL);
    }
    XSRETURN(1);
}


XS(XS_POSIX_isupper); /* prototype to pass -Wmissing-prototypes */
XS(XS_POSIX_isupper)
{
#ifdef dVAR
    dVAR; dXSARGS;
#else
    dXSARGS;
#endif
    if (items != 1)
       croak_xs_usage(cv,  "charstring");
    {
	SV *	charstring = ST(0);
#line 1105 "POSIX.xs"
	STRLEN	len;
#line 2047 "POSIX.c"
	int	RETVAL;
	dXSTARG;
#line 1107 "POSIX.xs"
	unsigned char *s = (unsigned char *) SvPV(charstring, len);
	unsigned char *e = s + len;
	for (RETVAL = 1; RETVAL && s < e; s++)
	    if (!isupper(*s))
		RETVAL = 0;
#line 2056 "POSIX.c"
	XSprePUSH; PUSHi((IV)RETVAL);
    }
    XSRETURN(1);
}


XS(XS_POSIX_isxdigit); /* prototype to pass -Wmissing-prototypes */
XS(XS_POSIX_isxdigit)
{
#ifdef dVAR
    dVAR; dXSARGS;
#else
    dXSARGS;
#endif
    if (items != 1)
       croak_xs_usage(cv,  "charstring");
    {
	SV *	charstring = ST(0);
#line 1119 "POSIX.xs"
	STRLEN	len;
#line 2077 "POSIX.c"
	int	RETVAL;
	dXSTARG;
#line 1121 "POSIX.xs"
	unsigned char *s = (unsigned char *) SvPV(charstring, len);
	unsigned char *e = s + len;
	for (RETVAL = 1; RETVAL && s < e; s++)
	    if (!isxdigit(*s))
		RETVAL = 0;
#line 2086 "POSIX.c"
	XSprePUSH; PUSHi((IV)RETVAL);
    }
    XSRETURN(1);
}


XS(XS_POSIX_open); /* prototype to pass -Wmissing-prototypes */
XS(XS_POSIX_open)
{
#ifdef dVAR
    dVAR; dXSARGS;
#else
    dXSARGS;
#endif
    if (items < 1 || items > 3)
       croak_xs_usage(cv,  "filename, flags = O_RDONLY, mode = 0666");
    {
	char *	filename = (char *)SvPV_nolen(ST(0));
	int	flags;
	Mode_t	mode;
	SysRet	RETVAL;

	if (items < 2)
	    flags = O_RDONLY;
	else {
	    flags = (int)SvIV(ST(1));
	}

	if (items < 3)
	    mode = 0666;
	else {
	    mode = (Mode_t)SvNV(ST(2));
	}
#line 1135 "POSIX.xs"
	if (flags & (O_APPEND|O_CREAT|O_TRUNC|O_RDWR|O_WRONLY|O_EXCL))
	    TAINT_PROPER("open");
	RETVAL = open(filename, flags, mode);
#line 2124 "POSIX.c"
	ST(0) = sv_newmortal();
	if (RETVAL != -1) {
	    if (RETVAL == 0)
		sv_setpvn(ST(0), "0 but true", 10);
	    else
		sv_setiv(ST(0), (IV)RETVAL);
	}
    }
    XSRETURN(1);
}


XS(XS_POSIX_localeconv); /* prototype to pass -Wmissing-prototypes */
XS(XS_POSIX_localeconv)
{
#ifdef dVAR
    dVAR; dXSARGS;
#else
    dXSARGS;
#endif
    if (items != 0)
       croak_xs_usage(cv,  "");
    {
	HV *	RETVAL;
#line 1145 "POSIX.xs"
#ifdef HAS_LOCALECONV
	struct lconv *lcbuf;
	RETVAL = newHV();
	sv_2mortal((SV*)RETVAL);
	if ((lcbuf = localeconv())) {
	    /* the strings */
	    if (lcbuf->decimal_point && *lcbuf->decimal_point)
		(void) hv_store(RETVAL, "decimal_point", 13,
		    newSVpv(lcbuf->decimal_point, 0), 0);
	    if (lcbuf->thousands_sep && *lcbuf->thousands_sep)
		(void) hv_store(RETVAL, "thousands_sep", 13,
		    newSVpv(lcbuf->thousands_sep, 0), 0);
#ifndef NO_LOCALECONV_GROUPING
	    if (lcbuf->grouping && *lcbuf->grouping)
		(void) hv_store(RETVAL, "grouping", 8,
		    newSVpv(lcbuf->grouping, 0), 0);
#endif
	    if (lcbuf->int_curr_symbol && *lcbuf->int_curr_symbol)
		(void) hv_store(RETVAL, "int_curr_symbol", 15,
		    newSVpv(lcbuf->int_curr_symbol, 0), 0);
	    if (lcbuf->currency_symbol && *lcbuf->currency_symbol)
		(void) hv_store(RETVAL, "currency_symbol", 15,
		    newSVpv(lcbuf->currency_symbol, 0), 0);
	    if (lcbuf->mon_decimal_point && *lcbuf->mon_decimal_point)
		(void) hv_store(RETVAL, "mon_decimal_point", 17,
		    newSVpv(lcbuf->mon_decimal_point, 0), 0);
#ifndef NO_LOCALECONV_MON_THOUSANDS_SEP
	    if (lcbuf->mon_thousands_sep && *lcbuf->mon_thousands_sep)
		(void) hv_store(RETVAL, "mon_thousands_sep", 17,
		    newSVpv(lcbuf->mon_thousands_sep, 0), 0);
#endif
#ifndef NO_LOCALECONV_MON_GROUPING
	    if (lcbuf->mon_grouping && *lcbuf->mon_grouping)
		(void) hv_store(RETVAL, "mon_grouping", 12,
		    newSVpv(lcbuf->mon_grouping, 0), 0);
#endif
	    if (lcbuf->positive_sign && *lcbuf->positive_sign)
		(void) hv_store(RETVAL, "positive_sign", 13,
		    newSVpv(lcbuf->positive_sign, 0), 0);
	    if (lcbuf->negative_sign && *lcbuf->negative_sign)
		(void) hv_store(RETVAL, "negative_sign", 13,
		    newSVpv(lcbuf->negative_sign, 0), 0);
	    /* the integers */
	    if (lcbuf->int_frac_digits != CHAR_MAX)
		(void) hv_store(RETVAL, "int_frac_digits", 15,
		    newSViv(lcbuf->int_frac_digits), 0);
	    if (lcbuf->frac_digits != CHAR_MAX)
		(void) hv_store(RETVAL, "frac_digits", 11,
		    newSViv(lcbuf->frac_digits), 0);
	    if (lcbuf->p_cs_precedes != CHAR_MAX)
		(void) hv_store(RETVAL, "p_cs_precedes", 13,
		    newSViv(lcbuf->p_cs_precedes), 0);
	    if (lcbuf->p_sep_by_space != CHAR_MAX)
		(void) hv_store(RETVAL, "p_sep_by_space", 14,
		    newSViv(lcbuf->p_sep_by_space), 0);
	    if (lcbuf->n_cs_precedes != CHAR_MAX)
		(void) hv_store(RETVAL, "n_cs_precedes", 13,
		    newSViv(lcbuf->n_cs_precedes), 0);
	    if (lcbuf->n_sep_by_space != CHAR_MAX)
		(void) hv_store(RETVAL, "n_sep_by_space", 14,
		    newSViv(lcbuf->n_sep_by_space), 0);
	    if (lcbuf->p_sign_posn != CHAR_MAX)
		(void) hv_store(RETVAL, "p_sign_posn", 11,
		    newSViv(lcbuf->p_sign_posn), 0);
	    if (lcbuf->n_sign_posn != CHAR_MAX)
		(void) hv_store(RETVAL, "n_sign_posn", 11,
		    newSViv(lcbuf->n_sign_posn), 0);
	}
#else
	localeconv(); /* A stub to call not_here(). */
#endif
#line 2221 "POSIX.c"
	ST(0) = newRV((SV*)RETVAL);
	sv_2mortal(ST(0));
    }
    XSRETURN(1);
}


XS(XS_POSIX_setlocale); /* prototype to pass -Wmissing-prototypes */
XS(XS_POSIX_setlocale)
{
#ifdef dVAR
    dVAR; dXSARGS;
#else
    dXSARGS;
#endif
    if (items < 1 || items > 2)
       croak_xs_usage(cv,  "category, locale = 0");
    {
	int	category = (int)SvIV(ST(0));
	char *	locale;
#line 1224 "POSIX.xs"
	char *		retval;
#line 2244 "POSIX.c"
	char *	RETVAL;
	dXSTARG;

	if (items < 2)
	    locale = 0;
	else {
	    locale = (char *)SvPV_nolen(ST(1));
	}
#line 1226 "POSIX.xs"
	retval = setlocale(category, locale);
	if (retval) {
	    /* Save retval since subsequent setlocale() calls
	     * may overwrite it. */
	    RETVAL = savepv(retval);
#ifdef USE_LOCALE_CTYPE
	    if (category == LC_CTYPE
#ifdef LC_ALL
		|| category == LC_ALL
#endif
		)
	    {
		char *newctype;
#ifdef LC_ALL
		if (category == LC_ALL)
		    newctype = setlocale(LC_CTYPE, NULL);
		else
#endif
		    newctype = RETVAL;
		new_ctype(newctype);
	    }
#endif /* USE_LOCALE_CTYPE */
#ifdef USE_LOCALE_COLLATE
	    if (category == LC_COLLATE
#ifdef LC_ALL
		|| category == LC_ALL
#endif
		)
	    {
		char *newcoll;
#ifdef LC_ALL
		if (category == LC_ALL)
		    newcoll = setlocale(LC_COLLATE, NULL);
		else
#endif
		    newcoll = RETVAL;
		new_collate(newcoll);
	    }
#endif /* USE_LOCALE_COLLATE */
#ifdef USE_LOCALE_NUMERIC
	    if (category == LC_NUMERIC
#ifdef LC_ALL
		|| category == LC_ALL
#endif
		)
	    {
		char *newnum;
#ifdef LC_ALL
		if (category == LC_ALL)
		    newnum = setlocale(LC_NUMERIC, NULL);
		else
#endif
		    newnum = RETVAL;
		new_numeric(newnum);
	    }
#endif /* USE_LOCALE_NUMERIC */
	}
	else
	    RETVAL = NULL;
#line 2313 "POSIX.c"
	sv_setpv(TARG, RETVAL); XSprePUSH; PUSHTARG;
#line 1288 "POSIX.xs"
        if (RETVAL)
	    Safefree(RETVAL);
#line 2318 "POSIX.c"
    }
    XSRETURN(1);
}


XS(XS_POSIX_acos); /* prototype to pass -Wmissing-prototypes */
XS(XS_POSIX_acos)
{
#ifdef dVAR
    dVAR; dXSARGS;
#else
    dXSARGS;
#endif
    if (items != 1)
       croak_xs_usage(cv,  "x");
    {
	NV	x = (NV)SvNV(ST(0));
	NV	RETVAL;
	dXSTARG;

	RETVAL = acos(x);
	XSprePUSH; PUSHn((NV)RETVAL);
    }
    XSRETURN(1);
}


XS(XS_POSIX_asin); /* prototype to pass -Wmissing-prototypes */
XS(XS_POSIX_asin)
{
#ifdef dVAR
    dVAR; dXSARGS;
#else
    dXSARGS;
#endif
    if (items != 1)
       croak_xs_usage(cv,  "x");
    {
	NV	x = (NV)SvNV(ST(0));
	NV	RETVAL;
	dXSTARG;

	RETVAL = asin(x);
	XSprePUSH; PUSHn((NV)RETVAL);
    }
    XSRETURN(1);
}


XS(XS_POSIX_atan); /* prototype to pass -Wmissing-prototypes */
XS(XS_POSIX_atan)
{
#ifdef dVAR
    dVAR; dXSARGS;
#else
    dXSARGS;
#endif
    if (items != 1)
       croak_xs_usage(cv,  "x");
    {
	NV	x = (NV)SvNV(ST(0));
	NV	RETVAL;
	dXSTARG;

	RETVAL = atan(x);
	XSprePUSH; PUSHn((NV)RETVAL);
    }
    XSRETURN(1);
}


XS(XS_POSIX_ceil); /* prototype to pass -Wmissing-prototypes */
XS(XS_POSIX_ceil)
{
#ifdef dVAR
    dVAR; dXSARGS;
#else
    dXSARGS;
#endif
    if (items != 1)
       croak_xs_usage(cv,  "x");
    {
	NV	x = (NV)SvNV(ST(0));
	NV	RETVAL;
	dXSTARG;

	RETVAL = ceil(x);
	XSprePUSH; PUSHn((NV)RETVAL);
    }
    XSRETURN(1);
}


XS(XS_POSIX_cosh); /* prototype to pass -Wmissing-prototypes */
XS(XS_POSIX_cosh)
{
#ifdef dVAR
    dVAR; dXSARGS;
#else
    dXSARGS;
#endif
    if (items != 1)
       croak_xs_usage(cv,  "x");
    {
	NV	x = (NV)SvNV(ST(0));
	NV	RETVAL;
	dXSTARG;

	RETVAL = cosh(x);
	XSprePUSH; PUSHn((NV)RETVAL);
    }
    XSRETURN(1);
}


XS(XS_POSIX_floor); /* prototype to pass -Wmissing-prototypes */
XS(XS_POSIX_floor)
{
#ifdef dVAR
    dVAR; dXSARGS;
#else
    dXSARGS;
#endif
    if (items != 1)
       croak_xs_usage(cv,  "x");
    {
	NV	x = (NV)SvNV(ST(0));
	NV	RETVAL;
	dXSTARG;

	RETVAL = floor(x);
	XSprePUSH; PUSHn((NV)RETVAL);
    }
    XSRETURN(1);
}


XS(XS_POSIX_fmod); /* prototype to pass -Wmissing-prototypes */
XS(XS_POSIX_fmod)
{
#ifdef dVAR
    dVAR; dXSARGS;
#else
    dXSARGS;
#endif
    if (items != 2)
       croak_xs_usage(cv,  "x, y");
    {
	NV	x = (NV)SvNV(ST(0));
	NV	y = (NV)SvNV(ST(1));
	NV	RETVAL;
	dXSTARG;

	RETVAL = fmod(x, y);
	XSprePUSH; PUSHn((NV)RETVAL);
    }
    XSRETURN(1);
}


XS(XS_POSIX_frexp); /* prototype to pass -Wmissing-prototypes */
XS(XS_POSIX_frexp)
{
#ifdef dVAR
    dVAR; dXSARGS;
#else
    dXSARGS;
#endif
    if (items != 1)
       croak_xs_usage(cv,  "x");
    PERL_UNUSED_VAR(ax); /* -Wall */
    SP -= items;
    {
	NV	x = (NV)SvNV(ST(0));
#line 1324 "POSIX.xs"
	int expvar;
	/* (We already know stack is long enough.) */
	PUSHs(sv_2mortal(newSVnv(frexp(x,&expvar))));
	PUSHs(sv_2mortal(newSViv(expvar)));
#line 2498 "POSIX.c"
	PUTBACK;
	return;
    }
}


XS(XS_POSIX_ldexp); /* prototype to pass -Wmissing-prototypes */
XS(XS_POSIX_ldexp)
{
#ifdef dVAR
    dVAR; dXSARGS;
#else
    dXSARGS;
#endif
    if (items != 2)
       croak_xs_usage(cv,  "x, exp");
    {
	NV	x = (NV)SvNV(ST(0));
	int	exp = (int)SvIV(ST(1));
	NV	RETVAL;
	dXSTARG;

	RETVAL = ldexp(x, exp);
	XSprePUSH; PUSHn((NV)RETVAL);
    }
    XSRETURN(1);
}


XS(XS_POSIX_log10); /* prototype to pass -Wmissing-prototypes */
XS(XS_POSIX_log10)
{
#ifdef dVAR
    dVAR; dXSARGS;
#else
    dXSARGS;
#endif
    if (items != 1)
       croak_xs_usage(cv,  "x");
    {
	NV	x = (NV)SvNV(ST(0));
	NV	RETVAL;
	dXSTARG;

	RETVAL = log10(x);
	XSprePUSH; PUSHn((NV)RETVAL);
    }
    XSRETURN(1);
}


XS(XS_POSIX_modf); /* prototype to pass -Wmissing-prototypes */
XS(XS_POSIX_modf)
{
#ifdef dVAR
    dVAR; dXSARGS;
#else
    dXSARGS;
#endif
    if (items != 1)
       croak_xs_usage(cv,  "x");
    PERL_UNUSED_VAR(ax); /* -Wall */
    SP -= items;
    {
	NV	x = (NV)SvNV(ST(0));
#line 1342 "POSIX.xs"
	NV intvar;
	/* (We already know stack is long enough.) */
	PUSHs(sv_2mortal(newSVnv(Perl_modf(x,&intvar))));
	PUSHs(sv_2mortal(newSVnv(intvar)));
#line 2569 "POSIX.c"
	PUTBACK;
	return;
    }
}


XS(XS_POSIX_sinh); /* prototype to pass -Wmissing-prototypes */
XS(XS_POSIX_sinh)
{
#ifdef dVAR
    dVAR; dXSARGS;
#else
    dXSARGS;
#endif
    if (items != 1)
       croak_xs_usage(cv,  "x");
    {
	NV	x = (NV)SvNV(ST(0));
	NV	RETVAL;
	dXSTARG;

	RETVAL = sinh(x);
	XSprePUSH; PUSHn((NV)RETVAL);
    }
    XSRETURN(1);
}


XS(XS_POSIX_tan); /* prototype to pass -Wmissing-prototypes */
XS(XS_POSIX_tan)
{
#ifdef dVAR
    dVAR; dXSARGS;
#else
    dXSARGS;
#endif
    if (items != 1)
       croak_xs_usage(cv,  "x");
    {
	NV	x = (NV)SvNV(ST(0));
	NV	RETVAL;
	dXSTARG;

	RETVAL = tan(x);
	XSprePUSH; PUSHn((NV)RETVAL);
    }
    XSRETURN(1);
}


XS(XS_POSIX_tanh); /* prototype to pass -Wmissing-prototypes */
XS(XS_POSIX_tanh)
{
#ifdef dVAR
    dVAR; dXSARGS;
#else
    dXSARGS;
#endif
    if (items != 1)
       croak_xs_usage(cv,  "x");
    {
	NV	x = (NV)SvNV(ST(0));
	NV	RETVAL;
	dXSTARG;

	RETVAL = tanh(x);
	XSprePUSH; PUSHn((NV)RETVAL);
    }
    XSRETURN(1);
}


XS(XS_POSIX_sigaction); /* prototype to pass -Wmissing-prototypes */
XS(XS_POSIX_sigaction)
{
#ifdef dVAR
    dVAR; dXSARGS;
#else
    dXSARGS;
#endif
    if (items < 2 || items > 3)
       croak_xs_usage(cv,  "sig, optaction, oldaction = 0");
    {
	int	sig = (int)SvIV(ST(0));
	SV *	optaction = ST(1);
	POSIX__SigAction	oldaction;
	SysRet	RETVAL;

	if (items < 3)
	    oldaction = 0;
	else {
	    STMT_START {
		    SV* const xsub_tmp_sv = ST(2);
		    SvGETMAGIC(xsub_tmp_sv);
		    if (SvROK(xsub_tmp_sv) && SvTYPE(SvRV(xsub_tmp_sv)) == SVt_PVHV){
			oldaction = (HV*)SvRV(xsub_tmp_sv);
		    }
		    else{
			Perl_croak(aTHX_ "%s: %s is not a HASH reference",
				    "POSIX::sigaction",
				    "oldaction");
		    }
	    } STMT_END;
	}
#line 1365 "POSIX.xs"
#if defined(WIN32) || defined(NETWARE)
	RETVAL = not_here("sigaction");
#else

	{
	    dVAR;
	    POSIX__SigAction action;
	    GV *siggv = gv_fetchpvs("SIG", GV_ADD, SVt_PVHV);
	    struct sigaction act;
	    struct sigaction oact;
	    sigset_t sset;
	    SV *osset_sv;
	    sigset_t osset;
	    POSIX__SigSet sigset;
	    SV** svp;
	    SV** sigsvp;

            if (sig < 0) {
                croak("Negative signals are not allowed");
            }

	    if (sig == 0 && SvPOK(ST(0))) {
	        const char *s = SvPVX_const(ST(0));
		int i = whichsig(s);

	        if (i < 0 && memEQ(s, "SIG", 3))
		    i = whichsig(s + 3);
	        if (i < 0) {
	            if (ckWARN(WARN_SIGNAL))
		        Perl_warner(aTHX_ packWARN(WARN_SIGNAL),
                                    "No such signal: SIG%s", s);
	            XSRETURN_UNDEF;
		}
	        else
		    sig = i;
            }
#ifdef NSIG
	    if (sig > NSIG) { /* NSIG - 1 is still okay. */
	        Perl_warner(aTHX_ packWARN(WARN_SIGNAL),
                            "No such signal: %d", sig);
	        XSRETURN_UNDEF;
	    }
#endif
	    sigsvp = hv_fetch(GvHVn(siggv),
			      PL_sig_name[sig],
			      strlen(PL_sig_name[sig]),
			      TRUE);

	    /* Check optaction and set action */
	    if(SvTRUE(optaction)) {
		if(sv_isa(optaction, "POSIX::SigAction"))
			action = (HV*)SvRV(optaction);
		else
			croak("action is not of type POSIX::SigAction");
	    }
	    else {
		action=0;
	    }

	    /* sigaction() is supposed to look atomic. In particular, any
	     * signal handler invoked during a sigaction() call should
	     * see either the old or the new disposition, and not something
	     * in between. We use sigprocmask() to make it so.
	     */
	    sigfillset(&sset);
	    RETVAL=sigprocmask(SIG_BLOCK, &sset, &osset);
	    if(RETVAL == -1)
               XSRETURN_UNDEF;
	    ENTER;
	    /* Restore signal mask no matter how we exit this block. */
	    osset_sv = newSVpvn((char *)(&osset), sizeof(sigset_t));
	    SAVEFREESV( osset_sv );
	    SAVEDESTRUCTOR_X(restore_sigmask, osset_sv);

	    RETVAL=-1; /* In case both oldaction and action are 0. */

	    /* Remember old disposition if desired. */
	    if (oldaction) {
		svp = hv_fetchs(oldaction, "HANDLER", TRUE);
		if(!svp)
		    croak("Can't supply an oldaction without a HANDLER");
		if(SvTRUE(*sigsvp)) { /* TBD: what if "0"? */
			sv_setsv(*svp, *sigsvp);
		}
		else {
			sv_setpvs(*svp, "DEFAULT");
		}
		RETVAL = sigaction(sig, (struct sigaction *)0, & oact);
		if(RETVAL == -1) {
                   LEAVE;
                   XSRETURN_UNDEF;
                }
		/* Get back the mask. */
		svp = hv_fetchs(oldaction, "MASK", TRUE);
		if (sv_isa(*svp, "POSIX::SigSet")) {
		    IV tmp = SvIV((SV*)SvRV(*svp));
		    sigset = INT2PTR(sigset_t*, tmp);
		}
		else {
		    Newx(sigset, 1, sigset_t);
		    sv_setptrobj(*svp, sigset, "POSIX::SigSet");
		}
		*sigset = oact.sa_mask;

		/* Get back the flags. */
		svp = hv_fetchs(oldaction, "FLAGS", TRUE);
		sv_setiv(*svp, oact.sa_flags);

		/* Get back whether the old handler used safe signals. */
		svp = hv_fetchs(oldaction, "SAFE", TRUE);
		sv_setiv(*svp,
		/* compare incompatible pointers by casting to integer */
		    PTR2nat(oact.sa_handler) == PTR2nat(PL_csighandlerp));
	    }

	    if (action) {
		/* Safe signals use "csighandler", which vectors through the
		   PL_sighandlerp pointer when it's safe to do so.
		   (BTW, "csighandler" is very different from "sighandler".) */
		svp = hv_fetchs(action, "SAFE", FALSE);
		act.sa_handler =
			DPTR2FPTR(
			    void (*)(int),
			    (*svp && SvTRUE(*svp))
				? PL_csighandlerp : PL_sighandlerp
			);

		/* Vector new Perl handler through %SIG.
		   (The core signal handlers read %SIG to dispatch.) */
		svp = hv_fetchs(action, "HANDLER", FALSE);
		if (!svp)
		    croak("Can't supply an action without a HANDLER");
		sv_setsv(*sigsvp, *svp);

		/* This call actually calls sigaction() with almost the
		   right settings, including appropriate interpretation
		   of DEFAULT and IGNORE.  However, why are we doing
		   this when we're about to do it again just below?  XXX */
		SvSETMAGIC(*sigsvp);

		/* And here again we duplicate -- DEFAULT/IGNORE checking. */
		if(SvPOK(*svp)) {
			const char *s=SvPVX_const(*svp);
			if(strEQ(s,"IGNORE")) {
				act.sa_handler = SIG_IGN;
			}
			else if(strEQ(s,"DEFAULT")) {
				act.sa_handler = SIG_DFL;
			}
		}

		/* Set up any desired mask. */
		svp = hv_fetchs(action, "MASK", FALSE);
		if (svp && sv_isa(*svp, "POSIX::SigSet")) {
		    IV tmp = SvIV((SV*)SvRV(*svp));
		    sigset = INT2PTR(sigset_t*, tmp);
		    act.sa_mask = *sigset;
		}
		else
		    sigemptyset(& act.sa_mask);

		/* Set up any desired flags. */
		svp = hv_fetchs(action, "FLAGS", FALSE);
		act.sa_flags = svp ? SvIV(*svp) : 0;

		/* Don't worry about cleaning up *sigsvp if this fails,
		 * because that means we tried to disposition a
		 * nonblockable signal, in which case *sigsvp is
		 * essentially meaningless anyway.
		 */
		RETVAL = sigaction(sig, & act, (struct sigaction *)0);
		if(RETVAL == -1) {
                    LEAVE;
		    XSRETURN_UNDEF;
                }
	    }

	    LEAVE;
	}
#endif
#line 2855 "POSIX.c"
	ST(0) = sv_newmortal();
	if (RETVAL != -1) {
	    if (RETVAL == 0)
		sv_setpvn(ST(0), "0 but true", 10);
	    else
		sv_setiv(ST(0), (IV)RETVAL);
	}
    }
    XSRETURN(1);
}


XS(XS_POSIX_sigpending); /* prototype to pass -Wmissing-prototypes */
XS(XS_POSIX_sigpending)
{
#ifdef dVAR
    dVAR; dXSARGS;
#else
    dXSARGS;
#endif
    if (items != 1)
       croak_xs_usage(cv,  "sigset");
    {
	POSIX__SigSet	sigset;
	SysRet	RETVAL;

	if (SvROK(ST(0)) && sv_derived_from(ST(0), "POSIX::SigSet")) {
	    IV tmp = SvIV((SV*)SvRV(ST(0)));
	    sigset = INT2PTR(POSIX__SigSet,tmp);
	}
	else
	    Perl_croak(aTHX_ "%s: %s is not of type %s",
			"POSIX::sigpending",
			"sigset", "POSIX::SigSet");

	RETVAL = sigpending(sigset);
	ST(0) = sv_newmortal();
	if (RETVAL != -1) {
	    if (RETVAL == 0)
		sv_setpvn(ST(0), "0 but true", 10);
	    else
		sv_setiv(ST(0), (IV)RETVAL);
	}
    }
    XSRETURN(1);
}


XS(XS_POSIX_sigprocmask); /* prototype to pass -Wmissing-prototypes */
XS(XS_POSIX_sigprocmask)
{
#ifdef dVAR
    dVAR; dXSARGS;
#else
    dXSARGS;
#endif
    if (items < 2 || items > 3)
       croak_xs_usage(cv,  "how, sigset, oldsigset = 0");
    {
	int	how = (int)SvIV(ST(0));
	POSIX__SigSet	sigset;
	POSIX__SigSet	oldsigset;
	SysRet	RETVAL;
#line 1560 "POSIX.xs"
	if (! SvOK(ST(1))) {
	    sigset = NULL;
	} else if (sv_isa(ST(1), "POSIX::SigSet")) {
	    IV tmp = SvIV((SV*)SvRV(ST(1)));
	    sigset = INT2PTR(POSIX__SigSet,tmp);
	} else {
	    croak("sigset is not of type POSIX::SigSet");
	}

	if (items < 3 || ! SvOK(ST(2))) {
	    oldsigset = NULL;
	} else if (sv_isa(ST(2), "POSIX::SigSet")) {
	    IV tmp = SvIV((SV*)SvRV(ST(2)));
	    oldsigset = INT2PTR(POSIX__SigSet,tmp);
	} else {
	    croak("oldsigset is not of type POSIX::SigSet");
	}
#line 2937 "POSIX.c"

	RETVAL = sigprocmask(how, sigset, oldsigset);
	ST(0) = sv_newmortal();
	if (RETVAL != -1) {
	    if (RETVAL == 0)
		sv_setpvn(ST(0), "0 but true", 10);
	    else
		sv_setiv(ST(0), (IV)RETVAL);
	}
    }
    XSRETURN(1);
}


XS(XS_POSIX_sigsuspend); /* prototype to pass -Wmissing-prototypes */
XS(XS_POSIX_sigsuspend)
{
#ifdef dVAR
    dVAR; dXSARGS;
#else
    dXSARGS;
#endif
    if (items != 1)
       croak_xs_usage(cv,  "signal_mask");
    {
	POSIX__SigSet	signal_mask;
	SysRet	RETVAL;

	if (SvROK(ST(0)) && sv_derived_from(ST(0), "POSIX::SigSet")) {
	    IV tmp = SvIV((SV*)SvRV(ST(0)));
	    signal_mask = INT2PTR(POSIX__SigSet,tmp);
	}
	else
	    Perl_croak(aTHX_ "%s: %s is not of type %s",
			"POSIX::sigsuspend",
			"signal_mask", "POSIX::SigSet");

	RETVAL = sigsuspend(signal_mask);
	ST(0) = sv_newmortal();
	if (RETVAL != -1) {
	    if (RETVAL == 0)
		sv_setpvn(ST(0), "0 but true", 10);
	    else
		sv_setiv(ST(0), (IV)RETVAL);
	}
    }
    XSRETURN(1);
}


XS(XS_POSIX__exit); /* prototype to pass -Wmissing-prototypes */
XS(XS_POSIX__exit)
{
#ifdef dVAR
    dVAR; dXSARGS;
#else
    dXSARGS;
#endif
    if (items != 1)
       croak_xs_usage(cv,  "status");
    {
	int	status = (int)SvIV(ST(0));

	_exit(status);
    }
    XSRETURN_EMPTY;
}


XS(XS_POSIX_close); /* prototype to pass -Wmissing-prototypes */
XS(XS_POSIX_close)
{
#ifdef dVAR
    dVAR; dXSARGS;
#else
    dXSARGS;
#endif
    if (items != 1)
       croak_xs_usage(cv,  "fd");
    {
	int	fd = (int)SvIV(ST(0));
	SysRet	RETVAL;

	RETVAL = close(fd);
	ST(0) = sv_newmortal();
	if (RETVAL != -1) {
	    if (RETVAL == 0)
		sv_setpvn(ST(0), "0 but true", 10);
	    else
		sv_setiv(ST(0), (IV)RETVAL);
	}
    }
    XSRETURN(1);
}


XS(XS_POSIX_dup); /* prototype to pass -Wmissing-prototypes */
XS(XS_POSIX_dup)
{
#ifdef dVAR
    dVAR; dXSARGS;
#else
    dXSARGS;
#endif
    if (items != 1)
       croak_xs_usage(cv,  "fd");
    {
	int	fd = (int)SvIV(ST(0));
	SysRet	RETVAL;

	RETVAL = dup(fd);
	ST(0) = sv_newmortal();
	if (RETVAL != -1) {
	    if (RETVAL == 0)
		sv_setpvn(ST(0), "0 but true", 10);
	    else
		sv_setiv(ST(0), (IV)RETVAL);
	}
    }
    XSRETURN(1);
}


XS(XS_POSIX_dup2); /* prototype to pass -Wmissing-prototypes */
XS(XS_POSIX_dup2)
{
#ifdef dVAR
    dVAR; dXSARGS;
#else
    dXSARGS;
#endif
    if (items != 2)
       croak_xs_usage(cv,  "fd1, fd2");
    {
	int	fd1 = (int)SvIV(ST(0));
	int	fd2 = (int)SvIV(ST(1));
	SysRet	RETVAL;

	RETVAL = dup2(fd1, fd2);
	ST(0) = sv_newmortal();
	if (RETVAL != -1) {
	    if (RETVAL == 0)
		sv_setpvn(ST(0), "0 but true", 10);
	    else
		sv_setiv(ST(0), (IV)RETVAL);
	}
    }
    XSRETURN(1);
}


XS(XS_POSIX_lseek); /* prototype to pass -Wmissing-prototypes */
XS(XS_POSIX_lseek)
{
#ifdef dVAR
    dVAR; dXSARGS;
#else
    dXSARGS;
#endif
    if (items != 3)
       croak_xs_usage(cv,  "fd, offset, whence");
    {
	int	fd = (int)SvIV(ST(0));
	Off_t	offset = (Off_t)SvNV(ST(1));
	int	whence = (int)SvIV(ST(2));
	SV *	RETVAL;
#line 1605 "POSIX.xs"
	Off_t pos = PerlLIO_lseek(fd, offset, whence);
	RETVAL = sizeof(Off_t) > sizeof(IV)
		 ? newSVnv((NV)pos) : newSViv((IV)pos);
#line 3108 "POSIX.c"
	ST(0) = RETVAL;
	sv_2mortal(ST(0));
    }
    XSRETURN(1);
}


XS(XS_POSIX_nice); /* prototype to pass -Wmissing-prototypes */
XS(XS_POSIX_nice)
{
#ifdef dVAR
    dVAR; dXSARGS;
#else
    dXSARGS;
#endif
    if (items != 1)
       croak_xs_usage(cv,  "incr");
    PERL_UNUSED_VAR(ax); /* -Wall */
    SP -= items;
    {
	int	incr = (int)SvIV(ST(0));
#line 1615 "POSIX.xs"
	errno = 0;
	if ((incr = nice(incr)) != -1 || errno == 0) {
	    if (incr == 0)
		XPUSHs(newSVpvs_flags("0 but true", SVs_TEMP));
	    else
		XPUSHs(sv_2mortal(newSViv(incr)));
	}
#line 3138 "POSIX.c"
	PUTBACK;
	return;
    }
}


XS(XS_POSIX_pipe); /* prototype to pass -Wmissing-prototypes */
XS(XS_POSIX_pipe)
{
#ifdef dVAR
    dVAR; dXSARGS;
#else
    dXSARGS;
#endif
    if (items != 0)
       croak_xs_usage(cv,  "");
    PERL_UNUSED_VAR(ax); /* -Wall */
    SP -= items;
    {
#line 1626 "POSIX.xs"
	int fds[2];
	if (pipe(fds) != -1) {
	    EXTEND(SP,2);
	    PUSHs(sv_2mortal(newSViv(fds[0])));
	    PUSHs(sv_2mortal(newSViv(fds[1])));
	}
#line 3165 "POSIX.c"
	PUTBACK;
	return;
    }
}


XS(XS_POSIX_read); /* prototype to pass -Wmissing-prototypes */
XS(XS_POSIX_read)
{
#ifdef dVAR
    dVAR; dXSARGS;
#else
    dXSARGS;
#endif
    if (items != 3)
       croak_xs_usage(cv,  "fd, buffer, nbytes");
    {
#line 1636 "POSIX.xs"
        SV *sv_buffer = SvROK(ST(1)) ? SvRV(ST(1)) : ST(1);
#line 3185 "POSIX.c"
	int	fd = (int)SvIV(ST(0));
	size_t	nbytes = (size_t)SvUV(ST(2));
	char *	buffer = sv_grow( sv_buffer, nbytes+1 );
	SysRet	RETVAL;

	RETVAL = read(fd, buffer, nbytes);
	ST(0) = sv_newmortal();
	if (RETVAL != -1) {
	    if (RETVAL == 0)
		sv_setpvn(ST(0), "0 but true", 10);
	    else
		sv_setiv(ST(0), (IV)RETVAL);
	}
#line 1642 "POSIX.xs"
        if (RETVAL >= 0) {
            SvCUR_set(sv_buffer, RETVAL);
            SvPOK_only(sv_buffer);
            *SvEND(sv_buffer) = '\0';
            SvTAINTED_on(sv_buffer);
        }
#line 3206 "POSIX.c"
    }
    XSRETURN(1);
}


XS(XS_POSIX_setpgid); /* prototype to pass -Wmissing-prototypes */
XS(XS_POSIX_setpgid)
{
#ifdef dVAR
    dVAR; dXSARGS;
#else
    dXSARGS;
#endif
    if (items != 2)
       croak_xs_usage(cv,  "pid, pgid");
    {
	pid_t	pid = (pid_t)SvNV(ST(0));
	pid_t	pgid = (pid_t)SvNV(ST(1));
	SysRet	RETVAL;

	RETVAL = setpgid(pid, pgid);
	ST(0) = sv_newmortal();
	if (RETVAL != -1) {
	    if (RETVAL == 0)
		sv_setpvn(ST(0), "0 but true", 10);
	    else
		sv_setiv(ST(0), (IV)RETVAL);
	}
    }
    XSRETURN(1);
}


XS(XS_POSIX_setsid); /* prototype to pass -Wmissing-prototypes */
XS(XS_POSIX_setsid)
{
#ifdef dVAR
    dVAR; dXSARGS;
#else
    dXSARGS;
#endif
    if (items != 0)
       croak_xs_usage(cv,  "");
    {
	pid_t	RETVAL;
	dXSTARG;

	RETVAL = setsid();
	XSprePUSH; PUSHn((NV)RETVAL);
    }
    XSRETURN(1);
}


XS(XS_POSIX_tcgetpgrp); /* prototype to pass -Wmissing-prototypes */
XS(XS_POSIX_tcgetpgrp)
{
#ifdef dVAR
    dVAR; dXSARGS;
#else
    dXSARGS;
#endif
    if (items != 1)
       croak_xs_usage(cv,  "fd");
    {
	int	fd = (int)SvIV(ST(0));
	pid_t	RETVAL;
	dXSTARG;

	RETVAL = tcgetpgrp(fd);
	XSprePUSH; PUSHn((NV)RETVAL);
    }
    XSRETURN(1);
}


XS(XS_POSIX_tcsetpgrp); /* prototype to pass -Wmissing-prototypes */
XS(XS_POSIX_tcsetpgrp)
{
#ifdef dVAR
    dVAR; dXSARGS;
#else
    dXSARGS;
#endif
    if (items != 2)
       croak_xs_usage(cv,  "fd, pgrp_id");
    {
	int	fd = (int)SvIV(ST(0));
	pid_t	pgrp_id = (pid_t)SvNV(ST(1));
	SysRet	RETVAL;

	RETVAL = tcsetpgrp(fd, pgrp_id);
	ST(0) = sv_newmortal();
	if (RETVAL != -1) {
	    if (RETVAL == 0)
		sv_setpvn(ST(0), "0 but true", 10);
	    else
		sv_setiv(ST(0), (IV)RETVAL);
	}
    }
    XSRETURN(1);
}


XS(XS_POSIX_uname); /* prototype to pass -Wmissing-prototypes */
XS(XS_POSIX_uname)
{
#ifdef dVAR
    dVAR; dXSARGS;
#else
    dXSARGS;
#endif
    if (items != 0)
       croak_xs_usage(cv,  "");
    PERL_UNUSED_VAR(ax); /* -Wall */
    SP -= items;
    {
#line 1669 "POSIX.xs"
#ifdef HAS_UNAME
	struct utsname buf;
	if (uname(&buf) >= 0) {
	    EXTEND(SP, 5);
	    PUSHs(newSVpvn_flags(buf.sysname, strlen(buf.sysname), SVs_TEMP));
	    PUSHs(newSVpvn_flags(buf.nodename, strlen(buf.nodename), SVs_TEMP));
	    PUSHs(newSVpvn_flags(buf.release, strlen(buf.release), SVs_TEMP));
	    PUSHs(newSVpvn_flags(buf.version, strlen(buf.version), SVs_TEMP));
	    PUSHs(newSVpvn_flags(buf.machine, strlen(buf.machine), SVs_TEMP));
	}
#else
	uname((char *) 0); /* A stub to call not_here(). */
#endif
#line 3338 "POSIX.c"
	PUTBACK;
	return;
    }
}


XS(XS_POSIX_write); /* prototype to pass -Wmissing-prototypes */
XS(XS_POSIX_write)
{
#ifdef dVAR
    dVAR; dXSARGS;
#else
    dXSARGS;
#endif
    if (items != 3)
       croak_xs_usage(cv,  "fd, buffer, nbytes");
    {
	int	fd = (int)SvIV(ST(0));
	char *	buffer = (char *)SvPV_nolen(ST(1));
	size_t	nbytes = (size_t)SvUV(ST(2));
	SysRet	RETVAL;

	RETVAL = write(fd, buffer, nbytes);
	ST(0) = sv_newmortal();
	if (RETVAL != -1) {
	    if (RETVAL == 0)
		sv_setpvn(ST(0), "0 but true", 10);
	    else
		sv_setiv(ST(0), (IV)RETVAL);
	}
    }
    XSRETURN(1);
}


XS(XS_POSIX_tmpnam); /* prototype to pass -Wmissing-prototypes */
XS(XS_POSIX_tmpnam)
{
#ifdef dVAR
    dVAR; dXSARGS;
#else
    dXSARGS;
#endif
    if (items != 0)
       croak_xs_usage(cv,  "");
    {
#line 1692 "POSIX.xs"
	STRLEN i;
	int len;
#line 3388 "POSIX.c"
	SV *	RETVAL;
#line 1695 "POSIX.xs"
	RETVAL = newSVpvn("", 0);
	SvGROW(RETVAL, L_tmpnam);
	len = strlen(tmpnam(SvPV(RETVAL, i)));
	SvCUR_set(RETVAL, len);
#line 3395 "POSIX.c"
	ST(0) = RETVAL;
	sv_2mortal(ST(0));
    }
    XSRETURN(1);
}


XS(XS_POSIX_abort); /* prototype to pass -Wmissing-prototypes */
XS(XS_POSIX_abort)
{
#ifdef dVAR
    dVAR; dXSARGS;
#else
    dXSARGS;
#endif
    if (items != 0)
       croak_xs_usage(cv,  "");
    {

	abort();
    }
    XSRETURN_EMPTY;
}


XS(XS_POSIX_mblen); /* prototype to pass -Wmissing-prototypes */
XS(XS_POSIX_mblen)
{
#ifdef dVAR
    dVAR; dXSARGS;
#else
    dXSARGS;
#endif
    if (items != 2)
       croak_xs_usage(cv,  "s, n");
    {
	char *	s = (char *)SvPV_nolen(ST(0));
	size_t	n = (size_t)SvUV(ST(1));
	int	RETVAL;
	dXSTARG;

	RETVAL = mblen(s, n);
	XSprePUSH; PUSHi((IV)RETVAL);
    }
    XSRETURN(1);
}


XS(XS_POSIX_mbstowcs); /* prototype to pass -Wmissing-prototypes */
XS(XS_POSIX_mbstowcs)
{
#ifdef dVAR
    dVAR; dXSARGS;
#else
    dXSARGS;
#endif
    if (items != 3)
       croak_xs_usage(cv,  "s, pwcs, n");
    {
	wchar_t *	s = (wchar_t *)SvPV_nolen(ST(0));
	char *	pwcs = (char *)SvPV_nolen(ST(1));
	size_t	n = (size_t)SvUV(ST(2));
	size_t	RETVAL;
	dXSTARG;

	RETVAL = mbstowcs(s, pwcs, n);
	XSprePUSH; PUSHu((UV)RETVAL);
    }
    XSRETURN(1);
}


XS(XS_POSIX_mbtowc); /* prototype to pass -Wmissing-prototypes */
XS(XS_POSIX_mbtowc)
{
#ifdef dVAR
    dVAR; dXSARGS;
#else
    dXSARGS;
#endif
    if (items != 3)
       croak_xs_usage(cv,  "pwc, s, n");
    {
	wchar_t *	pwc = (wchar_t *)SvPV_nolen(ST(0));
	char *	s = (char *)SvPV_nolen(ST(1));
	size_t	n = (size_t)SvUV(ST(2));
	int	RETVAL;
	dXSTARG;

	RETVAL = mbtowc(pwc, s, n);
	XSprePUSH; PUSHi((IV)RETVAL);
    }
    XSRETURN(1);
}


XS(XS_POSIX_wcstombs); /* prototype to pass -Wmissing-prototypes */
XS(XS_POSIX_wcstombs)
{
#ifdef dVAR
    dVAR; dXSARGS;
#else
    dXSARGS;
#endif
    if (items != 3)
       croak_xs_usage(cv,  "s, pwcs, n");
    {
	char *	s = (char *)SvPV_nolen(ST(0));
	wchar_t *	pwcs = (wchar_t *)SvPV_nolen(ST(1));
	size_t	n = (size_t)SvUV(ST(2));
	int	RETVAL;
	dXSTARG;

	RETVAL = wcstombs(s, pwcs, n);
	XSprePUSH; PUSHi((IV)RETVAL);
    }
    XSRETURN(1);
}


XS(XS_POSIX_wctomb); /* prototype to pass -Wmissing-prototypes */
XS(XS_POSIX_wctomb)
{
#ifdef dVAR
    dVAR; dXSARGS;
#else
    dXSARGS;
#endif
    if (items != 2)
       croak_xs_usage(cv,  "s, wchar");
    {
	char *	s = (char *)SvPV_nolen(ST(0));
	wchar_t	wchar = (wchar_t)SvIV(ST(1));
	int	RETVAL;
	dXSTARG;

	RETVAL = wctomb(s, wchar);
	XSprePUSH; PUSHi((IV)RETVAL);
    }
    XSRETURN(1);
}


XS(XS_POSIX_strcoll); /* prototype to pass -Wmissing-prototypes */
XS(XS_POSIX_strcoll)
{
#ifdef dVAR
    dVAR; dXSARGS;
#else
    dXSARGS;
#endif
    if (items != 2)
       croak_xs_usage(cv,  "s1, s2");
    {
	char *	s1 = (char *)SvPV_nolen(ST(0));
	char *	s2 = (char *)SvPV_nolen(ST(1));
	int	RETVAL;
	dXSTARG;

	RETVAL = strcoll(s1, s2);
	XSprePUSH; PUSHi((IV)RETVAL);
    }
    XSRETURN(1);
}


XS(XS_POSIX_strtod); /* prototype to pass -Wmissing-prototypes */
XS(XS_POSIX_strtod)
{
#ifdef dVAR
    dVAR; dXSARGS;
#else
    dXSARGS;
#endif
    if (items != 1)
       croak_xs_usage(cv,  "str");
    PERL_UNUSED_VAR(ax); /* -Wall */
    SP -= items;
    {
	char *	str = (char *)SvPV_nolen(ST(0));
#line 1742 "POSIX.xs"
	double num;
	char *unparsed;
#line 3579 "POSIX.c"
#line 1745 "POSIX.xs"
	SET_NUMERIC_LOCAL();
	num = strtod(str, &unparsed);
	PUSHs(sv_2mortal(newSVnv(num)));
	if (GIMME == G_ARRAY) {
	    EXTEND(SP, 1);
	    if (unparsed)
		PUSHs(sv_2mortal(newSViv(strlen(unparsed))));
	    else
		PUSHs(&PL_sv_undef);
	}
#line 3591 "POSIX.c"
	PUTBACK;
	return;
    }
}


XS(XS_POSIX_strtol); /* prototype to pass -Wmissing-prototypes */
XS(XS_POSIX_strtol)
{
#ifdef dVAR
    dVAR; dXSARGS;
#else
    dXSARGS;
#endif
    if (items < 1 || items > 2)
       croak_xs_usage(cv,  "str, base = 0");
    PERL_UNUSED_VAR(ax); /* -Wall */
    SP -= items;
    {
	char *	str = (char *)SvPV_nolen(ST(0));
	int	base;
#line 1761 "POSIX.xs"
	long num;
	char *unparsed;
#line 3616 "POSIX.c"

	if (items < 2)
	    base = 0;
	else {
	    base = (int)SvIV(ST(1));
	}
#line 1764 "POSIX.xs"
	num = strtol(str, &unparsed, base);
#if IVSIZE <= LONGSIZE
	if (num < IV_MIN || num > IV_MAX)
	    PUSHs(sv_2mortal(newSVnv((double)num)));
	else
#endif
	    PUSHs(sv_2mortal(newSViv((IV)num)));
	if (GIMME == G_ARRAY) {
	    EXTEND(SP, 1);
	    if (unparsed)
		PUSHs(sv_2mortal(newSViv(strlen(unparsed))));
	    else
		PUSHs(&PL_sv_undef);
	}
#line 3638 "POSIX.c"
	PUTBACK;
	return;
    }
}


XS(XS_POSIX_strtoul); /* prototype to pass -Wmissing-prototypes */
XS(XS_POSIX_strtoul)
{
#ifdef dVAR
    dVAR; dXSARGS;
#else
    dXSARGS;
#endif
    if (items < 1 || items > 2)
       croak_xs_usage(cv,  "str, base = 0");
    PERL_UNUSED_VAR(ax); /* -Wall */
    SP -= items;
    {
	const char *	str = (const char *)SvPV_nolen(ST(0));
	int	base;
#line 1784 "POSIX.xs"
	unsigned long num;
	char *unparsed;
#line 3663 "POSIX.c"

	if (items < 2)
	    base = 0;
	else {
	    base = (int)SvIV(ST(1));
	}
#line 1787 "POSIX.xs"
	num = strtoul(str, &unparsed, base);
#if IVSIZE <= LONGSIZE
	if (num > IV_MAX)
	    PUSHs(sv_2mortal(newSVnv((double)num)));
	else
#endif
	    PUSHs(sv_2mortal(newSViv((IV)num)));
	if (GIMME == G_ARRAY) {
	    EXTEND(SP, 1);
	    if (unparsed)
		PUSHs(sv_2mortal(newSViv(strlen(unparsed))));
	    else
		PUSHs(&PL_sv_undef);
	}
#line 3685 "POSIX.c"
	PUTBACK;
	return;
    }
}


XS(XS_POSIX_strxfrm); /* prototype to pass -Wmissing-prototypes */
XS(XS_POSIX_strxfrm)
{
#ifdef dVAR
    dVAR; dXSARGS;
#else
    dXSARGS;
#endif
    if (items != 1)
       croak_xs_usage(cv,  "src");
    {
	SV *	src = ST(0);
#line 1806 "POSIX.xs"
	{
          STRLEN srclen;
          STRLEN dstlen;
          char *p = SvPV(src,srclen);
          srclen++;
          ST(0) = sv_2mortal(newSV(srclen*4+1));
          dstlen = strxfrm(SvPVX(ST(0)), p, (size_t)srclen);
          if (dstlen > srclen) {
              dstlen++;
              SvGROW(ST(0), dstlen);
              strxfrm(SvPVX(ST(0)), p, (size_t)dstlen);
              dstlen--;
          }
          SvCUR_set(ST(0), dstlen);
	    SvPOK_only(ST(0));
	}
#line 3721 "POSIX.c"
    }
    XSRETURN(1);
}


XS(XS_POSIX_mkfifo); /* prototype to pass -Wmissing-prototypes */
XS(XS_POSIX_mkfifo)
{
#ifdef dVAR
    dVAR; dXSARGS;
#else
    dXSARGS;
#endif
    if (items != 2)
       croak_xs_usage(cv,  "filename, mode");
    {
	char *	filename = (char *)SvPV_nolen(ST(0));
	Mode_t	mode = (Mode_t)SvNV(ST(1));
	SysRet	RETVAL;
#line 1828 "POSIX.xs"
	TAINT_PROPER("mkfifo");
	RETVAL = mkfifo(filename, mode);
#line 3744 "POSIX.c"
	ST(0) = sv_newmortal();
	if (RETVAL != -1) {
	    if (RETVAL == 0)
		sv_setpvn(ST(0), "0 but true", 10);
	    else
		sv_setiv(ST(0), (IV)RETVAL);
	}
    }
    XSRETURN(1);
}


XS(XS_POSIX_tcdrain); /* prototype to pass -Wmissing-prototypes */
XS(XS_POSIX_tcdrain)
{
#ifdef dVAR
    dVAR; dXSARGS;
#else
    dXSARGS;
#endif
    if (items != 1)
       croak_xs_usage(cv,  "fd");
    {
	int	fd = (int)SvIV(ST(0));
	SysRet	RETVAL;

	RETVAL = tcdrain(fd);
	ST(0) = sv_newmortal();
	if (RETVAL != -1) {
	    if (RETVAL == 0)
		sv_setpvn(ST(0), "0 but true", 10);
	    else
		sv_setiv(ST(0), (IV)RETVAL);
	}
    }
    XSRETURN(1);
}


XS(XS_POSIX_tcflow); /* prototype to pass -Wmissing-prototypes */
XS(XS_POSIX_tcflow)
{
#ifdef dVAR
    dVAR; dXSARGS;
#else
    dXSARGS;
#endif
    if (items != 2)
       croak_xs_usage(cv,  "fd, action");
    {
	int	fd = (int)SvIV(ST(0));
	int	action = (int)SvIV(ST(1));
	SysRet	RETVAL;

	RETVAL = tcflow(fd, action);
	ST(0) = sv_newmortal();
	if (RETVAL != -1) {
	    if (RETVAL == 0)
		sv_setpvn(ST(0), "0 but true", 10);
	    else
		sv_setiv(ST(0), (IV)RETVAL);
	}
    }
    XSRETURN(1);
}


XS(XS_POSIX_tcflush); /* prototype to pass -Wmissing-prototypes */
XS(XS_POSIX_tcflush)
{
#ifdef dVAR
    dVAR; dXSARGS;
#else
    dXSARGS;
#endif
    if (items != 2)
       croak_xs_usage(cv,  "fd, queue_selector");
    {
	int	fd = (int)SvIV(ST(0));
	int	queue_selector = (int)SvIV(ST(1));
	SysRet	RETVAL;

	RETVAL = tcflush(fd, queue_selector);
	ST(0) = sv_newmortal();
	if (RETVAL != -1) {
	    if (RETVAL == 0)
		sv_setpvn(ST(0), "0 but true", 10);
	    else
		sv_setiv(ST(0), (IV)RETVAL);
	}
    }
    XSRETURN(1);
}


XS(XS_POSIX_tcsendbreak); /* prototype to pass -Wmissing-prototypes */
XS(XS_POSIX_tcsendbreak)
{
#ifdef dVAR
    dVAR; dXSARGS;
#else
    dXSARGS;
#endif
    if (items != 2)
       croak_xs_usage(cv,  "fd, duration");
    {
	int	fd = (int)SvIV(ST(0));
	int	duration = (int)SvIV(ST(1));
	SysRet	RETVAL;

	RETVAL = tcsendbreak(fd, duration);
	ST(0) = sv_newmortal();
	if (RETVAL != -1) {
	    if (RETVAL == 0)
		sv_setpvn(ST(0), "0 but true", 10);
	    else
		sv_setiv(ST(0), (IV)RETVAL);
	}
    }
    XSRETURN(1);
}


XS(XS_POSIX_asctime); /* prototype to pass -Wmissing-prototypes */
XS(XS_POSIX_asctime)
{
#ifdef dVAR
    dVAR; dXSARGS;
#else
    dXSARGS;
#endif
    if (items < 6 || items > 9)
       croak_xs_usage(cv,  "sec, min, hour, mday, mon, year, wday = 0, yday = 0, isdst = -1");
    {
	int	sec = (int)SvIV(ST(0));
	int	min = (int)SvIV(ST(1));
	int	hour = (int)SvIV(ST(2));
	int	mday = (int)SvIV(ST(3));
	int	mon = (int)SvIV(ST(4));
	int	year = (int)SvIV(ST(5));
	int	wday;
	int	yday;
	int	isdst;
	char *	RETVAL;
	dXSTARG;

	if (items < 7)
	    wday = 0;
	else {
	    wday = (int)SvIV(ST(6));
	}

	if (items < 8)
	    yday = 0;
	else {
	    yday = (int)SvIV(ST(7));
	}

	if (items < 9)
	    isdst = -1;
	else {
	    isdst = (int)SvIV(ST(8));
	}
#line 1866 "POSIX.xs"
	{
	    struct tm mytm;
	    init_tm(&mytm);	/* XXX workaround - see init_tm() above */
	    mytm.tm_sec = sec;
	    mytm.tm_min = min;
	    mytm.tm_hour = hour;
	    mytm.tm_mday = mday;
	    mytm.tm_mon = mon;
	    mytm.tm_year = year;
	    mytm.tm_wday = wday;
	    mytm.tm_yday = yday;
	    mytm.tm_isdst = isdst;
	    RETVAL = asctime(&mytm);
	}
#line 3923 "POSIX.c"
	sv_setpv(TARG, RETVAL); XSprePUSH; PUSHTARG;
    }
    XSRETURN(1);
}


XS(XS_POSIX_clock); /* prototype to pass -Wmissing-prototypes */
XS(XS_POSIX_clock)
{
#ifdef dVAR
    dVAR; dXSARGS;
#else
    dXSARGS;
#endif
    if (items != 0)
       croak_xs_usage(cv,  "");
    {
	long	RETVAL;
	dXSTARG;

	RETVAL = clock();
	XSprePUSH; PUSHi((IV)RETVAL);
    }
    XSRETURN(1);
}


XS(XS_POSIX_ctime); /* prototype to pass -Wmissing-prototypes */
XS(XS_POSIX_ctime)
{
#ifdef dVAR
    dVAR; dXSARGS;
#else
    dXSARGS;
#endif
    if (items != 1)
       croak_xs_usage(cv,  "time");
    {
	Time_t	time = (Time_t)SvNV(ST(0));
	char *	RETVAL;
	dXSTARG;

	RETVAL = ctime(&time);
	sv_setpv(TARG, RETVAL); XSprePUSH; PUSHTARG;
    }
    XSRETURN(1);
}


XS(XS_POSIX_times); /* prototype to pass -Wmissing-prototypes */
XS(XS_POSIX_times)
{
#ifdef dVAR
    dVAR; dXSARGS;
#else
    dXSARGS;
#endif
    if (items != 0)
       croak_xs_usage(cv,  "");
    PERL_UNUSED_VAR(ax); /* -Wall */
    SP -= items;
    {
#line 1893 "POSIX.xs"
	struct tms tms;
	clock_t realtime;
	realtime = times( &tms );
	EXTEND(SP,5);
	PUSHs( sv_2mortal( newSViv( (IV) realtime ) ) );
	PUSHs( sv_2mortal( newSViv( (IV) tms.tms_utime ) ) );
	PUSHs( sv_2mortal( newSViv( (IV) tms.tms_stime ) ) );
	PUSHs( sv_2mortal( newSViv( (IV) tms.tms_cutime ) ) );
	PUSHs( sv_2mortal( newSViv( (IV) tms.tms_cstime ) ) );
#line 3996 "POSIX.c"
	PUTBACK;
	return;
    }
}


XS(XS_POSIX_difftime); /* prototype to pass -Wmissing-prototypes */
XS(XS_POSIX_difftime)
{
#ifdef dVAR
    dVAR; dXSARGS;
#else
    dXSARGS;
#endif
    if (items != 2)
       croak_xs_usage(cv,  "time1, time2");
    {
	Time_t	time1 = (Time_t)SvNV(ST(0));
	Time_t	time2 = (Time_t)SvNV(ST(1));
	double	RETVAL;
	dXSTARG;

	RETVAL = difftime(time1, time2);
	XSprePUSH; PUSHn((double)RETVAL);
    }
    XSRETURN(1);
}


XS(XS_POSIX_mktime); /* prototype to pass -Wmissing-prototypes */
XS(XS_POSIX_mktime)
{
#ifdef dVAR
    dVAR; dXSARGS;
#else
    dXSARGS;
#endif
    if (items < 6 || items > 9)
       croak_xs_usage(cv,  "sec, min, hour, mday, mon, year, wday = 0, yday = 0, isdst = -1");
    {
	int	sec = (int)SvIV(ST(0));
	int	min = (int)SvIV(ST(1));
	int	hour = (int)SvIV(ST(2));
	int	mday = (int)SvIV(ST(3));
	int	mon = (int)SvIV(ST(4));
	int	year = (int)SvIV(ST(5));
	int	wday;
	int	yday;
	int	isdst;
	SysRetLong	RETVAL;

	if (items < 7)
	    wday = 0;
	else {
	    wday = (int)SvIV(ST(6));
	}

	if (items < 8)
	    yday = 0;
	else {
	    yday = (int)SvIV(ST(7));
	}

	if (items < 9)
	    isdst = -1;
	else {
	    isdst = (int)SvIV(ST(8));
	}
#line 1920 "POSIX.xs"
	{
	    struct tm mytm;
	    init_tm(&mytm);	/* XXX workaround - see init_tm() above */
	    mytm.tm_sec = sec;
	    mytm.tm_min = min;
	    mytm.tm_hour = hour;
	    mytm.tm_mday = mday;
	    mytm.tm_mon = mon;
	    mytm.tm_year = year;
	    mytm.tm_wday = wday;
	    mytm.tm_yday = yday;
	    mytm.tm_isdst = isdst;
	    RETVAL = (SysRetLong) mktime(&mytm);
	}
#line 4080 "POSIX.c"
	ST(0) = sv_newmortal();
	if (RETVAL != -1) {
	    if (RETVAL == 0)
		sv_setpvn(ST(0), "0 but true", 10);
	    else
		sv_setiv(ST(0), (IV)RETVAL);
	}
    }
    XSRETURN(1);
}


XS(XS_POSIX_strftime); /* prototype to pass -Wmissing-prototypes */
XS(XS_POSIX_strftime)
{
#ifdef dVAR
    dVAR; dXSARGS;
#else
    dXSARGS;
#endif
    if (items < 7 || items > 10)
       croak_xs_usage(cv,  "fmt, sec, min, hour, mday, mon, year, wday = -1, yday = -1, isdst = -1");
    {
	SV *	fmt = ST(0);
	int	sec = (int)SvIV(ST(1));
	int	min = (int)SvIV(ST(2));
	int	hour = (int)SvIV(ST(3));
	int	mday = (int)SvIV(ST(4));
	int	mon = (int)SvIV(ST(5));
	int	year = (int)SvIV(ST(6));
	int	wday;
	int	yday;
	int	isdst;

	if (items < 8)
	    wday = -1;
	else {
	    wday = (int)SvIV(ST(7));
	}

	if (items < 9)
	    yday = -1;
	else {
	    yday = (int)SvIV(ST(8));
	}

	if (items < 10)
	    isdst = -1;
	else {
	    isdst = (int)SvIV(ST(9));
	}
#line 1953 "POSIX.xs"
	{
	    char *buf = my_strftime(SvPV_nolen(fmt), sec, min, hour, mday, mon, year, wday, yday, isdst);
	    if (buf) {
		SV *const sv = sv_newmortal();
		sv_usepvn_flags(sv, buf, strlen(buf), SV_HAS_TRAILING_NUL);
		if (SvUTF8(fmt)) {
		    SvUTF8_on(sv);
		}
		ST(0) = sv;
	    }
	}
#line 4144 "POSIX.c"
    }
    XSRETURN(1);
}


XS(XS_POSIX_tzset); /* prototype to pass -Wmissing-prototypes */
XS(XS_POSIX_tzset)
{
#ifdef dVAR
    dVAR; dXSARGS;
#else
    dXSARGS;
#endif
    if (items != 0)
       croak_xs_usage(cv,  "");
    PERL_UNUSED_VAR(ax); /* -Wall */
    SP -= items;
    {
#line 1968 "POSIX.xs"
    my_tzset(aTHX);
#line 4165 "POSIX.c"
	PUTBACK;
	return;
    }
}


XS(XS_POSIX_tzname); /* prototype to pass -Wmissing-prototypes */
XS(XS_POSIX_tzname)
{
#ifdef dVAR
    dVAR; dXSARGS;
#else
    dXSARGS;
#endif
    if (items != 0)
       croak_xs_usage(cv,  "");
    PERL_UNUSED_VAR(ax); /* -Wall */
    SP -= items;
    {
#line 1973 "POSIX.xs"
	EXTEND(SP,2);
	PUSHs(newSVpvn_flags(tzname[0], strlen(tzname[0]), SVs_TEMP));
	PUSHs(newSVpvn_flags(tzname[1], strlen(tzname[1]), SVs_TEMP));
#line 4189 "POSIX.c"
	PUTBACK;
	return;
    }
}


XS(XS_POSIX_access); /* prototype to pass -Wmissing-prototypes */
XS(XS_POSIX_access)
{
#ifdef dVAR
    dVAR; dXSARGS;
#else
    dXSARGS;
#endif
    if (items != 2)
       croak_xs_usage(cv,  "filename, mode");
    {
	char *	filename = (char *)SvPV_nolen(ST(0));
	Mode_t	mode = (Mode_t)SvNV(ST(1));
	SysRet	RETVAL;

	RETVAL = access(filename, mode);
	ST(0) = sv_newmortal();
	if (RETVAL != -1) {
	    if (RETVAL == 0)
		sv_setpvn(ST(0), "0 but true", 10);
	    else
		sv_setiv(ST(0), (IV)RETVAL);
	}
    }
    XSRETURN(1);
}


XS(XS_POSIX_ctermid); /* prototype to pass -Wmissing-prototypes */
XS(XS_POSIX_ctermid)
{
#ifdef dVAR
    dVAR; dXSARGS;
#else
    dXSARGS;
#endif
    if (items < 0 || items > 1)
       croak_xs_usage(cv,  "s = 0");
    {
	char *	s = 0;
	char *	RETVAL;
	dXSTARG;
#line 1986 "POSIX.xs"
#ifdef HAS_CTERMID_R
	s = (char *) safemalloc((size_t) L_ctermid);
#endif
	RETVAL = ctermid(s);
#line 4243 "POSIX.c"
	sv_setpv(TARG, RETVAL); XSprePUSH; PUSHTARG;
#line 1993 "POSIX.xs"
#ifdef HAS_CTERMID_R
	Safefree(s);
#endif
#line 4249 "POSIX.c"
    }
    XSRETURN(1);
}


XS(XS_POSIX_cuserid); /* prototype to pass -Wmissing-prototypes */
XS(XS_POSIX_cuserid)
{
#ifdef dVAR
    dVAR; dXSARGS;
#else
    dXSARGS;
#endif
    if (items < 0 || items > 1)
       croak_xs_usage(cv,  "s = 0");
    {
	char *	s = 0;
	char *	RETVAL;
	dXSTARG;
#line 2001 "POSIX.xs"
#ifdef HAS_CUSERID
  RETVAL = cuserid(s);
#else
  RETVAL = 0;
  not_here("cuserid");
#endif
#line 4276 "POSIX.c"
	sv_setpv(TARG, RETVAL); XSprePUSH; PUSHTARG;
    }
    XSRETURN(1);
}


XS(XS_POSIX_fpathconf); /* prototype to pass -Wmissing-prototypes */
XS(XS_POSIX_fpathconf)
{
#ifdef dVAR
    dVAR; dXSARGS;
#else
    dXSARGS;
#endif
    if (items != 2)
       croak_xs_usage(cv,  "fd, name");
    {
	int	fd = (int)SvIV(ST(0));
	int	name = (int)SvIV(ST(1));
	SysRetLong	RETVAL;

	RETVAL = fpathconf(fd, name);
	ST(0) = sv_newmortal();
	if (RETVAL != -1) {
	    if (RETVAL == 0)
		sv_setpvn(ST(0), "0 but true", 10);
	    else
		sv_setiv(ST(0), (IV)RETVAL);
	}
    }
    XSRETURN(1);
}


XS(XS_POSIX_pathconf); /* prototype to pass -Wmissing-prototypes */
XS(XS_POSIX_pathconf)
{
#ifdef dVAR
    dVAR; dXSARGS;
#else
    dXSARGS;
#endif
    if (items != 2)
       croak_xs_usage(cv,  "filename, name");
    {
	char *	filename = (char *)SvPV_nolen(ST(0));
	int	name = (int)SvIV(ST(1));
	SysRetLong	RETVAL;

	RETVAL = pathconf(filename, name);
	ST(0) = sv_newmortal();
	if (RETVAL != -1) {
	    if (RETVAL == 0)
		sv_setpvn(ST(0), "0 but true", 10);
	    else
		sv_setiv(ST(0), (IV)RETVAL);
	}
    }
    XSRETURN(1);
}


XS(XS_POSIX_pause); /* prototype to pass -Wmissing-prototypes */
XS(XS_POSIX_pause)
{
#ifdef dVAR
    dVAR; dXSARGS;
#else
    dXSARGS;
#endif
    if (items != 0)
       croak_xs_usage(cv,  "");
    {
	SysRet	RETVAL;

	RETVAL = pause();
	ST(0) = sv_newmortal();
	if (RETVAL != -1) {
	    if (RETVAL == 0)
		sv_setpvn(ST(0), "0 but true", 10);
	    else
		sv_setiv(ST(0), (IV)RETVAL);
	}
    }
    XSRETURN(1);
}


XS(XS_POSIX_setgid); /* prototype to pass -Wmissing-prototypes */
XS(XS_POSIX_setgid)
{
#ifdef dVAR
    dVAR; dXSARGS;
#else
    dXSARGS;
#endif
    if (items != 1)
       croak_xs_usage(cv,  "gid");
    {
	Gid_t	gid = (Gid_t)SvNV(ST(0));
	SysRet	RETVAL;

	RETVAL = setgid(gid);
	ST(0) = sv_newmortal();
	if (RETVAL != -1) {
	    if (RETVAL == 0)
		sv_setpvn(ST(0), "0 but true", 10);
	    else
		sv_setiv(ST(0), (IV)RETVAL);
	}
#line 2027 "POSIX.xs"
#ifndef WIN32
	if (RETVAL >= 0) {
	    PL_gid  = getgid();
	    PL_egid = getegid();
	}
#endif
#line 4394 "POSIX.c"
    }
    XSRETURN(1);
}


XS(XS_POSIX_setuid); /* prototype to pass -Wmissing-prototypes */
XS(XS_POSIX_setuid)
{
#ifdef dVAR
    dVAR; dXSARGS;
#else
    dXSARGS;
#endif
    if (items != 1)
       croak_xs_usage(cv,  "uid");
    {
	Uid_t	uid = (Uid_t)SvNV(ST(0));
	SysRet	RETVAL;

	RETVAL = setuid(uid);
	ST(0) = sv_newmortal();
	if (RETVAL != -1) {
	    if (RETVAL == 0)
		sv_setpvn(ST(0), "0 but true", 10);
	    else
		sv_setiv(ST(0), (IV)RETVAL);
	}
#line 2038 "POSIX.xs"
#ifndef WIN32
	if (RETVAL >= 0) {
	    PL_uid  = getuid();
	    PL_euid = geteuid();
	}
#endif
#line 4429 "POSIX.c"
    }
    XSRETURN(1);
}


XS(XS_POSIX_sysconf); /* prototype to pass -Wmissing-prototypes */
XS(XS_POSIX_sysconf)
{
#ifdef dVAR
    dVAR; dXSARGS;
#else
    dXSARGS;
#endif
    if (items != 1)
       croak_xs_usage(cv,  "name");
    {
	int	name = (int)SvIV(ST(0));
	SysRetLong	RETVAL;

	RETVAL = sysconf(name);
	ST(0) = sv_newmortal();
	if (RETVAL != -1) {
	    if (RETVAL == 0)
		sv_setpvn(ST(0), "0 but true", 10);
	    else
		sv_setiv(ST(0), (IV)RETVAL);
	}
    }
    XSRETURN(1);
}


XS(XS_POSIX_ttyname); /* prototype to pass -Wmissing-prototypes */
XS(XS_POSIX_ttyname)
{
#ifdef dVAR
    dVAR; dXSARGS;
#else
    dXSARGS;
#endif
    if (items != 1)
       croak_xs_usage(cv,  "fd");
    {
	int	fd = (int)SvIV(ST(0));
	char *	RETVAL;
	dXSTARG;

	RETVAL = ttyname(fd);
	sv_setpv(TARG, RETVAL); XSprePUSH; PUSHTARG;
    }
    XSRETURN(1);
}


XS(XS_POSIX_getcwd); /* prototype to pass -Wmissing-prototypes */
XS(XS_POSIX_getcwd)
{
#ifdef dVAR
    dVAR; dXSARGS;
#else
    dXSARGS;
#endif
    if (items != 0)
       croak_xs_usage(cv,  "");
    PERL_UNUSED_VAR(ax); /* -Wall */
    SP -= items;
    {
#line 2056 "POSIX.xs"
      {
	dXSTARG;
	getcwd_sv(TARG);
	XSprePUSH; PUSHTARG;
      }
#line 4503 "POSIX.c"
	PUTBACK;
	return;
    }
}


XS(XS_POSIX_lchown); /* prototype to pass -Wmissing-prototypes */
XS(XS_POSIX_lchown)
{
#ifdef dVAR
    dVAR; dXSARGS;
#else
    dXSARGS;
#endif
    if (items != 3)
       croak_xs_usage(cv,  "uid, gid, path");
    {
	Uid_t	uid = (Uid_t)SvNV(ST(0));
	Gid_t	gid = (Gid_t)SvNV(ST(1));
	char *	path = (char *)SvPV_nolen(ST(2));
	SysRet	RETVAL;
#line 2068 "POSIX.xs"
#ifdef HAS_LCHOWN
       /* yes, the order of arguments is different,
        * but consistent with CORE::chown() */
       RETVAL = lchown(path, uid, gid);
#else
       RETVAL = not_here("lchown");
#endif
#line 4533 "POSIX.c"
	ST(0) = sv_newmortal();
	if (RETVAL != -1) {
	    if (RETVAL == 0)
		sv_setpvn(ST(0), "0 but true", 10);
	    else
		sv_setiv(ST(0), (IV)RETVAL);
	}
    }
    XSRETURN(1);
}

#ifdef __cplusplus
extern "C"
#endif
XS(boot_POSIX); /* prototype to pass -Wmissing-prototypes */
XS(boot_POSIX)
{
#ifdef dVAR
    dVAR; dXSARGS;
#else
    dXSARGS;
#endif
#if (PERL_REVISION == 5 && PERL_VERSION < 9)
    char* file = __FILE__;
#else
    const char* file = __FILE__;
#endif

    PERL_UNUSED_VAR(cv); /* -W */
    PERL_UNUSED_VAR(items); /* -W */
#ifdef XS_APIVERSION_BOOTCHECK
    XS_APIVERSION_BOOTCHECK;
#endif
    XS_VERSION_BOOTCHECK ;

    {
        CV * cv ;

        newXS("POSIX::SigSet::new", XS_POSIX__SigSet_new, file);
        newXS("POSIX::SigSet::DESTROY", XS_POSIX__SigSet_DESTROY, file);
        newXS("POSIX::SigSet::addset", XS_POSIX__SigSet_addset, file);
        newXS("POSIX::SigSet::delset", XS_POSIX__SigSet_delset, file);
        newXS("POSIX::SigSet::emptyset", XS_POSIX__SigSet_emptyset, file);
        newXS("POSIX::SigSet::fillset", XS_POSIX__SigSet_fillset, file);
        newXS("POSIX::SigSet::ismember", XS_POSIX__SigSet_ismember, file);
        newXS("POSIX::Termios::new", XS_POSIX__Termios_new, file);
        newXS("POSIX::Termios::DESTROY", XS_POSIX__Termios_DESTROY, file);
        newXS("POSIX::Termios::getattr", XS_POSIX__Termios_getattr, file);
        newXS("POSIX::Termios::setattr", XS_POSIX__Termios_setattr, file);
        newXS("POSIX::Termios::getispeed", XS_POSIX__Termios_getispeed, file);
        newXS("POSIX::Termios::getospeed", XS_POSIX__Termios_getospeed, file);
        newXS("POSIX::Termios::getiflag", XS_POSIX__Termios_getiflag, file);
        newXS("POSIX::Termios::getoflag", XS_POSIX__Termios_getoflag, file);
        newXS("POSIX::Termios::getcflag", XS_POSIX__Termios_getcflag, file);
        newXS("POSIX::Termios::getlflag", XS_POSIX__Termios_getlflag, file);
        newXS("POSIX::Termios::getcc", XS_POSIX__Termios_getcc, file);
        newXS("POSIX::Termios::setispeed", XS_POSIX__Termios_setispeed, file);
        newXS("POSIX::Termios::setospeed", XS_POSIX__Termios_setospeed, file);
        newXS("POSIX::Termios::setiflag", XS_POSIX__Termios_setiflag, file);
        newXS("POSIX::Termios::setoflag", XS_POSIX__Termios_setoflag, file);
        newXS("POSIX::Termios::setcflag", XS_POSIX__Termios_setcflag, file);
        newXS("POSIX::Termios::setlflag", XS_POSIX__Termios_setlflag, file);
        newXS("POSIX::Termios::setcc", XS_POSIX__Termios_setcc, file);
        newXS("POSIX::constant", XS_POSIX_constant, file);
        cv = newXS("POSIX::WIFSIGNALED", XS_POSIX_WEXITSTATUS, file);
        XSANY.any_i32 = 2 ;
        cv = newXS("POSIX::WIFSTOPPED", XS_POSIX_WEXITSTATUS, file);
        XSANY.any_i32 = 3 ;
        cv = newXS("POSIX::WIFEXITED", XS_POSIX_WEXITSTATUS, file);
        XSANY.any_i32 = 1 ;
        cv = newXS("POSIX::WEXITSTATUS", XS_POSIX_WEXITSTATUS, file);
        XSANY.any_i32 = 0 ;
        cv = newXS("POSIX::WTERMSIG", XS_POSIX_WEXITSTATUS, file);
        XSANY.any_i32 = 5 ;
        cv = newXS("POSIX::WSTOPSIG", XS_POSIX_WEXITSTATUS, file);
        XSANY.any_i32 = 4 ;
        newXS("POSIX::isalnum", XS_POSIX_isalnum, file);
        newXS("POSIX::isalpha", XS_POSIX_isalpha, file);
        newXS("POSIX::iscntrl", XS_POSIX_iscntrl, file);
        newXS("POSIX::isdigit", XS_POSIX_isdigit, file);
        newXS("POSIX::isgraph", XS_POSIX_isgraph, file);
        newXS("POSIX::islower", XS_POSIX_islower, file);
        newXS("POSIX::isprint", XS_POSIX_isprint, file);
        newXS("POSIX::ispunct", XS_POSIX_ispunct, file);
        newXS("POSIX::isspace", XS_POSIX_isspace, file);
        newXS("POSIX::isupper", XS_POSIX_isupper, file);
        newXS("POSIX::isxdigit", XS_POSIX_isxdigit, file);
        newXS("POSIX::open", XS_POSIX_open, file);
        newXS("POSIX::localeconv", XS_POSIX_localeconv, file);
        newXS("POSIX::setlocale", XS_POSIX_setlocale, file);
        newXS("POSIX::acos", XS_POSIX_acos, file);
        newXS("POSIX::asin", XS_POSIX_asin, file);
        newXS("POSIX::atan", XS_POSIX_atan, file);
        newXS("POSIX::ceil", XS_POSIX_ceil, file);
        newXS("POSIX::cosh", XS_POSIX_cosh, file);
        newXS("POSIX::floor", XS_POSIX_floor, file);
        newXS("POSIX::fmod", XS_POSIX_fmod, file);
        newXS("POSIX::frexp", XS_POSIX_frexp, file);
        newXS("POSIX::ldexp", XS_POSIX_ldexp, file);
        newXS("POSIX::log10", XS_POSIX_log10, file);
        newXS("POSIX::modf", XS_POSIX_modf, file);
        newXS("POSIX::sinh", XS_POSIX_sinh, file);
        newXS("POSIX::tan", XS_POSIX_tan, file);
        newXS("POSIX::tanh", XS_POSIX_tanh, file);
        newXS("POSIX::sigaction", XS_POSIX_sigaction, file);
        newXS("POSIX::sigpending", XS_POSIX_sigpending, file);
        newXS("POSIX::sigprocmask", XS_POSIX_sigprocmask, file);
        newXS("POSIX::sigsuspend", XS_POSIX_sigsuspend, file);
        newXS("POSIX::_exit", XS_POSIX__exit, file);
        newXS("POSIX::close", XS_POSIX_close, file);
        newXS("POSIX::dup", XS_POSIX_dup, file);
        newXS("POSIX::dup2", XS_POSIX_dup2, file);
        newXS("POSIX::lseek", XS_POSIX_lseek, file);
        newXS("POSIX::nice", XS_POSIX_nice, file);
        newXS("POSIX::pipe", XS_POSIX_pipe, file);
        newXS("POSIX::read", XS_POSIX_read, file);
        newXS("POSIX::setpgid", XS_POSIX_setpgid, file);
        newXS("POSIX::setsid", XS_POSIX_setsid, file);
        newXS("POSIX::tcgetpgrp", XS_POSIX_tcgetpgrp, file);
        newXS("POSIX::tcsetpgrp", XS_POSIX_tcsetpgrp, file);
        newXS("POSIX::uname", XS_POSIX_uname, file);
        newXS("POSIX::write", XS_POSIX_write, file);
        newXS("POSIX::tmpnam", XS_POSIX_tmpnam, file);
        newXS("POSIX::abort", XS_POSIX_abort, file);
        newXS("POSIX::mblen", XS_POSIX_mblen, file);
        newXS("POSIX::mbstowcs", XS_POSIX_mbstowcs, file);
        newXS("POSIX::mbtowc", XS_POSIX_mbtowc, file);
        newXS("POSIX::wcstombs", XS_POSIX_wcstombs, file);
        newXS("POSIX::wctomb", XS_POSIX_wctomb, file);
        newXS("POSIX::strcoll", XS_POSIX_strcoll, file);
        newXS("POSIX::strtod", XS_POSIX_strtod, file);
        newXS("POSIX::strtol", XS_POSIX_strtol, file);
        newXS("POSIX::strtoul", XS_POSIX_strtoul, file);
        newXS("POSIX::strxfrm", XS_POSIX_strxfrm, file);
        newXS("POSIX::mkfifo", XS_POSIX_mkfifo, file);
        newXS("POSIX::tcdrain", XS_POSIX_tcdrain, file);
        newXS("POSIX::tcflow", XS_POSIX_tcflow, file);
        newXS("POSIX::tcflush", XS_POSIX_tcflush, file);
        newXS("POSIX::tcsendbreak", XS_POSIX_tcsendbreak, file);
        newXS("POSIX::asctime", XS_POSIX_asctime, file);
        newXS("POSIX::clock", XS_POSIX_clock, file);
        newXS("POSIX::ctime", XS_POSIX_ctime, file);
        newXS("POSIX::times", XS_POSIX_times, file);
        newXS("POSIX::difftime", XS_POSIX_difftime, file);
        newXS("POSIX::mktime", XS_POSIX_mktime, file);
        newXS("POSIX::strftime", XS_POSIX_strftime, file);
        newXS("POSIX::tzset", XS_POSIX_tzset, file);
        newXS("POSIX::tzname", XS_POSIX_tzname, file);
        newXS("POSIX::access", XS_POSIX_access, file);
        newXS("POSIX::ctermid", XS_POSIX_ctermid, file);
        newXS("POSIX::cuserid", XS_POSIX_cuserid, file);
        newXS("POSIX::fpathconf", XS_POSIX_fpathconf, file);
        newXS("POSIX::pathconf", XS_POSIX_pathconf, file);
        newXS("POSIX::pause", XS_POSIX_pause, file);
        newXS("POSIX::setgid", XS_POSIX_setgid, file);
        newXS("POSIX::setuid", XS_POSIX_setuid, file);
        newXS("POSIX::sysconf", XS_POSIX_sysconf, file);
        newXS("POSIX::ttyname", XS_POSIX_ttyname, file);
        newXS("POSIX::getcwd", XS_POSIX_getcwd, file);
        newXS("POSIX::lchown", XS_POSIX_lchown, file);
    }

    /* Initialisation Section */

#line 2 "./const-xs.inc"
  {
#ifdef dTHX
    dTHX;
#endif
    HV *symbol_table = get_hv("POSIX::", GV_ADD);

    static const struct iv_s values_for_iv[] =
      {
#ifdef ARG_MAX
        { "ARG_MAX", 7, ARG_MAX },
#endif
#ifdef B0
        { "B0", 2, B0 },
#endif
#ifdef B110
        { "B110", 4, B110 },
#endif
#ifdef B1200
        { "B1200", 5, B1200 },
#endif
#ifdef B134
        { "B134", 4, B134 },
#endif
#ifdef B150
        { "B150", 4, B150 },
#endif
#ifdef B1800
        { "B1800", 5, B1800 },
#endif
#ifdef B19200
        { "B19200", 6, B19200 },
#endif
#ifdef B200
        { "B200", 4, B200 },
#endif
#ifdef B2400
        { "B2400", 5, B2400 },
#endif
#ifdef B300
        { "B300", 4, B300 },
#endif
#ifdef B38400
        { "B38400", 6, B38400 },
#endif
#ifdef B4800
        { "B4800", 5, B4800 },
#endif
#ifdef B50
        { "B50", 3, B50 },
#endif
#ifdef B600
        { "B600", 4, B600 },
#endif
#ifdef B75
        { "B75", 3, B75 },
#endif
#ifdef B9600
        { "B9600", 5, B9600 },
#endif
#ifdef BRKINT
        { "BRKINT", 6, BRKINT },
#endif
#ifdef BUFSIZ
        { "BUFSIZ", 6, BUFSIZ },
#endif
#ifdef CHAR_BIT
        { "CHAR_BIT", 8, CHAR_BIT },
#endif
#ifdef CHAR_MAX
        { "CHAR_MAX", 8, CHAR_MAX },
#endif
#ifdef CHAR_MIN
        { "CHAR_MIN", 8, CHAR_MIN },
#endif
#ifdef CHILD_MAX
        { "CHILD_MAX", 9, CHILD_MAX },
#endif
#ifdef CLOCAL
        { "CLOCAL", 6, CLOCAL },
#endif
#ifdef CLOCKS_PER_SEC
        { "CLOCKS_PER_SEC", 14, CLOCKS_PER_SEC },
#endif
#ifdef CREAD
        { "CREAD", 5, CREAD },
#endif
#ifdef CS5
        { "CS5", 3, CS5 },
#endif
#ifdef CS6
        { "CS6", 3, CS6 },
#endif
#ifdef CS7
        { "CS7", 3, CS7 },
#endif
#ifdef CS8
        { "CS8", 3, CS8 },
#endif
#ifdef CSIZE
        { "CSIZE", 5, CSIZE },
#endif
#ifdef CSTOPB
        { "CSTOPB", 6, CSTOPB },
#endif
#ifdef E2BIG
        { "E2BIG", 5, E2BIG },
#endif
#ifdef EACCES
        { "EACCES", 6, EACCES },
#endif
#ifdef EADDRINUSE
        { "EADDRINUSE", 10, EADDRINUSE },
#endif
#ifdef EADDRNOTAVAIL
        { "EADDRNOTAVAIL", 13, EADDRNOTAVAIL },
#endif
#ifdef EAFNOSUPPORT
        { "EAFNOSUPPORT", 12, EAFNOSUPPORT },
#endif
#ifdef EAGAIN
        { "EAGAIN", 6, EAGAIN },
#endif
#ifdef EALREADY
        { "EALREADY", 8, EALREADY },
#endif
#ifdef EBADF
        { "EBADF", 5, EBADF },
#endif
#ifdef EBUSY
        { "EBUSY", 5, EBUSY },
#endif
#ifdef ECHILD
        { "ECHILD", 6, ECHILD },
#endif
#ifdef ECHO
        { "ECHO", 4, ECHO },
#endif
#ifdef ECHOE
        { "ECHOE", 5, ECHOE },
#endif
#ifdef ECHOK
        { "ECHOK", 5, ECHOK },
#endif
#ifdef ECHONL
        { "ECHONL", 6, ECHONL },
#endif
#ifdef ECONNABORTED
        { "ECONNABORTED", 12, ECONNABORTED },
#endif
#ifdef ECONNREFUSED
        { "ECONNREFUSED", 12, ECONNREFUSED },
#endif
#ifdef ECONNRESET
        { "ECONNRESET", 10, ECONNRESET },
#endif
#ifdef EDEADLK
        { "EDEADLK", 7, EDEADLK },
#endif
#ifdef EDESTADDRREQ
        { "EDESTADDRREQ", 12, EDESTADDRREQ },
#endif
#ifdef EDOM
        { "EDOM", 4, EDOM },
#endif
#ifdef EDQUOT
        { "EDQUOT", 6, EDQUOT },
#endif
#ifdef EEXIST
        { "EEXIST", 6, EEXIST },
#endif
#ifdef EFAULT
        { "EFAULT", 6, EFAULT },
#endif
#ifdef EFBIG
        { "EFBIG", 5, EFBIG },
#endif
#ifdef EHOSTDOWN
        { "EHOSTDOWN", 9, EHOSTDOWN },
#endif
#ifdef EHOSTUNREACH
        { "EHOSTUNREACH", 12, EHOSTUNREACH },
#endif
#ifdef EINPROGRESS
        { "EINPROGRESS", 11, EINPROGRESS },
#endif
#ifdef EINTR
        { "EINTR", 5, EINTR },
#endif
#ifdef EINVAL
        { "EINVAL", 6, EINVAL },
#endif
#ifdef EIO
        { "EIO", 3, EIO },
#endif
#ifdef EISCONN
        { "EISCONN", 7, EISCONN },
#endif
#ifdef EISDIR
        { "EISDIR", 6, EISDIR },
#endif
#ifdef ELOOP
        { "ELOOP", 5, ELOOP },
#endif
#ifdef EMFILE
        { "EMFILE", 6, EMFILE },
#endif
#ifdef EMLINK
        { "EMLINK", 6, EMLINK },
#endif
#ifdef EMSGSIZE
        { "EMSGSIZE", 8, EMSGSIZE },
#endif
#ifdef ENAMETOOLONG
        { "ENAMETOOLONG", 12, ENAMETOOLONG },
#endif
#ifdef ENETDOWN
        { "ENETDOWN", 8, ENETDOWN },
#endif
#ifdef ENETRESET
        { "ENETRESET", 9, ENETRESET },
#endif
#ifdef ENETUNREACH
        { "ENETUNREACH", 11, ENETUNREACH },
#endif
#ifdef ENFILE
        { "ENFILE", 6, ENFILE },
#endif
#ifdef ENOBUFS
        { "ENOBUFS", 7, ENOBUFS },
#endif
#ifdef ENODEV
        { "ENODEV", 6, ENODEV },
#endif
#ifdef ENOENT
        { "ENOENT", 6, ENOENT },
#endif
#ifdef ENOEXEC
        { "ENOEXEC", 7, ENOEXEC },
#endif
#ifdef ENOLCK
        { "ENOLCK", 6, ENOLCK },
#endif
#ifdef ENOMEM
        { "ENOMEM", 6, ENOMEM },
#endif
#ifdef ENOPROTOOPT
        { "ENOPROTOOPT", 11, ENOPROTOOPT },
#endif
#ifdef ENOSPC
        { "ENOSPC", 6, ENOSPC },
#endif
#ifdef ENOSYS
        { "ENOSYS", 6, ENOSYS },
#endif
#ifdef ENOTBLK
        { "ENOTBLK", 7, ENOTBLK },
#endif
#ifdef ENOTCONN
        { "ENOTCONN", 8, ENOTCONN },
#endif
#ifdef ENOTDIR
        { "ENOTDIR", 7, ENOTDIR },
#endif
#ifdef ENOTEMPTY
        { "ENOTEMPTY", 9, ENOTEMPTY },
#endif
#ifdef ENOTSOCK
        { "ENOTSOCK", 8, ENOTSOCK },
#endif
#ifdef ENOTTY
        { "ENOTTY", 6, ENOTTY },
#endif
#ifdef ENXIO
        { "ENXIO", 5, ENXIO },
#endif
#ifdef EOF
        { "EOF", 3, EOF },
#endif
#ifdef EOPNOTSUPP
        { "EOPNOTSUPP", 10, EOPNOTSUPP },
#endif
#ifdef EPERM
        { "EPERM", 5, EPERM },
#endif
#ifdef EPFNOSUPPORT
        { "EPFNOSUPPORT", 12, EPFNOSUPPORT },
#endif
#ifdef EPIPE
        { "EPIPE", 5, EPIPE },
#endif
#ifdef EPROCLIM
        { "EPROCLIM", 8, EPROCLIM },
#endif
#ifdef EPROTONOSUPPORT
        { "EPROTONOSUPPORT", 15, EPROTONOSUPPORT },
#endif
#ifdef EPROTOTYPE
        { "EPROTOTYPE", 10, EPROTOTYPE },
#endif
#ifdef ERANGE
        { "ERANGE", 6, ERANGE },
#endif
#ifdef EREMOTE
        { "EREMOTE", 7, EREMOTE },
#endif
#ifdef ERESTART
        { "ERESTART", 8, ERESTART },
#endif
#ifdef EROFS
        { "EROFS", 5, EROFS },
#endif
#ifdef ESHUTDOWN
        { "ESHUTDOWN", 9, ESHUTDOWN },
#endif
#ifdef ESOCKTNOSUPPORT
        { "ESOCKTNOSUPPORT", 15, ESOCKTNOSUPPORT },
#endif
#ifdef ESPIPE
        { "ESPIPE", 6, ESPIPE },
#endif
#ifdef ESRCH
        { "ESRCH", 5, ESRCH },
#endif
#ifdef ESTALE
        { "ESTALE", 6, ESTALE },
#endif
#ifdef ETIMEDOUT
        { "ETIMEDOUT", 9, ETIMEDOUT },
#endif
#ifdef ETOOMANYREFS
        { "ETOOMANYREFS", 12, ETOOMANYREFS },
#endif
#ifdef ETXTBSY
        { "ETXTBSY", 7, ETXTBSY },
#endif
#ifdef EUSERS
        { "EUSERS", 6, EUSERS },
#endif
#ifdef EWOULDBLOCK
        { "EWOULDBLOCK", 11, EWOULDBLOCK },
#endif
#ifdef EXDEV
        { "EXDEV", 5, EXDEV },
#endif
#ifdef FILENAME_MAX
        { "FILENAME_MAX", 12, FILENAME_MAX },
#endif
#ifdef F_OK
        { "F_OK", 4, F_OK },
#endif
#ifdef HUPCL
        { "HUPCL", 5, HUPCL },
#endif
#ifdef ICANON
        { "ICANON", 6, ICANON },
#endif
#ifdef ICRNL
        { "ICRNL", 5, ICRNL },
#endif
#ifdef IEXTEN
        { "IEXTEN", 6, IEXTEN },
#endif
#ifdef IGNBRK
        { "IGNBRK", 6, IGNBRK },
#endif
#ifdef IGNCR
        { "IGNCR", 5, IGNCR },
#endif
#ifdef IGNPAR
        { "IGNPAR", 6, IGNPAR },
#endif
#ifdef INLCR
        { "INLCR", 5, INLCR },
#endif
#ifdef INPCK
        { "INPCK", 5, INPCK },
#endif
#ifdef INT_MAX
        { "INT_MAX", 7, INT_MAX },
#endif
#ifdef INT_MIN
        { "INT_MIN", 7, INT_MIN },
#endif
#ifdef ISIG
        { "ISIG", 4, ISIG },
#endif
#ifdef ISTRIP
        { "ISTRIP", 6, ISTRIP },
#endif
#ifdef IXOFF
        { "IXOFF", 5, IXOFF },
#endif
#ifdef IXON
        { "IXON", 4, IXON },
#endif
#ifdef LC_ALL
        { "LC_ALL", 6, LC_ALL },
#endif
#ifdef LC_COLLATE
        { "LC_COLLATE", 10, LC_COLLATE },
#endif
#ifdef LC_CTYPE
        { "LC_CTYPE", 8, LC_CTYPE },
#endif
#ifdef LC_MESSAGES
        { "LC_MESSAGES", 11, LC_MESSAGES },
#endif
#ifdef LC_MONETARY
        { "LC_MONETARY", 11, LC_MONETARY },
#endif
#ifdef LC_NUMERIC
        { "LC_NUMERIC", 10, LC_NUMERIC },
#endif
#ifdef LC_TIME
        { "LC_TIME", 7, LC_TIME },
#endif
#ifdef LINK_MAX
        { "LINK_MAX", 8, LINK_MAX },
#endif
#ifdef LONG_MAX
        { "LONG_MAX", 8, LONG_MAX },
#endif
#ifdef LONG_MIN
        { "LONG_MIN", 8, LONG_MIN },
#endif
#ifdef L_ctermid
        { "L_ctermid", 9, L_ctermid },
#endif
#ifdef L_cuserid
        { "L_cuserid", 9, L_cuserid },
#endif
#ifdef L_tmpnam
        { "L_tmpnam", 8, L_tmpnam },
#endif
#ifdef MAX_CANON
        { "MAX_CANON", 9, MAX_CANON },
#endif
#ifdef MAX_INPUT
        { "MAX_INPUT", 9, MAX_INPUT },
#endif
#ifdef MB_LEN_MAX
        { "MB_LEN_MAX", 10, MB_LEN_MAX },
#endif
#ifdef MSG_CTRUNC
        { "MSG_CTRUNC", 10, MSG_CTRUNC },
#endif
#ifdef MSG_DONTROUTE
        { "MSG_DONTROUTE", 13, MSG_DONTROUTE },
#endif
#ifdef MSG_EOR
        { "MSG_EOR", 7, MSG_EOR },
#endif
#ifdef MSG_OOB
        { "MSG_OOB", 7, MSG_OOB },
#endif
#ifdef MSG_PEEK
        { "MSG_PEEK", 8, MSG_PEEK },
#endif
#ifdef MSG_TRUNC
        { "MSG_TRUNC", 9, MSG_TRUNC },
#endif
#ifdef MSG_WAITALL
        { "MSG_WAITALL", 11, MSG_WAITALL },
#endif
#ifdef NAME_MAX
        { "NAME_MAX", 8, NAME_MAX },
#endif
#ifdef NCCS
        { "NCCS", 4, NCCS },
#endif
#ifdef NGROUPS_MAX
        { "NGROUPS_MAX", 11, NGROUPS_MAX },
#endif
#ifdef NOFLSH
        { "NOFLSH", 6, NOFLSH },
#endif
#ifdef OPEN_MAX
        { "OPEN_MAX", 8, OPEN_MAX },
#endif
#ifdef OPOST
        { "OPOST", 5, OPOST },
#endif
#ifdef PARENB
        { "PARENB", 6, PARENB },
#endif
#ifdef PARMRK
        { "PARMRK", 6, PARMRK },
#endif
#ifdef PARODD
        { "PARODD", 6, PARODD },
#endif
#ifdef PATH_MAX
        { "PATH_MAX", 8, PATH_MAX },
#endif
#ifdef PIPE_BUF
        { "PIPE_BUF", 8, PIPE_BUF },
#endif
#ifdef RAND_MAX
        { "RAND_MAX", 8, RAND_MAX },
#endif
#ifdef R_OK
        { "R_OK", 4, R_OK },
#endif
#ifdef SCHAR_MAX
        { "SCHAR_MAX", 9, SCHAR_MAX },
#endif
#ifdef SCHAR_MIN
        { "SCHAR_MIN", 9, SCHAR_MIN },
#endif
#ifdef SHRT_MAX
        { "SHRT_MAX", 8, SHRT_MAX },
#endif
#ifdef SHRT_MIN
        { "SHRT_MIN", 8, SHRT_MIN },
#endif
#ifdef SIGABRT
        { "SIGABRT", 7, SIGABRT },
#endif
#ifdef SIGALRM
        { "SIGALRM", 7, SIGALRM },
#endif
#ifdef SIGCHLD
        { "SIGCHLD", 7, SIGCHLD },
#endif
#ifdef SIGCONT
        { "SIGCONT", 7, SIGCONT },
#endif
#ifdef SIGFPE
        { "SIGFPE", 6, SIGFPE },
#endif
#ifdef SIGHUP
        { "SIGHUP", 6, SIGHUP },
#endif
#ifdef SIGILL
        { "SIGILL", 6, SIGILL },
#endif
#ifdef SIGINT
        { "SIGINT", 6, SIGINT },
#endif
#ifdef SIGKILL
        { "SIGKILL", 7, SIGKILL },
#endif
#ifdef SIGPIPE
        { "SIGPIPE", 7, SIGPIPE },
#endif
#ifdef SIGQUIT
        { "SIGQUIT", 7, SIGQUIT },
#endif
#ifdef SIGSEGV
        { "SIGSEGV", 7, SIGSEGV },
#endif
#ifdef SIGSTOP
        { "SIGSTOP", 7, SIGSTOP },
#endif
#ifdef SIGTERM
        { "SIGTERM", 7, SIGTERM },
#endif
#ifdef SIGTSTP
        { "SIGTSTP", 7, SIGTSTP },
#endif
#ifdef SIGTTIN
        { "SIGTTIN", 7, SIGTTIN },
#endif
#ifdef SIGTTOU
        { "SIGTTOU", 7, SIGTTOU },
#endif
#ifdef SIGUSR1
        { "SIGUSR1", 7, SIGUSR1 },
#endif
#ifdef SIGUSR2
        { "SIGUSR2", 7, SIGUSR2 },
#endif
#ifdef SIG_BLOCK
        { "SIG_BLOCK", 9, SIG_BLOCK },
#endif
#ifdef SIG_SETMASK
        { "SIG_SETMASK", 11, SIG_SETMASK },
#endif
#ifdef SIG_UNBLOCK
        { "SIG_UNBLOCK", 11, SIG_UNBLOCK },
#endif
#ifdef SSIZE_MAX
        { "SSIZE_MAX", 9, SSIZE_MAX },
#endif
#ifdef SIGBUS
        { "SIGBUS", 6, SIGBUS },
#endif
#ifdef SIGPOLL
        { "SIGPOLL", 7, SIGPOLL },
#endif
#ifdef SIGPROF
        { "SIGPROF", 7, SIGPROF },
#endif
#ifdef SIGSYS
        { "SIGSYS", 6, SIGSYS },
#endif
#ifdef SIGTRAP
        { "SIGTRAP", 7, SIGTRAP },
#endif
#ifdef SIGURG
        { "SIGURG", 6, SIGURG },
#endif
#ifdef SIGVTALRM
        { "SIGVTALRM", 9, SIGVTALRM },
#endif
#ifdef SIGXCPU
        { "SIGXCPU", 7, SIGXCPU },
#endif
#ifdef SIGXFSZ
        { "SIGXFSZ", 7, SIGXFSZ },
#endif
#ifdef STDERR_FILENO
        { "STDERR_FILENO", 13, STDERR_FILENO },
#endif
#ifdef STDIN_FILENO
        { "STDIN_FILENO", 12, STDIN_FILENO },
#endif
#ifdef STDOUT_FILENO
        { "STDOUT_FILENO", 13, STDOUT_FILENO },
#endif
#ifdef STREAM_MAX
        { "STREAM_MAX", 10, STREAM_MAX },
#endif
#ifdef TCIFLUSH
        { "TCIFLUSH", 8, TCIFLUSH },
#endif
#ifdef TCIOFF
        { "TCIOFF", 6, TCIOFF },
#endif
#ifdef TCIOFLUSH
        { "TCIOFLUSH", 9, TCIOFLUSH },
#endif
#ifdef TCION
        { "TCION", 5, TCION },
#endif
#ifdef TCOFLUSH
        { "TCOFLUSH", 8, TCOFLUSH },
#endif
#ifdef TCOOFF
        { "TCOOFF", 6, TCOOFF },
#endif
#ifdef TCOON
        { "TCOON", 5, TCOON },
#endif
#ifdef TCSADRAIN
        { "TCSADRAIN", 9, TCSADRAIN },
#endif
#ifdef TCSAFLUSH
        { "TCSAFLUSH", 9, TCSAFLUSH },
#endif
#ifdef TCSANOW
        { "TCSANOW", 7, TCSANOW },
#endif
#ifdef TMP_MAX
        { "TMP_MAX", 7, TMP_MAX },
#endif
#ifdef TOSTOP
        { "TOSTOP", 6, TOSTOP },
#endif
#ifdef TZNAME_MAX
        { "TZNAME_MAX", 10, TZNAME_MAX },
#endif
#ifdef VEOF
        { "VEOF", 4, VEOF },
#endif
#ifdef VEOL
        { "VEOL", 4, VEOL },
#endif
#ifdef VERASE
        { "VERASE", 6, VERASE },
#endif
#ifdef VINTR
        { "VINTR", 5, VINTR },
#endif
#ifdef VKILL
        { "VKILL", 5, VKILL },
#endif
#ifdef VMIN
        { "VMIN", 4, VMIN },
#endif
#ifdef VQUIT
        { "VQUIT", 5, VQUIT },
#endif
#ifdef VSTART
        { "VSTART", 6, VSTART },
#endif
#ifdef VSTOP
        { "VSTOP", 5, VSTOP },
#endif
#ifdef VSUSP
        { "VSUSP", 5, VSUSP },
#endif
#ifdef VTIME
        { "VTIME", 5, VTIME },
#endif
#ifdef WNOHANG
        { "WNOHANG", 7, WNOHANG },
#endif
#ifdef WUNTRACED
        { "WUNTRACED", 9, WUNTRACED },
#endif
#ifdef W_OK
        { "W_OK", 4, W_OK },
#endif
#ifdef X_OK
        { "X_OK", 4, X_OK },
#endif
#ifdef _PC_CHOWN_RESTRICTED
        { "_PC_CHOWN_RESTRICTED", 20, _PC_CHOWN_RESTRICTED },
#endif
#ifdef _PC_LINK_MAX
        { "_PC_LINK_MAX", 12, _PC_LINK_MAX },
#endif
#ifdef _PC_MAX_CANON
        { "_PC_MAX_CANON", 13, _PC_MAX_CANON },
#endif
#ifdef _PC_MAX_INPUT
        { "_PC_MAX_INPUT", 13, _PC_MAX_INPUT },
#endif
#ifdef _PC_NAME_MAX
        { "_PC_NAME_MAX", 12, _PC_NAME_MAX },
#endif
#ifdef _PC_NO_TRUNC
        { "_PC_NO_TRUNC", 12, _PC_NO_TRUNC },
#endif
#ifdef _PC_PATH_MAX
        { "_PC_PATH_MAX", 12, _PC_PATH_MAX },
#endif
#ifdef _PC_PIPE_BUF
        { "_PC_PIPE_BUF", 12, _PC_PIPE_BUF },
#endif
#ifdef _PC_VDISABLE
        { "_PC_VDISABLE", 12, _PC_VDISABLE },
#endif
#ifdef _SC_ARG_MAX
        { "_SC_ARG_MAX", 11, _SC_ARG_MAX },
#endif
#ifdef _SC_CHILD_MAX
        { "_SC_CHILD_MAX", 13, _SC_CHILD_MAX },
#endif
#ifdef _SC_CLK_TCK
        { "_SC_CLK_TCK", 11, _SC_CLK_TCK },
#endif
#ifdef _SC_JOB_CONTROL
        { "_SC_JOB_CONTROL", 15, _SC_JOB_CONTROL },
#endif
#ifdef _SC_NGROUPS_MAX
        { "_SC_NGROUPS_MAX", 15, _SC_NGROUPS_MAX },
#endif
#ifdef _SC_OPEN_MAX
        { "_SC_OPEN_MAX", 12, _SC_OPEN_MAX },
#endif
#ifdef _SC_PAGESIZE
        { "_SC_PAGESIZE", 12, _SC_PAGESIZE },
#endif
#ifdef _SC_SAVED_IDS
        { "_SC_SAVED_IDS", 13, _SC_SAVED_IDS },
#endif
#ifdef _SC_STREAM_MAX
        { "_SC_STREAM_MAX", 14, _SC_STREAM_MAX },
#endif
#ifdef _SC_TZNAME_MAX
        { "_SC_TZNAME_MAX", 14, _SC_TZNAME_MAX },
#endif
#ifdef _SC_VERSION
        { "_SC_VERSION", 11, _SC_VERSION },
#endif
#ifdef EAI_AGAIN
        { "EAI_AGAIN", 9, EAI_AGAIN },
#endif
#ifdef EAI_BADFLAGS
        { "EAI_BADFLAGS", 12, EAI_BADFLAGS },
#endif
#ifdef EAI_FAIL
        { "EAI_FAIL", 8, EAI_FAIL },
#endif
#ifdef EAI_FAMILY
        { "EAI_FAMILY", 10, EAI_FAMILY },
#endif
#ifdef EAI_MEMORY
        { "EAI_MEMORY", 10, EAI_MEMORY },
#endif
#ifdef EAI_NONAME
        { "EAI_NONAME", 10, EAI_NONAME },
#endif
#ifdef EAI_SERVICE
        { "EAI_SERVICE", 11, EAI_SERVICE },
#endif
#ifdef EAI_SOCKTYPE
        { "EAI_SOCKTYPE", 12, EAI_SOCKTYPE },
#endif
#ifdef EAI_SYSTEM
        { "EAI_SYSTEM", 10, EAI_SYSTEM },
#endif
#ifdef EAI_OVERFLOW
        { "EAI_OVERFLOW", 12, EAI_OVERFLOW },
#endif
#ifdef EXIT_FAILURE
        { "EXIT_FAILURE", 12, EXIT_FAILURE },
#endif
#ifdef EXIT_SUCCESS
        { "EXIT_SUCCESS", 12, EXIT_SUCCESS },
#endif
#ifdef L_tmpname
        { "L_tmpname", 9, L_tmpnam },
#endif
#ifdef NULL
        { "NULL", 4, 0 },
#endif
#ifdef _POSIX_ARG_MAX
        { "_POSIX_ARG_MAX", 14, _POSIX_ARG_MAX },
#endif
#ifdef _POSIX_CHILD_MAX
        { "_POSIX_CHILD_MAX", 16, _POSIX_CHILD_MAX },
#endif
#ifdef _POSIX_CHOWN_RESTRICTED
        { "_POSIX_CHOWN_RESTRICTED", 23, _POSIX_CHOWN_RESTRICTED },
#endif
#ifdef _POSIX_LINK_MAX
        { "_POSIX_LINK_MAX", 15, _POSIX_LINK_MAX },
#endif
#ifdef _POSIX_MAX_CANON
        { "_POSIX_MAX_CANON", 16, _POSIX_MAX_CANON },
#endif
#ifdef _POSIX_MAX_INPUT
        { "_POSIX_MAX_INPUT", 16, _POSIX_MAX_INPUT },
#endif
#ifdef _POSIX_NAME_MAX
        { "_POSIX_NAME_MAX", 15, _POSIX_NAME_MAX },
#endif
#ifdef _POSIX_NGROUPS_MAX
        { "_POSIX_NGROUPS_MAX", 18, _POSIX_NGROUPS_MAX },
#endif
#ifdef _POSIX_NO_TRUNC
        { "_POSIX_NO_TRUNC", 15, _POSIX_NO_TRUNC },
#endif
#ifdef _POSIX_OPEN_MAX
        { "_POSIX_OPEN_MAX", 15, _POSIX_OPEN_MAX },
#endif
#ifdef _POSIX_PATH_MAX
        { "_POSIX_PATH_MAX", 15, _POSIX_PATH_MAX },
#endif
#ifdef _POSIX_PIPE_BUF
        { "_POSIX_PIPE_BUF", 15, _POSIX_PIPE_BUF },
#endif
#ifdef _POSIX_SSIZE_MAX
        { "_POSIX_SSIZE_MAX", 16, _POSIX_SSIZE_MAX },
#endif
#ifdef _POSIX_STREAM_MAX
        { "_POSIX_STREAM_MAX", 17, _POSIX_STREAM_MAX },
#endif
#ifdef _POSIX_TZNAME_MAX
        { "_POSIX_TZNAME_MAX", 17, _POSIX_TZNAME_MAX },
#endif
#ifdef _POSIX_VDISABLE
        { "_POSIX_VDISABLE", 15, _POSIX_VDISABLE },
#endif
#ifdef _POSIX_VERSION
        { "_POSIX_VERSION", 14, _POSIX_VERSION },
#endif
#ifndef EXIT_FAILURE
        /* This is the default value: */
        { "EXIT_FAILURE", 12, 1 },
#endif
#ifndef EXIT_SUCCESS
        /* This is the default value: */
        { "EXIT_SUCCESS", 12, 0 },
#endif
#ifndef _POSIX_JOB_CONTROL
        /* This is the default value: */
        { "_POSIX_JOB_CONTROL", 18, 0 },
#endif
#ifndef _POSIX_SAVED_IDS
        /* This is the default value: */
        { "_POSIX_SAVED_IDS", 16, 0 },
#endif
#ifndef _POSIX_ARG_MAX
        /* This is the default value: */
        { "_POSIX_ARG_MAX", 14, 0 },
#endif
#ifndef _POSIX_CHILD_MAX
        /* This is the default value: */
        { "_POSIX_CHILD_MAX", 16, 0 },
#endif
#ifndef _POSIX_CHOWN_RESTRICTED
        /* This is the default value: */
        { "_POSIX_CHOWN_RESTRICTED", 23, 0 },
#endif
#ifndef _POSIX_LINK_MAX
        /* This is the default value: */
        { "_POSIX_LINK_MAX", 15, 0 },
#endif
#ifndef _POSIX_MAX_CANON
        /* This is the default value: */
        { "_POSIX_MAX_CANON", 16, 0 },
#endif
#ifndef _POSIX_MAX_INPUT
        /* This is the default value: */
        { "_POSIX_MAX_INPUT", 16, 0 },
#endif
#ifndef _POSIX_NAME_MAX
        /* This is the default value: */
        { "_POSIX_NAME_MAX", 15, 0 },
#endif
#ifndef _POSIX_NGROUPS_MAX
        /* This is the default value: */
        { "_POSIX_NGROUPS_MAX", 18, 0 },
#endif
#ifndef _POSIX_NO_TRUNC
        /* This is the default value: */
        { "_POSIX_NO_TRUNC", 15, 0 },
#endif
#ifndef _POSIX_OPEN_MAX
        /* This is the default value: */
        { "_POSIX_OPEN_MAX", 15, 0 },
#endif
#ifndef _POSIX_PATH_MAX
        /* This is the default value: */
        { "_POSIX_PATH_MAX", 15, 0 },
#endif
#ifndef _POSIX_PIPE_BUF
        /* This is the default value: */
        { "_POSIX_PIPE_BUF", 15, 0 },
#endif
#ifndef _POSIX_SSIZE_MAX
        /* This is the default value: */
        { "_POSIX_SSIZE_MAX", 16, 0 },
#endif
#ifndef _POSIX_STREAM_MAX
        /* This is the default value: */
        { "_POSIX_STREAM_MAX", 17, 0 },
#endif
#ifndef _POSIX_TZNAME_MAX
        /* This is the default value: */
        { "_POSIX_TZNAME_MAX", 17, 0 },
#endif
#ifndef _POSIX_VDISABLE
        /* This is the default value: */
        { "_POSIX_VDISABLE", 15, 0 },
#endif
#ifndef _POSIX_VERSION
        /* This is the default value: */
        { "_POSIX_VERSION", 14, 0 },
#endif
        { NULL, 0, 0 } };
	const struct iv_s *value_for_iv = values_for_iv;

    static const struct nv_s values_for_nv[] =
      {
#ifdef DBL_DIG
        { "DBL_DIG", 7, DBL_DIG },
#endif
#ifdef DBL_MANT_DIG
        { "DBL_MANT_DIG", 12, DBL_MANT_DIG },
#endif
#ifdef DBL_MAX_10_EXP
        { "DBL_MAX_10_EXP", 14, DBL_MAX_10_EXP },
#endif
#ifdef DBL_MAX_EXP
        { "DBL_MAX_EXP", 11, DBL_MAX_EXP },
#endif
#ifdef DBL_MIN_10_EXP
        { "DBL_MIN_10_EXP", 14, DBL_MIN_10_EXP },
#endif
#ifdef DBL_MIN_EXP
        { "DBL_MIN_EXP", 11, DBL_MIN_EXP },
#endif
#ifdef FLT_DIG
        { "FLT_DIG", 7, FLT_DIG },
#endif
#ifdef FLT_MANT_DIG
        { "FLT_MANT_DIG", 12, FLT_MANT_DIG },
#endif
#ifdef FLT_MAX_10_EXP
        { "FLT_MAX_10_EXP", 14, FLT_MAX_10_EXP },
#endif
#ifdef FLT_MAX_EXP
        { "FLT_MAX_EXP", 11, FLT_MAX_EXP },
#endif
#ifdef FLT_MIN_10_EXP
        { "FLT_MIN_10_EXP", 14, FLT_MIN_10_EXP },
#endif
#ifdef FLT_MIN_EXP
        { "FLT_MIN_EXP", 11, FLT_MIN_EXP },
#endif
#ifdef FLT_RADIX
        { "FLT_RADIX", 9, FLT_RADIX },
#endif
#ifdef LDBL_DIG
        { "LDBL_DIG", 8, LDBL_DIG },
#endif
#ifdef LDBL_MANT_DIG
        { "LDBL_MANT_DIG", 13, LDBL_MANT_DIG },
#endif
#ifdef LDBL_MAX_10_EXP
        { "LDBL_MAX_10_EXP", 15, LDBL_MAX_10_EXP },
#endif
#ifdef LDBL_MAX_EXP
        { "LDBL_MAX_EXP", 12, LDBL_MAX_EXP },
#endif
#ifdef LDBL_MIN_10_EXP
        { "LDBL_MIN_10_EXP", 15, LDBL_MIN_10_EXP },
#endif
#ifdef LDBL_MIN_EXP
        { "LDBL_MIN_EXP", 12, LDBL_MIN_EXP },
#endif
        { NULL, 0, 0 } };
	const struct nv_s *value_for_nv = values_for_nv;

    static const struct uv_s values_for_uv[] =
      {
#ifdef SA_NOCLDSTOP
        { "SA_NOCLDSTOP", 12, SA_NOCLDSTOP },
#endif
#ifdef SA_NOCLDWAIT
        { "SA_NOCLDWAIT", 12, SA_NOCLDWAIT },
#endif
#ifdef SA_NODEFER
        { "SA_NODEFER", 10, SA_NODEFER },
#endif
#ifdef SA_ONSTACK
        { "SA_ONSTACK", 10, SA_ONSTACK },
#endif
#ifdef SA_RESETHAND
        { "SA_RESETHAND", 12, SA_RESETHAND },
#endif
#ifdef SA_RESTART
        { "SA_RESTART", 10, SA_RESTART },
#endif
#ifdef SA_SIGINFO
        { "SA_SIGINFO", 10, SA_SIGINFO },
#endif
#ifdef UCHAR_MAX
        { "UCHAR_MAX", 9, UCHAR_MAX },
#endif
#ifdef UINT_MAX
        { "UINT_MAX", 8, UINT_MAX },
#endif
#ifdef ULONG_MAX
        { "ULONG_MAX", 9, ULONG_MAX },
#endif
#ifdef USHRT_MAX
        { "USHRT_MAX", 9, USHRT_MAX },
#endif
        { NULL, 0, 0 } };
	const struct uv_s *value_for_uv = values_for_uv;

    static const struct yes_s values_for_yes[] =
      {
#ifdef _POSIX_JOB_CONTROL
        { "_POSIX_JOB_CONTROL", 18 },
#endif
#ifdef _POSIX_SAVED_IDS
        { "_POSIX_SAVED_IDS", 16 },
#endif
        { NULL, 0 } };
	const struct yes_s *value_for_yes = values_for_yes;
        while (value_for_iv->name) {
	    constant_add_symbol(aTHX_  symbol_table, value_for_iv->name,
				value_for_iv->namelen, newSViv(value_for_iv->value));
            ++value_for_iv;
	}
        while (value_for_nv->name) {
	    constant_add_symbol(aTHX_  symbol_table, value_for_nv->name,
				value_for_nv->namelen, newSVnv(value_for_nv->value));
            ++value_for_nv;
	}
        while (value_for_uv->name) {
	    constant_add_symbol(aTHX_  symbol_table, value_for_uv->name,
				value_for_uv->namelen, newSVuv(value_for_uv->value));
            ++value_for_uv;
	}
        while (value_for_yes->name) {
	    constant_add_symbol(aTHX_  symbol_table, value_for_yes->name,
				value_for_yes->namelen, &PL_sv_yes);
            ++value_for_yes;
	}
	if (C_ARRAY_LENGTH(values_for_notfound) > 1) {
#ifndef SYMBIAN
	    HV *const constant_missing = get_missing_hash(aTHX);
#endif
	    const struct notfound_s *value_for_notfound = values_for_notfound;
	    do {

		/* Need to add prototypes, else parsing will vary by platform.  */
		HE *he = (HE*) hv_common_key_len(symbol_table,
						 value_for_notfound->name,
						 value_for_notfound->namelen,
						 HV_FETCH_LVALUE, NULL, 0);
		SV *sv;
#ifndef SYMBIAN
		HEK *hek;
#endif
		if (!he) {
		    Perl_croak(aTHX_ 
			       "Couldn't add key '%s' to %%POSIX::",
			       value_for_notfound->name);
		}
		sv = HeVAL(he);
		if (!SvOK(sv) && SvTYPE(sv) != SVt_PVGV) {
		    /* Nothing was here before, so mark a prototype of ""  */
		    sv_setpvn(sv, "", 0);
		} else if (SvPOK(sv) && SvCUR(sv) == 0) {
		    /* There is already a prototype of "" - do nothing  */
		} else {
		    /* Someone has been here before us - have to make a real
		       typeglob.  */
		    /* It turns out to be incredibly hard to deal with all the
		       corner cases of sub foo (); and reporting errors correctly,
		       so lets cheat a bit.  Start with a constant subroutine  */
		    CV *cv = newCONSTSUB(symbol_table,
					 value_for_notfound->name,
					 &PL_sv_yes);
		    /* and then turn it into a non constant declaration only.  */
		    SvREFCNT_dec(CvXSUBANY(cv).any_ptr);
		    CvCONST_off(cv);
		    CvXSUB(cv) = NULL;
		    CvXSUBANY(cv).any_ptr = NULL;
		}
#ifndef SYMBIAN
		hek = HeKEY_hek(he);
		if (!hv_common(constant_missing, NULL, HEK_KEY(hek),
 			       HEK_LEN(hek), HEK_FLAGS(hek), HV_FETCH_ISSTORE,
			       &PL_sv_yes, HEK_HASH(hek)))
		    Perl_croak(aTHX_  "Couldn't add key '%s' to missing_hash",
			       value_for_notfound->name);
#endif
	    } while ((++value_for_notfound)->name);
	}
#ifdef CLK_TCK
        {
            IV temp0;
            temp0 = CLK_TCK;
	    constant_add_symbol(aTHX_  symbol_table, "CLK_TCK",
				    7, newSViv(temp0));
        }
#endif
#ifdef MB_CUR_MAX
        {
            IV temp0;
            temp0 = MB_CUR_MAX;
	    constant_add_symbol(aTHX_  symbol_table, "MB_CUR_MAX",
				    10, newSViv(temp0));
        }
#endif
#ifdef SIG_DFL
        {
            IV temp0;
            temp0 = PTR2IV(SIG_DFL);
	    constant_add_symbol(aTHX_  symbol_table, "SIG_DFL",
				    7, newSViv(temp0));
        }
#endif
#ifdef SIG_ERR
        {
            IV temp0;
            temp0 = PTR2IV(SIG_ERR);
	    constant_add_symbol(aTHX_  symbol_table, "SIG_ERR",
				    7, newSViv(temp0));
        }
#endif
#ifdef SIG_IGN
        {
            IV temp0;
            temp0 = PTR2IV(SIG_IGN);
	    constant_add_symbol(aTHX_  symbol_table, "SIG_IGN",
				    7, newSViv(temp0));
        }
#endif
#ifdef FLT_ROUNDS
        {
            NV temp0;
            temp0 = FLT_ROUNDS;
	    constant_add_symbol(aTHX_  symbol_table, "FLT_ROUNDS",
				    10, newSVnv(temp0));
        }
#endif
#if (defined(USE_LONG_DOUBLE) && defined(HUGE_VALL)) || defined(HUGE_VAL)
	/* HUGE_VALL is admittedly non-POSIX but if we are using long doubles
	 * we might as well use long doubles. --jhi */
        {
            NV temp0;
            temp0 = 
#if defined(USE_LONG_DOUBLE) && defined(HUGE_VALL)
                   HUGE_VALL
#else
                   HUGE_VAL
#endif
                           ;
	    constant_add_symbol(aTHX_  symbol_table, "HUGE_VAL",
				    8, newSVnv(temp0));
        }
#endif
#ifdef DBL_MAX
        {
            NV temp0;
            temp0 = DBL_MAX;
	    constant_add_symbol(aTHX_  symbol_table, "DBL_MAX",
				    7, newSVnv(temp0));
        }
#endif
#ifdef FLT_MAX
        {
            NV temp0;
            temp0 = FLT_MAX;
	    constant_add_symbol(aTHX_  symbol_table, "FLT_MAX",
				    7, newSVnv(temp0));
        }
#endif
#ifdef LDBL_MAX
        {
            NV temp0;
            temp0 = LDBL_MAX;
	    constant_add_symbol(aTHX_  symbol_table, "LDBL_MAX",
				    8, newSVnv(temp0));
        }
#endif
#ifdef LDBL_MIN
        {
            NV temp0;
            temp0 = LDBL_MIN;
	    constant_add_symbol(aTHX_  symbol_table, "LDBL_MIN",
				    8, newSVnv(temp0));
        }
#endif
#ifdef LDBL_EPSILON
        {
            NV temp0;
            temp0 = LDBL_EPSILON;
	    constant_add_symbol(aTHX_  symbol_table, "LDBL_EPSILON",
				    12, newSVnv(temp0));
        }
#endif
#ifdef DBL_EPSILON
        {
            NV temp0;
            temp0 = DBL_EPSILON;
	    constant_add_symbol(aTHX_  symbol_table, "DBL_EPSILON",
				    11, newSVnv(temp0));
        }
#endif
#ifdef DBL_MIN
        {
            NV temp0;
            temp0 = DBL_MIN;
	    constant_add_symbol(aTHX_  symbol_table, "DBL_MIN",
				    7, newSVnv(temp0));
        }
#endif
#ifdef FLT_EPSILON
        {
            NV temp0;
            temp0 = FLT_EPSILON;
	    constant_add_symbol(aTHX_  symbol_table, "FLT_EPSILON",
				    11, newSVnv(temp0));
        }
#endif
#ifdef FLT_MIN
        {
            NV temp0;
            temp0 = FLT_MIN;
	    constant_add_symbol(aTHX_  symbol_table, "FLT_MIN",
				    7, newSVnv(temp0));
        }
#endif
#ifdef SIGRTMAX
        {
            IV temp0;
            temp0 = SIGRTMAX;
	    constant_add_symbol(aTHX_  symbol_table, "SIGRTMAX",
				    8, newSViv(temp0));
        }
#endif
#ifdef SIGRTMIN
        {
            IV temp0;
            temp0 = SIGRTMIN;
	    constant_add_symbol(aTHX_  symbol_table, "SIGRTMIN",
				    8, newSViv(temp0));
        }
#endif
    /* As we've been creating subroutines, we better invalidate any cached
       methods  */
    mro_method_changed_in(symbol_table);
  }

#line 5985 "POSIX.c"

    /* End of Initialisation Section */

#if (PERL_REVISION == 5 && PERL_VERSION >= 9)
  if (PL_unitcheckav)
       call_list(PL_scopestack_ix, PL_unitcheckav);
#endif
    XSRETURN_YES;
}

