/*
 * This file was generated automatically by ExtUtils::ParseXS version 2.2210 from the
 * contents of Socket.xs. Do not edit this file, edit Socket.xs instead.
 *
 *	ANY CHANGES MADE HERE WILL BE LOST! 
 *
 */

#line 1 "Socket.xs"
#define PERL_NO_GET_CONTEXT
#include "EXTERN.h"
#include "perl.h"
#include "XSUB.h"

#include <stddef.h>

#ifndef VMS
# ifdef I_SYS_TYPES
#  include <sys/types.h>
# endif
# if !defined(ultrix) /* Avoid double definition. */
#   include <sys/socket.h>
# endif
# if defined(USE_SOCKS) && defined(I_SOCKS)
#   include <socks.h>
# endif
# ifdef MPE
#  define PF_INET AF_INET
#  define PF_UNIX AF_UNIX
#  define SOCK_RAW 3
# endif
# ifdef I_SYS_UN
#  include <sys/un.h>
# endif
/* XXX Configure test for <netinet/in_systm.h needed XXX */
# if defined(NeXT) || defined(__NeXT__)
#  include <netinet/in_systm.h>
# endif
# if defined(__sgi) && !defined(AF_LINK) && defined(PF_LINK) && PF_LINK == AF_LNK
#  undef PF_LINK
# endif
# if defined(I_NETINET_IN) || defined(__ultrix__)
#  include <netinet/in.h>
# endif
# ifdef I_NETDB
#  if !defined(ultrix)  /* Avoid double definition. */
#   include <netdb.h>
#  endif
# endif
# ifdef I_ARPA_INET
#  include <arpa/inet.h>
# endif
# ifdef I_NETINET_TCP
#  include <netinet/tcp.h>
# endif
#else
# include "sockadapt.h"
#endif

#ifdef NETWARE
NETDB_DEFINE_CONTEXT
NETINET_DEFINE_CONTEXT
#endif

#ifdef I_SYSUIO
# include <sys/uio.h>
#endif

#ifndef AF_NBS
# undef PF_NBS
#endif

#ifndef AF_X25
# undef PF_X25
#endif

#ifndef INADDR_NONE
# define INADDR_NONE	0xffffffff
#endif /* INADDR_NONE */
#ifndef INADDR_BROADCAST
# define INADDR_BROADCAST	0xffffffff
#endif /* INADDR_BROADCAST */
#ifndef INADDR_LOOPBACK
# define INADDR_LOOPBACK         0x7F000001
#endif /* INADDR_LOOPBACK */

#ifndef HAS_INET_ATON

/*
 * Check whether "cp" is a valid ascii representation
 * of an Internet address and convert to a binary address.
 * Returns 1 if the address is valid, 0 if not.
 * This replaces inet_addr, the return value from which
 * cannot distinguish between failure and a local broadcast address.
 */
static int
my_inet_aton(register const char *cp, struct in_addr *addr)
{
	dTHX;
	register U32 val;
	register int base;
	register char c;
	int nparts;
	const char *s;
	unsigned int parts[4];
	register unsigned int *pp = parts;

       if (!cp || !*cp)
		return 0;
	for (;;) {
		/*
		 * Collect number up to ``.''.
		 * Values are specified as for C:
		 * 0x=hex, 0=octal, other=decimal.
		 */
		val = 0; base = 10;
		if (*cp == '0') {
			if (*++cp == 'x' || *cp == 'X')
				base = 16, cp++;
			else
				base = 8;
		}
		while ((c = *cp) != '\0') {
			if (isDIGIT(c)) {
				val = (val * base) + (c - '0');
				cp++;
				continue;
			}
			if (base == 16 && (s=strchr(PL_hexdigit,c))) {
				val = (val << 4) +
					((s - PL_hexdigit) & 15);
				cp++;
				continue;
			}
			break;
		}
		if (*cp == '.') {
			/*
			 * Internet format:
			 *	a.b.c.d
			 *	a.b.c	(with c treated as 16-bits)
			 *	a.b	(with b treated as 24 bits)
			 */
			if (pp >= parts + 3 || val > 0xff)
				return 0;
			*pp++ = val, cp++;
		} else
			break;
	}
	/*
	 * Check for trailing characters.
	 */
	if (*cp && !isSPACE(*cp))
		return 0;
	/*
	 * Concoct the address according to
	 * the number of parts specified.
	 */
	nparts = pp - parts + 1;	/* force to an int for switch() */
	switch (nparts) {

	case 1:				/* a -- 32 bits */
		break;

	case 2:				/* a.b -- 8.24 bits */
		if (val > 0xffffff)
			return 0;
		val |= parts[0] << 24;
		break;

	case 3:				/* a.b.c -- 8.8.16 bits */
		if (val > 0xffff)
			return 0;
		val |= (parts[0] << 24) | (parts[1] << 16);
		break;

	case 4:				/* a.b.c.d -- 8.8.8.8 bits */
		if (val > 0xff)
			return 0;
		val |= (parts[0] << 24) | (parts[1] << 16) | (parts[2] << 8);
		break;
	}
	addr->s_addr = htonl(val);
	return 1;
}

#undef inet_aton
#define inet_aton my_inet_aton

#endif /* ! HAS_INET_ATON */


static int
not_here(const char *s)
{
    croak("Socket::%s not implemented on this architecture", s);
    return -1;
}

#define PERL_IN_ADDR_S_ADDR_SIZE 4

/*
* Bad assumptions possible here.
*
* Bad Assumption 1: struct in_addr has no other fields
* than the s_addr (which is the field we care about
* in here, really). However, we can be fed either 4-byte
* addresses (from pack("N", ...), or va.b.c.d, or ...),
* or full struct in_addrs (from e.g. pack_sockaddr_in()),
* which may or may not be 4 bytes in size.
*
* Bad Assumption 2: the s_addr field is a simple type
* (such as an int, u_int32_t).  It can be a bit field,
* in which case using & (address-of) on it or taking sizeof()
* wouldn't go over too well.  (Those are not attempted
* now but in case someone thinks to change the below code
* to use addr.s_addr instead of addr, you have been warned.)
*
* Bad Assumption 3: the s_addr is the first field in
* an in_addr, or that its bytes are the first bytes in
* an in_addr.
*
* These bad assumptions are wrong in UNICOS which has
* struct in_addr { struct { u_long  st_addr:32; } s_da };
* #define s_addr s_da.st_addr
* and u_long is 64 bits.
*
* --jhi */

#include "const-c.inc"

#ifdef HAS_GETADDRINFO
static SV *err_to_SV(pTHX_ int err)
{
	SV *ret = sv_newmortal();
	SvUPGRADE(ret, SVt_PVNV);

	if(err) {
		const char *error = gai_strerror(err);
		sv_setpv(ret, error);
	}
	else {
		sv_setpv(ret, "");
	}

	SvIV_set(ret, err); SvIOK_on(ret);

	return ret;
}

static void xs_getaddrinfo(pTHX_ CV *cv)
{
	dVAR;
	dXSARGS;

	SV   *host;
	SV   *service;
	SV   *hints;

	char *hostname = NULL;
	char *servicename = NULL;
	STRLEN len;
	struct addrinfo hints_s;
	struct addrinfo *res;
	struct addrinfo *res_iter;
	int err;
	int n_res;

	if(items > 3)
		croak_xs_usage(cv, "host, service, hints");

	SP -= items;

	if(items < 1)
		host = &PL_sv_undef;
	else
		host = ST(0);

	if(items < 2)
		service = &PL_sv_undef;
	else
		service = ST(1);

	if(items < 3)
		hints = NULL;
	else
		hints = ST(2);

	SvGETMAGIC(host);
	if(SvOK(host)) {
		hostname = SvPV_nomg(host, len);
		if (!len)
			hostname = NULL;
	}

	SvGETMAGIC(service);
	if(SvOK(service)) {
		servicename = SvPV_nomg(service, len);
		if (!len)
			servicename = NULL;
	}

	Zero(&hints_s, sizeof hints_s, char);
	hints_s.ai_family = PF_UNSPEC;

	if(hints && SvOK(hints)) {
		HV *hintshash;
		SV **valp;

		if(!SvROK(hints) || SvTYPE(SvRV(hints)) != SVt_PVHV)
			croak("hints is not a HASH reference");

		hintshash = (HV*)SvRV(hints);

		if((valp = hv_fetch(hintshash, "flags", 5, 0)) != NULL)
			hints_s.ai_flags = SvIV(*valp);
		if((valp = hv_fetch(hintshash, "family", 6, 0)) != NULL)
			hints_s.ai_family = SvIV(*valp);
		if((valp = hv_fetch(hintshash, "socktype", 8, 0)) != NULL)
			hints_s.ai_socktype = SvIV(*valp);
		if((valp = hv_fetch(hintshash, "protocol", 8, 0)) != NULL)
			hints_s.ai_protocol = SvIV(*valp);
	}

	err = getaddrinfo(hostname, servicename, &hints_s, &res);

	XPUSHs(err_to_SV(aTHX_ err));

	if(err)
		XSRETURN(1);

	n_res = 0;
	for(res_iter = res; res_iter; res_iter = res_iter->ai_next) {
		HV *res_hv = newHV();

		(void)hv_stores(res_hv, "family",   newSViv(res_iter->ai_family));
		(void)hv_stores(res_hv, "socktype", newSViv(res_iter->ai_socktype));
		(void)hv_stores(res_hv, "protocol", newSViv(res_iter->ai_protocol));

		(void)hv_stores(res_hv, "addr",     newSVpvn((char*)res_iter->ai_addr, res_iter->ai_addrlen));

		if(res_iter->ai_canonname)
			(void)hv_stores(res_hv, "canonname", newSVpv(res_iter->ai_canonname, 0));
		else
			(void)hv_stores(res_hv, "canonname", newSV(0));

		XPUSHs(sv_2mortal(newRV_noinc((SV*)res_hv)));
		n_res++;
	}

	freeaddrinfo(res);

	XSRETURN(1 + n_res);
}
#endif

#ifdef HAS_GETNAMEINFO
static void xs_getnameinfo(pTHX_ CV *cv)
{
	dVAR;
	dXSARGS;

	SV  *addr;
	int  flags;

	char host[1024];
	char serv[256];
	char *sa; /* we'll cast to struct sockaddr * when necessary */
	STRLEN addr_len;
	int err;

	if(items < 1 || items > 2)
		croak_xs_usage(cv, "addr, flags=0");

	SP -= items;

	addr = ST(0);

	if(items < 2)
		flags = 0;
	else
		flags = SvIV(ST(1));

	if(!SvPOK(addr))
		croak("addr is not a string");

	addr_len = SvCUR(addr);

	/* We need to ensure the sockaddr is aligned, because a random SvPV might
	 * not be due to SvOOK */
	Newx(sa, addr_len, char);
	Copy(SvPV_nolen(addr), sa, addr_len, char);
#ifdef HAS_SOCKADDR_SA_LEN
	((struct sockaddr *)sa)->sa_len = addr_len;
#endif

	err = getnameinfo((struct sockaddr *)sa, addr_len,
			host, sizeof(host),
			serv, sizeof(serv),
			flags);

	Safefree(sa);

	XPUSHs(err_to_SV(aTHX_ err));

	if(err)
		XSRETURN(1);

	XPUSHs(sv_2mortal(newSVpv(host, 0)));
	XPUSHs(sv_2mortal(newSVpv(serv, 0)));

	XSRETURN(3);
}
#endif

#line 417 "Socket.c"
#ifndef PERL_UNUSED_VAR
#  define PERL_UNUSED_VAR(var) if (0) var = var
#endif

#ifndef PERL_ARGS_ASSERT_CROAK_XS_USAGE
#define PERL_ARGS_ASSERT_CROAK_XS_USAGE assert(cv); assert(params)

/* prototype to pass -Wmissing-prototypes */
STATIC void
S_croak_xs_usage(pTHX_ const CV *const cv, const char *const params);

STATIC void
S_croak_xs_usage(pTHX_ const CV *const cv, const char *const params)
{
    const GV *const gv = CvGV(cv);

    PERL_ARGS_ASSERT_CROAK_XS_USAGE;

    if (gv) {
        const char *const gvname = GvNAME(gv);
        const HV *const stash = GvSTASH(gv);
        const char *const hvname = stash ? HvNAME(stash) : NULL;

        if (hvname)
            Perl_croak(aTHX_ "Usage: %s::%s(%s)", hvname, gvname, params);
        else
            Perl_croak(aTHX_ "Usage: %s(%s)", gvname, params);
    } else {
        /* Pants. I don't think that it should be possible to get here. */
        Perl_croak(aTHX_ "Usage: CODE(0x%"UVxf")(%s)", PTR2UV(cv), params);
    }
}
#undef  PERL_ARGS_ASSERT_CROAK_XS_USAGE

#ifdef PERL_IMPLICIT_CONTEXT
#define croak_xs_usage(a,b)	S_croak_xs_usage(aTHX_ a,b)
#else
#define croak_xs_usage		S_croak_xs_usage
#endif

#endif

/* NOTE: the prototype of newXSproto() is different in versions of perls,
 * so we define a portable version of newXSproto()
 */
#ifdef newXS_flags
#define newXSproto_portable(name, c_impl, file, proto) newXS_flags(name, c_impl, file, proto, 0)
#else
#define newXSproto_portable(name, c_impl, file, proto) (PL_Sv=(SV*)newXS(name, c_impl, file), sv_setpv(PL_Sv, proto), (CV*)PL_Sv)
#endif /* !defined(newXS_flags) */

#line 469 "Socket.c"

/* INCLUDE:  Including 'const-xs.inc' from 'Socket.xs' */


XS(XS_Socket_AUTOLOAD); /* prototype to pass -Wmissing-prototypes */
XS(XS_Socket_AUTOLOAD)
{
#ifdef dVAR
    dVAR; dXSARGS;
#else
    dXSARGS;
#endif
    if (items != 0)
       croak_xs_usage(cv,  "");
    PERL_UNUSED_VAR(ax); /* -Wall */
    SP -= items;
    {
#line 744 "./const-xs.inc"
	SV *sv = newSVpvn_flags(SvPVX(cv), SvCUR(cv), SVs_TEMP | SvUTF8(cv));
	const COP *cop = PL_curcop;
#line 490 "Socket.c"
#line 747 "./const-xs.inc"
#ifndef SYMBIAN
	/* It's not obvious how to calculate this at C pre-processor time.
	   However, any compiler optimiser worth its salt should be able to
	   remove the dead code, and hopefully the now-obviously-unused static
	   function too.  */
	HV *constant_missing = (C_ARRAY_LENGTH(values_for_notfound) > 1)
	    ? get_missing_hash(aTHX) : NULL;
	if ((C_ARRAY_LENGTH(values_for_notfound) > 1)
	    ? hv_exists_ent(constant_missing, sv, 0) : 0) {
	    sv = newSVpvf("Your vendor has not defined Socket macro %" SVf
			  ", used at %" COP_FILE_F " line %d\n", sv,
			  COP_FILE(cop), CopLINE(cop));
	} else
#endif
	{
	    sv = newSVpvf("%"SVf" is not a valid Socket macro at %"
			  COP_FILE_F " line %d\n", sv, COP_FILE(cop), CopLINE(cop));
	}
	croak_sv(sv_2mortal(sv));
#line 511 "Socket.c"
	PUTBACK;
	return;
    }
}


/* INCLUDE: Returning to 'Socket.xs' from 'const-xs.inc' */


XS(XS_Socket_inet_aton); /* prototype to pass -Wmissing-prototypes */
XS(XS_Socket_inet_aton)
{
#ifdef dVAR
    dVAR; dXSARGS;
#else
    dXSARGS;
#endif
    if (items != 1)
       croak_xs_usage(cv,  "host");
    {
	char *	host = (char *)SvPV_nolen(ST(0));
#line 423 "Socket.xs"
	{
	struct in_addr ip_address;
	struct hostent * phe;

	if ((*host != '\0') && inet_aton(host, &ip_address)) {
		ST(0) = newSVpvn_flags((char *)&ip_address, sizeof ip_address, SVs_TEMP);
		XSRETURN(1);
	}

	phe = gethostbyname(host);
	if (phe && phe->h_addrtype == AF_INET && phe->h_length == 4) {
		ST(0) = newSVpvn_flags((char *)phe->h_addr, phe->h_length, SVs_TEMP);
		XSRETURN(1);
	}

	XSRETURN_UNDEF;
	}
#line 551 "Socket.c"
    }
    XSRETURN(1);
}


XS(XS_Socket_inet_ntoa); /* prototype to pass -Wmissing-prototypes */
XS(XS_Socket_inet_ntoa)
{
#ifdef dVAR
    dVAR; dXSARGS;
#else
    dXSARGS;
#endif
    if (items != 1)
       croak_xs_usage(cv,  "ip_address_sv");
    {
	SV *	ip_address_sv = ST(0);
#line 445 "Socket.xs"
	{
	STRLEN addrlen;
	struct in_addr addr;
	char * ip_address;
	if (DO_UTF8(ip_address_sv) && !sv_utf8_downgrade(ip_address_sv, 1))
	     croak("Wide character in %s", "Socket::inet_ntoa");
	ip_address = SvPVbyte(ip_address_sv, addrlen);
	if (addrlen == sizeof(addr) || addrlen == 4)
	        addr.s_addr =
		    (ip_address[0] & 0xFF) << 24 |
		    (ip_address[1] & 0xFF) << 16 |
		    (ip_address[2] & 0xFF) <<  8 |
		    (ip_address[3] & 0xFF);
	else
	        croak("Bad arg length for %s, length is %d, should be %d",
		      "Socket::inet_ntoa",
		      addrlen, sizeof(addr));
	/* We could use inet_ntoa() but that is broken
	 * in HP-UX + GCC + 64bitint (returns "0.0.0.0"),
	 * so let's use this sprintf() workaround everywhere.
	 * This is also more threadsafe than using inet_ntoa(). */
	ST(0) = sv_2mortal(Perl_newSVpvf(aTHX_ "%d.%d.%d.%d", /* IPv6? */
					 ((addr.s_addr >> 24) & 0xFF),
					 ((addr.s_addr >> 16) & 0xFF),
					 ((addr.s_addr >>  8) & 0xFF),
					 ( addr.s_addr        & 0xFF)));
	}
#line 597 "Socket.c"
    }
    XSRETURN(1);
}


XS(XS_Socket_sockaddr_family); /* prototype to pass -Wmissing-prototypes */
XS(XS_Socket_sockaddr_family)
{
#ifdef dVAR
    dVAR; dXSARGS;
#else
    dXSARGS;
#endif
    if (items != 1)
       croak_xs_usage(cv,  "sockaddr");
    {
	SV *	sockaddr = ST(0);
#line 477 "Socket.xs"
	STRLEN sockaddr_len;
	char *sockaddr_pv = SvPVbyte(sockaddr, sockaddr_len);
#line 618 "Socket.c"
#line 480 "Socket.xs"
	if (sockaddr_len < offsetof(struct sockaddr, sa_data)) {
	    croak("Bad arg length for %s, length is %d, should be at least %d",
	          "Socket::sockaddr_family", sockaddr_len,
		  offsetof(struct sockaddr, sa_data));
	}
	ST(0) = sv_2mortal(newSViv(((struct sockaddr*)sockaddr_pv)->sa_family));
#line 626 "Socket.c"
    }
    XSRETURN(1);
}


XS(XS_Socket_pack_sockaddr_un); /* prototype to pass -Wmissing-prototypes */
XS(XS_Socket_pack_sockaddr_un)
{
#ifdef dVAR
    dVAR; dXSARGS;
#else
    dXSARGS;
#endif
    if (items != 1)
       croak_xs_usage(cv,  "pathname");
    {
	SV *	pathname = ST(0);
#line 491 "Socket.xs"
	{
#ifdef I_SYS_UN
	struct sockaddr_un sun_ad; /* fear using sun */
	STRLEN len;
	char * pathname_pv;
	int addr_len;

	Zero( &sun_ad, sizeof sun_ad, char );
	sun_ad.sun_family = AF_UNIX;
	pathname_pv = SvPV(pathname,len);
	if (len > sizeof(sun_ad.sun_path))
	    len = sizeof(sun_ad.sun_path);
#  ifdef OS2	/* Name should start with \socket\ and contain backslashes! */
	{
	    int off;
	    char *s, *e;

	    if (pathname_pv[0] != '/' && pathname_pv[0] != '\\')
		croak("Relative UNIX domain socket name '%s' unsupported",
			pathname_pv);
	    else if (len < 8
		     || pathname_pv[7] != '/' && pathname_pv[7] != '\\'
		     || !strnicmp(pathname_pv + 1, "socket", 6))
		off = 7;
	    else
		off = 0;		/* Preserve names starting with \socket\ */
	    Copy( "\\socket", sun_ad.sun_path, off, char);
	    Copy( pathname_pv, sun_ad.sun_path + off, len, char );

	    s = sun_ad.sun_path + off - 1;
	    e = s + len + 1;
	    while (++s < e)
		if (*s = '/')
		    *s = '\\';
	}
#  else	/* !( defined OS2 ) */
	Copy( pathname_pv, sun_ad.sun_path, len, char );
#  endif
	if (0) not_here("dummy");
	if (len > 1 && sun_ad.sun_path[0] == '\0') {
		/* Linux-style abstract-namespace socket.
		 * The name is not a file name, but an array of arbitrary
		 * character, starting with \0 and possibly including \0s,
		 * therefore the length of the structure must denote the
		 * end of that character array */
		addr_len = (char *)&(sun_ad.sun_path) - (char *)&sun_ad + len;
	} else {
		addr_len = sizeof sun_ad;
	}
#  ifdef HAS_SOCKADDR_SA_LEN
	sun_ad.sun_len = addr_len;
#  endif
	ST(0) = newSVpvn_flags((char *)&sun_ad, addr_len, SVs_TEMP);
#else
	ST(0) = (SV *) not_here("pack_sockaddr_un");
#endif

	}
#line 703 "Socket.c"
    }
    XSRETURN(1);
}


XS(XS_Socket_unpack_sockaddr_un); /* prototype to pass -Wmissing-prototypes */
XS(XS_Socket_unpack_sockaddr_un)
{
#ifdef dVAR
    dVAR; dXSARGS;
#else
    dXSARGS;
#endif
    if (items != 1)
       croak_xs_usage(cv,  "sun_sv");
    {
	SV *	sun_sv = ST(0);
#line 554 "Socket.xs"
	{
#ifdef I_SYS_UN
	struct sockaddr_un addr;
	STRLEN sockaddrlen;
	char * sun_ad = SvPVbyte(sun_sv,sockaddrlen);
	int addr_len;
#   ifndef __linux__
	/* On Linux sockaddrlen on sockets returned by accept, recvfrom,
	   getpeername and getsockname is not equal to sizeof(addr). */
	if (sockaddrlen != sizeof(addr)) {
	    croak("Bad arg length for %s, length is %d, should be %d",
			"Socket::unpack_sockaddr_un",
			sockaddrlen, sizeof(addr));
	}
#   endif

	Copy( sun_ad, &addr, sizeof addr, char );

	if ( addr.sun_family != AF_UNIX ) {
	    croak("Bad address family for %s, got %d, should be %d",
			"Socket::unpack_sockaddr_un",
			addr.sun_family,
			AF_UNIX);
	}

	if (addr.sun_path[0] == '\0') {
		/* Linux-style abstract socket address begins with a nul
		 * and can contain nuls. */
		addr_len = (char *)&addr - (char *)&(addr.sun_path) + sockaddrlen;
	} else {
		for (addr_len = 0; addr.sun_path[addr_len]
		     && addr_len < (int)sizeof(addr.sun_path); addr_len++);
	}

	ST(0) = newSVpvn_flags(addr.sun_path, addr_len, SVs_TEMP);
#else
	ST(0) = (SV *) not_here("unpack_sockaddr_un");
#endif
	}
#line 761 "Socket.c"
    }
    XSRETURN(1);
}


XS(XS_Socket_pack_sockaddr_in); /* prototype to pass -Wmissing-prototypes */
XS(XS_Socket_pack_sockaddr_in)
{
#ifdef dVAR
    dVAR; dXSARGS;
#else
    dXSARGS;
#endif
    if (items != 2)
       croak_xs_usage(cv,  "port, ip_address_sv");
    {
	unsigned short	port = (unsigned short)SvUV(ST(0));
	SV *	ip_address_sv = ST(1);
#line 599 "Socket.xs"
	{
	struct sockaddr_in sin;
	struct in_addr addr;
	STRLEN addrlen;
	char * ip_address;
	if (DO_UTF8(ip_address_sv) && !sv_utf8_downgrade(ip_address_sv, 1))
	     croak("Wide character in %s", "Socket::pack_sockaddr_in");
	ip_address = SvPVbyte(ip_address_sv, addrlen);
	if (addrlen == sizeof(addr) || addrlen == 4)
	        addr.s_addr =
		    (ip_address[0] & 0xFF) << 24 |
		    (ip_address[1] & 0xFF) << 16 |
		    (ip_address[2] & 0xFF) <<  8 |
		    (ip_address[3] & 0xFF);
	else
	        croak("Bad arg length for %s, length is %d, should be %d",
		      "Socket::pack_sockaddr_in",
		      addrlen, sizeof(addr));
	Zero( &sin, sizeof sin, char );
	sin.sin_family = AF_INET;
	sin.sin_port = htons(port);
	sin.sin_addr.s_addr = htonl(addr.s_addr);
#  ifdef HAS_SOCKADDR_SA_LEN
	sin.sin_len = sizeof (sin);
#  endif
	ST(0) = newSVpvn_flags((char *)&sin, sizeof (sin), SVs_TEMP);
	}
#line 808 "Socket.c"
    }
    XSRETURN(1);
}


XS(XS_Socket_unpack_sockaddr_in); /* prototype to pass -Wmissing-prototypes */
XS(XS_Socket_unpack_sockaddr_in)
{
#ifdef dVAR
    dVAR; dXSARGS;
#else
    dXSARGS;
#endif
    if (items != 1)
       croak_xs_usage(cv,  "sin_sv");
    PERL_UNUSED_VAR(ax); /* -Wall */
    SP -= items;
    {
	SV *	sin_sv = ST(0);
#line 631 "Socket.xs"
	{
	STRLEN sockaddrlen;
	struct sockaddr_in addr;
	unsigned short	port;
	struct in_addr  ip_address;
	char *	sin = SvPVbyte(sin_sv,sockaddrlen);
	if (sockaddrlen != sizeof(addr)) {
	    croak("Bad arg length for %s, length is %d, should be %d",
			"Socket::unpack_sockaddr_in",
			sockaddrlen, sizeof(addr));
	}
	Copy( sin, &addr,sizeof addr, char );
	if ( addr.sin_family != AF_INET ) {
	    croak("Bad address family for %s, got %d, should be %d",
			"Socket::unpack_sockaddr_in",
			addr.sin_family,
			AF_INET);
	}
	port = ntohs(addr.sin_port);
	ip_address = addr.sin_addr;

	EXTEND(SP, 2);
	PUSHs(sv_2mortal(newSViv((IV) port)));
	PUSHs(newSVpvn_flags((char *)&ip_address, sizeof(ip_address), SVs_TEMP));
	}
#line 854 "Socket.c"
	PUTBACK;
	return;
    }
}


XS(XS_Socket_pack_sockaddr_in6); /* prototype to pass -Wmissing-prototypes */
XS(XS_Socket_pack_sockaddr_in6)
{
#ifdef dVAR
    dVAR; dXSARGS;
#else
    dXSARGS;
#endif
    if (items < 2 || items > 4)
       croak_xs_usage(cv,  "port, sin6_addr, scope_id=0, flowinfo=0");
    {
	unsigned short	port = (unsigned short)SvUV(ST(0));
	SV *	sin6_addr = ST(1);
	unsigned long	scope_id;
	unsigned long	flowinfo;

	if (items < 3)
	    scope_id = 0;
	else {
	    scope_id = (unsigned long)SvUV(ST(2));
	}

	if (items < 4)
	    flowinfo = 0;
	else {
	    flowinfo = (unsigned long)SvUV(ST(3));
	}
#line 664 "Socket.xs"
	{
#ifdef AF_INET6
	struct sockaddr_in6 sin6;
	char * addrbytes;
	STRLEN addrlen;
	if (DO_UTF8(sin6_addr) && !sv_utf8_downgrade(sin6_addr, 1))
	    croak("Wide character in %s", "Socket::pack_sockaddr_in6");
	addrbytes = SvPVbyte(sin6_addr, addrlen);
	if(addrlen != sizeof(sin6.sin6_addr))
	    croak("Bad arg length %s, length is %d, should be %d",
		  "Socket::pack_sockaddr_in6", addrlen, sizeof(sin6.sin6_addr));
	Zero(&sin6, sizeof(sin6), char);
	sin6.sin6_family = AF_INET6;
	sin6.sin6_port = htons(port);
	sin6.sin6_flowinfo = htonl(flowinfo);
	Copy(addrbytes, &sin6.sin6_addr, sizeof(sin6.sin6_addr), char);
#  ifdef HAS_SIN6_SCOPE_ID
	sin6.sin6_scope_id = scope_id;
#  else
	if(scope_id != 0)
	    warn("%s cannot represent non-zero scope_id %d",
	         "Socket::pack_sockaddr_in6", scope_id);
#  endif
#  ifdef HAS_SOCKADDR_SA_LEN
	sin6.sin6_len = sizeof(sin6);
#  endif
	ST(0) = newSVpvn_flags((char *)&sin6, sizeof(sin6), SVs_TEMP);
#else
	ST(0) = (SV*)not_here("pack_sockaddr_in6");
#endif
	}
#line 920 "Socket.c"
    }
    XSRETURN(1);
}


XS(XS_Socket_unpack_sockaddr_in6); /* prototype to pass -Wmissing-prototypes */
XS(XS_Socket_unpack_sockaddr_in6)
{
#ifdef dVAR
    dVAR; dXSARGS;
#else
    dXSARGS;
#endif
    if (items != 1)
       croak_xs_usage(cv,  "sin6_sv");
    PERL_UNUSED_VAR(ax); /* -Wall */
    SP -= items;
    {
	SV *	sin6_sv = ST(0);
#line 700 "Socket.xs"
	{
#ifdef AF_INET6
	STRLEN addrlen;
	struct sockaddr_in6 sin6;
	char * addrbytes = SvPVbyte(sin6_sv, addrlen);
	if (addrlen != sizeof(sin6))
	    croak("Bad arg length for %s, length is %d, should be %d",
		    "Socket::unpack_sockaddr_in6",
		    addrlen, sizeof(sin6));
	Copy(addrbytes, &sin6, sizeof(sin6), char);
	if(sin6.sin6_family != AF_INET6)
	    croak("Bad address family for %s, got %d, should be %d",
		    "Socket::unpack_sockaddr_in6",
		    sin6.sin6_family, AF_INET6);
	EXTEND(SP, 4);
	mPUSHi(ntohs(sin6.sin6_port));
	mPUSHp((char *)&sin6.sin6_addr, sizeof(sin6.sin6_addr));
#  ifdef HAS_SIN6_SCOPE_ID
	mPUSHi(sin6.sin6_scope_id);
#  else
	mPUSHi(0);
#  endif
	mPUSHi(ntohl(sin6.sin6_flowinfo));
#else
	ST(0) = (SV*)not_here("pack_sockaddr_in6");
#endif
	}
#line 968 "Socket.c"
	PUTBACK;
	return;
    }
}


XS(XS_Socket_inet_ntop); /* prototype to pass -Wmissing-prototypes */
XS(XS_Socket_inet_ntop)
{
#ifdef dVAR
    dVAR; dXSARGS;
#else
    dXSARGS;
#endif
    if (items != 2)
       croak_xs_usage(cv,  "af, ip_address_sv");
    {
	int	af = (int)SvIV(ST(0));
	SV *	ip_address_sv = ST(1);
#line 733 "Socket.xs"
#ifdef HAS_INETNTOP
	STRLEN addrlen, struct_size;
#ifdef AF_INET6
	struct in6_addr addr;
	char str[INET6_ADDRSTRLEN];
#else
	struct in_addr addr;
	char str[INET_ADDRSTRLEN];
#endif
	char *ip_address = SvPV(ip_address_sv, addrlen);

	struct_size = sizeof(addr);

	if(af != AF_INET
#ifdef AF_INET6
	    && af != AF_INET6
#endif
	  ) {
           croak("Bad address family for %s, got %d, should be"
#ifdef AF_INET6
	       " either AF_INET or AF_INET6",
#else
	       " AF_INET",
#endif
               "Socket::inet_ntop",
               af);
        }

	Copy( ip_address, &addr, sizeof addr, char );
	inet_ntop(af, &addr, str, sizeof str);

	ST(0) = newSVpvn_flags(str, strlen(str), SVs_TEMP);
#else
        ST(0) = (SV *)not_here("inet_ntop");
#endif
#line 1024 "Socket.c"
    }
    XSRETURN(1);
}


XS(XS_Socket_inet_pton); /* prototype to pass -Wmissing-prototypes */
XS(XS_Socket_inet_pton)
{
#ifdef dVAR
    dVAR; dXSARGS;
#else
    dXSARGS;
#endif
    if (items != 2)
       croak_xs_usage(cv,  "af, host");
    {
	int	af = (int)SvIV(ST(0));
	const char *	host = (const char *)SvPV_nolen(ST(1));
#line 774 "Socket.xs"
#ifdef HAS_INETPTON
        int ok;
#ifdef AF_INET6
	struct in6_addr ip_address;
#else
	struct in_addr ip_address;
#endif

	if(af != AF_INET
#ifdef AF_INET6
		&& af != AF_INET6
#endif
	  ) {
		croak("Bad address family for %s, got %d, should be"
#ifdef AF_INET6
			" either AF_INET or AF_INET6",
#else
			" AF_INET",
#endif
                        "Socket::inet_pton",
                        af);
        }
        ok = (*host != '\0') && inet_pton(af, host, &ip_address);

        ST(0) = sv_newmortal();
        if (ok) {
                sv_setpvn( ST(0), (char *)&ip_address, sizeof(ip_address) );
        }
#else
        ST(0) = (SV *)not_here("inet_pton");
#endif
#line 1075 "Socket.c"
    }
    XSRETURN(1);
}

#ifdef __cplusplus
extern "C"
#endif
XS(boot_Socket); /* prototype to pass -Wmissing-prototypes */
XS(boot_Socket)
{
#ifdef dVAR
    dVAR; dXSARGS;
#else
    dXSARGS;
#endif
#if (PERL_REVISION == 5 && PERL_VERSION < 9)
    char* file = __FILE__;
#else
    const char* file = __FILE__;
#endif

    PERL_UNUSED_VAR(cv); /* -W */
    PERL_UNUSED_VAR(items); /* -W */
#ifdef XS_APIVERSION_BOOTCHECK
    XS_APIVERSION_BOOTCHECK;
#endif
    XS_VERSION_BOOTCHECK ;

        newXS("Socket::AUTOLOAD", XS_Socket_AUTOLOAD, file);
        newXS("Socket::inet_aton", XS_Socket_inet_aton, file);
        newXS("Socket::inet_ntoa", XS_Socket_inet_ntoa, file);
        newXS("Socket::sockaddr_family", XS_Socket_sockaddr_family, file);
        newXS("Socket::pack_sockaddr_un", XS_Socket_pack_sockaddr_un, file);
        newXS("Socket::unpack_sockaddr_un", XS_Socket_unpack_sockaddr_un, file);
        newXS("Socket::pack_sockaddr_in", XS_Socket_pack_sockaddr_in, file);
        newXS("Socket::unpack_sockaddr_in", XS_Socket_unpack_sockaddr_in, file);
        newXS("Socket::pack_sockaddr_in6", XS_Socket_pack_sockaddr_in6, file);
        newXS("Socket::unpack_sockaddr_in6", XS_Socket_unpack_sockaddr_in6, file);
        newXS("Socket::inet_ntop", XS_Socket_inet_ntop, file);
        newXS("Socket::inet_pton", XS_Socket_inet_pton, file);

    /* Initialisation Section */

#line 2 "./const-xs.inc"
  {
#ifdef dTHX
    dTHX;
#endif
    HV *symbol_table = get_hv("Socket::", GV_ADD);

    static const struct iv_s values_for_iv[] =
      {
#ifdef AF_802
        { "AF_802", 6, AF_802 },
#endif
#ifdef AF_AAL
        { "AF_AAL", 6, AF_AAL },
#endif
#ifdef AF_APPLETALK
        { "AF_APPLETALK", 12, AF_APPLETALK },
#endif
#ifdef AF_CCITT
        { "AF_CCITT", 8, AF_CCITT },
#endif
#ifdef AF_CHAOS
        { "AF_CHAOS", 8, AF_CHAOS },
#endif
#ifdef AF_CTF
        { "AF_CTF", 6, AF_CTF },
#endif
#ifdef AF_DATAKIT
        { "AF_DATAKIT", 10, AF_DATAKIT },
#endif
#ifdef AF_DECnet
        { "AF_DECnet", 9, AF_DECnet },
#endif
#ifdef AF_DLI
        { "AF_DLI", 6, AF_DLI },
#endif
#ifdef AF_ECMA
        { "AF_ECMA", 7, AF_ECMA },
#endif
#ifdef AF_GOSIP
        { "AF_GOSIP", 8, AF_GOSIP },
#endif
#ifdef AF_HYLINK
        { "AF_HYLINK", 9, AF_HYLINK },
#endif
#ifdef AF_IMPLINK
        { "AF_IMPLINK", 10, AF_IMPLINK },
#endif
#ifdef AF_INET
        { "AF_INET", 7, AF_INET },
#endif
#ifdef AF_INET6
        { "AF_INET6", 8, AF_INET6 },
#endif
#ifdef AF_ISO
        { "AF_ISO", 6, AF_ISO },
#endif
#ifdef AF_KEY
        { "AF_KEY", 6, AF_KEY },
#endif
#ifdef AF_LAST
        { "AF_LAST", 7, AF_LAST },
#endif
#ifdef AF_LAT
        { "AF_LAT", 6, AF_LAT },
#endif
#ifdef AF_LINK
        { "AF_LINK", 7, AF_LINK },
#endif
#ifdef AF_MAX
        { "AF_MAX", 6, AF_MAX },
#endif
#ifdef AF_NBS
        { "AF_NBS", 6, AF_NBS },
#endif
#ifdef AF_NIT
        { "AF_NIT", 6, AF_NIT },
#endif
#ifdef AF_NS
        { "AF_NS", 5, AF_NS },
#endif
#ifdef AF_OSI
        { "AF_OSI", 6, AF_OSI },
#endif
#ifdef AF_OSINET
        { "AF_OSINET", 9, AF_OSINET },
#endif
#ifdef AF_PUP
        { "AF_PUP", 6, AF_PUP },
#endif
#ifdef AF_ROUTE
        { "AF_ROUTE", 8, AF_ROUTE },
#endif
#ifdef AF_SNA
        { "AF_SNA", 6, AF_SNA },
#endif
#ifdef AF_UNIX
        { "AF_UNIX", 7, AF_UNIX },
#endif
#ifdef AF_UNSPEC
        { "AF_UNSPEC", 9, AF_UNSPEC },
#endif
#ifdef AF_USER
        { "AF_USER", 7, AF_USER },
#endif
#ifdef AF_WAN
        { "AF_WAN", 6, AF_WAN },
#endif
#ifdef AF_X25
        { "AF_X25", 6, AF_X25 },
#endif
#ifdef AI_CANONNAME
        { "AI_CANONNAME", 12, AI_CANONNAME },
#endif
#ifdef AI_NUMERICHOST
        { "AI_NUMERICHOST", 14, AI_NUMERICHOST },
#endif
#ifdef AI_NUMERICSERV
        { "AI_NUMERICSERV", 14, AI_NUMERICSERV },
#endif
#ifdef AI_PASSIVE
        { "AI_PASSIVE", 10, AI_PASSIVE },
#endif
#ifdef EAI_ADDRFAMILY
        { "EAI_ADDRFAMILY", 14, EAI_ADDRFAMILY },
#endif
#ifdef EAI_AGAIN
        { "EAI_AGAIN", 9, EAI_AGAIN },
#endif
#ifdef EAI_BADFLAGS
        { "EAI_BADFLAGS", 12, EAI_BADFLAGS },
#endif
#ifdef EAI_FAIL
        { "EAI_FAIL", 8, EAI_FAIL },
#endif
#ifdef EAI_FAMILY
        { "EAI_FAMILY", 10, EAI_FAMILY },
#endif
#ifdef EAI_NODATA
        { "EAI_NODATA", 10, EAI_NODATA },
#endif
#ifdef EAI_NONAME
        { "EAI_NONAME", 10, EAI_NONAME },
#endif
#ifdef EAI_SERVICE
        { "EAI_SERVICE", 11, EAI_SERVICE },
#endif
#ifdef EAI_SOCKTYPE
        { "EAI_SOCKTYPE", 12, EAI_SOCKTYPE },
#endif
#ifdef IOV_MAX
        { "IOV_MAX", 7, IOV_MAX },
#endif
#ifdef IP_OPTIONS
        { "IP_OPTIONS", 10, IP_OPTIONS },
#endif
#ifdef IP_HDRINCL
        { "IP_HDRINCL", 10, IP_HDRINCL },
#endif
#ifdef IP_TOS
        { "IP_TOS", 6, IP_TOS },
#endif
#ifdef IP_TTL
        { "IP_TTL", 6, IP_TTL },
#endif
#ifdef IP_RECVOPTS
        { "IP_RECVOPTS", 11, IP_RECVOPTS },
#endif
#ifdef IP_RECVRETOPTS
        { "IP_RECVRETOPTS", 14, IP_RECVRETOPTS },
#endif
#ifdef IP_RETOPTS
        { "IP_RETOPTS", 10, IP_RETOPTS },
#endif
#ifdef MSG_BCAST
        { "MSG_BCAST", 9, MSG_BCAST },
#endif
#ifdef MSG_BTAG
        { "MSG_BTAG", 8, MSG_BTAG },
#endif
#ifdef MSG_CTLFLAGS
        { "MSG_CTLFLAGS", 12, MSG_CTLFLAGS },
#endif
#ifdef MSG_CTLIGNORE
        { "MSG_CTLIGNORE", 13, MSG_CTLIGNORE },
#endif
#ifdef MSG_DONTWAIT
        { "MSG_DONTWAIT", 12, MSG_DONTWAIT },
#endif
#ifdef MSG_EOF
        { "MSG_EOF", 7, MSG_EOF },
#endif
#ifdef MSG_EOR
        { "MSG_EOR", 7, MSG_EOR },
#endif
#ifdef MSG_ERRQUEUE
        { "MSG_ERRQUEUE", 12, MSG_ERRQUEUE },
#endif
#ifdef MSG_ETAG
        { "MSG_ETAG", 8, MSG_ETAG },
#endif
#ifdef MSG_FIN
        { "MSG_FIN", 7, MSG_FIN },
#endif
#ifdef MSG_MAXIOVLEN
        { "MSG_MAXIOVLEN", 13, MSG_MAXIOVLEN },
#endif
#ifdef MSG_MCAST
        { "MSG_MCAST", 9, MSG_MCAST },
#endif
#ifdef MSG_NOSIGNAL
        { "MSG_NOSIGNAL", 12, MSG_NOSIGNAL },
#endif
#ifdef MSG_RST
        { "MSG_RST", 7, MSG_RST },
#endif
#ifdef MSG_SYN
        { "MSG_SYN", 7, MSG_SYN },
#endif
#ifdef MSG_TRUNC
        { "MSG_TRUNC", 9, MSG_TRUNC },
#endif
#ifdef MSG_URG
        { "MSG_URG", 7, MSG_URG },
#endif
#ifdef MSG_WAITALL
        { "MSG_WAITALL", 11, MSG_WAITALL },
#endif
#ifdef MSG_WIRE
        { "MSG_WIRE", 8, MSG_WIRE },
#endif
#ifdef NI_DGRAM
        { "NI_DGRAM", 8, NI_DGRAM },
#endif
#ifdef NI_NAMEREQD
        { "NI_NAMEREQD", 11, NI_NAMEREQD },
#endif
#ifdef NI_NUMERICHOST
        { "NI_NUMERICHOST", 14, NI_NUMERICHOST },
#endif
#ifdef NI_NUMERICSERV
        { "NI_NUMERICSERV", 14, NI_NUMERICSERV },
#endif
#ifdef PF_802
        { "PF_802", 6, PF_802 },
#endif
#ifdef PF_AAL
        { "PF_AAL", 6, PF_AAL },
#endif
#ifdef PF_APPLETALK
        { "PF_APPLETALK", 12, PF_APPLETALK },
#endif
#ifdef PF_CCITT
        { "PF_CCITT", 8, PF_CCITT },
#endif
#ifdef PF_CHAOS
        { "PF_CHAOS", 8, PF_CHAOS },
#endif
#ifdef PF_CTF
        { "PF_CTF", 6, PF_CTF },
#endif
#ifdef PF_DATAKIT
        { "PF_DATAKIT", 10, PF_DATAKIT },
#endif
#ifdef PF_DECnet
        { "PF_DECnet", 9, PF_DECnet },
#endif
#ifdef PF_DLI
        { "PF_DLI", 6, PF_DLI },
#endif
#ifdef PF_ECMA
        { "PF_ECMA", 7, PF_ECMA },
#endif
#ifdef PF_GOSIP
        { "PF_GOSIP", 8, PF_GOSIP },
#endif
#ifdef PF_HYLINK
        { "PF_HYLINK", 9, PF_HYLINK },
#endif
#ifdef PF_IMPLINK
        { "PF_IMPLINK", 10, PF_IMPLINK },
#endif
#ifdef PF_INET
        { "PF_INET", 7, PF_INET },
#endif
#ifdef PF_INET6
        { "PF_INET6", 8, PF_INET6 },
#endif
#ifdef PF_ISO
        { "PF_ISO", 6, PF_ISO },
#endif
#ifdef PF_KEY
        { "PF_KEY", 6, PF_KEY },
#endif
#ifdef PF_LAST
        { "PF_LAST", 7, PF_LAST },
#endif
#ifdef PF_LAT
        { "PF_LAT", 6, PF_LAT },
#endif
#ifdef PF_LINK
        { "PF_LINK", 7, PF_LINK },
#endif
#ifdef PF_MAX
        { "PF_MAX", 6, PF_MAX },
#endif
#ifdef PF_NBS
        { "PF_NBS", 6, PF_NBS },
#endif
#ifdef PF_NIT
        { "PF_NIT", 6, PF_NIT },
#endif
#ifdef PF_NS
        { "PF_NS", 5, PF_NS },
#endif
#ifdef PF_OSI
        { "PF_OSI", 6, PF_OSI },
#endif
#ifdef PF_OSINET
        { "PF_OSINET", 9, PF_OSINET },
#endif
#ifdef PF_PUP
        { "PF_PUP", 6, PF_PUP },
#endif
#ifdef PF_ROUTE
        { "PF_ROUTE", 8, PF_ROUTE },
#endif
#ifdef PF_SNA
        { "PF_SNA", 6, PF_SNA },
#endif
#ifdef PF_UNIX
        { "PF_UNIX", 7, PF_UNIX },
#endif
#ifdef PF_UNSPEC
        { "PF_UNSPEC", 9, PF_UNSPEC },
#endif
#ifdef PF_USER
        { "PF_USER", 7, PF_USER },
#endif
#ifdef PF_WAN
        { "PF_WAN", 6, PF_WAN },
#endif
#ifdef PF_X25
        { "PF_X25", 6, PF_X25 },
#endif
#ifdef SCM_CONNECT
        { "SCM_CONNECT", 11, SCM_CONNECT },
#endif
#ifdef SCM_CREDENTIALS
        { "SCM_CREDENTIALS", 15, SCM_CREDENTIALS },
#endif
#ifdef SCM_CREDS
        { "SCM_CREDS", 9, SCM_CREDS },
#endif
#ifdef SCM_TIMESTAMP
        { "SCM_TIMESTAMP", 13, SCM_TIMESTAMP },
#endif
#ifdef SOCK_DGRAM
        { "SOCK_DGRAM", 10, SOCK_DGRAM },
#endif
#ifdef SOCK_RAW
        { "SOCK_RAW", 8, SOCK_RAW },
#endif
#ifdef SOCK_RDM
        { "SOCK_RDM", 8, SOCK_RDM },
#endif
#ifdef SOCK_SEQPACKET
        { "SOCK_SEQPACKET", 14, SOCK_SEQPACKET },
#endif
#ifdef SOCK_STREAM
        { "SOCK_STREAM", 11, SOCK_STREAM },
#endif
#ifdef SOL_SOCKET
        { "SOL_SOCKET", 10, SOL_SOCKET },
#endif
#ifdef SOMAXCONN
        { "SOMAXCONN", 9, SOMAXCONN },
#endif
#ifdef SO_ACCEPTCONN
        { "SO_ACCEPTCONN", 13, SO_ACCEPTCONN },
#endif
#ifdef SO_ATTACH_FILTER
        { "SO_ATTACH_FILTER", 16, SO_ATTACH_FILTER },
#endif
#ifdef SO_BACKLOG
        { "SO_BACKLOG", 10, SO_BACKLOG },
#endif
#ifdef SO_BROADCAST
        { "SO_BROADCAST", 12, SO_BROADCAST },
#endif
#ifdef SO_CHAMELEON
        { "SO_CHAMELEON", 12, SO_CHAMELEON },
#endif
#ifdef SO_DEBUG
        { "SO_DEBUG", 8, SO_DEBUG },
#endif
#ifdef SO_DETACH_FILTER
        { "SO_DETACH_FILTER", 16, SO_DETACH_FILTER },
#endif
#ifdef SO_DGRAM_ERRIND
        { "SO_DGRAM_ERRIND", 15, SO_DGRAM_ERRIND },
#endif
#ifdef SO_DONTLINGER
        { "SO_DONTLINGER", 13, SO_DONTLINGER },
#endif
#ifdef SO_DONTROUTE
        { "SO_DONTROUTE", 12, SO_DONTROUTE },
#endif
#ifdef SO_ERROR
        { "SO_ERROR", 8, SO_ERROR },
#endif
#ifdef SO_FAMILY
        { "SO_FAMILY", 9, SO_FAMILY },
#endif
#ifdef SO_KEEPALIVE
        { "SO_KEEPALIVE", 12, SO_KEEPALIVE },
#endif
#ifdef SO_LINGER
        { "SO_LINGER", 9, SO_LINGER },
#endif
#ifdef SO_OOBINLINE
        { "SO_OOBINLINE", 12, SO_OOBINLINE },
#endif
#ifdef SO_PASSCRED
        { "SO_PASSCRED", 11, SO_PASSCRED },
#endif
#ifdef SO_PASSIFNAME
        { "SO_PASSIFNAME", 13, SO_PASSIFNAME },
#endif
#ifdef SO_PEERCRED
        { "SO_PEERCRED", 11, SO_PEERCRED },
#endif
#ifdef SO_PROTOCOL
        { "SO_PROTOCOL", 11, SO_PROTOCOL },
#endif
#ifdef SO_PROTOTYPE
        { "SO_PROTOTYPE", 12, SO_PROTOTYPE },
#endif
#ifdef SO_RCVBUF
        { "SO_RCVBUF", 9, SO_RCVBUF },
#endif
#ifdef SO_RCVLOWAT
        { "SO_RCVLOWAT", 11, SO_RCVLOWAT },
#endif
#ifdef SO_RCVTIMEO
        { "SO_RCVTIMEO", 11, SO_RCVTIMEO },
#endif
#ifdef SO_REUSEADDR
        { "SO_REUSEADDR", 12, SO_REUSEADDR },
#endif
#ifdef SO_REUSEPORT
        { "SO_REUSEPORT", 12, SO_REUSEPORT },
#endif
#ifdef SO_SECURITY_AUTHENTICATION
        { "SO_SECURITY_AUTHENTICATION", 26, SO_SECURITY_AUTHENTICATION },
#endif
#ifdef SO_SECURITY_ENCRYPTION_NETWORK
        { "SO_SECURITY_ENCRYPTION_NETWORK", 30, SO_SECURITY_ENCRYPTION_NETWORK },
#endif
#ifdef SO_SECURITY_ENCRYPTION_TRANSPORT
        { "SO_SECURITY_ENCRYPTION_TRANSPORT", 32, SO_SECURITY_ENCRYPTION_TRANSPORT },
#endif
#ifdef SO_SNDBUF
        { "SO_SNDBUF", 9, SO_SNDBUF },
#endif
#ifdef SO_SNDLOWAT
        { "SO_SNDLOWAT", 11, SO_SNDLOWAT },
#endif
#ifdef SO_SNDTIMEO
        { "SO_SNDTIMEO", 11, SO_SNDTIMEO },
#endif
#ifdef SO_STATE
        { "SO_STATE", 8, SO_STATE },
#endif
#ifdef SO_TYPE
        { "SO_TYPE", 7, SO_TYPE },
#endif
#ifdef SO_USELOOPBACK
        { "SO_USELOOPBACK", 14, SO_USELOOPBACK },
#endif
#ifdef SO_XOPEN
        { "SO_XOPEN", 8, SO_XOPEN },
#endif
#ifdef SO_XSE
        { "SO_XSE", 6, SO_XSE },
#endif
#ifdef TCP_KEEPALIVE
        { "TCP_KEEPALIVE", 13, TCP_KEEPALIVE },
#endif
#ifdef TCP_MAXRT
        { "TCP_MAXRT", 9, TCP_MAXRT },
#endif
#ifdef TCP_MAXSEG
        { "TCP_MAXSEG", 10, TCP_MAXSEG },
#endif
#ifdef TCP_NODELAY
        { "TCP_NODELAY", 11, TCP_NODELAY },
#endif
#ifdef TCP_STDURG
        { "TCP_STDURG", 10, TCP_STDURG },
#endif
#ifdef TCP_CORK
        { "TCP_CORK", 8, TCP_CORK },
#endif
#ifdef TCP_KEEPIDLE
        { "TCP_KEEPIDLE", 12, TCP_KEEPIDLE },
#endif
#ifdef TCP_KEEPINTVL
        { "TCP_KEEPINTVL", 13, TCP_KEEPINTVL },
#endif
#ifdef TCP_KEEPCNT
        { "TCP_KEEPCNT", 11, TCP_KEEPCNT },
#endif
#ifdef TCP_SYNCNT
        { "TCP_SYNCNT", 10, TCP_SYNCNT },
#endif
#ifdef TCP_LINGER2
        { "TCP_LINGER2", 11, TCP_LINGER2 },
#endif
#ifdef TCP_DEFER_ACCEPT
        { "TCP_DEFER_ACCEPT", 16, TCP_DEFER_ACCEPT },
#endif
#ifdef TCP_WINDOW_CLAMP
        { "TCP_WINDOW_CLAMP", 16, TCP_WINDOW_CLAMP },
#endif
#ifdef TCP_INFO
        { "TCP_INFO", 8, TCP_INFO },
#endif
#ifdef TCP_QUICKACK
        { "TCP_QUICKACK", 12, TCP_QUICKACK },
#endif
#ifdef TCP_CONGESTION
        { "TCP_CONGESTION", 14, TCP_CONGESTION },
#endif
#ifdef TCP_MD5SIG
        { "TCP_MD5SIG", 10, TCP_MD5SIG },
#endif
#ifdef UIO_MAXIOV
        { "UIO_MAXIOV", 10, UIO_MAXIOV },
#endif
#ifdef IPPROTO_IP
        { "IPPROTO_IP", 10, IPPROTO_IP },
#endif
#ifdef IPPROTO_IPV6
        { "IPPROTO_IPV6", 12, IPPROTO_IPV6 },
#endif
#ifdef IPPROTO_RAW
        { "IPPROTO_RAW", 11, IPPROTO_RAW },
#endif
#ifdef IPPROTO_ICMP
        { "IPPROTO_ICMP", 12, IPPROTO_ICMP },
#endif
#ifdef IPPROTO_TCP
        { "IPPROTO_TCP", 11, IPPROTO_TCP },
#endif
#ifdef IPPROTO_UDP
        { "IPPROTO_UDP", 11, IPPROTO_UDP },
#endif
#ifdef SHUT_RD
        { "SHUT_RD", 7, SHUT_RD },
#endif
#ifdef SHUT_WR
        { "SHUT_WR", 7, SHUT_WR },
#endif
#ifdef SHUT_RDWR
        { "SHUT_RDWR", 9, SHUT_RDWR },
#endif
#if defined(MSG_CTRUNC) || defined(HAS_MSG_CTRUNC) /* might be an enum */
        { "MSG_CTRUNC", 10, MSG_CTRUNC },
#endif
#if defined(MSG_DONTROUTE) || defined(HAS_MSG_DONTROUTE) /* might be an enum */
        { "MSG_DONTROUTE", 13, MSG_DONTROUTE },
#endif
#if defined(MSG_OOB) || defined(HAS_MSG_OOB) /* might be an enum */
        { "MSG_OOB", 7, MSG_OOB },
#endif
#if defined(MSG_PEEK) || defined(HAS_MSG_PEEK) /* might be an enum */
        { "MSG_PEEK", 8, MSG_PEEK },
#endif
#if defined(MSG_PROXY) || defined(HAS_MSG_PROXY) /* might be an enum */
        { "MSG_PROXY", 9, MSG_PROXY },
#endif
#if defined(SCM_RIGHTS) || defined(HAS_SCM_RIGHTS) /* might be an enum */
        { "SCM_RIGHTS", 10, SCM_RIGHTS },
#endif
#ifndef IPPROTO_IP
        /* This is the default value: */
        { "IPPROTO_IP", 10, 0 },
#endif
#ifndef IPPROTO_IPV6
        /* This is the default value: */
        { "IPPROTO_IPV6", 12, 41 },
#endif
#ifndef IPPROTO_RAW
        /* This is the default value: */
        { "IPPROTO_RAW", 11, 255 },
#endif
#ifndef IPPROTO_ICMP
        /* This is the default value: */
        { "IPPROTO_ICMP", 12, 1 },
#endif
#ifndef IPPROTO_TCP
        /* This is the default value: */
        { "IPPROTO_TCP", 11, 6 },
#endif
#ifndef IPPROTO_UDP
        /* This is the default value: */
        { "IPPROTO_UDP", 11, 17 },
#endif
#ifndef SHUT_RD
        /* This is the default value: */
        { "SHUT_RD", 7, 0 },
#endif
#ifndef SHUT_WR
        /* This is the default value: */
        { "SHUT_WR", 7, 1 },
#endif
#ifndef SHUT_RDWR
        /* This is the default value: */
        { "SHUT_RDWR", 9, 2 },
#endif
        { NULL, 0, 0 } };
	const struct iv_s *value_for_iv = values_for_iv;
        while (value_for_iv->name) {
	    constant_add_symbol(aTHX_  symbol_table, value_for_iv->name,
				value_for_iv->namelen, newSViv(value_for_iv->value));
            ++value_for_iv;
	}
	if (C_ARRAY_LENGTH(values_for_notfound) > 1) {
#ifndef SYMBIAN
	    HV *const constant_missing = get_missing_hash(aTHX);
#endif
	    const struct notfound_s *value_for_notfound = values_for_notfound;
	    do {

		/* Need to add prototypes, else parsing will vary by platform.  */
		HE *he = (HE*) hv_common_key_len(symbol_table,
						 value_for_notfound->name,
						 value_for_notfound->namelen,
						 HV_FETCH_LVALUE, NULL, 0);
		SV *sv;
#ifndef SYMBIAN
		HEK *hek;
#endif
		if (!he) {
		    Perl_croak(aTHX_ 
			       "Couldn't add key '%s' to %%Socket::",
			       value_for_notfound->name);
		}
		sv = HeVAL(he);
		if (!SvOK(sv) && SvTYPE(sv) != SVt_PVGV) {
		    /* Nothing was here before, so mark a prototype of ""  */
		    sv_setpvn(sv, "", 0);
		} else if (SvPOK(sv) && SvCUR(sv) == 0) {
		    /* There is already a prototype of "" - do nothing  */
		} else {
		    /* Someone has been here before us - have to make a real
		       typeglob.  */
		    /* It turns out to be incredibly hard to deal with all the
		       corner cases of sub foo (); and reporting errors correctly,
		       so lets cheat a bit.  Start with a constant subroutine  */
		    CV *cv = newCONSTSUB(symbol_table,
					 value_for_notfound->name,
					 &PL_sv_yes);
		    /* and then turn it into a non constant declaration only.  */
		    SvREFCNT_dec(CvXSUBANY(cv).any_ptr);
		    CvCONST_off(cv);
		    CvXSUB(cv) = NULL;
		    CvXSUBANY(cv).any_ptr = NULL;
		}
#ifndef SYMBIAN
		hek = HeKEY_hek(he);
		if (!hv_common(constant_missing, NULL, HEK_KEY(hek),
 			       HEK_LEN(hek), HEK_FLAGS(hek), HV_FETCH_ISSTORE,
			       &PL_sv_yes, HEK_HASH(hek)))
		    Perl_croak(aTHX_  "Couldn't add key '%s' to missing_hash",
			       value_for_notfound->name);
#endif
	    } while ((++value_for_notfound)->name);
	}
#ifdef INADDR_ANY
        {
            SV * temp0;
            struct in_addr ip_address; ip_address.s_addr = htonl(INADDR_ANY);
            temp0 = newSVpvn_flags((char *)&ip_address,sizeof(ip_address), SVs_TEMP);
	    constant_add_symbol(aTHX_  symbol_table, "INADDR_ANY",
				    10, SvREFCNT_inc(temp0));
        }
#endif
#ifdef INADDR_LOOPBACK
        {
            SV * temp0;
            struct in_addr ip_address; ip_address.s_addr = htonl(INADDR_LOOPBACK);
            temp0 = newSVpvn_flags((char *)&ip_address,sizeof(ip_address), SVs_TEMP);
	    constant_add_symbol(aTHX_  symbol_table, "INADDR_LOOPBACK",
				    15, SvREFCNT_inc(temp0));
        }
#endif
#ifdef INADDR_NONE
        {
            SV * temp0;
            struct in_addr ip_address; ip_address.s_addr = htonl(INADDR_NONE);
            temp0 = newSVpvn_flags((char *)&ip_address,sizeof(ip_address), SVs_TEMP);
	    constant_add_symbol(aTHX_  symbol_table, "INADDR_NONE",
				    11, SvREFCNT_inc(temp0));
        }
#endif
#ifdef INADDR_BROADCAST
        {
            SV * temp0;
            struct in_addr ip_address; ip_address.s_addr = htonl(INADDR_BROADCAST);
            temp0 = newSVpvn_flags((char *)&ip_address,sizeof(ip_address), SVs_TEMP);
	    constant_add_symbol(aTHX_  symbol_table, "INADDR_BROADCAST",
				    16, SvREFCNT_inc(temp0));
        }
#endif
#ifdef IN6ADDR_ANY_INIT
        {
            SV * temp0;
            struct in6_addr ip6_address = IN6ADDR_ANY_INIT;
            temp0 = newSVpvn_flags((char *)&ip6_address,sizeof(ip6_address), SVs_TEMP);
	    constant_add_symbol(aTHX_  symbol_table, "IN6ADDR_ANY",
				    11, SvREFCNT_inc(temp0));
        }
#endif
#ifdef IN6ADDR_LOOPBACK_INIT
        {
            SV * temp0;
            struct in6_addr ip6_address = IN6ADDR_LOOPBACK_INIT;
            temp0 = newSVpvn_flags((char *)&ip6_address,sizeof(ip6_address), SVs_TEMP);
	    constant_add_symbol(aTHX_  symbol_table, "IN6ADDR_LOOPBACK",
				    16, SvREFCNT_inc(temp0));
        }
#endif
    /* As we've been creating subroutines, we better invalidate any cached
       methods  */
    mro_method_changed_in(symbol_table);
  }

#line 412 "Socket.xs"
#ifdef HAS_GETADDRINFO
  newXS("Socket::getaddrinfo", xs_getaddrinfo, __FILE__);
#endif
#ifdef HAS_GETNAMEINFO
  newXS("Socket::getnameinfo", xs_getnameinfo, __FILE__);
#endif

#line 1866 "Socket.c"

    /* End of Initialisation Section */

#if (PERL_REVISION == 5 && PERL_VERSION >= 9)
  if (PL_unitcheckav)
       call_list(PL_scopestack_ix, PL_unitcheckav);
#endif
    XSRETURN_YES;
}

