#include "system.h"
const char *__progname;

#include <rpmio.h>
#include <rpmiotypes.h>
#include <rpmcb.h>
#include <argv.h>
#include <rpmtypes.h>
#include <rpmtag.h>

#include <rpmds.h>
#define   _RPMFC_INTERNAL     /* XXX for debugging */
#include <rpmfc.h>

#include <rpmcli.h>

#include "debug.h"

/*@unchecked@*/
char *progname;

#define   RPMDEP_RPMFC        1

static int rpmdepPrint(char *filename, rpmds ds, FILE * fp)
{
    if (fp == NULL) fp = stderr;

    ds = rpmdsInit(ds);
    while (rpmdsNext(ds) >= 0) {
  fprintf(fp, "%s %s: %s\n", filename, rpmdsType(ds), rpmdsDNEVR(ds)+2);
    }
    return 0;
}

static struct poptOption optionsTable[] = {

 { NULL, '\0', POPT_ARG_INCLUDE_TABLE, rpmcliAllPoptTable, 0,
  N_("Common options:"),
  NULL }, 

   POPT_AUTOALIAS
   POPT_AUTOHELP
   POPT_TABLEEND
};


int
main(int argc, char *argv[])
{
    poptContext optCon;
    ARGV_t av = NULL;
    rpmfc fc = NULL;
    FILE * fp = NULL;
    int flags = 0;
    int ac = 0;
    int ec = 1;
    int xx;
    int i;
    char buf[BUFSIZ];
    int nddict;
    const char * s;
    char * se;
    const char * fn;
    const char * N;
    const char * EVR;
    evrFlags Flags;
    unsigned char deptype;
    int ix;
    rpmds ds;

/*@-modobserver@*/
    if ((progname = strrchr(argv[0], '/')) != NULL)
  progname++;
    else
  progname = argv[0];
/*@=modobserver@*/

    optCon = rpmcliInit(argc, argv, optionsTable);
    if (optCon == NULL)
  goto exit;

    av = poptGetArgs(optCon);
    ac = argvCount(av);

    if (ac == 0) {
  av = NULL;
  xx = argvFgets(&av, NULL);
  ac = argvCount(av);
    }

    /* Make sure file names are sorted. */
    xx = argvSort(av, NULL);

    /* Build file class dictionary. */
    fc = rpmfcNew();
    xx = rpmfcClassify(fc, av, NULL);

    /* Build file/package dependency dictionary. */
    xx = rpmfcApply(fc);

    /* Generate per-file indices into package dependencies. */
    nddict = argvCount(fc->ddict);

    for (i = 0; i < nddict; i++) {
  s = fc->ddict[i];

  /* Parse out (file#,deptype,N,EVR,Flags) */
  ix = strtol(s, &se, 10);
  assert(se != NULL);
  deptype = *se++;
  se++;
  N = se;
  while (*se && *se != ' ')
      se++;
  *se++ = '\0';
  EVR = se;
  while (*se && *se != ' ')
      se++;
  *se++ = '\0';
  Flags = strtol(se, NULL, 16);

  switch (deptype) {
  default:
      /*@switchbreak@*/ break;
  case 'P':   
      ds = rpmdsSingle(RPMTAG_PROVIDENAME, N, EVR, Flags);
      rpmdepPrint((char *)fc->fn[ix], ds, stdout);
      (void)rpmdsFree(ds);
      ds = NULL;
      /*@switchbreak@*/ break;
  case 'R':
      ds = rpmdsSingle(RPMTAG_REQUIRENAME, N, EVR, Flags);
      rpmdepPrint((char *)fc->fn[ix], ds, stdout);
      (void)rpmdsFree(ds);
      ds = NULL;
      /*@switchbreak@*/ break;
  }
    }

    fc = rpmfcFree(fc);

    ec = 0;

exit:
    optCon = rpmcliFini(optCon);
    return ec;
}
