var answersArray;
var questionsArray;
var questionsCount;
var pageIndex;
var correctCards = 0;

$(document).ready(function() {
	entryPoint();
});

function init(){
	$('#ajax-cont').html('<div id="cardPile"> </div><div id="cardSlots"> </div>');
	$('#cardPile').droppable({
		accept: '.card',
		drop: function (even,ui) { 
			ui.draggable.draggable( 'option', 'revert', false );
			$('#cardSlots .slot[card="' + ui.draggable.attr('id') + '"]').attr('card', '');
		},
		out: handleCardOut,
		hoverClass: 'hovered'
	});
	
	$('#ajax-questions').html('<ul id="nonsortable"></ul>');

	answersArray = [];
	questionsArray = [];
	questionsCount = 0;
	answersCount = 0;
	
	$(gameXMLDOM).find('Question').each(function (index, item) {
		questionsArray.push({ text: $(item).text(), correct: index });
	});
	
	$(gameXMLDOM).find('Answer').each(function (index, item) {
		answersArray.push({ text: $(item).text(), correct: index });
	});
}

function getPagesCount() {
	return 1;
}

function getAudio () {
	return '';
}

function getPage(pageNumber){
	
}

function onCheckPageAnswer() {
	$('#cardSlots .slot').each(function(sIndex, slot) {
		if ( $(slot).attr( 'correct' ) === $(slot).attr('card') ) {
			$(this).addClass( 'correct' );
			$(this).removeClass( 'incorrect' );
		} else {
			$(this).addClass( 'incorrect' );
			$(this).removeClass( 'correct' );
		}
		$(slot).addClass('show');
	});
}

function reset() {
	// Reset the game
	$('#cardPile').html( '' );
	$('#cardSlots').html( '' );

	// Create the pile of shuffled cards
	answersArray.sort(function() { return Math.random() - 0.5; });
	for ( var i=0; i<answersArray.length; i++ ) {
		$('<div class="card" id="' + answersArray[i].correct + '">' + answersArray[i].text + '</div>').appendTo( '#cardPile' ).draggable( {
			stack: '#cardPile div',
			cursor: 'move',
			revert: true
		} );
	}

	// Create the card slots
	questionsArray.sort(function() { return Math.random() - 0.5; });
	for ( i=0; i<questionsArray.length; i++ ) {
		$slot = $(
			'<div class="slot incorrect" correct="' + questionsArray[i].correct + '">&nbsp;' +
				'<div class="text">' + questionsArray[i].text + '</div>' +
				'<img id="incorrect-icon" src="images/icon-incorrect.png"/>' +
				'<img id="correct-icon" src="images/icon-correct.png"/>' +
			'</div>');
		$slot.droppable( {
			accept: '.card',
			hoverClass: 'hovered',
			drop: handleCardDrop,
			out: handleCardOut
		});
		$('#cardSlots').append($slot);
	}
}

function handleCardDrop( event, ui ) {
	if ($(this).attr('card') === '' || $(this).attr('card') === undefined) {
		$('#cardSlots .slot[card="' + ui.draggable.attr('id') + '"]').attr('card', '');
		$(this).attr('card', ui.draggable.attr('id'));
		
		ui.draggable.position( { of: $(this), my: 'right center', at: 'right center' } );
		ui.draggable.draggable( 'option', 'revert', false );
	}
}

function handleCardOut (event, ui) {
	ui.draggable.draggable( 'option', 'revert', true );
}

function getScore() {
	var questions = [];
	var answers = [];
	var corrects = [];
	var points = [];
	var totals = [];
	var gamePoints = 0;
	var gameTotal = 0;
	
	$('#cardSlots .slot').each(function(sIndex, slot) {
		questions.push('');
		
		var answer = $('#cardPile .card[id="' + $(slot).attr('card') + '"]').text();
		if (answer !== '') {
			answers.push($(slot).text() + ' ' + answer);
		} else {
			answers.push('You did not give any answer');
		}
		
		corrects.push($(slot).text() + ' ' + $('#cardPile .card[id="' + $(slot).attr('correct') + '"]').text());
		
		if ($(slot).hasClass('correct')) {
			points.push(1);
			gamePoints ++;
		} else {
			points.push(0);
		}
		totals.push(1);
		gameTotal++;
	});
	
	return {
		'questions': questions,
		'answers': answers,
		'corrects': corrects,
		'points': points,
		'totals': totals,
		'gamePoints': gamePoints,
		'gameTotal': gameTotal
	};
}