var pageIndex;
var questionsArray = [];

$(document).ready(function() {
	entryPoint();
});

//Game-specific initialization
function init(){
	//TrueOrFalse with each question on a separate page is equivalent to MultipleChoice game style
	if (gameDisplayOptions == 0) {
		$('head link[href="css/TrueOrFalse.css"]').remove();
		$('<link/>', { rel: 'stylesheet', type: 'text/css', href: 'css/MultipleChoice.css'}).appendTo('head');
		$.getScript('js/MultipleChoice.js');
		return;
	}
	
	$('#ajax-questions').html('<ul></ul>');
	
	var defaultOptions = '';
	$(gameXMLDOM).find('GlobalOptions > Option').each(function(index, Element) {
		defaultOptions +=
			'<a class="options" href="javascript:void(0)" value='+$(this).attr('value')+' onclick="answerQuestion(this)">' +
				'<span>' + $(this).text() + '</span>' +
			'</a>';
	});
		
	$(gameXMLDOM).find('MultipleChoiceQuestionItem').each(function(key, Element) {
		$options = $(this).find('Option');
		var options = '';
		
		if ($options.length !== 0) {
			$options.each(function (oIndex, option) {
				options +=
					'<a class="options" href="javascript:void(0)" value="' + $(option).attr('value') + '" onclick="answerQuestion(this)">' + 
						'<span>' + $(option).text() + '</span>' +
					'</a>';
			});
		} else {
			options = defaultOptions;
		}
		
		questionsArray.push({
			question: $(this).find('Question').text(),
			options: options,
			correct: $(this).find('Answer').text()
		});
	});
}

//Should return the number of pages
function getPagesCount() {
	return 1;
}

//If there are several pages, page loading handler
function getPage(pageNumber){
	
}

//Audio file, if available
function getAudio() {
	return '';
}

//When Check Answers button is pressed
function onCheckPageAnswer() {
	$('#ajax-questions li').each(function() {
		var $thisQuestion = $(this);
		var answered = $thisQuestion.attr('answered');
		var answer = $thisQuestion.data('answer');
		$thisQuestion.removeClass('correct');
		$thisQuestion.removeClass('incorrect');
		if (answer === answered) {
			$thisQuestion.addClass('correct');
		} else {
			$thisQuestion.addClass('incorrect');
		}
	});
}

//Game-specific reset procedure
function reset() {
	var $questionList = $('#ajax-questions ul');
	$questionList.empty();
	$.each(questionsArray, function (key, question) {
		var domString =
			'<li id="' + (key + 1) + '" class="items">' +
				'<span class="question">' + question.question + '</span>' +
				'<div class="btn-group">' + question.options + '</div>' +
			'</li>';
		var $domString = $(domString).data('answer', question.correct);
		$questionList.append($domString);
	});
}

//The score values to be displayed after the game finish
//returns: {percentage: , points: , total: }
function getScore() {
	var questions = [];
	var answers = [];
	var corrects = [];
	var points = [];
	var totals = [];
	var gamePoints = 0;
	var gameTotal = 0;
	
	$('#ajax-questions .items').each(function(qIndex, question) {
		questions.push($(question).find('.question').text());
		
		answers.push($(question).find('.btn-group .options.selected').text());
		
		corrects.push($(question).find('.btn-group .options[value="' + $(question).data('answer') + '"]').text());
		
		if ($(question).hasClass('correct')) {
			points.push(1);
			gamePoints ++;
		} else {
			points.push(0);
		}
		totals.push(1);
		gameTotal++;
	});
	
	return {
		'questions': questions,
		'answers': answers,
		'corrects': corrects,
		'points': points,
		'totals': totals,
		'gamePoints': gamePoints,
		'gameTotal': gameTotal
	};
}

function answerQuestion(dom) {
	$dom = $(dom);
	$dom.siblings().removeClass('selected');
	$dom.addClass('selected');
	$dom.parents('li').attr('answered', $dom.attr('value'));
}
