/**
 * Core functions
 * 
 * To create a new game, copy the contents of GameTemplate.js and fill in the functions
 */

var gameXML = '';
var gameType = '';
var gameTitle = '';
var gameDescription = '';
var gameClues = '';
var gameInstructions = '';
var gameTestMin = "";
var gameXMLDOM;
var gameShowQuestionNo = "true";
var gameDisplayOptions = 0;
var gameNoCorrectAnswers = 0;
var fn;
var playerId = 0;

/**
 * Load XML Data and parsing
 *
 * @param xmlurl
 *   URL of the XML file.
 * @param gametype
 *   Root XML element name of the XML.
 * @param callbackFunc
 *   A callback function.
 */
function entryPoint() {
	console.log('Game init()');
	closeGameInstructionsPopup();
	closeGameCluesPopup();
	closeGameFinishPopup();
	closeGameScorePopup();
	
	jQuery('#jparse-meta').html('<img alt="Content Loading" src="images/ajax-loader.gif" />');
	
	$.ajax({
		type: "GET",
		url: xmlData,
		dataType: "xml",
		success: function (data) {
			parseGameXMLParameters(data);
			init();
			var pagesCount = getPagesCount();
			if (pagesCount > 1) {
				for (var i = 1; i <= pagesCount; i++) {
					$('#ajax-pages').append('<a id="' + i + '" class="pageButton" onclick="onPageClick(this.id)">' + i + '</a>');
				}
			}
			onReset();
		}
	});
	
	$('body').on('click', '#instructionsButton', onInstructions);
	$('body').on('click', '#checkAnswerButton:not(.disabled)', onCheckPageAnswer);
	$('body').on('click', '#finishButton', onFinish);
	$('body').on('click', '.play-btn', function(event) {
		if ($(this).hasClass('playing')) {
			$(this).removeClass('playing');
			document.getElementById($(event.target).siblings('.html-audio').attr('id')).pause();
		} else {
			$(this).addClass('playing');
			document.getElementById($(event.target).siblings('.html-audio').attr('id')).play();
		}
	});
}

function parseGameXMLParameters(xml) { 
	console.log('Parsing xml for general game data - ' + gameXML);
	gameXMLDOM = xml;
	
	gameTitle = $(xml).find('GameTitle').text();
	gameClues = $(xml).find('Clues').text();
	gameClues = gameClues.replace(/\n/g, '<br/>');
	if (gameClues !== undefined && gameClues !== '') {
		$('#gameCluesText').html(gameClues);
	}

	gameInstructions = $(xml).find('Instructions').text();
	gameInstructions = gameInstructions.replace(/\n/g, '<br/>');
	if (gameInstructions !== undefined && gameInstructions !== '') {
		$('#gameInstructionsText').html(gameInstructions);
		$('#gameInstructionsText2').html(gameInstructions);
	}

	gameDescription = $(xml).find('Description').text();
	gameTestMin = $(xml).find('TestMin').text();
	gameShowQuestionNo = $(xml).find('ShowQuestionNo').text();
	var option = $(xml).find('DisplayOption').text();
	if (option === 'One Question Per Page') {
		gameDisplayOptions = 0;
	} else if (option === 'All Question On One Page') {
		gameDisplayOptions = 1;
	}
	
	if ($(xml).find('[noCorrectAnswer="true"]').length > 0 ||
		$(xml).find('NoCorrectAnswer').length > 0) {
		gameNoCorrectAnswers = 1;
		disableCheckPageAnswer();
	}
	
	$('#ajax-cont').html('<div class="feed-entry"> <h4>' + gameTitle + '</h4></div>');
}

function onGameStart(){
	if (gameTestMin !== "") {
		setTimeout(onTimeOut, parseInt(gameTestMin * 60 * 1000, 10));
	}
}

function onTimeOut () {
	openPopup('#gameTimeOutPopup');
}

function onReset(){
	$('#jparse-meta').remove();
	$('#answers').remove();
	closeGameInstructionsPopup();
	closeGameCluesPopup();
	closeGameFinishPopup();
	closeGameScorePopup();
	reset();
	
	onPageClick("1");
	
	if (gameInstructions !== undefined && gameInstructions !== '') {
		openPopup('#gameStartPopup');
	}
}

function onPageClick(id){
	$('#answers').remove();
	$('#ajax-pages a').removeClass('active');
	$('#ajax-pages a[id="' + id + '"]').addClass('active');
	getPage(parseInt(id, 10) - 1);
	
	$('.control .audio').remove();
	var audio = getAudio();
	if (audio !== undefined && audio !== '' ) {
		var audioStr = getAudioCode(audio);
		$('.control').append($(audioStr));
		processPlayer($('.control .audio'));
	}
}

function openPopup(id) {
	$(id).fadeIn("fast");
	$('#popup-overlay').fadeIn("fast");

	//L.F. 14-feb-2012 - Fix for android results popup height problem
	var ht = $('#gameScorePopup').height() + $('#gameScorePopup').offset().top;
	$('.game-content').height(ht*1.2);
}

function closePopup(id) {
	$(id).fadeOut("fast");
	$('#popup-overlay').fadeOut("fast");
}

function onHelp(){
	openPopup('#gameCluesPopup');
}

function onInstructions(event){
	openPopup('#gameInstructionsPopup');
}

function onFinish(){
	openPopup('#gameFinishPopup');
}

function onScore(){
	openPopup('#gameScorePopup');
}

function onConfirmedFinish(){
	var pages = getPagesCount();
	for (var i = 0; i < pages; i++) {
		onCheckPageAnswer(i);
	}
	
	closeGameFinishPopup();
	var score = getScore();
	
	var table = '';
			
	$.each(score.questions, function(qIndex, question) {
		table +=
			'<tr><td class="index-td"><span class="result-index">' + (qIndex + 1) + '.</span></td>';
		
		table += '<td>';
		if (question !== '') {
			table += '<div class="result-original">' + question + '</div>';
		}
		
		table += '<div class="result-answer">Your answer: ' + score.answers[qIndex] + '</div>';
		
		if (score.points[qIndex] !== score.totals[qIndex] &&
			gameNoCorrectAnswers !== 1) {
			table +=
				'<div class="result-correct">Correct answer: ' + score.corrects[qIndex] + '</div>';
		}
		
		table +=
			'</td>' +
			'<td><div class="result-score">' + score.points[qIndex] + ' out of ' + score.totals[qIndex] + '</div></td>' +
		'</tr>';
	});
	
	var percentage = Math.round(score.gamePoints * 100 / score.gameTotal);
	
	var noCorrectMessage = '';
	if (gameNoCorrectAnswers) {
		noCorrectMessage = '(There are no correct answers for this exercise)';
	}
	
	tableOut =
		'<table><tbody>' +
			'<tr>' +
				'<th colspan="2">Total score is ' + score.gamePoints + ' out of ' + score.gameTotal + ' (' + percentage + '%) ' + noCorrectMessage + '</th>' +
				'<th>Your answer</th>' +
			'</tr>' +
			table +
		'</tbody></table>';
	
	$('#gameScorePopup .content .scores').html(tableOut);
	
	openPopup('#gameScorePopup');
	
	saveScore(percentage);
}

function closeGameStartPopup(){
	closePopup('#gameStartPopup');
	onGameStart();
}

function closeGameInstructionsPopup(){
	closePopup('#gameInstructionsPopup');
}

function closeGameCluesPopup(){
	closePopup('#gameCluesPopup');
}

function closeGameFinishPopup(){
	closePopup('#gameFinishPopup');
}

function closeGameScorePopup(){
	closePopup('#gameScorePopup');
}

function closeGameTimeOutPopup() {
	closePopup('#gameTimeOutPopup');
	onConfirmedFinish();
}

/**
 * a helper function to get the key value from URL parameter http://example.com?key=value
 */
function getParameterByName(name) {
	name = name.replace(/[\[]/, "\\\[").replace(/[\]]/, "\\\]");
	var regexS = "[\\?&]" + name + "=([^&#]*)";
	var regex = new RegExp(regexS);
	var results = regex.exec(window.location.search);
	if(results == null) {
		return "";
	} else {
		return decodeURIComponent(results[1].replace(/\+/g, " "));
	}
}

/**
 * a helper function to get the game type from URL
 */
function getGameType(xmldata) { 
	var flashname = xmldata.split("/");
	flashname = flashname[flashname.length-1];
	flashname = flashname.split(".");
	flashname = flashname[0].split("_");
	return flashname[0];
}

// If an audio player is needed in the game, its code can be added with this function, 
// argument 'mp3' is the audio url. After adding, processPlayer has to be called to replace the player with a flash version, if necessary
function getAudioCode(mp3) {
	return '' +
		'<div class="audio" source="' + mp3 + '">' +
			'<audio class="html-audio" id="html-player' + playerId + '" onEnded="onAudioEnded(event)">' +
				'<source src="' + mp3 + '" type="audio/mp3"/>' +
			'</audio>' +
			'<div class="play-btn"></div>' +
			'<div class="player-wrap">' +
				'<div class="player" id="flash-player' + playerId++ + '">' +
				'</div>' +
			'</div>' +
		'</div>';
}

function processPlayer(player) {
	if (!document.createElement('audio').canPlayType ||
		!document.createElement('audio').canPlayType('audio/mpeg'))
	{
		player.find('.player-wrap').show();
		player.find('.play-btn').hide();
		
		swfobject.embedSWF(
			"js/dewplayer-mini.swf", 
			player.find('.player').attr('id'), 
			"38",
			"20",
			"9.0.0", 
			"", 
			{"mp3": player.attr('source')},
			{"wmode": "transparent"}
		);
	}
}

function onAudioEnded(event) {
	//$(event.target).siblings('.play-btn').removeClass('playing');
}

//If the game does not support checking of the answers, the check answers button can be disabled
function disableCheckPageAnswer() {
	$('.btn-name-check-ans').addClass('disabled');
}



