$(document).ready(function(){

    var qs = getQueryStrings();
	lessonID = qs["id"]; 	
	if(false){
		//removed blank options
	}
	else{
		var o = getObjects(manifest, 'id', lessonID);
		var lessonObject = o[0];

		var iskids = $.grep(lessonObject.filter, function(e){
			return (e == 'kids');
		});

		if (iskids.length != 0)
		{	
			var isfun_with_english = $.grep(lessonObject.filter, function(e){
				return (e == 'fun_with_english');
			});
			var kidsGame = '';
			if (isfun_with_english.length != 0){	
				kidsGame = '<iframe src="' + lessonObject.flash + '"> </iframe>';
			}
			else{
				kidsGame = '<video src="' + lessonObject.flash + '" preload="preload" id="" controls="controls"> </video>';
			}
			$('#kids-instructions').append(lessonObject.instructions);
			//$('#kids-title').append(lessonObject.title);	
			$('#kids-description').append(lessonObject.description);
			$('#kids-copyright').append(lessonObject.copyright);
			$('#myGame').append(kidsGame);
			$('#kids-content-area').show();

			var vh = 660;
			$('#myGame').find('video').height(vh);
			//$('video').height(vh);

			$('#myGame').find('iframe').height(vh);
			notifyParent(vh);
		}
		else
		{
			if (lessonObject.tabs) {
				var n = 0;
					$('#tabs').tabs();
					$.each(lessonObject.tabs, function(label, body) {
  						$('#tabs').tabs('add', '#tabs-'+n, label);
  						$('#tabs-'+n).html(body);
  						n++;
					});
				$('#tabs').tabs({activate: function(event, ui){
						notifyParent();
					}
				});

				var str_video='<div id="contentMove" ><div id="content-image" style="display: none;"><img src=""></div><div id="content-video" style="display: none;"></div><div id="content-audio" style="display: none;"> <div id="custVidControl"><div class="button-play" onclick="custVidControl_play()"> </div>	<div class="button-paused" onclick="custVidControl_pause()"  style="display:none;"> </div><div class="button-stop" onclick="custVidControl_stop()"> </div></div></div><div id="content-body"></div></div>';
				$('#tabs-1').html(str_video);

				$("#tabs").show();

				$('#content-title').html(lessonObject.title );
					$('#content-body').html(lessonObject.body);
					$('#content-body').show();
					$('#content-title').show();

					if(lessonObject.video) {
					video_player(lessonObject.video, lessonObject.type,lessonObject.image);
					}
				if(lessonObject.audio) {
					audio_player(lessonObject.audio,lessonObject.image);
				}

					if (lessonObject.instructions) {
	 					$('#instruction-content').html(lessonObject.instructions);
						$('#instruction').show();
					if(lessonObject.attachment){
 							$('#attachment a').attr('href', lessonObject.attachment);
      						$('#attachment').show();
						}
					}
					render_flash();
				}
			
			$('#content').show();
			$('#learn-english-content').show();
		}
	}

	$('.iframeholder *').disableSelection();

	screenOrientation = ($(window).width() > $(window).height())? 90 : 0;
	$(window).bind("resize", function(){
	    screenOrientationNew = ($(window).width() > $(window).height())? 90 : 0;
	    if(screenOrientationNew != screenOrientation){
	    	console.log('changing orient');
	    	notifyParent();
	    	screenOrientation = screenOrientationNew;
	    }
	});

	$(window).on('orientationchange', function(event){
		handleOrientation();
	});
});
var screenOrientation; 


var gameDataStack = [];
    	
$('video').live('click', function(e){
	var stopped = $(this);
	e.preventDefault();
	setTimeout(function(){
		$('video').die('click');
	}, 500);
});

$(window).load(function(){
	setTimeout(function(){
		$('video').die('click');
	}, 500);
});

function getQueryStrings() { 
	var assoc  = {};
	var decode = function (s) { return decodeURIComponent(s.replace(/\+/g, " ")); };
	var queryString = window.location.search.substring(1); 
	var keyValues = queryString.split('&'); 
	for(var i in keyValues) { 
		var key = keyValues[i].split('=');
		if (key.length > 1) {
			assoc[decode(key[0])] = decode(key[1]);
		}
	} 
	return assoc; 
}

function getObjects(obj, key, val) {
	var objects = [];
	for (var i in obj) {
		if (!obj.hasOwnProperty(i)) continue;
		if (typeof obj[i] == 'object') {
			objects = objects.concat(getObjects(obj[i], key, val));
		} else if (i == key && obj[key] == val) {
			objects.push(obj);
		}
	}
	return objects;
}

function audio_player(audiofile, imagefile) 
{
	$('#content-audio').prepend('<video id="audio" src="'+ audiofile + '" poster="' + imagefile +'"></video>');
	$('#content-audio').show();
	//LF Added - setup for custom video controls
	$('video').height('1px').width('1px');
	$('video').css('overflow', 'hidden');
	$('#custVidControl').show();
	$('#content-audio').prepend('<img src="' + imagefile + '" height="70%" style="position:relative;"/>');
	$('#content-audio img').css({'width':'25%', 'height':'auto'});
	$('#custVidControl').css('width', $('#content-audio img').css('width'));
}	

function video_player(videofile, type, imagefile) 
{
		$('#content-video').html('<video id="audio" src="files/' + videofile +'" poster="' + imagefile +'"></video>');
    $('video').attr("controls","controls");
		$('#content-video').show();
}


function render_flash() 
{
	$("div.embed").each(function (index) {
		var a = $(this).attr("href");
		a.search(/http/);
		var b = a.split("/"),
		a = b = b[b.length - 1],
		b = b.split("."),
		b = b[0].split("_");
		$(this).text("");
		$(this).attr("href", "#");
		$(this).attr("id", "bcgame_" + index);
		$(this).html($('#bc-game-basic-markup').html());
		gameDataStack[index] = new BCGAME();
		var markup = gameDataStack[index].initGameType(a, $(this));
		$(this).click(function () {
			return !1
		})
	});
	//window.scrollTo(0, 1);
}

function custVidControl_play(){
	$('video')[0].play();
	var vi = $('#custVidControl');
	$('.button-play').toggle();
	$('.button-paused').toggle();
}
function custVidControl_pause(){
	$('video')[0].pause();
	var vi = $('#custVidControl');
	$('.button-play').toggle();
	$('.button-paused').toggle();
}
function custVidControl_stop(){
	$('video')[0].pause();
	$('video')[0].currentTime = 0;
	$('.button-paused').hide();
	$('.button-play').show();
}
function custVidControl_mute(){
	$('video')[0].muted = !$('video')[1].muted;
	var vi = $('#custVidControl');
	$('.button-audio').toggle();
	$('.button-audio-mute').toggle();
}

function bodyIsLoaded(){
	//IE needs slight delay
	setTimeout(function(){
		notifyParent();
	}, 500);
}
function notifyParent(absoluteElement){
		if (window.parent){
			if(window.parent.updateParent){
				var a;
				if(null != absoluteElement){
					console.log('abselem' + absoluteElement);
					a = Math.max(absoluteElement, getDocHeight());
				}
				else{
					a = getDocHeight();
				}
				console.log('setting ' + a);
				window.parent.updateParent(a + 60);
			}
		}
}
function getDocHeight() {
    var D = document.getElementById('bod');
    return Math.max(
        D.scrollHeight,
        D.offsetHeight,
        D.clientHeight,
        $(D).height(),
        $(D).outerHeight()
    );
}


function handleOrientation(){
	alert();
	setTimeout(function(){
		notifyParent();
	}, 100);
}