/**
 * Core functions
 * 
 * To create a new game, copy the contents of GameTemplate.js and fill in the functions
 */

var BCGAME = function(){
	this.xmlData = '';

	this.gameXML = '';
	this.gameType = '';
	this.gameTitle = '';
	this.gameDescription = '';
	this.gameClues = '';
	this.gameInstructions = '';
	this.gameTestMin = "";
	this.gameXMLDOM;
	this.gameShowQuestionNo = "true";
	this.gameNoCorrectAnswers = 0;
	this.fn;
	this.playerId = 0;

	/**
	 * Load XML Data and parsing
	 *
	 * @param xmlurl
	 *   URL of the XML file.
	 * @param gametype
	 *   Root XML element name of the XML.
	 * @param callbackFunc
	 *   A callback function.
	 */

	this.gameContainer;
	this.markup;

	this.gameScript;

}

	BCGAME.prototype.initGameType = function(filename, container){
		this.gameContainer = container;
	 	this.xmlData = filename;
		var gametype = getGameType(filename);
		console.log(gametype);
		if (gametype =='TrueOrFalse'){
			//These are equivalent for all the content that we have and Multiple choice is what should be used.
			gametype = 'MultipleChoice';
		}
		this.gameType = gametype;
		this.gameContainer.find('.game-container').each(function(){
			$(this).addClass('game-type-'+ gametype)
		});
		

		var method = 'new ' + gametype + '(container)'
		this.gameScript = eval(method);
		this.entryPoint();
	}

	
	 
	 
	/** Testet with:
	 *  - IE 5.5, 7.0, 8.0, 9.0 (preview)
	 *  - Firefox 3.6.3, 3.6.8
	 *  - Safari 5.0
	 *  - Chrome 5.0
	 *  - Opera 10.10, 10.60
	 */
	var JSLoader = {
	  load: function(src, filename, callback) {
	    var script = document.createElement('script'),
	        loaded;
	    script.setAttribute('src', src);
	    if (callback) {
	      script.onreadystatechange = script.onload = function() {
	        if (!loaded) {
	          callback(filename);
	        }
	        loaded = true;
	      };
	    }
	    document.getElementsByTagName('head')[0].appendChild(script);
	  }
	};

	BCGAME.prototype.entryPoint = function() {
		this.closeGameInstructionsPopup();
		this.closeGameCluesPopup();
		this.closeGameFinishPopup();
		this.closeGameScorePopup();
		
		this.gameContainer.find('#jparse-meta').html('<img alt="Content Loading" src="images/ajax-loader.gif" />');
		var obj = this;
		var cont = this.gameContainer;

		
		var jsFileName = obj.xmlData.replace('.xml', '.js');
		var jsUrl = 'files/flash/' + jsFileName;
		
		JSLoader.load(jsUrl, jsFileName, function(gN) {
			var gameStr = gN.replace(/=/g, '').replace('.js', '');
			obj.parseGameXMLParameters($.parseXML(eval(gameStr)));
				obj.gameScript.init(obj.gameXMLDOM);
				var pagesCount = obj.gameScript.getPagesCount();
				if (pagesCount > 1) {
					for (var i = 1; i <= pagesCount; i++) {											//TODO: this.onPageClick fix
						cont.find('#ajax-pages').append('<a id="' + i + '" class="pageButton" onclick="onPageClick(event, this.id)">' + i + '</a>');
					}
				}
				obj.onReset();
		});
		
		/*
		$.ajax({
			type: "GET",
			url: 'files/flash/' + obj.xmlData,
			dataType: "xml",
			success: function (data) {
				obj.parseGameXMLParameters(data);
				obj.gameScript.init(obj.gameXMLDOM);
				var pagesCount = obj.gameScript.getPagesCount();
				if (pagesCount > 1) {
					for (var i = 1; i <= pagesCount; i++) {											//TODO: this.onPageClick fix
						cont.find('#ajax-pages').append('<a id="' + i + '" class="pageButton" onclick="onPageClick(event, this.id)">' + i + '</a>');
					}
				}
				obj.onReset();
			}
		});
		*/
		/*
		
		var inst = this.gameContainer.find('#instructionsButton');
		this.gameContainer.on('click', inst, function(event){
			console.log('bind 1');
			//obj.onInstructions(event);
		});
		*/
		var obj = this;
		this.gameContainer.on('click', '#checkAnswerButton:not(.disabled)', function(event){
			obj.gameScript.onCheckPageAnswer(event);
		});
		this.gameContainer.on('click', '#finishButton', function(event){
			obj.onFinish(event);
		});
		/*
		this.gameContainer.on('click', '.play-btn', function(event) {
			console.log('bind 4');
			if ($(this).hasClass('playing')) {
				$(this).removeClass('playing');
				document.getElementById($(event.target).siblings('.html-audio').attr('id')).pause();
			} else {
				$(this).addClass('playing');
				document.getElementById($(event.target).siblings('.html-audio').attr('id')).play();
			}
		});
		*/
	}



	BCGAME.prototype.parseGameXMLParameters = function(xml) { 
		this.gameXMLDOM = xml;
		
		this.gameTitle = $(xml).find('GameTitle').text();
		this.gameClues = $(xml).find('Clues').text();
		this.gameClues = this.gameClues.replace(/\n/g, '<br/>');
		if (this.gameClues !== undefined && this.gameClues !== '') {
			this.gameContainer.find('#gameCluesText').html(this.gameClues);
		}

		this.gameInstructions = $(xml).find('Instructions').text();
		this.gameInstructions = this.gameInstructions.replace(/\n/g, '<br/>');
		if (this.gameInstructions !== undefined && this.gameInstructions !== '') {
			this.gameContainer.find('#gameInstructionsText').html(this.gameInstructions);
			this.gameContainer.find('#gameInstructionsText2').html(this.gameInstructions);
		}

		this.gameDescription = $(xml).find('Description').text();
		this.gameTestMin = $(xml).find('TestMin').text();
		this.gameShowQuestionNo = $(xml).find('ShowQuestionNo').text();
		var option = $(xml).find('DisplayOption').text();
		if (option === 'One Question Per Page') {
			this.gameScript.gameDisplayOptions = 0;
		} else if (option === 'All Question On One Page') {
			this.gameScript.gameDisplayOptions = 1;
		}
		
		if ($(xml).find('[noCorrectAnswer="true"]').length > 0 ||
			$(xml).find('NoCorrectAnswer').length > 0) {
			this.gameNoCorrectAnswers = 1;
			this.disableCheckPageAnswer();
		}
		//TODO: check what removing this will do
		//this.gameContainer.find('#ajax-cont').html('<div class="feed-entry"> <h4>' + this.gameTitle + '</h4></div>');
	}

	BCGAME.prototype.onGameStart = function(){
		if (this.gameTestMin !== "") {
			setTimeout(this.onTimeOut, parseInt(this.gameTestMin * 60 * 1000, 10));
		}
	}

	BCGAME.prototype.onTimeOut = function() {
		this.openPopup('#gameTimeOutPopup');
	}

	BCGAME.prototype.onReset = function(){
		this.gameContainer.find('#jparse-meta').first().remove();
		this.gameContainer.find('#answers').first().remove();
		this.closeGameInstructionsPopup();
		this.closeGameCluesPopup();
		this.closeGameFinishPopup();
		this.closeGameScorePopup();
		this.gameScript.reset();
		
		this.onPageClick("1");
		
		if (this.gameInstructions !== undefined && this.gameInstructions !== '') {
			this.openPopup('#gameStartPopup');
		}
	}

	BCGAME.prototype.onPageClick = function(id){
		this.gameContainer.find('#answers').remove();
		this.gameContainer.find('#ajax-pages a').removeClass('active');
		this.gameContainer.find('#ajax-pages a[id="' + id + '"]').addClass('active');
		this.gameScript.getPage(parseInt(id, 10) - 1);
		
		this.gameContainer.find('.control .audio').remove();
		var audio = this.gameScript.getAudio();
		if (audio !== undefined && audio !== '' ) {
			var audioStr = getAudioCode(audio);
			this.gameContainer.find('.control').append($(audioStr));
			this.processPlayer($('.control .audio'));
		}
	}

 	BCGAME.prototype.openPopup = function(id) {
		
		this.gameContainer.find(id).fadeIn("fast");
		this.gameContainer.find('#popup-overlay').fadeIn("fast");

		//L.F. 14-feb-2012 - Fix for android results popup height problem
		//var ht = $('#gameScorePopup').height() + $('#gameScorePopup').offset().top;
		//$('.game-content').height(ht*1.2);
		
	}

	BCGAME.prototype.closePopup = function(id) {
		this.gameContainer.find(id).fadeOut("fast");
		this.gameContainer.find('#popup-overlay').fadeOut("fast");
	}

	BCGAME.prototype.onHelp = function(){
		this.openPopup('#gameCluesPopup');
	}

	BCGAME.prototype.onInstructions = function(event){
		this.openPopup('#gameInstructionsPopup');
	}

	BCGAME.prototype.onFinish = function(){
		this.openPopup('#gameFinishPopup');
	}

	BCGAME.prototype.onScore = function(){
		this.openPopup('#gameScorePopup');
	}

	BCGAME.prototype.onConfirmedFinish = function(){
		var pages = this.gameScript.getPagesCount();
		for (var i = 0; i < pages; i++) {
			this.gameScript.onCheckPageAnswer(i);
		}
		
		this.closeGameFinishPopup();
		var score = this.gameScript.getScore();
		
		var table = '';
		var obj = this;
		$.each(score.questions, function(qIndex, question) {
			table +=
				'<tr><td class="index-td"><span class="result-index">' + (qIndex + 1) + '.</span></td>';
			
			table += '<td>';
			if (question !== '') {
				table += '<div class="result-original">' + question + '</div>';
			}
			
			table += '<div class="result-answer">Your answer: ' + score.answers[qIndex] + '</div>';
			
			if (score.points[qIndex] !== score.totals[qIndex] &&
				obj.gameNoCorrectAnswers !== 1) {
				table +=
					'<div class="result-correct">Correct answer: ' + score.corrects[qIndex] + '</div>';
			}
			
			table +=
				'</td>' +
				'<td><div class="result-score">' + score.points[qIndex] + ' out of ' + score.totals[qIndex] + '</div></td>' +
			'</tr>';
		});
		
		var percentage = Math.round(score.gamePoints * 100 / score.gameTotal);
		
		var noCorrectMessage = '';
		if (obj.gameNoCorrectAnswers) {
			noCorrectMessage = '(There are no correct answers for this exercise)';
		}
		
		tableOut =
			'<table><tbody>' +
				'<tr>' +
					'<th colspan="2">Total score is ' + score.gamePoints + ' out of ' + score.gameTotal + ' (' + percentage + '%) ' + noCorrectMessage + '</th>' +
					'<th>Your answer</th>' +
				'</tr>' +
				table +
			'</tbody></table>';
		
		this.gameContainer.find('#gameScorePopup .content .scores').html(tableOut);
		this.openPopup('#gameScorePopup');
		
		var size = $('#gameScorePopup').height() + $('#gameScorePopup').offset().top + 60;
		notifyParent(size);

		setTimeout(function(){
			
			
		}, 500);
		saveScore(percentage);
	}

	BCGAME.prototype.closeGameStartPopup = function(e){
		this.closePopup('#gameStartPopup');
		this.onGameStart();
	}

	BCGAME.prototype.closeGameInstructionsPopup = function(){
		this.closePopup('#gameInstructionsPopup');
	}

	BCGAME.prototype.closeGameCluesPopup = function(){
		this.closePopup('#gameCluesPopup');
	}

	BCGAME.prototype.closeGameFinishPopup = function(){
		this.closePopup('#gameFinishPopup');
	}

	BCGAME.prototype.closeGameScorePopup = function(){
		this.closePopup('#gameScorePopup');
	}

	BCGAME.prototype.closeGameTimeOutPopup = function() {
		this.closePopup('#gameTimeOutPopup');
		this.onConfirmedFinish();
	}

	/**
	 * a helper function to get the key value from URL parameter http://example.com?key=value
	 */
	function getParameterByName(name) {
		name = name.replace(/[\[]/, "\\\[").replace(/[\]]/, "\\\]");
		var regexS = "[\\?&]" + name + "=([^&#]*)";
		var regex = new RegExp(regexS);
		var results = regex.exec(window.location.search);
		if(results == null) {
			return "";
		} else {
			return decodeURIComponent(results[1].replace(/\+/g, " "));
		}
	}

	/**
	 * a helper function to get the game type from URL
	 */
	function getGameType(xmldata) { 
		var flashname = xmldata.split("/");
		flashname = flashname[flashname.length-1];
		flashname = flashname.split(".");
		flashname = flashname[0].split("_");
		return flashname[0];
	}

	// If an audio player is needed in the game, its code can be added with this function, 
	// argument 'mp3' is the audio url. After adding, processPlayer has to be called to replace the player with a flash version, if necessary
	function getAudioCode(mp3) {
		return '' +
			'<div class="audio" source="' + mp3 + '">' +
				'<audio class="html-audio" id="html-player' + playerId + '" onEnded="onAudioEnded(event)">' +
					'<source src="' + mp3 + '" type="audio/mp3"/>' +
				'</audio>' +
				'<div class="play-btn"></div>' +
				'<div class="player-wrap">' +
					'<div class="player" id="flash-player' + playerId++ + '">' +
					'</div>' +
				'</div>' +
			'</div>';
	}

	BCGAME.prototype.processPlayer = function(player) {
		if (!document.createElement('audio').canPlayType ||
			!document.createElement('audio').canPlayType('audio/mpeg'))
		{
			player.find('.player-wrap').show();
			player.find('.play-btn').hide();
			
			swfobject.embedSWF(
				"js/dewplayer-mini.swf", 
				player.find('.player').attr('id'), 
				"38",
				"20",
				"9.0.0", 
				"", 
				{"mp3": player.attr('source')},
				{"wmode": "transparent"}
			);
		}
	}

	function onAudioEnded(event) {
		//$(event.target).siblings('.play-btn').removeClass('playing');
	}

	//If the game does not support checking of the answers, the check answers button can be disabled
	BCGAME.prototype.disableCheckPageAnswer = function() {
		this.gameContainer('.btn-name-check-ans').addClass('disabled');
	}


//global functions to act as hooks into the calling game where the clicks originate
/*
onHelp()
onInstructions(event)
onCheckPageAnswer()
onFinish()
onReset()
closeGameInstructionsPopup()
closeGameCluesPopup()
closeGameStartPopup()
onConfirmedFinish()
closeGameFinishPopup()
closeGameScorePopup()
closeGameTimeOutPopup()
*/

var onHelp = function(e){
	gameDataStack[getIdFromContainer(e)].onHelp(e);
}
var onInstructions = function(event){
	//had specific event/investigate where its used
	gameDataStack[getIdFromContainer(event)].onInstructions(event);
}
var onCheckPageAnswer = function(e){
	gameDataStack[getIdFromContainer(e)].onCheckPageAnswer(e);
}
var onFinish = function(e){
	gameDataStack[getIdFromContainer(e)].onFinish(e);
}
var onReset = function(e){
	gameDataStack[getIdFromContainer(e)].onReset(e);
}
var closeGameInstructionsPopup = function(e){
	gameDataStack[getIdFromContainer(e)].closeGameInstructionsPopup(e);
}
var closeGameCluesPopup = function(e){
	gameDataStack[getIdFromContainer(e)].closeGameCluesPopup(e);
}
var closeGameStartPopup = function(e){
	gameDataStack[getIdFromContainer(e)].closeGameStartPopup(e);
}
var onConfirmedFinish = function(e){
	gameDataStack[getIdFromContainer(e)].onConfirmedFinish(e);
}
var closeGameFinishPopup = function(e){
	gameDataStack[getIdFromContainer(e)].closeGameFinishPopup(e);
}
var closeGameScorePopup = function(e){
	gameDataStack[getIdFromContainer(e)].closeGameScorePopup(e);
}
var closeGameTimeOutPopup = function(e){
	gameDataStack[getIdFromContainer(e)].closeGameTimeOutPopup(e);
}


var onPageClick = function(e, id){
	gameDataStack[getIdFromContainer(e)].onPageClick(id);
}

var saveScore = function(percentage){
	//down the drain you go....
}


var getIdFromContainer = function(container){
	var embed = $(container.target).closest('.embed');
	var idString = embed.attr('id');
	if(idString){
		return parseInt(idString.replace('bcgame_',''));
	}

}