@ECHO OFF
:; Clear the screen
CLS 

:; Clear any previous variables set 
SET SASID=
SET Ver=

:; Expose Enclosure Devices Enable
CmdTool2_64 -adpsetprop ExposeEnclDevicesEnbl 1 -aall
TIMEOUT /T 2 /NOBREAK

:; Get SAS Address 
FOR /F "skip=14 tokens=2,4 delims= " %%h IN ('xflash -i get avail') do Call :ProgramExpander %%h %%i
	
	:; Expose Enclosure Devices Disable
	CmdTool2_64 -adpsetprop ExposeEnclDevicesEnbl 0 -aall

	:; Print message and exit
	ECHO System power cycle is required to complete expander firmware udpate process
	GOTO :EOF

:; Program Expander(s) with new firmware
:ProgramExpander

	:; Remove unused char, assign variable 2 to SASID
	SET SASID=%2
	SET SASID=%SASID::=%
	SET SASID=%SASID:(=%
	SET SASID=%SASID:)=%

	:; Assign variable 1 to DEVICE
	SET DEVICE=%1

	
	:; Print SAS Address to program
	ECHO %SASID%
	ECHO %DEVICE%

	:; Program Expander
	IF "%DEVICE%" == "RES2CV360-R" (
	
	:; Flash base firmware to expander
	xflash -i %SASID% down fw sas2xfw.fw 2 -y
	xflash -i %SASID% reset exp -y
	ECHO Pause while firmware initializes and creates OEM page
	TIMEOUT /T 20 /NOBREAK

	:; Flash MFG page to expander
	xflash -i %SASID% down mfg mfgRES2CV360-R_1.04.bin 3 -y
	xflash -i %SASID% reset exp -y
        TIMEOUT /T 10 /NOBREAK
	
	) else (

	:; Print error message to screen
	ECHO "This update is for RES2CV360-R expanders only, skipping update for this expander"
	TIMEOUT /T 5 /NOBREAK

	)

:EOF
