%define kmod_name mpt3sas
%define version 5.00.00.00
%define release 1
Summary: 	%{kmod_name} kernel module
Name: 		%{kmod_name}-kmod
Version: 	%{version}
Release: 	%{release}%{?dist}
Vendor: 	LSI Corporation
License: 	GPL
Group: 		System Environment/Kernel
Source0: 	lsi-%{kmod_name}-%{version}.tar.gz
Source10: 	kmodtool_%{kmod_name}
URL: 		http://www.lsilogic.com
Distribution: 	LSI Logic
BuildRoot:	%{_tmppath}/%{name}-%{version}-%{release}-root-%(%{__id_u} -n)
Packager: 	Sathya Prakash <sathya.prakash@lsi.com>

%define kmodtool bash %{SOURCE10}
%{!?kversion: %define kversion 2.6.18-8.el5}

%define kverrel %(%{kmodtool} verrel %{?kversion} 2>/dev/null)

%ifarch i686 
%define paevar PAE
%endif
%ifarch i686 x86_64 ia64
%define xenvar xen
%endif
%ifarch ppc64 
%define kdumpvar kdump
%endif

%define upvar ""
%{!?kvariants: %define kvariants %{?upvar} %{?xenvar} %{?kdumpvar} %{?paevar}}

ExclusiveArch:  i686 ia64 ppc64 x86_64

%description
%{kmod_name} - LSI MPT Fusion HBA drivers

# magic hidden here:
%{expand:%(%{kmodtool} rpmtemplate_kmp %{kmod_name} %{kverrel} %{kvariants} 2>/dev/null)}

%prep
# to understand the magic better or to debug it, uncomment this:
#{kmodtool} rpmtemplate_kmp %{kmod_name} %{kverrel} %{kvariants} 2>/dev/null
#sleep 5
%setup -q -c -T -a 0
for kvariant in %{kvariants} ; do
    cp -a lsi-%{kmod_name}-%{version} _kmod_build_$kvariant
done


%build
for kvariant in %{kvariants}
do
    ksrc=%{_usrsrc}/kernels/%{kverrel}${kvariant:+-$kvariant}-%{_target_cpu}
    pushd _kmod_build_$kvariant
    make -C "${ksrc}" modules M=$PWD
    popd
done


%install
export INSTALL_MOD_PATH=$RPM_BUILD_ROOT
export INSTALL_MOD_DIR=extra/%{kmod_name}
for kvariant in %{kvariants}
do
    ksrc=%{_usrsrc}/kernels/%{kverrel}${kvariant:+-$kvariant}-%{_target_cpu}
    pushd _kmod_build_$kvariant
    make -C "${ksrc}" modules_install M=$PWD
    popd
done

mkdir -p $RPM_BUILD_ROOT/etc/init.d
mkdir -p ${RPM_BUILD_ROOT}/lib/firmware

%clean
rm -rf $RPM_BUILD_ROOT

%changelog
* Tue Jan  9 2008 Sathya Prakash <sathya.prakash@lsi.com> - 1.0
- Initial version.
