# FORCE_EFI_BOOT

echo -off
# +
# + ============================================================== +
#  Copyright (c) 2014, Intel Corporation.

#  This source code and any documentation accompanying it ("Material") is furnished
#  under license and may only be used or copied in accordance with the terms of that
#  license.  No license, express or implied, by estoppel or otherwise, to any
#  intellectual property rights is granted to you by disclosure or delivery of these
#  Materials.  The Materials are subject to change without notice and should not be
#  construed as a commitment by Intel Corporation to market, license, sell or support
#  any product or technology.  Unless otherwise provided for in the license under which
#  this Material is provided, the Material is provided AS IS, with no warranties of
#  any kind, express or implied, including without limitation the implied warranties
#  of fitness, merchantability, or non-infringement.  Except as expressly permitted by
#  the license for the Material, neither Intel Corporation nor its suppliers assumes
#  any responsibility for any errors or inaccuracies that may appear herein.  Except
#  as expressly permitted by the license for the Material, no part of the Material
#  may be reproduced, stored in a retrieval system, transmitted in any form, or
#  distributed by any means without the express written consent of Intel Corporation.

#  Module Name:  startup.nsh

#  Abstract:  Script file for invoking iflash.

# + ============================================================== +
#    Program all blocks of BIOS from capsule file 
# + ============================================================== +

@echo -off
mode 80 25
;foundimage section is simply to locate the correct drive
cls
if exist .\ipmi.efi then
 goto FOUNDIMAGE
endif
if exist fs0:\ipmi.efi then
 fs0:
 echo Found Update Packages on fs0:
 goto FOUNDIMAGE
endif
if exist fs1:\ipmi.efi then
 fs1:
 echo Found Update Packages on fs1:
 goto FOUNDIMAGE
endif
if exist fs2:\ipmi.efi then
 fs2:
 echo Found Update Packages on fs2:
 goto FOUNDIMAGE
endif
 echo "Unable to find Update Packages".  
 echo "Please mount the drive with the update package".
 echo ""
 goto END
:FOUNDIMAGE

echo "==============================================================================="

echo "This script will install BMC, BIOS, ME firmware, and FRUSDR in the"
echo "Intel(R) Server Board S2400LP or Intel(R) Server System H2000LP"
echo ""
echo "You can use other scripts such as BIOS.nsh to update each component separately."
echo ""
echo "================================== IMPORTANT =================================="
echo "Please ensure your server system is on BIOS 01.02.0006, BMC 01.06r3137, ME 02.01.05.91 "
echo "and FRUSDR 105 or above these versions, otherwise the update process may "
echo "render the system not operatable! If you are not sure about the versions,"
echo "hit 'q' and reboot into BIOS to verify."
echo "================================== IMPORTANT =================================="
echo ""

echo "The update process will install following BMC/BIOS/ME/FRUSDR on your system:"
echo "       BMC 01.22r6890;"
echo "       BIOS 02.04.0003;"
echo "       ME Firmware 02.01.07.328;"
echo "       FRUSDR 1.11"
echo ""
echo "Do NOT reboot during this process until you see Updates completed."
echo "==============================================================================="
pause

echo ""
echo BMC 01.22r6890 is being installed.
echo ""
FWPIAUPD -u -bin -ni -b -o -pia -nopc -if=usb BMC_i_0122r6890.bin
echo ""
echo "BMC update completed"

echo ""
echo BIOS 02.04.0003 is being installed.
  iflash32 /u /ni R02.04.0003.cap
echo ""
echo "BIOS update completed."


echo ""
echo "ME firmware 02.01.07.328 is being installed."
  iflash32 /u /ni MEComplete_02.01.07.328_HFW.cap  
echo ""
echo "ME firmware update completed."


echo ""
echo "FRUSDR 1.11 is being installed."
frusdr -cfg master.cfg
echo ""
echo "FRUSDR update completed."
echo ""
echo ""
echo "Updates completed. Please remove the USB key and reboot."
echo ""

:END

