/*
 * Decompiled with CFR 0.152.
 */
package processing.app;

import javax.swing.undo.CannotRedoException;
import javax.swing.undo.CannotUndoException;
import javax.swing.undo.UndoableEdit;
import processing.app.syntax.JEditTextArea;

public class CaretAwareUndoableEdit
implements UndoableEdit {
    private final UndoableEdit undoableEdit;
    private final int caretPosition;

    public CaretAwareUndoableEdit(UndoableEdit undoableEdit, JEditTextArea textArea) {
        this.undoableEdit = undoableEdit;
        this.caretPosition = textArea.getCaretPosition();
    }

    public void undo() throws CannotUndoException {
        this.undoableEdit.undo();
    }

    public boolean canUndo() {
        return this.undoableEdit.canUndo();
    }

    public void redo() throws CannotRedoException {
        this.undoableEdit.redo();
    }

    public boolean canRedo() {
        return this.undoableEdit.canRedo();
    }

    public void die() {
        this.undoableEdit.die();
    }

    public boolean addEdit(UndoableEdit undoableEdit) {
        return this.undoableEdit.addEdit(undoableEdit);
    }

    public boolean replaceEdit(UndoableEdit undoableEdit) {
        return this.undoableEdit.replaceEdit(undoableEdit);
    }

    public boolean isSignificant() {
        return this.undoableEdit.isSignificant();
    }

    public String getPresentationName() {
        return this.undoableEdit.getPresentationName();
    }

    public String getUndoPresentationName() {
        return this.undoableEdit.getUndoPresentationName();
    }

    public String getRedoPresentationName() {
        return this.undoableEdit.getRedoPresentationName();
    }

    public int getCaretPosition() {
        return this.caretPosition;
    }
}

