/*
 * Decompiled with CFR 0.152.
 */
package processing.app;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.geom.Rectangle2D;
import javax.swing.JComponent;
import processing.app.Base;
import processing.app.Preferences;
import processing.app.Theme;
import processing.app.helpers.PreferencesMap;
import processing.app.syntax.JEditTextArea;

public class EditorLineStatus
extends JComponent {
    JEditTextArea textarea;
    int start = -1;
    int stop;
    Image resize;
    Color foreground;
    Color background;
    Color messageForeground;
    Font font;
    int high;
    String text = "";
    String name = "";
    String serialport = "";

    public EditorLineStatus(JEditTextArea textarea) {
        this.textarea = textarea;
        textarea.editorLineStatus = this;
        this.background = Theme.getColor("linestatus.bgcolor");
        this.font = Theme.getFont("linestatus.font");
        this.foreground = Theme.getColor("linestatus.color");
        this.high = Theme.getInteger("linestatus.height");
        if (Base.isMacOS()) {
            this.resize = Base.getThemeImage("resize.gif", this);
        }
    }

    public void set(int newStart, int newStop) {
        if (newStart == this.start && newStop == this.stop) {
            return;
        }
        this.start = newStart;
        this.stop = newStop;
        this.text = this.start == this.stop ? String.valueOf(this.start + 1) : this.start + 1 + " - " + (this.stop + 1);
        this.repaint();
    }

    public void paintComponent(Graphics g) {
        if (this.name == "" && this.serialport == "") {
            PreferencesMap boardPreferences = Base.getBoardPreferences();
            if (boardPreferences != null) {
                this.setBoardName((String)boardPreferences.get("name"));
            } else {
                this.setBoardName("-");
            }
            this.setSerialPort(Preferences.get("serial.port"));
        }
        g.setColor(this.background);
        Dimension size = this.getSize();
        g.fillRect(0, 0, size.width, size.height);
        g.setFont(this.font);
        g.setColor(this.foreground);
        int baseline = (this.high + g.getFontMetrics().getAscent()) / 2;
        g.drawString(this.text, 6, baseline);
        g.setColor(this.messageForeground);
        String tmp = this.name + " on " + this.serialport;
        Rectangle2D bounds = g.getFontMetrics().getStringBounds(tmp, null);
        g.drawString(tmp, size.width - (int)bounds.getWidth() - 20, baseline);
        if (Base.isMacOS()) {
            g.drawImage(this.resize, size.width - 20, 0, this);
        }
    }

    public void setBoardName(String name) {
        this.name = name;
    }

    public void setSerialPort(String serialport) {
        this.serialport = serialport;
    }

    public Dimension getPreferredSize() {
        return new Dimension(300, this.high);
    }

    public Dimension getMinimumSize() {
        return this.getPreferredSize();
    }

    public Dimension getMaximumSize() {
        return new Dimension(3000, this.high);
    }
}

