/*
 * Decompiled with CFR 0.152.
 */
package processing.app;

import java.nio.charset.Charset;
import java.util.Arrays;
import java.util.List;
import java.util.ListIterator;
import java.util.Vector;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GalileoVersionId
implements Comparable<GalileoVersionId> {
    static Charset utf8 = Charset.forName("UTF-8");
    static Integer zero = new Integer(0);
    static Integer[] empty = new Integer[0];
    static String quarkCodeline = "!Quark";
    private String codeline;
    private List<Integer> release;
    private Integer build;

    public GalileoVersionId(String codeline, Integer[] release, Integer build) {
        this.codeline = new String(codeline.getBytes(utf8));
        this.release = Arrays.asList(release);
        this.build = build;
    }

    private String toStringAux(Boolean useCanonical) {
        StringBuilder s = new StringBuilder();
        Boolean codelined = this.codeline.length() > 0;
        Boolean identified = this.release.size() > 0;
        Boolean serialized = !this.build.equals(zero);
        if (!useCanonical.booleanValue() && this.codeline.equals(quarkCodeline)) {
            codelined = false;
            serialized = identified == false;
        }
        if (codelined.booleanValue()) {
            s.append(this.codeline);
            if (identified.booleanValue()) {
                s.append('-');
            }
        }
        Boolean point = false;
        for (Integer n : this.release) {
            if (point.booleanValue()) {
                s.append('.');
            }
            s.append(n.toString());
            point = true;
        }
        if (serialized.booleanValue()) {
            if (identified.booleanValue() || codelined.booleanValue()) {
                s.append('+');
            }
            s.append(this.build.toString());
        }
        return s.toString();
    }

    public String toPresentationString() {
        return this.toStringAux(false);
    }

    public String toCanonicalString() {
        return this.toStringAux(true);
    }

    public static Boolean isReleasedQuarkBuild(String version) {
        int n;
        Boolean matched = version.matches("^0[Xx][0-9A-Fa-f]+$");
        if (matched.booleanValue() && (n = Integer.parseInt(version.substring(2), 16)) < 524288) {
            matched = false;
        }
        return matched;
    }

    public static Boolean isUnreleasedQuarkBuild(String version) {
        int n;
        Boolean matched = version.matches("^[1-9][0-9]*$");
        if (!matched.booleanValue() && (matched = Boolean.valueOf(version.matches("^0[Xx][0-9A-Fa-f]+$"))).booleanValue() && (n = Integer.parseInt(version.substring(2), 16)) >= 524288) {
            matched = false;
        }
        return matched;
    }

    public static Boolean isCanonicalFormat(String version) {
        if (version == null || version.length() < 1 || version.length() > 63) {
            return false;
        }
        Pattern p = Pattern.compile("(!?[A-Z][A-Za-z0-9_]*)([-+]?)");
        Matcher m = p.matcher(version);
        if (!m.lookingAt()) {
            return false;
        }
        version = version.substring(m.end());
        String conjunct = m.group(1);
        Boolean hasReleaseArray = conjunct.equals("-");
        Boolean hasBuildNumber = conjunct.equals("+");
        if (hasReleaseArray.booleanValue()) {
            p = Pattern.compile("((0|[1-9][0-9]*)(\\.(0|[1-9][0-9]*)))(\\+?)");
            m = p.matcher(version);
            if (!m.lookingAt()) {
                return false;
            }
            version = version.substring(m.end());
            conjunct = m.group(4);
            hasBuildNumber = conjunct.equals("+");
        }
        return hasBuildNumber == false || version.matches("0|[1-9][0-9]*");
    }

    public static String parseCodeline(String version) {
        int i = version.indexOf("-");
        if (i < 0 && (i = version.indexOf("+")) < 0) {
            return "";
        }
        return version.substring(0, i);
    }

    public static Integer parseBuildNumber(String version) {
        int i = version.lastIndexOf("+");
        if (i < 0) {
            return zero;
        }
        try {
            String s = version.substring(i + 1);
            return Integer.parseInt(s, 10);
        }
        catch (NumberFormatException _) {
            throw new IllegalArgumentException(version);
        }
    }

    public static Integer[] parseReleaseArray(String version) {
        int i = version.indexOf("-");
        i = i >= 0 ? i + 1 : 0;
        int j = version.lastIndexOf("+");
        j = j >= 0 ? j : version.length();
        Vector<Integer> v = new Vector<Integer>();
        if (i < j) {
            String code = version.substring(i, j);
            for (String part : code.split("\\.")) {
                Integer n;
                try {
                    n = Integer.parseInt(part, 10);
                }
                catch (NumberFormatException _) {
                    throw new IllegalArgumentException("part '" + part + "' not valid.");
                }
                v.add(n);
            }
        }
        return v.toArray(empty);
    }

    public static GalileoVersionId ofTargetString(String version) {
        if (GalileoVersionId.isUnreleasedQuarkBuild(version).booleanValue()) {
            String codeline = quarkCodeline;
            Integer[] release = empty;
            Integer build = version.startsWith("0x") || version.startsWith("0X") ? Integer.valueOf(Integer.parseInt(version.substring(2), 16)) : Integer.valueOf(Integer.parseInt(version, 10));
            return new GalileoVersionId(codeline, release, build);
        }
        if (GalileoVersionId.isReleasedQuarkBuild(version).booleanValue()) {
            String codeline = quarkCodeline;
            int n = Integer.parseInt(version.substring(2), 16);
            Integer build = n & 0xFF;
            n >>= 8;
            Vector<Integer> v = new Vector<Integer>();
            for (int i = 0; i < 3; ++i) {
                v.add(0, n & 0xFF);
                n >>= 8;
            }
            Integer[] release = v.toArray(empty);
            return new GalileoVersionId(codeline, release, build);
        }
        return GalileoVersionId.ofString(version);
    }

    public static GalileoVersionId ofString(String version) {
        if (!GalileoVersionId.isCanonicalFormat(version).booleanValue()) {
            throw new IllegalArgumentException(version);
        }
        String codeline = GalileoVersionId.parseCodeline(version);
        Integer[] release = GalileoVersionId.parseReleaseArray(version);
        Integer build = GalileoVersionId.parseBuildNumber(version);
        return new GalileoVersionId(codeline, release, build);
    }

    @Override
    public int compareTo(GalileoVersionId that) {
        Boolean thatHasNext;
        Boolean thisHasNext;
        ListIterator<Integer> thisRelease = this.release.listIterator();
        ListIterator<Integer> thatRelease = that.release.listIterator();
        if (this.codeline.equals(quarkCodeline) && that.codeline.equals(quarkCodeline) && (thisHasNext = Boolean.valueOf(thisRelease.hasNext())) != (thatHasNext = Boolean.valueOf(thatRelease.hasNext()))) {
            throw new IllegalArgumentException();
        }
        while (thisRelease.hasNext() && thatRelease.hasNext()) {
            Integer thatPart;
            Integer thisPart = (Integer)thisRelease.next();
            int d = thisPart.compareTo(thatPart = (Integer)thatRelease.next());
            if (d == 0) continue;
            return d;
        }
        if (thisRelease.hasNext()) {
            return -1;
        }
        if (thatRelease.hasNext()) {
            return 1;
        }
        int d = this.codeline.compareTo(that.codeline);
        if (d != 0) {
            return d;
        }
        return this.build.compareTo(that.build);
    }
}

