/*
 * Decompiled with CFR 0.152.
 */
package processing.app.debug;

import java.util.ArrayList;
import java.util.List;
import processing.app.Base;
import processing.app.I18n;
import processing.app.Preferences;
import processing.app.Serial;
import processing.app.SerialException;
import processing.app.debug.RunnerException;
import processing.app.debug.TargetPlatform;
import processing.app.debug.Uploader;
import processing.app.helpers.PreferencesMap;
import processing.app.helpers.PreferencesMapException;
import processing.app.helpers.StringReplacer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BasicUploader
extends Uploader {
    @Override
    public boolean uploadUsingPreferences(String buildPath, String className, boolean usingProgrammer) throws Exception {
        boolean uploadResult;
        block24: {
            boolean waitForUploadPort;
            TargetPlatform targetPlatform = Base.getTargetPlatform();
            PreferencesMap prefs = Preferences.getMap();
            prefs.putAll(Base.getBoardPreferences());
            String tool = prefs.getOrExcept("upload.tool");
            if (tool.contains(":")) {
                String[] split = tool.split(":", 2);
                targetPlatform = Base.getCurrentTargetPlatformFromPackage(split[0]);
                tool = split[1];
            }
            prefs.putAll(targetPlatform.getTool(tool));
            if (usingProgrammer || prefs.get("upload.protocol") == null) {
                return this.uploadUsingProgrammer(buildPath, className);
            }
            String t = (String)prefs.get("upload.use_1200bps_touch");
            boolean doTouch = t != null && t.equals("true");
            t = (String)prefs.get("upload.wait_for_upload_port");
            boolean bl = waitForUploadPort = t != null && t.equals("true");
            if (doTouch) {
                String uploadPort = prefs.getOrExcept("serial.port");
                try {
                    List<String> before = Serial.list();
                    if (before.contains(uploadPort)) {
                        if (this.verbose || Preferences.getBoolean("upload.verbose")) {
                            System.out.println(I18n._("Forcing reset using 1200bps open/close on port ") + uploadPort);
                        }
                        Serial.touchPort(uploadPort, 1200);
                    }
                    if (waitForUploadPort) {
                        if (!Base.isMacOS()) {
                            Thread.sleep(300L);
                        }
                        uploadPort = this.waitForUploadPort(uploadPort, before);
                    } else {
                        Thread.sleep(400L);
                    }
                }
                catch (SerialException e) {
                    throw new RunnerException(e.getMessage());
                }
                catch (InterruptedException e) {
                    throw new RunnerException(e.getMessage());
                }
                prefs.put("serial.port", uploadPort);
                if (uploadPort.startsWith("/dev/")) {
                    prefs.put("serial.port.file", uploadPort.substring(5));
                } else {
                    prefs.put("serial.port.file", uploadPort);
                }
            }
            prefs.put("build.path", buildPath);
            prefs.put("build.project_name", className);
            if (this.verbose) {
                prefs.put("upload.verbose", prefs.getOrExcept("upload.params.verbose"));
            } else {
                prefs.put("upload.verbose", prefs.getOrExcept("upload.params.quiet"));
            }
            try {
                String pattern = prefs.getOrExcept("upload.pattern");
                String[] cmd = StringReplacer.formatAndSplit(pattern, prefs, true);
                uploadResult = this.executeUploadCommand(cmd);
            }
            catch (Exception e) {
                throw new RunnerException(e);
            }
            try {
                if (!uploadResult || !doTouch) break block24;
                String uploadPort = Preferences.get("serial.port");
                if (waitForUploadPort) {
                    Thread.sleep(500L);
                    long timeout = System.currentTimeMillis() + 2000L;
                    while (timeout > System.currentTimeMillis()) {
                        List<String> portList = Serial.list();
                        if (portList.contains(uploadPort)) {
                            try {
                                Serial.touchPort(uploadPort, 9600);
                                break block24;
                            }
                            catch (SerialException e) {
                                // empty catch block
                            }
                        }
                        Thread.sleep(250L);
                    }
                    break block24;
                }
                Serial.touchPort(uploadPort, 9600);
            }
            catch (InterruptedException ex) {
                // empty catch block
            }
        }
        return uploadResult;
    }

    private String waitForUploadPort(String uploadPort, List<String> before) throws InterruptedException, RunnerException {
        int elapsed = 0;
        while (elapsed < 10000) {
            List<String> now = Serial.list();
            ArrayList<String> diff = new ArrayList<String>(now);
            diff.removeAll(before);
            if (this.verbose || Preferences.getBoolean("upload.verbose")) {
                System.out.print("PORTS {");
                for (String p : before) {
                    System.out.print(p + ", ");
                }
                System.out.print("} / {");
                for (String p : now) {
                    System.out.print(p + ", ");
                }
                System.out.print("} => {");
                for (String p : diff) {
                    System.out.print(p + ", ");
                }
                System.out.println("}");
            }
            if (diff.size() > 0) {
                String newPort = (String)diff.get(0);
                if (this.verbose || Preferences.getBoolean("upload.verbose")) {
                    System.out.println("Found upload port: " + newPort);
                }
                return newPort;
            }
            before = now;
            Thread.sleep(250L);
            if ((Base.isWindows() || (elapsed += 250) < 500) && elapsed < 5000 || !now.contains(uploadPort)) continue;
            if (this.verbose || Preferences.getBoolean("upload.verbose")) {
                System.out.println("Uploading using selected port: " + uploadPort);
            }
            return uploadPort;
        }
        throw new RunnerException(I18n._("Couldn't find a Board on the selected port. Check that you have the correct port selected.  If it is correct, try pressing the board's reset button after initiating the upload."));
    }

    public boolean uploadUsingProgrammer(String buildPath, String className) throws Exception {
        TargetPlatform targetPlatform = Base.getTargetPlatform();
        String programmer = Preferences.get("programmer");
        if (programmer.contains(":")) {
            String[] split = programmer.split(":", 2);
            targetPlatform = Base.getCurrentTargetPlatformFromPackage(split[0]);
            programmer = split[1];
        }
        PreferencesMap prefs = Preferences.getMap();
        prefs.putAll(Base.getBoardPreferences());
        prefs.putAll(targetPlatform.getProgrammer(programmer));
        prefs.putAll(targetPlatform.getTool(prefs.getOrExcept("program.tool")));
        prefs.put("build.path", buildPath);
        prefs.put("build.project_name", className);
        if (this.verbose) {
            prefs.put("program.verbose", prefs.getOrExcept("program.params.verbose"));
        } else {
            prefs.put("program.verbose", prefs.getOrExcept("program.params.quiet"));
        }
        try {
            String pattern = prefs.getOrExcept("program.pattern");
            String[] cmd = StringReplacer.formatAndSplit(pattern, prefs, true);
            return this.executeUploadCommand(cmd);
        }
        catch (Exception e) {
            throw new RunnerException(e);
        }
    }

    @Override
    public boolean burnBootloader() throws RunnerException, PreferencesMapException {
        PreferencesMap programmerPrefs;
        TargetPlatform targetPlatform = Base.getTargetPlatform();
        String programmer = Preferences.get("programmer");
        if (programmer.contains(":")) {
            String[] split = programmer.split(":", 2);
            TargetPlatform platform = Base.getCurrentTargetPlatformFromPackage(split[0]);
            programmer = split[1];
            programmerPrefs = platform.getProgrammer(programmer);
        } else {
            programmerPrefs = targetPlatform.getProgrammer(programmer);
        }
        PreferencesMap prefs = Preferences.getMap();
        prefs.putAll(Base.getBoardPreferences());
        prefs.putAll(programmerPrefs);
        PreferencesMap toolPrefs = new PreferencesMap();
        String tool = prefs.getOrExcept("bootloader.tool");
        if (tool.contains(":")) {
            String[] split = tool.split(":", 2);
            TargetPlatform platform = Base.getCurrentTargetPlatformFromPackage(split[0]);
            tool = split[1];
            toolPrefs.putAll(platform.getTool(tool));
            if (toolPrefs.size() == 0) {
                throw new RunnerException(I18n.format(I18n._("Could not find tool {0} from package {1}"), tool, split[0]));
            }
        }
        toolPrefs.putAll(targetPlatform.getTool(tool));
        if (toolPrefs.size() == 0) {
            throw new RunnerException(I18n.format(I18n._("Could not find tool {0}"), tool));
        }
        prefs.putAll(toolPrefs);
        if (this.verbose) {
            prefs.put("erase.verbose", prefs.getOrExcept("erase.params.verbose"));
            prefs.put("bootloader.verbose", prefs.getOrExcept("bootloader.params.verbose"));
        } else {
            prefs.put("erase.verbose", prefs.getOrExcept("erase.params.quiet"));
            prefs.put("bootloader.verbose", prefs.getOrExcept("bootloader.params.quiet"));
        }
        try {
            String pattern = prefs.getOrExcept("erase.pattern");
            String[] cmd = StringReplacer.formatAndSplit(pattern, prefs, true);
            if (!this.executeUploadCommand(cmd)) {
                return false;
            }
            pattern = prefs.getOrExcept("bootloader.pattern");
            cmd = StringReplacer.formatAndSplit(pattern, prefs, true);
            return this.executeUploadCommand(cmd);
        }
        catch (Exception e) {
            throw new RunnerException(e);
        }
    }

    @Override
    public boolean updateFirmware(String[] command) throws RunnerException {
        boolean uploadResult = false;
        try {
            uploadResult = this.executeUploadCommand(command);
        }
        catch (Exception e) {
            throw new RunnerException(e);
        }
        return uploadResult;
    }
}

