/*
 * Decompiled with CFR 0.152.
 */
package processing.app.debug;

public class RunnerException
extends Exception {
    protected String message;
    protected int codeIndex;
    protected int codeLine;
    protected int codeColumn;
    protected boolean showStackTrace;

    public RunnerException(String message) {
        this(message, true);
    }

    public RunnerException(String message, boolean showStackTrace) {
        this(message, -1, -1, -1, showStackTrace);
    }

    public RunnerException(String message, int file, int line) {
        this(message, file, line, -1, true);
    }

    public RunnerException(String message, int file, int line, int column) {
        this(message, file, line, column, true);
    }

    public RunnerException(String message, int file, int line, int column, boolean showStackTrace) {
        this.message = message;
        this.codeIndex = file;
        this.codeLine = line;
        this.codeColumn = column;
        this.showStackTrace = showStackTrace;
    }

    public RunnerException(Exception e) {
        this(e.getMessage(), true);
    }

    public String getMessage() {
        return this.message;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    public int getCodeIndex() {
        return this.codeIndex;
    }

    public void setCodeIndex(int index) {
        this.codeIndex = index;
    }

    public boolean hasCodeIndex() {
        return this.codeIndex != -1;
    }

    public int getCodeLine() {
        return this.codeLine;
    }

    public void setCodeLine(int line) {
        this.codeLine = line;
    }

    public boolean hasCodeLine() {
        return this.codeLine != -1;
    }

    public void setCodeColumn(int column) {
        this.codeColumn = column;
    }

    public int getCodeColumn() {
        return this.codeColumn;
    }

    public void showStackTrace() {
        this.showStackTrace = true;
    }

    public void hideStackTrace() {
        this.showStackTrace = false;
    }

    public void printStackTrace() {
        if (this.showStackTrace) {
            super.printStackTrace();
        }
    }
}

