/*
 * Decompiled with CFR 0.152.
 */
package processing.app.debug;

import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import processing.app.I18n;
import processing.app.debug.TargetPlatform;
import processing.app.helpers.PreferencesMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TargetBoard {
    private String id;
    private PreferencesMap prefs;
    private Map<String, PreferencesMap> menuOptions = new LinkedHashMap<String, PreferencesMap>();
    private TargetPlatform containerPlatform;

    public TargetBoard(String _id, PreferencesMap _prefs, TargetPlatform parent) {
        this.containerPlatform = parent;
        this.id = _id;
        this.prefs = new PreferencesMap(_prefs);
        PreferencesMap menus = this.prefs.firstLevelMap().get("menu");
        if (menus != null) {
            this.menuOptions = menus.firstLevelMap();
        }
        if (!this.prefs.containsKey("build.board")) {
            String board = this.containerPlatform.getId() + "_" + this.id;
            board = board.toUpperCase();
            this.prefs.put("build.board", board);
            System.out.println(I18n.format(I18n._("Board {0}:{1}:{2} doesn''t define a ''build.board'' preference. Auto-set to: {3}"), this.containerPlatform.getContainerPackage().getId(), this.containerPlatform.getId(), this.id, board));
        }
    }

    public String getName() {
        return (String)this.prefs.get("name");
    }

    public String getId() {
        return this.id;
    }

    public PreferencesMap getPreferences() {
        return this.prefs;
    }

    public boolean hasMenu(String menuId) {
        return this.menuOptions.containsKey(menuId);
    }

    public PreferencesMap getMenuLabels(String menuId) {
        return this.menuOptions.get(menuId).topLevelMap();
    }

    public String getMenuLabel(String menuId, String selectionId) {
        return (String)this.getMenuLabels(menuId).get(selectionId);
    }

    public Set<String> getMenuIds() {
        return this.menuOptions.keySet();
    }

    public PreferencesMap getMenuPreferences(String menuId, String selectionId) {
        return this.menuOptions.get(menuId).subTree(selectionId);
    }

    public TargetPlatform getContainerPlatform() {
        return this.containerPlatform;
    }
}

