/*
 * Decompiled with CFR 0.152.
 */
package processing.app.debug;

import java.io.File;
import java.io.IOException;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import processing.app.I18n;
import processing.app.debug.TargetBoard;
import processing.app.debug.TargetPackage;
import processing.app.debug.TargetPlatformException;
import processing.app.helpers.PreferencesMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TargetPlatform {
    private String id;
    private File folder;
    private TargetPackage containerPackage;
    private Map<String, TargetBoard> boards = new LinkedHashMap<String, TargetBoard>();
    private Map<String, PreferencesMap> programmers = new LinkedHashMap<String, PreferencesMap>();
    private PreferencesMap preferences = new PreferencesMap();
    private PreferencesMap customMenus = new PreferencesMap();

    public TargetPlatform(String _name, File _folder, TargetPackage parent) throws TargetPlatformException {
        this.id = _name;
        this.folder = _folder;
        this.containerPackage = parent;
        File boardsFile = new File(this.folder, "boards.txt");
        if (!boardsFile.exists() || !boardsFile.canRead()) {
            throw new TargetPlatformException(I18n.format(I18n._("Could not find boards.txt in {0}. Is it pre-1.5?"), boardsFile.getAbsolutePath()));
        }
        try {
            Map<String, PreferencesMap> boardsPreferences = new PreferencesMap(boardsFile).firstLevelMap();
            PreferencesMap menus = boardsPreferences.get("menu");
            if (menus != null) {
                this.customMenus = menus.topLevelMap();
            }
            boardsPreferences.remove("menu");
            for (String id : boardsPreferences.keySet()) {
                PreferencesMap preferences = boardsPreferences.get(id);
                TargetBoard board = new TargetBoard(id, preferences, this);
                this.boards.put(id, board);
            }
        }
        catch (IOException e) {
            throw new TargetPlatformException(I18n.format(I18n._("Error loading {0}"), boardsFile.getAbsolutePath()), e);
        }
        try {
            String os_name = System.getProperty("os.name");
            File platformsFile = new File(_folder, "platform.txt");
            if (platformsFile.exists()) {
                this.preferences.load(platformsFile);
            } else if (os_name.indexOf("Windows") != -1) {
                File winplatformsFile = new File(_folder, "platform.win.txt");
                if (winplatformsFile.exists()) {
                    this.preferences.load(winplatformsFile);
                }
            } else if (os_name.indexOf("Mac") != -1) {
                File macplatformsFile = new File(_folder, "platform.osx.txt");
                if (macplatformsFile.exists()) {
                    this.preferences.load(macplatformsFile);
                }
            } else if (os_name.indexOf("Linux") != -1) {
                if (System.getProperty("os.arch").indexOf("amd64") != -1) {
                    File lnx64platformsFile = new File(_folder, "platform.linux64.txt");
                    if (lnx64platformsFile.exists()) {
                        this.preferences.load(lnx64platformsFile);
                    }
                } else {
                    File lnx32platformsFile = new File(_folder, "platform.linux.txt");
                    if (lnx32platformsFile.exists()) {
                        this.preferences.load(lnx32platformsFile);
                    }
                }
            }
        }
        catch (Exception e) {
            System.err.println("Error loading platforms from platform.txt: " + e);
        }
        File progFile = new File(this.folder, "programmers.txt");
        try {
            if (progFile.exists() && progFile.canRead()) {
                PreferencesMap prefs = new PreferencesMap();
                prefs.load(progFile);
                this.programmers = prefs.firstLevelMap();
            }
        }
        catch (IOException e) {
            throw new TargetPlatformException(I18n.format(I18n._("Error loading {0}"), progFile.getAbsolutePath()), e);
        }
    }

    public String getId() {
        return this.id;
    }

    public File getFolder() {
        return this.folder;
    }

    public Map<String, TargetBoard> getBoards() {
        return this.boards;
    }

    public PreferencesMap getCustomMenus() {
        return this.customMenus;
    }

    public Set<String> getCustomMenuIds() {
        return this.customMenus.keySet();
    }

    public Map<String, PreferencesMap> getProgrammers() {
        return this.programmers;
    }

    public PreferencesMap getProgrammer(String programmer) {
        return this.getProgrammers().get(programmer);
    }

    public PreferencesMap getTool(String tool) {
        return this.getPreferences().subTree("tools").subTree(tool);
    }

    public PreferencesMap getPreferences() {
        return this.preferences;
    }

    public TargetBoard getBoard(String boardId) {
        return this.boards.get(boardId);
    }

    public TargetPackage getContainerPackage() {
        return this.containerPackage;
    }

    public String toString() {
        String res = "TargetPlatform: name=" + this.id + " boards={\n";
        for (String boardId : this.boards.keySet()) {
            res = res + "  " + boardId + " = " + this.boards.get(boardId) + "\n";
        }
        return res + "}";
    }
}

