/*
 * Decompiled with CFR 0.152.
 */
package processing.app.helpers;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.TreeSet;
import processing.app.Base;
import processing.app.helpers.PreferencesMapException;
import processing.core.PApplet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PreferencesMap
extends LinkedHashMap<String, String> {
    public PreferencesMap(Map<String, String> table) {
        super(table);
    }

    public PreferencesMap(File file) throws IOException {
        this.load(file);
    }

    public PreferencesMap() {
    }

    public void load(File file) throws IOException {
        this.load(new FileInputStream(file));
    }

    public void load(InputStream input) throws IOException {
        String[] lines;
        for (String line : lines = PApplet.loadStrings((InputStream)input)) {
            int equals;
            if (line.length() == 0 || line.charAt(0) == '#' || (equals = line.indexOf(61)) == -1) continue;
            String key = line.substring(0, equals);
            String value = line.substring(equals + 1);
            this.put(key.trim(), value.trim());
        }
        LinkedHashSet keys = new LinkedHashSet(this.keySet());
        for (String key : keys) {
            boolean replace = false;
            if (Base.isLinux() && key.endsWith(".linux")) {
                replace = true;
            }
            if (Base.isWindows() && key.endsWith(".windows")) {
                replace = true;
            }
            if (Base.isMacOS() && key.endsWith(".macos")) {
                replace = true;
            }
            if (!replace) continue;
            int dot = key.lastIndexOf(46);
            String overridenKey = key.substring(0, dot);
            this.put(overridenKey, this.get(key));
        }
    }

    public PreferencesMap topLevelMap() {
        PreferencesMap res = new PreferencesMap();
        for (String key : this.keySet()) {
            if (key.contains(".")) continue;
            res.put(key, this.get(key));
        }
        return res;
    }

    public Map<String, PreferencesMap> firstLevelMap() {
        LinkedHashMap<String, PreferencesMap> res = new LinkedHashMap<String, PreferencesMap>();
        for (String key : this.keySet()) {
            int dot = key.indexOf(46);
            if (dot == -1) continue;
            String parent = key.substring(0, dot);
            String child = key.substring(dot + 1);
            if (!res.containsKey(parent)) {
                res.put(parent, new PreferencesMap());
            }
            ((PreferencesMap)res.get(parent)).put(child, this.get(key));
        }
        return res;
    }

    public PreferencesMap subTree(String parent) {
        PreferencesMap res = new PreferencesMap();
        parent = parent + ".";
        int parentLen = parent.length();
        for (String key : this.keySet()) {
            if (!key.startsWith(parent)) continue;
            res.put(key.substring(parentLen), this.get(key));
        }
        return res;
    }

    public String toString(String indent) {
        String res = indent + "{\n";
        TreeSet treeSet = new TreeSet(this.keySet());
        for (String k : treeSet) {
            res = res + indent + k + " = " + (String)this.get(k) + "\n";
        }
        return res;
    }

    public String getOrExcept(String k) throws PreferencesMapException {
        String r = (String)this.get(k);
        if (r == null) {
            throw new PreferencesMapException(k);
        }
        return r;
    }

    @Override
    public String toString() {
        return this.toString("");
    }
}

