/*
 * Decompiled with CFR 0.152.
 */
package cc.arduino.packages.discoverers;

import cc.arduino.packages.BoardPort;
import cc.arduino.packages.Discovery;
import cc.arduino.packages.discoverers.network.NetworkChecker;
import cc.arduino.packages.discoverers.network.NetworkTopologyListener;
import java.io.IOException;
import java.net.Inet4Address;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Timer;
import javax.jmdns.JmDNS;
import javax.jmdns.NetworkTopologyDiscovery;
import javax.jmdns.ServiceEvent;
import javax.jmdns.ServiceInfo;
import javax.jmdns.ServiceListener;
import javax.jmdns.impl.DNSTaskStarter;
import processing.app.BaseNoGui;
import processing.app.helpers.NetUtils;
import processing.app.helpers.PreferencesMap;
import processing.app.zeroconf.jmdns.ArduinoDNSTaskStarter;

public class NetworkDiscovery
implements Discovery,
ServiceListener,
NetworkTopologyListener {
    private Timer timer;
    private final List<BoardPort> ports;
    private final Map<InetAddress, JmDNS> mappedJmDNSs;

    public NetworkDiscovery() {
        DNSTaskStarter.Factory.setClassDelegate((DNSTaskStarter.Factory.ClassDelegate)new ArduinoDNSTaskStarter());
        this.ports = new ArrayList<BoardPort>();
        this.mappedJmDNSs = new Hashtable<InetAddress, JmDNS>();
    }

    @Override
    public List<BoardPort> discovery() {
        List<BoardPort> list = this.clonePortsList();
        Iterator<BoardPort> iterator = list.iterator();
        while (iterator.hasNext()) {
            try {
                BoardPort boardPort = iterator.next();
                if (NetUtils.isReachable(InetAddress.getByName(boardPort.getAddress()), Integer.parseInt((String)boardPort.getPrefs().get("port")))) continue;
                iterator.remove();
            }
            catch (UnknownHostException unknownHostException) {
                iterator.remove();
            }
        }
        return list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<BoardPort> clonePortsList() {
        NetworkDiscovery networkDiscovery = this;
        synchronized (networkDiscovery) {
            return new ArrayList<BoardPort>(this.ports);
        }
    }

    @Override
    public void setPreferences(PreferencesMap preferencesMap) {
    }

    @Override
    public void start() throws IOException {
        this.timer = new Timer(this.getClass().getName() + " timer");
        new NetworkChecker(this, NetworkTopologyDiscovery.Factory.getInstance()).start(this.timer);
    }

    @Override
    public void stop() throws IOException {
        this.timer.purge();
    }

    public void serviceAdded(ServiceEvent serviceEvent) {
        String string = serviceEvent.getType();
        String string2 = serviceEvent.getName();
        JmDNS jmDNS = serviceEvent.getDNS();
        jmDNS.requestServiceInfo(string, string2);
        ServiceInfo serviceInfo = jmDNS.getServiceInfo(string, string2);
        if (serviceInfo != null) {
            jmDNS.requestServiceInfo(string, string2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void serviceRemoved(ServiceEvent serviceEvent) {
        String string = serviceEvent.getName();
        NetworkDiscovery networkDiscovery = this;
        synchronized (networkDiscovery) {
            for (BoardPort boardPort : this.ports) {
                if (!boardPort.getBoardName().equals(string)) continue;
                this.ports.remove(boardPort);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void serviceResolved(ServiceEvent serviceEvent) {
        ServiceInfo serviceInfo = serviceEvent.getInfo();
        for (Inet4Address inet4Address : serviceInfo.getInet4Addresses()) {
            Object object;
            String string = ((InetAddress)inet4Address).getHostAddress();
            String string2 = serviceEvent.getName();
            PreferencesMap preferencesMap = null;
            String string3 = null;
            if (serviceInfo.hasData()) {
                preferencesMap = new PreferencesMap();
                string3 = serviceInfo.getPropertyString("board");
                preferencesMap.put("board", string3);
                preferencesMap.put("distro_version", serviceInfo.getPropertyString("distro_version"));
            }
            preferencesMap.put("port", "" + serviceInfo.getPort());
            String string4 = string2 + " at " + string;
            if (string3 != null && (object = BaseNoGui.getPlatform().resolveDeviceByBoardID(BaseNoGui.packages, string3)) != null) {
                string4 = string4 + " (" + (String)object + ")";
            }
            object = new BoardPort();
            ((BoardPort)object).setAddress(string);
            ((BoardPort)object).setBoardName(string2);
            ((BoardPort)object).setProtocol("network");
            ((BoardPort)object).setPrefs(preferencesMap);
            ((BoardPort)object).setLabel(string4);
            NetworkDiscovery networkDiscovery = this;
            synchronized (networkDiscovery) {
                this.removeDuplicateBoards((BoardPort)object);
                this.ports.add((BoardPort)object);
            }
        }
    }

    private void removeDuplicateBoards(BoardPort boardPort) {
        Iterator<BoardPort> iterator = this.ports.iterator();
        while (iterator.hasNext()) {
            BoardPort boardPort2 = iterator.next();
            if (!boardPort.getAddress().equals(boardPort2.getAddress())) continue;
            iterator.remove();
        }
    }

    @Override
    public void inetAddressAdded(InetAddress inetAddress) {
        if (this.mappedJmDNSs.containsKey(inetAddress)) {
            return;
        }
        try {
            JmDNS jmDNS = JmDNS.create((InetAddress)inetAddress);
            jmDNS.addServiceListener("_arduino._tcp.local.", (ServiceListener)this);
            this.mappedJmDNSs.put(inetAddress, jmDNS);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    @Override
    public void inetAddressRemoved(InetAddress inetAddress) {
        JmDNS jmDNS = this.mappedJmDNSs.remove(inetAddress);
        if (jmDNS != null) {
            try {
                jmDNS.close();
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        }
    }
}

